/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.network;

import dangerzone.threads.NetworkSender;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NetworkOutputBuffer {
    public int currentlen = 0;
    public ByteBuffer currbuffer = null;
    public int maxlen = 2500;
    public int maxlist = 1024;
    public OutputStream out = null;
    public boolean error_happened = false;
    public float avgfill = 10.0f;
    public Lock lock = new ReentrantLock();
    public List<ByteBuffer> output_list;
    public List<ByteBuffer> free_list;
    private NetworkSender ns = null;

    public NetworkOutputBuffer(OutputStream inout, int howmany) {
        this.out = inout;
        this.output_list = new ArrayList<ByteBuffer>();
        this.free_list = new ArrayList<ByteBuffer>();
        this.maxlist = howmany;
        int i = 0;
        while (i < this.maxlist) {
            this.currbuffer = ByteBuffer.allocate(this.maxlen + 200);
            this.currbuffer.rewind();
            this.currbuffer.position(0);
            this.free_list.add(this.currbuffer);
            ++i;
        }
        this.currbuffer = ByteBuffer.allocate(this.maxlen + 200);
        this.currbuffer.rewind();
        this.currbuffer.position(0);
        this.ns = new NetworkSender(this);
        Thread it = new Thread(this.ns);
        it.start();
    }

    public void close() {
        this.error_happened = true;
        this.ns = null;
    }

    public float update_pct_full() {
        this.lock.lock();
        float lenf = this.output_list.size();
        float maxlenf = this.maxlist;
        this.lock.unlock();
        float pctf = lenf / maxlenf * 100.0f;
        this.avgfill = (this.avgfill * 9.0f + pctf) / 10.0f;
        return this.avgfill;
    }

    public boolean errorOccurred() {
        return this.error_happened;
    }

    public void flush() {
        if (this.error_happened) {
            return;
        }
        if (this.currentlen > 0) {
            this.lock.lock();
            this.output_list.add(this.currbuffer);
            while (this.free_list.size() <= 0) {
                this.lock.unlock();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.lock.lock();
            }
            this.currbuffer = this.free_list.get(0);
            this.currbuffer = this.free_list.remove(0);
            this.currbuffer.rewind();
            this.currbuffer.position(0);
            this.currentlen = 0;
            this.lock.unlock();
        }
    }

    public void writeInt(int in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 4) {
            this.flush();
        }
        this.currbuffer.putInt(in);
        this.currentlen += 4;
    }

    public void writeShort(short in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 2) {
            this.flush();
        }
        this.currbuffer.putShort(in);
        this.currentlen += 2;
    }

    public void writeByte(byte in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 1) {
            this.flush();
        }
        this.currbuffer.put(in);
        ++this.currentlen;
    }

    public void writeFloat(float in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 4) {
            this.flush();
        }
        this.currbuffer.putFloat(in);
        this.currentlen += 4;
    }

    public void writeDouble(double in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 8) {
            this.flush();
        }
        this.currbuffer.putDouble(in);
        this.currentlen += 8;
    }

    public void writeLong(long in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 8) {
            this.flush();
        }
        this.currbuffer.putLong(in);
        this.currentlen += 8;
    }

    public void writeString(String in) {
        if (this.error_happened) {
            return;
        }
        int len = 0;
        byte[] stringbytes = null;
        if (in != null) {
            try {
                stringbytes = in.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                stringbytes = in.getBytes();
            }
            len = stringbytes.length;
        }
        this.writeInt(len);
        if (this.maxlen - this.currentlen < len) {
            this.flush();
        }
        if (len > 0) {
            this.currbuffer.put(stringbytes, 0, len);
        }
        this.currentlen += len;
    }

    public void writeShortArray(short[] sh, int len) {
        if (this.error_happened) {
            return;
        }
        this.writeInt(len);
        if (this.error_happened) {
            return;
        }
        if (len > 0) {
            if (this.maxlen - this.currentlen < 2) {
                this.flush();
                if (this.error_happened) {
                    return;
                }
            }
            int i = 0;
            while (i < len) {
                this.currbuffer.putShort(sh[i]);
                this.currentlen += 2;
                if (this.maxlen - this.currentlen < 2) {
                    this.flush();
                    if (this.error_happened) {
                        return;
                    }
                }
                ++i;
            }
        }
    }

    public void writeByteArray(byte[] sh, int len) {
        if (this.error_happened) {
            return;
        }
        this.writeInt(len);
        if (this.error_happened) {
            return;
        }
        if (len > 0) {
            if (this.maxlen - this.currentlen < 100) {
                this.flush();
                if (this.error_happened) {
                    return;
                }
            }
            int bytes_to_write = 0;
            int bytes_written = 0;
            while (bytes_written < len) {
                bytes_to_write = len - bytes_written;
                if (bytes_to_write > this.maxlen - this.currentlen) {
                    bytes_to_write = this.maxlen - this.currentlen;
                }
                this.currbuffer.put(sh, bytes_written, bytes_to_write);
                bytes_written += bytes_to_write;
                this.currentlen += bytes_to_write;
                this.flush();
                if (!this.error_happened) continue;
                return;
            }
        }
    }
}

