/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TargetInfo;
import dangerzone.entities.Entity;
import dangerzone.entities.ThrownExpBottle;
import dangerzone.items.Item;

public class ItemExpBottle
extends Item {
    public ItemExpBottle(String n, String txt) {
        super(n, txt);
    }

    @Override
    public boolean onSwingStop(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (clickedon != null) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        if (holder.world.isServer) {
            if (DangerZone.isVR && holder instanceof Player) {
                TargetInfo ti = DangerZone.weapon_controller;
                ThrownExpBottle e = (ThrownExpBottle)holder.world.createEntityByName("DangerZone:ThrownExpBottle", holder.dimension, ti.real_posx, ti.real_posy + (double)holder.getEyeHeight(), ti.real_posz);
                if (e != null) {
                    e.init();
                    e.maxrenderdist = 64;
                    e.setBID(ic.bid);
                    e.setIID(ic.iid);
                    e.thrower = holder;
                    e.setDirectionAndVelocity(ti.dx, ti.dy, ti.dz, 5.0f, 0.15f);
                    holder.world.spawnEntityInWorld(e);
                }
            }
            holder.world.playSound("DangerZone:bow", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.5f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (clickedon != null) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        if (DangerZone.isVR) {
            return false;
        }
        if (holder.world.isServer) {
            ThrownExpBottle e = (ThrownExpBottle)holder.world.createEntityByName("DangerZone:ThrownExpBottle", holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 1.0f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.maxrenderdist = 64;
                e.setBID(ic.bid);
                e.setIID(ic.iid);
                e.thrower = holder;
                e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(holder.rotation_pitch_head))), (float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), 5.0f, 0.15f);
                holder.world.spawnEntityInWorld(e);
            }
            holder.world.playSound("DangerZone:bow", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.5f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            return true;
        }
        return false;
    }
}

