/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityArrow;
import dangerzone.gui.InventoryMenus;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.WorldRenderer;

public class ItemBow
extends Item {
    public ItemBow(String n, String txt, int a) {
        super(n, txt);
        this.maxuses = a;
        this.maxstack = 1;
        this.attackstrength = 5;
        this.burntime = 15;
        this.hold_straight = true;
        this.flopped = true;
        this.menu = InventoryMenus.HARDWARE;
        this.showInInventory = false;
        this.xoff = 0.4f;
        this.yoff = -0.3f;
        this.zoff = -0.4f;
        this.pitch_off = 26.9f;
        this.yaw_off = 89.9f;
        this.roll_off = -153.9f;
    }

    @Override
    public boolean rightclickup(Entity holder, InventoryContainer ic, int holdcount) {
        if (holder.world.isServer) {
            TargetInfo ti = DangerZone.weapon_controller;
            EntityArrow e = DangerZone.isVR && holder instanceof Player ? (EntityArrow)holder.world.createEntityByName("DangerZone:EntityArrow", holder.dimension, ti.real_posx, ti.real_posy + (double)holder.getEyeHeight(), ti.real_posz) : (EntityArrow)holder.world.createEntityByName("DangerZone:EntityArrow", holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.5f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 1.5f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.5f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))));
            if (e != null) {
                int spam = ic.getAttribute(5);
                int acc = ic.getAttribute(1);
                int dmg = ic.getAttribute(2);
                int rch = ic.getAttribute(4);
                float held = holdcount + 10 * spam;
                float acu = 0.01f * (float)acc;
                float dam = 8.0f + (float)(2 * dmg);
                float spd = 0.5f * (float)rch;
                if (held > this.getfullholdcount()) {
                    held = this.getfullholdcount();
                }
                e.init();
                e.setBID(0);
                e.setIID(Items.arrow.itemID);
                e.thrower = holder;
                if (DangerZone.isVR && holder instanceof Player) {
                    ti.calc_50();
                    e.setDirectionAndVelocity(ti.dx_50, ti.dy_50, ti.dz_50, 1.0f + 10.0f * held / this.getfullholdcount() + spd, 0.11f - acu);
                } else {
                    e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(holder.rotation_pitch_head))), (float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), 1.0f + 10.0f * held / this.getfullholdcount() + spd, 0.11f - acu);
                }
                e.setAttackDamage(1.0f + dam * held / this.getfullholdcount());
                holder.world.spawnEntityInWorld(e);
            }
            holder.world.playSound("DangerZone:bow", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.55f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            if (DangerZone.isVR && holder instanceof Player) {
                Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 20, holder.dimension, ti.real_posx, ti.real_posy + (double)holder.getEyeHeight(), ti.real_posz, 0, 0.25f * (holder.getWidth() + holder.getHeight()) / 4.0f);
            } else {
                Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 20, holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head - 15.0f)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 0.35f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head - 15.0f)) * (holder.getWidth() + 0.35f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), 0, 0.25f * (holder.getWidth() + holder.getHeight()) / 4.0f);
            }
            if (holder instanceof Player && holder.getGameMode() != 0) {
                return false;
            }
            holder.decrementInInventory(Items.arrow.itemID);
            return true;
        }
        DangerZone.hit_pulse(250);
        return false;
    }

    @Override
    public float getfullholdcount() {
        return 200.0f;
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay) {
        if (e == null) {
            return;
        }
        float count = e.getRightButtonDownCount();
        if (count > this.getfullholdcount()) {
            count = this.getfullholdcount();
        }
        float pct = count / this.getfullholdcount();
        MatrixStack.pushMatrix();
        if (!DangerZone.isVR) {
            MatrixStack.scale(1.0f + pct, 1.0f + pct, 1.0f);
        } else {
            MatrixStack.scale(1.0f + pct, 1.0f + pct, 1.0f);
        }
        MatrixStack.sendCurrentStack();
        super.renderMeHeld(wr, e, ic, isdisplay);
        MatrixStack.popMatrix();
    }

    @Override
    public void inventoryTick(Entity holder, InventoryContainer ic, int invindex) {
        if (holder.world.isServer && holder instanceof Player && !holder.hasInInventory(Items.arrow.itemID)) {
            InventoryContainer ic2;
            int i = 0;
            while (i < 10) {
                ic2 = holder.getHotbar(i);
                if (ic2 == ic) {
                    ic.iid = Items.bow_empty.itemID;
                    holder.setHotbarChanged(i);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < 50) {
                ic2 = holder.getInventory(i);
                if (ic2 == ic) {
                    ic.iid = Items.bow_empty.itemID;
                    holder.setInventoryChanged(i);
                    return;
                }
                ++i;
            }
        }
    }
}

