/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.gui.InventoryMenus;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import slick.Texture;

public class Item {
    public int itemID = 0;
    public String texturepath = null;
    public String uniquename;
    private Texture texture = null;
    public int maxstack = 64;
    private boolean compiled = false;
    private int vao = 0;
    private int vbo_buffer = 0;
    private ByteBuffer vbodata = null;
    private int vcount = 0;
    private int stride = 0;
    private int textureoff = 0;
    private int coloroff = 0;
    public int maxuses;
    public int attackstrength;
    public int stonestrength;
    public int woodstrength;
    public int dirtstrength;
    public int energy = 0;
    public boolean showInInventory = true;
    public float brightness = 0.0f;
    public boolean isfood = false;
    public boolean eatanytime = false;
    public float foodvalue = 0.0f;
    public int burntime = 0;
    public int menu = InventoryMenus.GENERIC;
    public boolean flipped = false;
    public boolean flopped = false;
    public boolean hold_straight = false;
    public boolean do_shoot_clicks = false;
    public boolean nocombo = false;
    public float xoff;
    public float yoff;
    public float zoff;
    public float pitch_off;
    public float yaw_off;
    public float roll_off;
    private float use_r;
    private float use_g;
    private float use_b;
    private float use_tx;
    private float use_ty;
    public float itemreach = 0.5f;
    public float itemwidth = 0.125f;

    public Item(String n, String txt) {
        this.texturepath = txt;
        this.uniquename = n;
        this.maxstack = 64;
        this.compiled = false;
        this.dirtstrength = 1;
        this.woodstrength = 1;
        this.stonestrength = 1;
        this.attackstrength = 1;
        this.maxuses = 0;
        this.isfood = false;
        this.eatanytime = false;
        this.foodvalue = 0.0f;
        this.xoff = 0.0f;
        this.yoff = 0.0f;
        this.zoff = -3.2f;
        this.pitch_off = 42.3f;
        this.yaw_off = 88.1f;
        this.roll_off = 179.6f;
    }

    public void inUseTick(Entity e, InventoryContainer ic, int invindex) {
    }

    public void inventoryTick(Entity e, InventoryContainer ic, int invindex) {
    }

    public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay) {
        if (!this.compiled) {
            this.compile_item();
            this.compiled = true;
        }
        if (this.vao != 0) {
            MatrixStack.sendFinalStack();
            GL30.glBindVertexArray((int)this.vao);
            GL11.glDrawArrays((int)7, (int)0, (int)this.vcount);
            GL30.glBindVertexArray((int)0);
        }
    }

    public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        return true;
    }

    public void onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic, int d, double px, double py, double pz, int fx, int fy, int fz, int bid) {
        if (clickedon != null) {
            Utils.spawnParticlesScaled(holder.world, "DangerZone:ParticleHurt", 50, d, px, py, pz, 0, 0.25f * (clickedon.getWidth() + clickedon.getHeight()) / 4.0f, true);
        } else {
            if (bid == 0) {
                return;
            }
            String particlename = Blocks.getParticleName(bid);
            if (particlename == null || particlename.equals("")) {
                particlename = "DangerZone:ParticleBreak";
            }
            Utils.spawnParticles(holder.world, particlename, 30, d, (double)fx + 0.5, (double)fy + 0.5, (double)fz + 0.5, bid, true);
            Utils.spawnParticlesScaled(holder.world, "DangerZone:ParticleBreak", 25, d, px, py, pz, 0, 0.25f, true);
        }
    }

    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        return false;
    }

    public boolean onSwingStop(Entity holder, Entity clickedon, InventoryContainer ic) {
        return false;
    }

    public boolean rightclickup(Entity ent, InventoryContainer ic, int holdcount) {
        return false;
    }

    public boolean singleshot(Entity ent, InventoryContainer ic, int holdcount) {
        return false;
    }

    public boolean semiauto(Entity ent, InventoryContainer ic, int holdcount) {
        return false;
    }

    public boolean fullauto(Entity ent, InventoryContainer ic, int holdcount) {
        return false;
    }

    public float getfullholdcount() {
        return 0.0f;
    }

    public void onCrafted(Player p, InventoryContainer ic) {
    }

    private int count_verts(byte[] data) {
        int count = 0;
        if (!this.flopped) {
            int i = 0;
            while (i < 16) {
                int j = 0;
                while (j < 16) {
                    int curval = this.gimmedataat(data, i, j);
                    if (curval >= 0) {
                        count += 4;
                        count += 4;
                        if (this.gimmedataat(data, i - 1, j) < 0) {
                            count += 4;
                        }
                        if (this.gimmedataat(data, i + 1, j) < 0) {
                            count += 4;
                        }
                        if (this.gimmedataat(data, i, j - 1) < 0) {
                            count += 4;
                        }
                        if (this.gimmedataat(data, i, j + 1) < 0) {
                            count += 4;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 16) {
                int j = 0;
                while (j < 16) {
                    int curval = this.gimmedataat(data, i, j);
                    if (curval >= 0) {
                        count += 4;
                        count += 4;
                        if (this.gimmedataat(data, i + 1, j) < 0) {
                            count += 4;
                        }
                        if (this.gimmedataat(data, i - 1, j) < 0) {
                            count += 4;
                        }
                        if (this.gimmedataat(data, i, j + 1) < 0) {
                            count += 4;
                        }
                        if (this.gimmedataat(data, i, j - 1) < 0) {
                            count += 4;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return count;
    }

    private void compile_item() {
        Texture t = this.getTexture();
        if (t == null) {
            return;
        }
        byte[] data = t.getTextureData();
        this.vcount = this.count_verts(data);
        this.begin_compile(this.vcount);
        if (!this.flopped) {
            int i = 0;
            while (i < 16) {
                int j = 0;
                while (j < 16) {
                    int curval = this.gimmedataat(data, i, j);
                    if (curval >= 0) {
                        this.set_use_color(0.98f, 0.98f, 0.98f);
                        this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                        this.add_vertex(-8 + j + 1, -8 + i + 1, 0.0f);
                        this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                        this.add_vertex(-8 + j + 1, -8 + i + 0, 0.0f);
                        this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                        this.add_vertex(-8 + j + 0, -8 + i + 0, 0.0f);
                        this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                        this.add_vertex(-8 + j + 0, -8 + i + 1, 0.0f);
                        this.set_use_color(0.98f, 0.98f, 0.98f);
                        this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                        this.add_vertex(-8 + j + 1, -8 + i + 1, 1.0f);
                        this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                        this.add_vertex(-8 + j + 0, -8 + i + 1, 1.0f);
                        this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                        this.add_vertex(-8 + j + 0, -8 + i + 0, 1.0f);
                        this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                        this.add_vertex(-8 + j + 1, -8 + i + 0, 1.0f);
                        if (this.gimmedataat(data, i - 1, j) < 0) {
                            this.set_use_color(0.96f, 0.96f, 0.96f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                            this.add_vertex(-8 + j + 1, -8 + i + 0, 1.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                            this.add_vertex(-8 + j + 0, -8 + i + 0, 1.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(-8 + j + 0, -8 + i + 0, 0.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(-8 + j + 1, -8 + i + 0, 0.0f);
                        }
                        if (this.gimmedataat(data, i + 1, j) < 0) {
                            this.set_use_color(0.96f, 0.96f, 0.96f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                            this.add_vertex(-8 + j + 1, -8 + i + 1, 1.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(-8 + j + 1, -8 + i + 1, 0.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(-8 + j + 0, -8 + i + 1, 0.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                            this.add_vertex(-8 + j + 0, -8 + i + 1, 1.0f);
                        }
                        if (this.gimmedataat(data, i, j - 1) < 0) {
                            this.set_use_color(1.0f, 1.0f, 1.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                            this.add_vertex(-8 + j + 0, -8 + i + 1, 0.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(-8 + j + 0, -8 + i + 0, 0.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(-8 + j + 0, -8 + i + 0, 1.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                            this.add_vertex(-8 + j + 0, -8 + i + 1, 1.0f);
                        }
                        if (this.gimmedataat(data, i, j + 1) < 0) {
                            this.set_use_color(1.0f, 1.0f, 1.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                            this.add_vertex(-8 + j + 1, -8 + i + 1, 1.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(-8 + j + 1, -8 + i + 0, 1.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(-8 + j + 1, -8 + i + 0, 0.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                            this.add_vertex(-8 + j + 1, -8 + i + 1, 0.0f);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 16) {
                int j = 0;
                while (j < 16) {
                    int curval = this.gimmedataat(data, i, j);
                    if (curval >= 0) {
                        this.set_use_color(0.98f, 0.98f, 0.98f);
                        this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                        this.add_vertex(8 - j + 1, 8 - i + 1, 0.0f);
                        this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                        this.add_vertex(8 - j + 1, 8 - i + 0, 0.0f);
                        this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                        this.add_vertex(8 - j + 0, 8 - i + 0, 0.0f);
                        this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                        this.add_vertex(8 - j + 0, 8 - i + 1, 0.0f);
                        this.set_use_color(0.98f, 0.98f, 0.98f);
                        this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                        this.add_vertex(8 - j + 1, 8 - i + 1, 1.0f);
                        this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                        this.add_vertex(8 - j + 0, 8 - i + 1, 1.0f);
                        this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                        this.add_vertex(8 - j + 0, 8 - i + 0, 1.0f);
                        this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                        this.add_vertex(8 - j + 1, 8 - i + 0, 1.0f);
                        if (this.gimmedataat(data, i + 1, j) < 0) {
                            this.set_use_color(0.96f, 0.96f, 0.96f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                            this.add_vertex(8 - j + 1, 8 - i + 0, 1.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                            this.add_vertex(8 - j + 0, 8 - i + 0, 1.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(8 - j + 0, 8 - i + 0, 0.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(8 - j + 1, 8 - i + 0, 0.0f);
                        }
                        if (this.gimmedataat(data, i - 1, j) < 0) {
                            this.set_use_color(0.96f, 0.96f, 0.96f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                            this.add_vertex(8 - j + 1, 8 - i + 1, 1.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(8 - j + 1, 8 - i + 1, 0.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(8 - j + 0, 8 - i + 1, 0.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                            this.add_vertex(8 - j + 0, 8 - i + 1, 1.0f);
                        }
                        if (this.gimmedataat(data, i, j + 1) < 0) {
                            this.set_use_color(1.0f, 1.0f, 1.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                            this.add_vertex(8 - j + 0, 8 - i + 1, 0.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(8 - j + 0, 8 - i + 0, 0.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(8 - j + 0, 8 - i + 0, 1.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                            this.add_vertex(8 - j + 0, 8 - i + 1, 1.0f);
                        }
                        if (this.gimmedataat(data, i, j - 1) < 0) {
                            this.set_use_color(1.0f, 1.0f, 1.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f);
                            this.add_vertex(8 - j + 1, 8 - i + 1, 1.0f);
                            this.set_use_tex((float)j / 16.0f + 0.0625f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(8 - j + 1, 8 - i + 0, 1.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f + 0.0625f);
                            this.add_vertex(8 - j + 1, 8 - i + 0, 0.0f);
                            this.set_use_tex((float)j / 16.0f, (float)i / 16.0f);
                            this.add_vertex(8 - j + 1, 8 - i + 1, 0.0f);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.finish_compile();
    }

    private int gimmedataat(byte[] data, int x, int y) {
        if (x < 0 || x >= 16) {
            return -1;
        }
        if (y < 0 || y >= 16) {
            return -1;
        }
        if (data[(x * 16 + y) * 4 + 3] >= 0 && data[(x * 16 + y) * 4 + 3] < 100) {
            return -1;
        }
        return data[(x * 16 + y) * 4] + data[(x * 16 + y) * 4 + 1] + data[(x * 16 + y) * 4 + 2] & 0xFFFFFF;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture(this.texturepath);
        }
        return this.texture;
    }

    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        return false;
    }

    public void leftClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
    }

    public void onFoodEaten(Entity e) {
    }

    public void onBlockBroken(Entity ent, int dimension, int x, int y, int z, int wasbid) {
    }

    private void begin_compile(int nverts) {
        this.textureoff = this.stride = 12;
        this.stride += 8;
        this.coloroff = this.stride;
        this.stride += 12;
        this.vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.vbodata = BufferUtils.createByteBuffer(nverts * this.stride);
    }

    private void finish_compile() {
        this.vbodata.flip();
        this.vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)this.vbodata, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)this.stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)this.stride, (long)this.textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)this.stride, (long)this.coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
    }

    private void addVertexInfoToVBO(float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        this.vbodata.putFloat(vx);
        this.vbodata.putFloat(vy);
        this.vbodata.putFloat(vz);
        this.vbodata.putFloat(tx);
        this.vbodata.putFloat(ty);
        this.vbodata.putFloat(br);
        this.vbodata.putFloat(bg);
        this.vbodata.putFloat(bb);
    }

    private void add_vertex(float x, float y, float z) {
        this.addVertexInfoToVBO(x, y, z, this.use_tx, this.use_ty, this.use_r, this.use_g, this.use_b);
    }

    private void set_use_color(float r, float g, float b) {
        this.use_r = r;
        this.use_g = g;
        this.use_b = b;
    }

    private void set_use_tex(float x, float y) {
        this.use_tx = x;
        this.use_ty = y;
    }

    public void vr_hit_something(Entity e, int bid) {
        if (bid != 0) {
            DangerZone.hit_pulse(500);
            return;
        }
        if (e != null) {
            DangerZone.hit_pulse(1500);
        }
    }

    public void vr_hit_EntityBlockItem(Entity e) {
        if (e != null && e instanceof EntityBlockItem) {
            DangerZone.player.leftclick(e.world, 0, 0, 0, 0, e.entityID, 0.0f, 0, 0.0, 0.0, 0.0);
            e.deadflag = true;
        }
    }
}

