/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.gui;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import slick.ColorSlick;
import slick.Texture;

public class GuiInterface {
    public boolean escaped = false;
    public boolean entered = false;
    public boolean arrow_up = false;
    public boolean arrow_down = false;
    public boolean caps = false;
    public InventoryContainer mousebite = null;
    public boolean grab_mouse = false;
    public List<ButtonHandler> buttons = null;
    public int clickx;
    public int clicky;
    public int diffx = 0;
    public int diffy = 0;
    public int startx;
    public int starty;
    public int middle;
    public int bottom_of_display;
    public int top_of_display;
    public int left_of_display;
    public float scalex = (float)DangerZone.screen_width / 1920.0f;
    public float scaley = (float)DangerZone.screen_height / 1080.0f;
    public boolean leftdown = false;
    public boolean rightdown = false;
    public boolean middledown = false;
    public String guimessagestring = null;
    public int guimessagetimer = 0;

    public void process(int mode) {
        this.K_clear();
        this.M_clear();
    }

    public void ImAllDone() {
        this.G_clear();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        this.K_clear();
        this.M_clear();
        this.G_clear();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        this.K_clear();
        this.M_clear();
        DangerZone.clearActiveGui();
        DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
    }

    public void textAt(float xpos, float ypos, String text) {
        DangerZone.wr.loadtexture(Blocks.stone.getTexture(0));
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scalex, (float)this.scaley, (float)1.0f);
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)DangerZone.font.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        DangerZone.font.drawString(0.0f, 0.0f, text, ColorSlick.white);
        GL11.glPopMatrix();
    }

    public void smallTextAt(float xpos, float ypos, String text) {
        DangerZone.wr.loadtexture(Blocks.stone.getTexture(0));
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scalex, (float)this.scaley, (float)1.0f);
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)DangerZone.font16.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        DangerZone.font16.drawString(0.0f, 0.0f, text, ColorSlick.white);
        GL11.glPopMatrix();
    }

    public void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize) {
        DangerZone.wr.forceloadtexture(t);
        float w = t.getWidth();
        float h = t.getHeight();
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scalex, (float)this.scaley, (float)1.0f);
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)(xsize / t.getWidth()), (float)(ysize / t.getHeight()), (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize, float zrot) {
        DangerZone.wr.forceloadtexture(t);
        float w = t.getWidth();
        float h = t.getHeight();
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scalex, (float)this.scaley, (float)1.0f);
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glRotatef((float)zrot, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)(xsize / t.getWidth()), (float)(ysize / t.getHeight()), (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void drawRectangleWithTextureTwo(Texture t, float xpos, float ypos, float xsize, float ysize, float zrot, float extrascale) {
        DangerZone.wr.forceloadtexture(t);
        float w = t.getWidth();
        float h = t.getHeight();
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scalex, (float)this.scaley, (float)1.0f);
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)(extrascale * xsize / t.getWidth()), (float)(extrascale * ysize / t.getHeight()), (float)1.0f);
        GL11.glRotatef((float)zrot, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void drawUsed(float used, float xpos, float ypos, float xsize, float ysize) {
        float xs;
        if (used > 1.0f) {
            used = 1.0f;
        }
        if (used < 0.0f) {
            used = 0.0f;
        }
        if ((xs = xsize * (1.0f - used)) < 1.0f) {
            xs = 1.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scalex, (float)this.scaley, (float)1.0f);
        GL11.glDisable((int)3553);
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glColor3f((float)used, (float)(1.0f - used), (float)0.0f);
        GL11.glVertex3f((float)xs, (float)ysize, (float)0.0f);
        GL11.glColor3f((float)used, (float)(1.0f - used), (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)ysize, (float)0.0f);
        GL11.glColor3f((float)used, (float)(1.0f - used), (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)used, (float)(1.0f - used), (float)0.0f);
        GL11.glVertex3f((float)xs, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public void drawcoloredsquare(int xpos, int ypos, int xsize, int ysize, float r, float g, float b, float a) {
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scalex, (float)this.scaley, (float)1.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glVertex3f((float)xsize, (float)ysize, (float)0.0f);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glVertex3f((float)0.0f, (float)ysize, (float)0.0f);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glVertex3f((float)xsize, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public void G_clear() {
        DangerZone.glfw_clear();
    }

    public void K_clear() {
        DangerZone.K_clear();
    }

    public void M_clear() {
        DangerZone.M_clear();
    }

    public boolean K_next() {
        return DangerZone.K_next();
    }

    public int K_getEventKey() {
        return DangerZone.K_getEventKey();
    }

    public boolean K_isEventKeyDown() {
        return DangerZone.K_isEventKeyDown();
    }

    public boolean K_isKeyDown(int key) {
        return DangerZone.K_isKeyDown(key);
    }

    public boolean M_next() {
        return DangerZone.M_next();
    }

    public int M_getEventButton() {
        return DangerZone.M_getEventButton();
    }

    public boolean M_getEventButtonState() {
        return DangerZone.M_getEventButtonState();
    }

    public int M_getEventX() {
        return DangerZone.M_getEventX();
    }

    public int M_getEventY() {
        return DangerZone.M_getEventY();
    }

    public int M_getEventDX() {
        return DangerZone.M_getEventDX();
    }

    public int M_geEventDY() {
        return DangerZone.M_getEventDY();
    }

    public int M_getCurX() {
        return DangerZone.M_getCurX();
    }

    public int M_getCurY() {
        return DangerZone.M_getCurY();
    }

    public int M_getCurDX() {
        return DangerZone.M_getCurDX();
    }

    public int M_getCurDY() {
        return DangerZone.M_getCurDY();
    }

    public String getTextChar() {
        this.escaped = false;
        this.entered = false;
        this.arrow_up = false;
        this.arrow_down = false;
        while (this.K_next()) {
            int currk = this.K_getEventKey();
            if (currk == 256) {
                this.escaped = this.K_isEventKeyDown();
            }
            if (currk == 257) {
                this.entered = this.K_isEventKeyDown();
            }
            if (currk == 265) {
                this.arrow_up = this.K_isEventKeyDown();
            }
            if (currk == 264) {
                this.arrow_down = this.K_isEventKeyDown();
            }
            if (currk == 340 || currk == 344) {
                this.caps = this.K_isEventKeyDown();
            }
            if (!this.K_isEventKeyDown()) continue;
            switch (currk) {
                case 261: {
                    return "delete";
                }
                case 259: {
                    return "delete";
                }
                case 48: {
                    if (this.caps) {
                        return ")";
                    }
                    return "0";
                }
                case 49: {
                    if (this.caps) {
                        return "!";
                    }
                    return "1";
                }
                case 50: {
                    if (this.caps) {
                        return "@";
                    }
                    return "2";
                }
                case 51: {
                    if (this.caps) {
                        return "#";
                    }
                    return "3";
                }
                case 52: {
                    if (this.caps) {
                        return "$";
                    }
                    return "4";
                }
                case 53: {
                    if (this.caps) {
                        return "%";
                    }
                    return "5";
                }
                case 54: {
                    if (this.caps) {
                        return "^";
                    }
                    return "6";
                }
                case 55: {
                    if (this.caps) {
                        return "&";
                    }
                    return "7";
                }
                case 56: {
                    if (this.caps) {
                        return "*";
                    }
                    return "8";
                }
                case 57: {
                    if (this.caps) {
                        return "(";
                    }
                    return "9";
                }
                case 65: {
                    if (this.caps) {
                        return "A";
                    }
                    return "a";
                }
                case 66: {
                    if (this.caps) {
                        return "B";
                    }
                    return "b";
                }
                case 67: {
                    if (this.caps) {
                        return "C";
                    }
                    return "c";
                }
                case 68: {
                    if (this.caps) {
                        return "D";
                    }
                    return "d";
                }
                case 69: {
                    if (this.caps) {
                        return "E";
                    }
                    return "e";
                }
                case 70: {
                    if (this.caps) {
                        return "F";
                    }
                    return "f";
                }
                case 71: {
                    if (this.caps) {
                        return "G";
                    }
                    return "g";
                }
                case 72: {
                    if (this.caps) {
                        return "H";
                    }
                    return "h";
                }
                case 73: {
                    if (this.caps) {
                        return "I";
                    }
                    return "i";
                }
                case 74: {
                    if (this.caps) {
                        return "J";
                    }
                    return "j";
                }
                case 75: {
                    if (this.caps) {
                        return "K";
                    }
                    return "k";
                }
                case 76: {
                    if (this.caps) {
                        return "L";
                    }
                    return "l";
                }
                case 77: {
                    if (this.caps) {
                        return "M";
                    }
                    return "m";
                }
                case 78: {
                    if (this.caps) {
                        return "N";
                    }
                    return "n";
                }
                case 79: {
                    if (this.caps) {
                        return "O";
                    }
                    return "o";
                }
                case 80: {
                    if (this.caps) {
                        return "P";
                    }
                    return "p";
                }
                case 81: {
                    if (this.caps) {
                        return "Q";
                    }
                    return "q";
                }
                case 82: {
                    if (this.caps) {
                        return "R";
                    }
                    return "r";
                }
                case 83: {
                    if (this.caps) {
                        return "S";
                    }
                    return "s";
                }
                case 84: {
                    if (this.caps) {
                        return "T";
                    }
                    return "t";
                }
                case 85: {
                    if (this.caps) {
                        return "U";
                    }
                    return "u";
                }
                case 86: {
                    if (this.caps) {
                        return "V";
                    }
                    return "v";
                }
                case 87: {
                    if (this.caps) {
                        return "W";
                    }
                    return "w";
                }
                case 88: {
                    if (this.caps) {
                        return "X";
                    }
                    return "x";
                }
                case 89: {
                    if (this.caps) {
                        return "Y";
                    }
                    return "y";
                }
                case 90: {
                    if (this.caps) {
                        return "Z";
                    }
                    return "z";
                }
                case 46: {
                    if (this.caps) {
                        return ">";
                    }
                    return ".";
                }
                case 44: {
                    if (this.caps) {
                        return "<";
                    }
                    return ",";
                }
                case 47: {
                    if (this.caps) {
                        return "?";
                    }
                    return "/";
                }
                case 59: {
                    if (this.caps) {
                        return ":";
                    }
                    return ";";
                }
                case 39: {
                    if (this.caps) {
                        return "\"";
                    }
                    return "'";
                }
                case 32: 
                case 258: {
                    return " ";
                }
                case 92: {
                    if (this.caps) {
                        return "|";
                    }
                    return "\\";
                }
                case 91: {
                    if (this.caps) {
                        return "{";
                    }
                    return "[";
                }
                case 93: {
                    if (this.caps) {
                        return "}";
                    }
                    return "]";
                }
                case 45: {
                    if (this.caps) {
                        return "_";
                    }
                    return "-";
                }
                case 61: {
                    if (this.caps) {
                        return "+";
                    }
                    return "=";
                }
            }
        }
        return null;
    }

    public void showArmorValue(int which, int x, int y) {
        Item it;
        InventoryContainer ic = DangerZone.player.getArmor(which);
        if (ic != null && ic.count == 1 && (it = ic.getItem()) instanceof ItemArmor) {
            ItemArmor ia = (ItemArmor)it;
            String s = String.format("%3.1f", Float.valueOf(ia.protection));
            this.textAt(x, y, s);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void ClickedHotBar(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(0, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void ClickedInventory(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(1, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void ClickedEntityInventory(int eid, int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(2, eid, which, leftrightmid, shifted ? 1 : 0);
    }

    public void ClickedCreativeInventory(int iid, int bid, boolean shifted) {
        DangerZone.server_connection.handleInventory(3, iid, bid, shifted ? 1 : 0, 0);
    }

    public void ClickedCrafted(int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(4, leftrightmid, shifted ? 1 : 0, 0, 0);
    }

    public void ClickedCrafting(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(5, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void SpreadListAdd(int which, int iid, int bid) {
        DangerZone.server_connection.handleInventory(6, which, iid, bid, 0);
    }

    public void SpreadListClear() {
        DangerZone.server_connection.handleInventory(7, 0, 0, 0, 0);
    }

    public void ClearTable() {
        DangerZone.server_connection.handleInventory(8, 0, 0, 0, 0);
    }

    public void ClickedArmor(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(9, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void DeleteMouseBite() {
        DangerZone.server_connection.handleInventory(10, 0, 0, 0, 0);
    }

    public void SpitMouseBite() {
        DangerZone.server_connection.handleInventory(11, 0, 0, 0, 0);
    }

    public void ClickedInventoryWithEntity(int which, int leftrightmid, boolean shifted, int eid) {
        DangerZone.server_connection.handleInventory(12, which, leftrightmid, shifted ? 1 : 0, eid);
    }

    public void SpitOneHotbar() {
        DangerZone.server_connection.handleInventory(13, 0, 0, 0, 0);
    }

    public void SellToEntity(int eid) {
        DangerZone.server_connection.handleInventory(14, eid, 0, 0, 0);
    }

    public void BuyFromEntity(int which, int eid) {
        DangerZone.server_connection.handleInventory(15, which, eid, 0, 0);
    }

    public void UnStayEntity(int eid) {
        DangerZone.server_connection.handleInventory(16, eid, 0, 0, 0);
    }

    public void MouseBiteToEntity(int eid) {
        DangerZone.server_connection.handleInventory(17, eid, 0, 0, 0);
    }

    public void ClickedDeskCrafted(int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(18, leftrightmid, shifted ? 1 : 0, 0, 0);
    }

    public void ClickedDeskCrafting(int which, int leftrightmid, boolean shifted) {
        DangerZone.server_connection.handleInventory(19, which, leftrightmid, shifted ? 1 : 0, 0);
    }

    public void std_setup(int mode) {
        this.scalex = (float)DangerZone.screen_width / 1920.0f;
        this.scaley = (float)DangerZone.screen_height / 1080.0f;
        this.starty = 1080;
        this.middle = 960;
        this.startx = 0;
        this.bottom_of_display = 0;
        if (mode != 0) {
            float useylast;
            this.startx = DangerZone.get_left(mode);
            this.starty = DangerZone.get_top(mode);
            this.middle = DangerZone.get_middle(mode);
            this.bottom_of_display = DangerZone.get_bottom(mode);
            this.scaley = (float)DangerZone.use_height / 1080.0f;
            this.scalex = (float)DangerZone.use_width / 1920.0f;
            float usexhead = DangerZone.player.rotation_yaw_head;
            float usexlast = DangerZone.player_last_yaw;
            float hdiff = usexhead - usexlast;
            if (hdiff > 180.0f) {
                hdiff -= 360.0f;
            }
            if (hdiff < -180.0f) {
                hdiff += 360.0f;
            }
            this.startx = (int)((float)this.startx - hdiff * 10.0f);
            this.middle = (int)((float)this.middle - hdiff * 10.0f);
            this.diffx = (int)(hdiff * 10.0f);
            float useyhead = DangerZone.player.rotation_pitch_head;
            if (useyhead > 180.0f) {
                useyhead -= 360.0f;
            }
            if ((useylast = -15.0f) > 180.0f) {
                useylast -= 360.0f;
            }
            hdiff = useyhead - useylast;
            this.starty = (int)((float)this.starty + hdiff * 10.0f);
            this.bottom_of_display = (int)((float)this.bottom_of_display + hdiff * 10.0f);
            this.diffy = (int)(hdiff * 10.0f);
        }
        this.startx += 100;
        this.top_of_display = this.starty;
        this.left_of_display = this.startx;
    }

    public int std_draw(int mode) {
        Texture sighttexture = null;
        Texture tx = null;
        String s = null;
        this.clickx = 0;
        this.clicky = 0;
        int high_button = this.findHighlightedButton(mode);
        if (this.buttons != null) {
            Iterator<ButtonHandler> bb = this.buttons.iterator();
            ButtonHandler thisbutton = null;
            float diff = 0.55f;
            if (mode == 0) {
                diff = 0.75f;
            }
            while (bb.hasNext()) {
                thisbutton = bb.next();
                thisbutton.draw(thisbutton.buttonid == high_button ? 1.0f : diff);
            }
        }
        this.std_text(high_button);
        if (this.guimessagetimer > 0) {
            --this.guimessagetimer;
            if (this.guimessagestring != null) {
                if (mode == 0) {
                    this.drawRectangleWithTexture(DangerZone.textinputtexture, this.middle - 5 * this.guimessagestring.length() - 50, this.bottom_of_display + 95, 13 * this.guimessagestring.length() + 20, 30.0f);
                    this.textAt(this.middle - 5 * this.guimessagestring.length() - 30, this.bottom_of_display + 95, this.guimessagestring);
                } else {
                    this.drawRectangleWithTexture(DangerZone.textinputtexture, this.clickx - 5 * this.guimessagestring.length() - 50, this.clicky - 65, 13 * this.guimessagestring.length() + 20, 30.0f);
                    this.textAt(this.clickx - 5 * this.guimessagestring.length() - 30, this.clicky - 65, this.guimessagestring);
                }
            }
            if (this.guimessagetimer <= 0) {
                this.guimessagestring = null;
            }
        }
        this.mousebite = DangerZone.player.getMouseBite();
        if (mode == 0) {
            if (this.mousebite != null) {
                float x = this.M_getCurX();
                float y = this.M_getCurY();
                x /= this.scalex;
                y /= this.scaley;
                tx = this.mousebite.getTexture();
                s = null;
                if (this.mousebite.count > 1) {
                    s = String.format("%d", this.mousebite.count);
                }
                if (tx != null) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    this.drawRectangleWithTexture(tx, x - 24.0f, y - 24.0f, 48.0f, 48.0f);
                }
                if (s != null && !s.equals("")) {
                    this.textAt(x - 18.0f, y - 24.0f, s);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        } else if (this.mousebite != null) {
            tx = this.mousebite.getTexture();
            s = null;
            if (this.mousebite.count > 1) {
                s = String.format("%d", this.mousebite.count);
            }
            if (tx != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.drawRectangleWithTexture(tx, this.clickx - 16, this.clicky - 16, 32.0f, 32.0f);
            }
            if (s != null && !s.equals("")) {
                this.textAt(this.clickx - 10, this.clicky - 16, s);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else if (mode != 0) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            sighttexture = TextureMapper.getTexture("res/menus/sight.png");
            this.drawRectangleWithTexture(sighttexture, this.clickx - 16, this.clicky - 16, 32.0f, 32.0f);
        }
        return high_button;
    }

    public int findHighlightedButton(int mode) {
        if (this.buttons == null) {
            return -1;
        }
        if (mode == 0) {
            float x = this.M_getCurX();
            float y = this.M_getCurY();
            int lclickx = (int)(x /= this.scalex);
            int lclicky = (int)(y /= this.scaley);
            Iterator<ButtonHandler> bb = this.buttons.iterator();
            ButtonHandler thisbutton = null;
            while (bb.hasNext()) {
                thisbutton = bb.next();
                if (lclickx < thisbutton.x || lclickx > thisbutton.x + thisbutton.xsize || lclicky < thisbutton.y || lclicky > thisbutton.y + thisbutton.ysize) continue;
                return thisbutton.buttonid;
            }
        } else {
            float useylast;
            this.clickx = DangerZone.get_middle(mode);
            this.clicky = DangerZone.screen_height / 2;
            DangerZone.pointer_controller.calc_50();
            float usexhead = DangerZone.pointer_controller.yaw_50;
            float usexlast = DangerZone.player_last_yaw;
            float hdiff = usexhead - usexlast;
            if (hdiff > 180.0f) {
                hdiff -= 360.0f;
            }
            if (hdiff < -180.0f) {
                hdiff += 360.0f;
            }
            this.clickx = (int)((float)this.clickx + hdiff * 20.0f);
            this.clickx -= this.diffx;
            float useyhead = DangerZone.pointer_controller.pitch_50;
            if (useyhead > 180.0f) {
                useyhead -= 360.0f;
            }
            if ((useylast = 0.0f) > 180.0f) {
                useylast -= 360.0f;
            }
            this.clicky = (int)((float)this.clicky - (useyhead - useylast) * 20.0f);
            this.clicky += this.diffy;
            Iterator<ButtonHandler> bb = this.buttons.iterator();
            ButtonHandler thisbutton = null;
            ButtonHandler closer = null;
            float closest = 1000000.0f;
            while (bb.hasNext()) {
                thisbutton = bb.next();
                float dist = (float)Math.sqrt((thisbutton.x + thisbutton.xsize / 2 - this.clickx) * (thisbutton.x + thisbutton.xsize / 2 - this.clickx) + (thisbutton.y + thisbutton.ysize / 2 - this.clicky) * (thisbutton.y + thisbutton.ysize / 2 - this.clicky));
                if (!(dist < closest)) continue;
                closest = dist;
                closer = thisbutton;
            }
            if (closer != null) {
                return closer.buttonid;
            }
        }
        return -1;
    }

    public void std_clicker(int mode, int high_button) {
        TargetInfo ti;
        ButtonHandler fb = null;
        ButtonHandler mb = null;
        while (this.K_next()) {
            if (this.K_getEventKey() == 69 && this.K_isKeyDown(69)) {
                this.ImAllDone();
                return;
            }
            if (this.K_getEventKey() == 256 && this.K_isKeyDown(256)) {
                this.ImAllDone();
                return;
            }
            if (this.K_getEventKey() != 291 || !this.K_isEventKeyDown()) continue;
            Utils.screenshot(DangerZone.screen_width, DangerZone.screen_height);
            this.guimessagestring = "Screenshot!";
            this.guimessagetimer = 60;
        }
        if (this.buttons == null) {
            return;
        }
        Iterator<ButtonHandler> bb = this.buttons.iterator();
        if (mode == 0) {
            while (this.M_next()) {
                float x = this.M_getEventX();
                float y = this.M_getEventY();
                int lclickx = (int)(x /= this.scalex);
                int lclicky = (int)(y /= this.scaley);
                if (this.M_getEventButtonState()) {
                    if (this.M_getEventButton() < 0) continue;
                    bb = this.buttons.iterator();
                    fb = null;
                    while (bb.hasNext()) {
                        mb = bb.next();
                        if (lclickx < mb.x || lclickx > mb.x + mb.xsize || lclicky < mb.y || lclicky > mb.y + mb.ysize) continue;
                        fb = mb;
                        break;
                    }
                    if (this.M_getEventButton() == 0) {
                        if (fb != null) {
                            fb.leftclickhandler();
                        }
                        this.leftdown = true;
                    }
                    if (this.M_getEventButton() == 1) {
                        if (fb != null) {
                            fb.rightclickhandler();
                        }
                        this.rightdown = true;
                    }
                    if (this.M_getEventButton() != 2) continue;
                    if (fb != null) {
                        fb.middleclickhandler();
                    }
                    this.middledown = true;
                    continue;
                }
                if (this.M_getEventButton() == 0) {
                    this.leftdown = false;
                }
                if (this.M_getEventButton() == 1) {
                    this.rightdown = false;
                }
                if (this.M_getEventButton() != 2) continue;
                this.middledown = false;
            }
        } else if (mode == 1 && (ti = DangerZone.vr_is_clicked()) != null) {
            bb = this.buttons.iterator();
            fb = null;
            while (bb.hasNext()) {
                mb = bb.next();
                if (high_button != mb.buttonid) continue;
                fb = mb;
                break;
            }
            if (ti == DangerZone.pointer_controller) {
                if (fb != null) {
                    fb.leftclickhandler();
                }
            } else if (fb != null) {
                fb.rightclickhandler();
            }
        }
    }

    public void std_text(int high_button) {
        ButtonHandler fb = null;
        ButtonHandler mb = null;
        if (this.buttons == null) {
            return;
        }
        Iterator<ButtonHandler> bb = this.buttons.iterator();
        InventoryContainer ic = null;
        bb = this.buttons.iterator();
        fb = null;
        while (bb.hasNext()) {
            mb = bb.next();
            if (high_button != mb.buttonid) continue;
            fb = mb;
            break;
        }
        if (fb != null && (ic = fb.ic) != null) {
            String hotstring = null;
            String[] hss = null;
            if (ic.bid != 0) {
                hotstring = Blocks.getUniqueName(ic.bid);
            }
            if (ic.iid != 0) {
                hotstring = Items.getUniqueName(ic.iid);
                int attackstrength = Items.getAttackStrength(ic.iid);
                if (attackstrength > 1) {
                    hotstring = String.valueOf(hotstring) + String.format(" +%d", attackstrength);
                }
            }
            if (hotstring != null && (hss = hotstring.split(":")).length >= 2) {
                this.guimessagestring = hss[1];
                this.guimessagetimer = 10;
            }
        }
    }

    public void std_keypad_add(int mode) {
        if (mode == 0) {
            return;
        }
        Texture buttontexture = null;
        String s = null;
        String special = "!@#$%^&*()_+-= {}[]\\|;':\",./<>?`~";
        String numeric = "0123456789";
        String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        int c = 0;
        buttontexture = TextureMapper.getTexture("res/menus/button.png");
        this.starty -= 100;
        int i = 0;
        while (i < alpha.length()) {
            c = alpha.charAt(i);
            s = String.format("%c", Character.valueOf((char)c));
            this.buttons.add(new ButtonHandler(this.startx + 30 * (i % 26), this.starty - 40 * (i / 26), 30, 30, buttontexture, s, 26000 + c));
            ++i;
        }
        i = 0;
        while (i < numeric.length()) {
            c = numeric.charAt(i);
            s = String.format("%c", Character.valueOf((char)c));
            this.buttons.add(new ButtonHandler(this.startx + 30 * (i % 26), this.starty + 40 - 40 * (i / 26), 30, 30, buttontexture, s, 26000 + c));
            ++i;
        }
        i = 0;
        while (i < special.length()) {
            c = special.charAt(i);
            s = String.format("%c", Character.valueOf((char)c));
            this.buttons.add(new ButtonHandler(this.startx + 30 * (i % 26), this.starty + 120 - 40 * (i / 26), 30, 30, buttontexture, s, 26000 + c));
            ++i;
        }
        c = 32;
        s = "<space>";
        this.buttons.add(new ButtonHandler(this.startx, this.starty - 80, 140, 30, buttontexture, s, 26000 + c));
        c = 8;
        s = "<delete>";
        this.buttons.add(new ButtonHandler(this.startx + 180, this.starty - 80, 140, 30, buttontexture, s, 26000 + c));
        c = 27;
        s = "<escape>";
        this.buttons.add(new ButtonHandler(this.startx + 360, this.starty - 80, 140, 30, buttontexture, s, 26000 + c));
        s = "<up>";
        this.buttons.add(new ButtonHandler(this.startx, this.starty - 120, 140, 30, buttontexture, s, 26264));
        s = "<down>";
        this.buttons.add(new ButtonHandler(this.startx + 180, this.starty - 120, 140, 30, buttontexture, s, 26265));
        c = 10;
        s = "<enter>";
        this.buttons.add(new ButtonHandler(this.startx + 360, this.starty - 120, 140, 30, buttontexture, s, 26000 + c));
    }

    public String std_keypad_get(int mode, int high_button) {
        this.entered = false;
        this.escaped = false;
        this.arrow_up = false;
        this.arrow_down = false;
        if (mode == 0) {
            return this.getTextChar();
        }
        if (high_button < 26000 || high_button > 26999) {
            return null;
        }
        TargetInfo ti = DangerZone.vr_is_clicked();
        if (ti == null) {
            return null;
        }
        if (ti != DangerZone.pointer_controller) {
            return null;
        }
        ButtonHandler mb2 = null;
        Iterator<ButtonHandler> bb = this.buttons.iterator();
        for (ButtonHandler mb2 : this.buttons) {
            if (high_button != mb2.buttonid || high_button < 26000 || high_button >= 27000) continue;
            if (high_button == 26008) {
                return "delete";
            }
            if (high_button == 26010) {
                DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
                this.entered = true;
                return null;
            }
            if (high_button == 26027) {
                DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
                this.escaped = true;
                return null;
            }
            if (high_button == 26264) {
                DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
                this.arrow_down = true;
                return null;
            }
            if (high_button == 26265) {
                DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
                this.arrow_up = true;
                return null;
            }
            DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
            return String.format("%c", Character.valueOf((char)(high_button - 26000)));
        }
        return null;
    }

    public class ButtonHandler {
        public Texture t;
        public int x;
        public int y;
        public int xsize;
        public int ysize;
        public String s;
        public InventoryContainer ic;
        public int buttonid = 0;

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int bid) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = tx;
            this.s = ot;
            this.ic = null;
            this.buttonid = bid;
        }

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, InventoryContainer iic, int bid) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = null;
            this.s = null;
            this.ic = iic;
            this.buttonid = bid;
        }

        public void leftclickhandler() {
        }

        public void rightclickhandler() {
        }

        public void middleclickhandler() {
        }

        public void draw() {
            if (this.ic != null) {
                int md;
                Item it;
                this.t = this.ic.getTexture();
                this.s = null;
                if (this.ic.count > 1) {
                    this.s = String.format("%d", this.ic.count);
                }
                if (this.t != null) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GuiInterface.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
                }
                if (this.s != null && !this.s.equals("")) {
                    GuiInterface.this.textAt(this.x + 6, this.y, this.s);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (this.ic.count == 1 && this.ic.currentuses > 0 && this.ic.getMaxStack() == 1 && (it = this.ic.getItem()) != null && (md = it.maxuses) > 0) {
                    float pu = (float)this.ic.currentuses / (float)md;
                    GuiInterface.this.drawUsed(pu, this.x, this.y, this.xsize, 2.0f);
                }
            } else {
                if (this.t != null) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GuiInterface.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
                }
                if (this.s != null && !this.s.equals("")) {
                    GuiInterface.this.textAt(this.x + 6, this.y, this.s);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }

        public void draw(float tcolor) {
            if (this.ic != null) {
                int md;
                Item it;
                this.t = this.ic.getTexture();
                this.s = null;
                if (this.ic.count > 1) {
                    this.s = String.format("%d", this.ic.count);
                }
                if (this.t != null) {
                    GL11.glColor3f((float)tcolor, (float)tcolor, (float)tcolor);
                    GuiInterface.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
                }
                if (this.s != null && !this.s.equals("")) {
                    GuiInterface.this.textAt(this.x + 6, this.y, this.s);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (this.ic.count == 1 && this.ic.currentuses > 0 && this.ic.getMaxStack() == 1 && (it = this.ic.getItem()) != null && (md = it.maxuses) > 0) {
                    float pu = (float)this.ic.currentuses / (float)md;
                    GuiInterface.this.drawUsed(pu, this.x, this.y, this.xsize, 2.0f);
                }
            } else {
                if (this.t != null) {
                    GL11.glColor3f((float)tcolor, (float)tcolor, (float)tcolor);
                    GuiInterface.this.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
                }
                if (this.s != null && !this.s.equals("")) {
                    GuiInterface.this.textAt(this.x + 6, this.y, this.s);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }
}

