/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.BigPharma;
import dangerzone.entities.Dean;
import dangerzone.entities.Doctor;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Libtard;
import dangerzone.entities.Professor;
import dangerzone.entities.Vaxxed;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class Teacher
extends EntityLiving {
    public Teacher(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 1.9f;
        this.width = 0.85f;
        this.uniquename = "DangerZone:Teacher";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(1.25f);
        this.setAttackDamage(1.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 3.0f;
        this.movefrequency = 55;
        this.setExperience(30);
        this.canSwim = true;
        this.has_inventory = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
        this.enable_buddy = true;
        this.findbuddydistance = 25;
        this.findbuddyfrequency = 25;
    }

    @Override
    public String getLivingSound() {
        int which = this.world.rand.nextInt(8);
        if (which == 1) {
            return "DangerZone:vaxxed_living1";
        }
        if (which == 2) {
            return "DangerZone:vaxxed_living2";
        }
        if (which == 3) {
            return "DangerZone:vaxxed_living3";
        }
        if (which == 4) {
            return "DangerZone:vaxxed_living4";
        }
        if (which == 5) {
            return "DangerZone:vaxxed_living5";
        }
        return null;
    }

    @Override
    public void update(float deltaT) {
        if (this.getAttacking()) {
            this.setArmsUp(true);
        } else {
            this.setArmsUp(false);
        }
        super.update(deltaT);
    }

    @Override
    public float getLivingSoundVolume() {
        return 0.5f;
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(5);
        if (which == 1) {
            return "DangerZone:vaxxed_hit1";
        }
        if (which == 2) {
            return "DangerZone:vaxxed_hit2";
        }
        if (which == 3) {
            return "DangerZone:vaxxed_hit3";
        }
        if (which == 4) {
            return "DangerZone:vaxxed_hit4";
        }
        if (which == 0) {
            return "DangerZone:vaxxed_hit5";
        }
        return null;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:vaxxed_death";
    }

    @Override
    public String getAttackSound() {
        int which = this.world.rand.nextInt(5);
        if (which == 1) {
            return "DangerZone:vaxxed_attack1";
        }
        if (which == 2) {
            return "DangerZone:vaxxed_attack2";
        }
        if (which == 3) {
            return "DangerZone:vaxxed_attack3";
        }
        return null;
    }

    @Override
    public boolean isBuddy(Entity e) {
        if (e instanceof Vaxxed) {
            return true;
        }
        if (e instanceof Libtard) {
            return true;
        }
        if (e instanceof Teacher) {
            return true;
        }
        if (e instanceof Professor) {
            return true;
        }
        if (e instanceof Dean) {
            return true;
        }
        if (e instanceof Doctor) {
            return true;
        }
        return e instanceof BigPharma;
    }

    @Override
    public void doFindBuddy() {
        if (this.world.rand.nextInt(this.findbuddyfrequency) == 1) {
            List<Integer> nearby_list = null;
            int nbuddy = 0;
            double totalz = 0.0;
            double totalx = 0.0;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRangei(this.findbuddydistance, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                Entity e = null;
                ListIterator<Integer> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = DangerZone.server.entityManager.entities[li.next()];
                    if (e == null || e == this || !this.isBuddy(e)) continue;
                    int mult = 1;
                    if (e instanceof Vaxxed) {
                        mult = 1;
                    }
                    if (e instanceof Libtard) {
                        mult = 2;
                    }
                    if (e instanceof Teacher) {
                        mult = 4;
                    }
                    if (e instanceof Professor) {
                        mult = 8;
                    }
                    if (e instanceof Dean) {
                        mult = 16;
                    }
                    if (e instanceof Doctor) {
                        mult = 16;
                    }
                    if (e instanceof BigPharma) {
                        mult = 32;
                    }
                    totalx += e.posx * (double)mult;
                    totalz += e.posz * (double)mult;
                    nbuddy += mult;
                }
                if (nbuddy > 0) {
                    float rundir = (float)Math.atan2((totalx /= (double)nbuddy) - this.posx, (totalz /= (double)nbuddy) - this.posz);
                    rundir = (float)Math.toDegrees(rundir);
                    this.findNewTarget(rundir, 45.0f);
                }
            }
        }
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 13) {
            return;
        }
        this.doAttackFromCustom(e, dt, pain, true);
    }

    @Override
    public void doAttack(Entity victim) {
        Effects ef = new Effects(6, 0.02f, 50);
        victim.addEffectFromServer(ef);
        ef = new Effects(7, 1.0f, 50);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.world.isServer && (this.effect_list == null || this.effect_list.size() == 0)) {
            Effects ef = new Effects(6, 0.01f, 1000);
            this.addEffect(ef);
            ef = new Effects(7, 1.0f, 1000);
            this.addEffect(ef);
        }
        super.doEntityAction(deltaT);
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(3) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyteacher.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        int i = 0;
        while (i < 5) {
            Utils.doDropRand(this.world, 0, Items.frog_poison1.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Vaxxed) {
            return false;
        }
        if (e instanceof Libtard) {
            return false;
        }
        if (e instanceof Teacher) {
            return false;
        }
        if (e instanceof Professor) {
            return false;
        }
        if (e instanceof Dean) {
            return false;
        }
        if (e instanceof Doctor) {
            return false;
        }
        if (e instanceof BigPharma) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Teachertexture.png");
        }
        return this.texture;
    }
}

