/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Skeletorus
extends EntityLiving {
    public Skeletorus(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.65f;
        this.width = 1.25f;
        this.uniquename = "DangerZone:Skeletorus";
        this.moveSpeed = 0.36f;
        this.setMaxHealth(110.0f);
        this.setHealth(110.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(5.5f);
        this.searchDistance = 32.0f;
        this.attackRange = 3.65f;
        this.movefrequency = 65;
        this.setExperience(153);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:fuzzbutt_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:fuzzbutt_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:fuzzbutt_death";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyskeletorus.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        int howmany = 5 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.string.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Skeletortexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Skeletorus) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        return !(this.getLightAtLocation(w, dimension, x, y, z) > 0.55f);
    }
}

