/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Moose
extends EntityLiving {
    public Moose(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.height = 3.33f;
        this.width = 1.33f;
        this.uniquename = "DangerZone:Moose";
        this.moveSpeed = 0.33f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(8.0f);
        this.searchDistance = 10.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 65;
        this.setExperience(99);
        this.canSwim = true;
        this.daytimespawn = true;
        this.nighttimespawn = true;
        this.setCanDespawn(false);
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 3;
        this.foodblockdisteat = 12;
        this.foodblockheal = 5;
        this.isMilkable = true;
        this.tower_defense_enable = true;
    }

    @Override
    public boolean isFoodBlock(int bid) {
        return bid == Blocks.grass.blockID;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:moose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:moose_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 5 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophymoose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, Items.moosehead.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Moose) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Moosetexture.png");
        }
        return this.texture;
    }
}

