/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Monarch
extends EntityLiving {
    public float myspeed = 0.0f;

    public Monarch(World w) {
        super(w);
        this.maxrenderdist = 128;
        this.height = 0.25f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:Monarch";
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(0.5f);
        if (w != null) {
            this.myspeed = 0.05f + this.world.rand.nextFloat() * 0.1f;
        }
        this.takesFallDamage = false;
        this.setExperience(1);
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.canFly = true;
        this.setFlying(true);
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.do_swarm_despawn();
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 25;
            if (!this.world.isDaytime() && this.world.rand.nextInt(100) == 1 && this.getCanDespawn()) {
                this.deadflag = true;
            }
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    if (this.isSwarming()) {
                        int updown = 5;
                        int k = 1;
                        while (k < 10) {
                            bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                            if (bid != 0) {
                                updown = -1;
                                break;
                            }
                            ++k;
                        }
                        this.target.setTarget(this.posx + (double)this.world.rand.nextInt(10), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(10));
                    } else {
                        this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(10) - this.world.rand.nextInt(10)), this.posy + (double)(this.world.rand.nextInt(7) - 2), this.posz + (double)(this.world.rand.nextInt(10) - this.world.rand.nextInt(10)));
                    }
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    --keep_trying;
                    this.myspeed = 0.05f + this.world.rand.nextFloat() * 0.1f;
                }
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            if (this.world.rand.nextInt(50) == 1 && ((bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - 1, (int)this.posz)) == Blocks.dirt.blockID || bid == Blocks.grassblock.blockID) && this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) == 0) {
                this.world.setblockandmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, Blocks.milkweed_plant.blockID, this.world.rand.nextInt(4) + 4);
            }
            float dy = (float)(this.target.targety - this.posy);
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0f) > 0.2f) {
                dy = 0.2f;
            }
            if (dy < -0.2f) {
                dy = -0.2f;
            }
            this.motiony += dy;
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
            Utils.SpawnDustAlongPath(this);
        }
        super.update(deltaT);
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophymonarch.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Monarchtexture.png");
        }
        return this.texture;
    }
}

