/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLightning;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ModelLightning
extends ModelBase {
    int light = 0;
    boolean compiled = false;
    ByteBuffer vbodata = null;
    int vbo_buffer = 0;

    @Override
    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor) {
        EntityLightning li = (EntityLightning)entity;
        if (li.world != null && li.world.rand.nextBoolean()) {
            return;
        }
        if (li.world == null && DangerZone.rand.nextBoolean()) {
            return;
        }
        li.resetrand();
        int howmany = 1;
        int wid = 10;
        if (li.getnextrand(4) == 2) {
            howmany = 2;
        }
        int howhigh = 200;
        if (entity.getDefense() <= 10.0f) {
            howhigh = 100;
            --wid;
        }
        if (entity.getDefense() <= 5.0f) {
            howhigh = 50;
            --wid;
        }
        if (entity.getDefense() <= 2.0f) {
            howhigh = 25;
            --wid;
        }
        DangerZone.wr.setBrightness(1.0f);
        MatrixStack.sendFinalStack();
        int i = 0;
        while (i < howmany) {
            this.doline(li, 0.0f, 0.0f, 0.0f, howhigh, wid);
            ++i;
        }
        DangerZone.wr.setBrightness();
    }

    private void doline(EntityLightning li, float x, float y, float z, float height, float width) {
        if (width <= 1.0f || height <= 5.0f) {
            return;
        }
        int nx = li.getnextrand((int)height) - li.getnextrand((int)height);
        int nz = li.getnextrand((int)height) - li.getnextrand((int)height);
        if (!this.compiled) {
            this.doCompile();
        }
        this.vbodata.position(0);
        this.vbodata.limit(this.vbodata.capacity());
        ModelLightning.addVertexInfoToBuffer(this.vbodata, x + width / 2.0f + (float)nx, -(y + height), z + (float)nz, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ModelLightning.addVertexInfoToBuffer(this.vbodata, x - width / 2.0f + (float)nx, -(y + height), z + (float)nz, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ModelLightning.addVertexInfoToBuffer(this.vbodata, x - width / 2.0f, -y, z, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ModelLightning.addVertexInfoToBuffer(this.vbodata, x + width / 2.0f, -y, z, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.vbodata.position(0);
        this.vbodata.limit(this.vbodata.capacity());
        GL15.glBindBuffer((int)34962, (int)this.vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)this.vbodata, (int)35048);
        GL15.glBindBuffer((int)34962, (int)0);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)this.light);
        GL11.glDrawArrays((int)7, (int)0, (int)4);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        int howmany = 1;
        if (li.getnextrand(4) == 2) {
            howmany = 2;
        }
        int i = 0;
        while (i < howmany) {
            this.doline(li, x + (float)nx, y + height, z + (float)nz, height - (float)li.getnextrand(5), width - 0.5f * (float)(howmany + 1));
            ++i;
        }
    }

    @Override
    public void doScale(Entity ent) {
        MatrixStack.scale(1.125f, 1.125f, 1.125f);
    }

    private void doCompile() {
        int stride;
        int textureoff = stride = 12;
        int coloroff = stride += 8;
        stride += 12;
        this.light = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.light);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.vbodata = BufferUtils.createByteBuffer(4 * stride);
        ModelLightning.addVertexInfoToBuffer(this.vbodata, 4.0f, 4.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ModelLightning.addVertexInfoToBuffer(this.vbodata, -4.0f, 4.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ModelLightning.addVertexInfoToBuffer(this.vbodata, -4.0f, -4.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ModelLightning.addVertexInfoToBuffer(this.vbodata, 4.0f, -4.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.vbodata.flip();
        this.vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)this.vbodata, (int)35048);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        this.compiled = true;
    }

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }
}

