/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.ItemTiara;
import dangerzone.items.Items;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;
import dangerzone.rendering.ModelRenderer;
import dangerzone.rendering.TextureMapper;

public class ModelHumanoid
extends ModelBase {
    ModelRenderer head = new ModelRenderer(0, 0);
    ModelRenderer body;
    ModelRenderer leftarm;
    ModelRenderer rightarm;
    ModelRenderer rightleg;
    ModelRenderer leftleg;
    ModelRenderer headoverlay;
    ModelRenderer tail1;
    ModelRenderer tail2;
    ModelRenderer tail3;
    ModelRenderer tail4;
    ModelRenderer tail5;
    ModelRenderer flip1;
    ModelRenderer flip2;
    ModelRenderer flip3;
    ModelRenderer flip4;
    ModelRenderer flip5;
    ModelRenderer flip6;

    public ModelHumanoid() {
        this.head.addCube(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.head.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.head.setTextureSize(64, 32);
        this.head.setRotation(0.0f, 0.0f, 0.0f);
        this.body = new ModelRenderer(16, 16);
        this.body.addCube(-4.0f, 0.0f, -2.0f, 8, 12, 4);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.body.setTextureSize(64, 32);
        this.body.setRotation(0.0f, 0.0f, 0.0f);
        this.leftarm = new ModelRenderer(40, 16);
        this.leftarm.addCube(0.0f, -1.0f, -2.0f, 4, 12, 4);
        this.leftarm.setRotationPoint(4.0f, 1.0f, 0.0f);
        this.leftarm.setTextureSize(64, 32);
        this.leftarm.setRotation(0.0f, 0.0f, 0.0f);
        this.leftarm.mirror = false;
        this.rightarm = new ModelRenderer(40, 16);
        this.rightarm.addCube(-4.0f, -1.0f, -2.0f, 4, 12, 4);
        this.rightarm.setRotationPoint(-4.0f, 1.0f, 0.0f);
        this.rightarm.setTextureSize(64, 32);
        this.rightarm.setRotation(0.0f, 0.0f, 0.0f);
        this.rightleg = new ModelRenderer(0, 16);
        this.rightleg.addCube(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.rightleg.setRotationPoint(-2.0f, 12.0f, 0.0f);
        this.rightleg.setTextureSize(64, 32);
        this.rightleg.setRotation(0.0f, 0.0f, 0.0f);
        this.leftleg = new ModelRenderer(0, 16);
        this.leftleg.addCube(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.leftleg.setRotationPoint(2.0f, 12.0f, 0.0f);
        this.leftleg.setTextureSize(64, 32);
        this.leftleg.setRotation(0.0f, 0.0f, 0.0f);
        this.leftleg.mirror = false;
        this.headoverlay = new ModelRenderer(this, 32, 0);
        this.headoverlay.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.headoverlay.setRotationPoint(0.0f, 0.5f, 0.0f);
        this.headoverlay.setTextureSize(64, 32);
        this.setRotation(this.headoverlay, 0.0f, 0.0f, 0.0f);
        this.tail1 = new ModelRenderer(this, 0, 33);
        this.tail1.addBox(-4.0f, 0.0f, -2.0f, 8, 8, 4);
        this.tail1.setRotationPoint(0.0f, 10.0f, 0.0f);
        this.tail1.setTextureSize(64, 128);
        this.setRotation(this.tail1, 0.5410521f, 0.0f, 0.0f);
        this.tail2 = new ModelRenderer(this, 0, 46);
        this.tail2.addBox(-4.0f, 0.0f, -2.0f, 8, 7, 4);
        this.tail2.setRotationPoint(0.0f, 16.0f, 3.0f);
        this.tail2.setTextureSize(64, 128);
        this.setRotation(this.tail2, 0.9948377f, 0.0f, 0.0f);
        this.tail3 = new ModelRenderer(this, 0, 58);
        this.tail3.addBox(-3.5f, 0.0f, -2.0f, 7, 6, 4);
        this.tail3.setRotationPoint(0.0f, 19.0f, 8.0f);
        this.tail3.setTextureSize(64, 128);
        this.setRotation(this.tail3, 1.343904f, 0.0f, 0.0f);
        this.tail4 = new ModelRenderer(this, 0, 69);
        this.tail4.addBox(-3.0f, 0.0f, -2.0f, 6, 6, 4);
        this.tail4.setRotationPoint(0.0f, 20.0f, 13.0f);
        this.tail4.setTextureSize(64, 128);
        this.setRotation(this.tail4, 1.500983f, 0.0f, 0.0f);
        this.tail5 = new ModelRenderer(this, 0, 80);
        this.tail5.addBox(-2.5f, 0.0f, -1.5f, 5, 6, 3);
        this.tail5.setRotationPoint(0.0f, 20.5f, 18.0f);
        this.tail5.setTextureSize(64, 128);
        this.setRotation(this.tail5, 1.570796f, 0.0f, 0.0f);
        this.flip1 = new ModelRenderer(this, 0, 90);
        this.flip1.addBox(-2.0f, 0.0f, -1.0f, 4, 7, 2);
        this.flip1.setRotationPoint(0.0f, 20.5f, 23.0f);
        this.flip1.setTextureSize(64, 128);
        this.setRotation(this.flip1, 1.570796f, 0.0f, 0.0f);
        this.flip2 = new ModelRenderer(this, 0, 100);
        this.flip2.addBox(-2.0f, 6.0f, -1.0f, 4, 7, 2);
        this.flip2.setRotationPoint(0.0f, 20.5f, 23.0f);
        this.flip2.setTextureSize(64, 128);
        this.setRotation(this.flip2, 1.570796f, 0.0f, 0.0f);
        this.flip3 = new ModelRenderer(this, 0, 112);
        this.flip3.addBox(-4.0f, -0.5f, 10.5f, 10, 1, 12);
        this.flip3.setRotationPoint(0.0f, 20.5f, 23.0f);
        this.flip3.setTextureSize(64, 128);
        this.setRotation(this.flip3, 0.0f, 0.3316126f, 0.0f);
        this.flip4 = new ModelRenderer(this, 18, 97);
        this.flip4.addBox(-6.0f, -0.5f, 10.5f, 10, 1, 12);
        this.flip4.setRotationPoint(0.0f, 20.5f, 23.0f);
        this.flip4.setTextureSize(64, 128);
        this.setRotation(this.flip4, 0.0f, -0.3316126f, 0.0f);
        this.flip5 = new ModelRenderer(this, 29, 84);
        this.flip5.addBox(-7.5f, -0.5f, 3.0f, 6, 1, 9);
        this.flip5.setRotationPoint(0.0f, 20.5f, 23.0f);
        this.flip5.setTextureSize(64, 128);
        this.setRotation(this.flip5, 0.0f, 0.9773844f, 0.0f);
        this.flip6 = new ModelRenderer(this, 29, 72);
        this.flip6.addBox(1.5f, -0.5f, 3.0f, 6, 1, 9);
        this.flip6.setRotationPoint(0.0f, 20.5f, 23.0f);
        this.flip6.setTextureSize(64, 128);
        this.setRotation(this.flip6, 0.0f, -0.9773844f, 0.0f);
    }

    @Override
    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor) {
        Item it;
        EntityLiving pl;
        int armorid;
        Entity ent;
        InventoryContainer ic;
        float newangle = 0.0f;
        Entity ridden = null;
        boolean isMermaid = false;
        if (entity != null) {
            ridden = entity.getRiddenEntity();
        }
        if (ridden != null) {
            f1 = 0.0f;
        }
        if (f2 > 40.0f) {
            f2 = 40.0f;
        }
        if (f2 < -40.0f) {
            f2 = -40.0f;
        }
        if (f3 > 55.0f) {
            f3 = 55.0f;
        }
        if (f3 < -55.0f) {
            f3 = -55.0f;
        }
        if (f4 > 30.0f) {
            f4 = 30.0f;
        }
        if (f4 < -30.0f) {
            f4 = -30.0f;
        }
        this.head.rotateAngleX = (float)Math.toRadians(f2);
        this.head.rotateAngleY = entity instanceof Player ? (float)Math.toRadians(f3) : (float)(-Math.toRadians(f3));
        this.head.rotateAngleZ = -((float)Math.toRadians(f4));
        if ((double)f1 > 0.02) {
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            newangle = (float)(Math.cos(Math.toRadians(f * 10.6f)) * 3.1415927410125732 * (double)0.45f * (double)f1);
            if (entity.isBaby()) {
                newangle = (float)(Math.cos(Math.toRadians(f * 20.6f)) * 3.1415927410125732 * (double)0.45f * (double)f1);
            }
        } else {
            newangle = 0.0f;
        }
        this.leftleg.rotateAngleX = newangle;
        this.rightleg.rotateAngleX = -newangle;
        this.leftarm.rotateAngleX = -newangle;
        this.rightarm.rotateAngleX = newangle;
        newangle = (float)(Math.cos(Math.toRadians(f * 1.6f)) * 3.1415927410125732 * (double)0.01f);
        this.leftarm.rotateAngleZ = -0.017f + newangle;
        newangle = (float)(Math.cos(Math.toRadians(f * 1.3f)) * 3.1415927410125732 * (double)0.01f);
        this.rightarm.rotateAngleZ = 0.017f + newangle;
        newangle = (float)(Math.cos(Math.toRadians(f * 1.1f)) * 3.1415927410125732 * (double)0.015f);
        this.leftarm.rotateAngleX += newangle;
        newangle = (float)(Math.cos(Math.toRadians(f * 1.2f)) * 3.1415927410125732 * (double)0.015f);
        this.rightarm.rotateAngleX += newangle;
        if (entity != null) {
            if (entity.getArmsUp()) {
                this.rightarm.rotateAngleX = (float)((double)this.rightarm.rotateAngleX - 1.5707963267948966);
                this.leftarm.rotateAngleX = (float)((double)this.leftarm.rotateAngleX - 1.5707963267948966);
            } else {
                this.rightarm.rotateAngleX = (float)((double)this.rightarm.rotateAngleX + Math.toRadians(entity.getRightArmAngle()));
                this.rightarm.rotateAngleZ = (float)((double)this.rightarm.rotateAngleZ + Math.toRadians(entity.getRightArmAngle()) / 6.0);
            }
        }
        if (entity != null && (ic = entity.getHotbar(entity.gethotbarindex())) != null) {
            Item it2;
            this.rightarm.rotateAngleX += -0.624f;
            if (entity.getRightButtonDownCount() != 0 && (it2 = ic.getItem()) != null && (it2.hold_straight || it2.isfood)) {
                this.rightarm.rotateAngleX = this.head.rotateAngleX - 1.620795f;
                this.rightarm.rotateAngleZ = 0.0f;
            }
        }
        MatrixStack.pushMatrix();
        if (entity != null && (ent = entity.getRiddenEntity()) != null) {
            MatrixStack.translate(0.0f, ent.getRiderYoffset() * 16.0f, 0.0f);
        }
        if (entity != null && entity.getSitting()) {
            this.leftleg.rotateAngleX = -1.344f;
            this.rightleg.rotateAngleX = -1.344f;
            this.leftleg.rotateAngleY = -0.244f;
            this.rightleg.rotateAngleY = 0.244f;
            MatrixStack.translate(0.0f, -10.0f, 0.0f);
        } else if (entity != null && entity instanceof Player && (armorid = (pl = (Player)entity).getBootsID()) != 0) {
            MatrixStack.translate(0.0f, 1.45f, 0.0f);
        }
        MatrixStack.sendCurrentStack();
        this.head.render(deathfactor);
        this.body.render(deathfactor);
        this.leftarm.render(deathfactor);
        this.rightarm.render(deathfactor);
        if (entity != null && entity instanceof EntityLiving) {
            pl = (EntityLiving)entity;
            armorid = pl.getHelmetID();
            if (armorid == 0) {
                this.drawHeadOverlay(deathfactor);
            } else {
                it = Items.getItem(armorid);
                if (it != null && it instanceof ItemTiara) {
                    isMermaid = true;
                }
            }
        }
        if (!isMermaid) {
            this.rightleg.render(deathfactor);
            this.leftleg.render(deathfactor);
        } else {
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if (f1 < 0.01f) {
                f1 = 0.01f;
            }
            float tailspeed = 3.25f;
            float tailamp = 0.1f;
            float pi4 = 0.7853982f;
            if (entity.getAttacking()) {
                tailspeed = 5.25f;
                tailamp = 0.25f;
            }
            this.tail1.rotateAngleX = (float)(Math.sin(Math.toRadians(f * tailspeed)) * 3.1415927410125732 * (double)(tailamp *= f1 * 3.0f) / 2.0);
            this.tail1.rotateAngleX += 0.541f;
            this.tail2.rotationPointZ = this.tail1.rotationPointZ + (float)Math.sin(this.tail1.rotateAngleX) * 7.0f;
            this.tail2.rotationPointY = this.tail1.rotationPointY + (float)Math.cos(this.tail1.rotateAngleX) * 7.0f;
            this.tail2.rotateAngleX = (float)(Math.sin(Math.toRadians(f * tailspeed) - (double)pi4) * 3.1415927410125732 * (double)tailamp);
            this.tail2.rotateAngleX += 0.995f;
            this.tail3.rotationPointZ = this.tail2.rotationPointZ + (float)Math.sin(this.tail2.rotateAngleX) * 6.0f;
            this.tail3.rotationPointY = this.tail2.rotationPointY + (float)Math.cos(this.tail2.rotateAngleX) * 6.0f;
            this.tail3.rotateAngleX = (float)(Math.sin(Math.toRadians(f * tailspeed) - (double)(2.0f * pi4)) * 3.1415927410125732 * (double)tailamp);
            this.tail3.rotateAngleX += 1.344f;
            this.tail4.rotationPointZ = this.tail3.rotationPointZ + (float)Math.sin(this.tail3.rotateAngleX) * 5.0f;
            this.tail4.rotationPointY = this.tail3.rotationPointY + (float)Math.cos(this.tail3.rotateAngleX) * 5.0f;
            this.tail4.rotateAngleX = (float)(Math.sin(Math.toRadians(f * tailspeed) - (double)(3.0f * pi4)) * 3.1415927410125732 * (double)tailamp);
            this.tail4.rotateAngleX += 1.501f;
            this.tail5.rotationPointZ = this.tail4.rotationPointZ + (float)Math.sin(this.tail4.rotateAngleX) * 5.0f;
            this.tail5.rotationPointY = this.tail4.rotationPointY + (float)Math.cos(this.tail4.rotateAngleX) * 5.0f;
            this.tail5.rotateAngleX = (float)(Math.sin(Math.toRadians(f * tailspeed) - (double)(4.0f * pi4)) * 3.1415927410125732 * (double)tailamp);
            this.tail5.rotateAngleX += 1.571f;
            this.flip1.rotationPointZ = this.tail5.rotationPointZ + (float)Math.sin(this.tail5.rotateAngleX) * 5.0f;
            this.flip1.rotationPointY = this.tail5.rotationPointY + (float)Math.cos(this.tail5.rotateAngleX) * 5.0f;
            this.flip1.rotateAngleX = (float)(Math.sin(Math.toRadians(f * tailspeed) - (double)(4.0f * pi4)) * 3.1415927410125732 * (double)tailamp);
            this.flip1.rotateAngleX += 1.571f;
            this.flip5.rotationPointX = this.flip6.rotationPointX = this.flip1.rotationPointX;
            this.flip4.rotationPointX = this.flip6.rotationPointX;
            this.flip3.rotationPointX = this.flip6.rotationPointX;
            this.flip2.rotationPointX = this.flip6.rotationPointX;
            this.flip5.rotationPointY = this.flip6.rotationPointY = this.flip1.rotationPointY;
            this.flip4.rotationPointY = this.flip6.rotationPointY;
            this.flip3.rotationPointY = this.flip6.rotationPointY;
            this.flip2.rotationPointY = this.flip6.rotationPointY;
            this.flip2.rotateAngleX = this.flip1.rotateAngleX;
            this.flip5.rotateAngleX = this.flip6.rotateAngleX = this.flip1.rotateAngleX - 1.571f;
            this.flip4.rotateAngleX = this.flip6.rotateAngleX;
            this.flip3.rotateAngleX = this.flip6.rotateAngleX;
            DangerZone.wr.loadtexture(TextureMapper.getTexture("res/skins/Mermaidtexture.png"));
            this.tail1.render(deathfactor);
            this.tail2.render(deathfactor);
            this.tail3.render(deathfactor);
            this.tail4.render(deathfactor);
            this.tail5.render(deathfactor);
            this.flip1.render(deathfactor);
            this.flip2.render(deathfactor);
            this.flip3.render(deathfactor);
            this.flip4.render(deathfactor);
            this.flip5.render(deathfactor);
            this.flip6.render(deathfactor);
        }
        if (entity != null && (entity != DangerZone.player || DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side)) {
            int bid = 0;
            int iid = 0;
            InventoryContainer ic2 = entity.getHotbar(entity.gethotbarindex());
            if (ic2 != null) {
                bid = ic2.bid;
                iid = ic2.iid;
            }
            if (bid != 0 || iid != 0) {
                MatrixStack.pushMatrix();
                MatrixStack.translate(this.rightarm.rotationPointX, this.rightarm.rotationPointY + 24.0f, this.rightarm.rotationPointZ);
                if (bid != 0) {
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    MatrixStack.translate(this.rightarm.offsetX + 1.8f, this.rightarm.offsetY - 16.2f, this.rightarm.offsetZ + 8.7f);
                    MatrixStack.rotate((float)Math.toDegrees(-this.rightarm.rotateAngleX) * 0.8f, 1.0f, 0.0f, 0.0f);
                    MatrixStack.rotate((float)Math.toDegrees(this.rightarm.rotateAngleY), 0.0f, 1.0f, 0.0f);
                    MatrixStack.rotate((float)Math.toDegrees(this.rightarm.rotateAngleZ), 0.0f, 0.0f, 1.0f);
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    MatrixStack.rotate(-79.6f, 1.0f, 0.0f, 0.0f);
                    MatrixStack.scale(0.3f, 0.3f, 0.3f);
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    if (Blocks.hasOwnRenderer(bid)) {
                        Blocks.renderMeHeld(DangerZone.wr, entity, bid, false);
                    } else {
                        DangerZone.wr.drawTexturedCube(255, Blocks.isSolidForRender(bid), bid, 0, false);
                    }
                    MatrixStack.popMatrix();
                    MatrixStack.popMatrix();
                    MatrixStack.popMatrix();
                } else if (iid != 0) {
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    MatrixStack.translate(this.rightarm.offsetX + 1.8f, this.rightarm.offsetY - 16.2f, this.rightarm.offsetZ + 8.7f);
                    MatrixStack.rotate((float)Math.toDegrees(-this.rightarm.rotateAngleX) * 0.8f, 1.0f, 0.0f, 0.0f);
                    MatrixStack.rotate((float)Math.toDegrees(this.rightarm.rotateAngleY), 0.0f, 1.0f, 0.0f);
                    MatrixStack.rotate((float)Math.toDegrees(this.rightarm.rotateAngleZ), 0.0f, 0.0f, 1.0f);
                    MatrixStack.sendCurrentStack();
                    MatrixStack.pushMatrix();
                    boolean needspush = false;
                    if (Items.isFlipped(iid)) {
                        MatrixStack.rotate(98.4f, 1.0f, 0.0f, 0.0f);
                        MatrixStack.rotate(25.7f, 0.0f, 1.0f, 0.0f);
                        MatrixStack.rotate(-101.1f, 0.0f, 0.0f, 1.0f);
                        needspush = true;
                    } else if (Items.isFlopped(iid)) {
                        MatrixStack.rotate(-94.7f, 1.0f, 0.0f, 0.0f);
                        MatrixStack.rotate(-27.7f, 0.0f, 1.0f, 0.0f);
                        MatrixStack.rotate(87.8f, 0.0f, 0.0f, 1.0f);
                        needspush = true;
                    } else {
                        MatrixStack.rotate(-27.2f, 1.0f, 0.0f, 0.0f);
                        MatrixStack.rotate(96.6f, 0.0f, 1.0f, 0.0f);
                        MatrixStack.rotate(22.5f, 0.0f, 0.0f, 1.0f);
                        needspush = true;
                    }
                    if (needspush) {
                        MatrixStack.sendCurrentStack();
                    }
                    DangerZone.wr.loadtexture(Items.getTexture(iid));
                    Items.renderMeHeld(DangerZone.wr, entity, ic2, false);
                    MatrixStack.popMatrix();
                    MatrixStack.popMatrix();
                }
                MatrixStack.popMatrix();
                MatrixStack.adjustStackDepthDown();
            }
        }
        if (entity != null && entity instanceof EntityLiving) {
            pl = (EntityLiving)entity;
            armorid = pl.getHelmetID();
            if (armorid != 0 && (it = Items.getItem(armorid)) != null && it instanceof ItemArmor) {
                ItemArmor ita = (ItemArmor)it;
                ita.drawHelmet(entity, this.head, deathfactor);
            }
            if ((armorid = pl.getLeggingsID()) != 0 && !isMermaid && (it = Items.getItem(armorid)) != null && it instanceof ItemArmor) {
                ItemArmor ita = (ItemArmor)it;
                ita.drawLeggings(entity, this.body, this.leftleg, this.rightleg, deathfactor);
            }
            if ((armorid = pl.getChestplateID()) != 0 && (it = Items.getItem(armorid)) != null && it instanceof ItemArmor) {
                ItemArmor ita = (ItemArmor)it;
                ita.drawChestplate(entity, this.body, this.leftarm, this.rightarm, deathfactor);
            }
            if ((armorid = pl.getBootsID()) != 0 && !isMermaid && (it = Items.getItem(armorid)) != null && it instanceof ItemArmor) {
                ItemArmor ita = (ItemArmor)it;
                ita.drawBoots(entity, this.leftleg, this.rightleg, deathfactor);
            }
        }
        MatrixStack.popMatrix();
    }

    @Override
    public void doScale(Entity ent) {
        super.doScale(ent);
        MatrixStack.scale(0.75f, 0.9f, 0.75f);
    }

    public void drawHeadOverlay(float deathfactor) {
        MatrixStack.pushMatrix();
        MatrixStack.translate(0.0f, -3.0f, 0.0f);
        MatrixStack.scale(1.125f, 1.125f, 1.125f);
        this.headoverlay.rotateAngleX = this.head.rotateAngleX;
        this.headoverlay.rotateAngleY = this.head.rotateAngleY;
        this.headoverlay.rotateAngleZ = this.head.rotateAngleZ;
        MatrixStack.sendCurrentStack();
        this.headoverlay.render(deathfactor);
        MatrixStack.popMatrix();
    }
}

