/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.world.World;
import slick.Texture;

public class EntityStand
extends Entity {
    public float spinz = 0.0f;

    public EntityStand(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityStand";
        this.ignoreCollisions = true;
        this.width = 1.0f;
        this.height = 1.5f;
        this.has_inventory = true;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        InventoryContainer ic;
        if (!this.world.isServer) {
            return;
        }
        if (this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 0.5), (int)this.posz) == Blocks.stand.blockID) {
            this.world.setblock(this.dimension, (int)this.posx, (int)(this.posy + 0.5), (int)this.posz, 0);
            Utils.doDropRand(this.world, Blocks.stand.blockID, 0, 0.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if ((ic = this.getInventory(0)) != null) {
            int i = 0;
            while (i < ic.count) {
                Utils.doDropRand(this.world, ic.bid, ic.iid, 1.0f, this.dimension, this.posx, this.posy, this.posz);
                ++i;
            }
        }
        this.deadflag = true;
        this.world.playSound(Blocks.getBreakSound(Blocks.stand.blockID), this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, 0.5f, 1.0f);
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        if (!Blocks.isSolid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.5), (int)this.posz))) {
            this.doAttackFrom(this, 1, 1.0f);
        }
        if (Blocks.isSolid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 1.5), (int)this.posz))) {
            this.doAttackFrom(this, 1, 1.0f);
        }
        if (this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 0.5), (int)this.posz) != Blocks.stand.blockID) {
            this.doAttackFrom(this, 1, 1.0f);
        }
    }

    @Override
    public Texture getTexture() {
        return null;
    }

    @Override
    public float getSpinz() {
        this.spinz += 0.75f;
        this.spinz %= 360.0f;
        return this.spinz;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic == null) {
                if (this.getInventory(0) != null) {
                    p.setHotbar(p.gethotbarindex(), this.getInventory(0));
                    this.setInventory(0, null);
                    this.world.playSound("DangerZone:pop", this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, 0.5f, 1.0f);
                }
            } else if (this.getInventory(0) == null) {
                this.setInventory(0, ic);
                p.setHotbar(p.gethotbarindex(), null);
                this.world.playSound("DangerZone:pop", this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, 0.5f, 1.0f);
            }
        }
        return false;
    }
}

