/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class EntitySign
extends Entity {
    int checker = 0;

    public EntitySign(World w) {
        super(w);
        this.uniquename = "DangerZone:EntitySign";
        this.ignoreCollisions = true;
        this.width = 1.0f;
        this.height = 1.5f;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (!this.world.isServer) {
            return;
        }
        Utils.doDropRand(this.world, 0, Items.sign.itemID, 0.0f, this.dimension, this.posx, this.posy, this.posz);
        this.deadflag = true;
    }

    @Override
    public void update(float deltaT) {
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        if (!Blocks.isSolid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.5), (int)this.posz))) {
            this.doAttackFrom(this, 1, 1.0f);
        }
        if (Blocks.isSolid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 0.5), (int)this.posz))) {
            this.doAttackFrom(this, 1, 1.0f);
        }
        if (Blocks.isSolid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 1.5), (int)this.posz))) {
            this.doAttackFrom(this, 1, 1.0f);
        }
        this.rotation_yaw_motion = this.getBID() == 0 ? 1.0f : 0.0f;
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/MooseSigntexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            return false;
        }
        DangerZone.signgui.init(this);
        DangerZone.setActiveGui(DangerZone.signgui);
        return false;
    }
}

