/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityExp;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class EntityNoob
extends EntityExp {
    public int deathtimer = 600;
    public int pickup_delay = 0;
    public int points = 0;
    int nexttext = 0;
    int nexttextcount = 0;
    int countdir = 1;
    boolean tried = false;

    public EntityNoob(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:Noob";
        this.pickup_delay = 10;
        this.points = 0;
        if (w != null) {
            this.nexttext = w.rand.nextInt(8);
            this.nexttextcount = w.rand.nextInt(10);
        }
        this.canthitme = true;
        this.setFlying(true);
    }

    @Override
    public void update(float deltaT) {
        float rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        if (this.world.isServer) {
            Player p;
            boolean inliquid = false;
            int bbid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)(this.getHeight() + 0.25f)), (int)this.posz);
            if (Blocks.isSolid(bbid)) {
                this.motiony += 0.007f * deltaT;
            } else {
                if (Blocks.isLiquid(bbid)) {
                    Blocks.entityInLiquid(bbid, this);
                    inliquid = true;
                }
                this.motiony -= 0.005f * deltaT;
            }
            this.setInLiquid(inliquid);
            this.motiony *= 1.0f - 0.05f * deltaT;
            this.motionx *= 1.0f - 0.05f * deltaT;
            this.motionz *= 1.0f - 0.05f * deltaT;
            if (this.getOnFire() != 0) {
                this.deathtimer -= 5;
            }
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
            if (this.pickup_delay > 0) {
                --this.pickup_delay;
            }
            this.rotation_yaw_motion = 0.0f;
            this.rotation_pitch_motion = 0.0f;
            this.rotation_roll_motion = 0.0f;
            this.rotation_pitch = 0.0f;
            this.rotation_yaw = 0.0f;
            this.rotation_roll = 0.0f;
            if (!this.deadflag && this.pickup_delay <= 0 && (p = DangerZone.server.findNearestPlayer(this)) != null) {
                double maxdist = p.getWidth() + 8.0f;
                if (this.getDistanceFromEntityCenter(p) < maxdist && !p.deadflag && p.getGameMode() != 3) {
                    if (this.getDistanceFromEntityCenter(p) < (double)(p.getWidth() + 1.0f)) {
                        p.setExperience(p.getExperience() - this.getExperience());
                        this.deadflag = true;
                        if (this.getBID() == 0) {
                            DangerZone.ground_pulse();
                            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                        }
                    }
                    float tdir = (float)Math.atan2(p.posx - this.posx, p.posz - this.posz);
                    double dist = this.getDistanceFromEntityCenter(p);
                    double factor = (maxdist - dist) / maxdist;
                    if (factor > 1.0) {
                        factor = 1.0;
                    }
                    if (factor < 0.0) {
                        factor = 0.0;
                    }
                    this.motionx = (float)((double)this.motionx + (double)0.04f * (factor *= 2.0) * Math.sin(tdir) * (double)deltaT);
                    this.motionz = (float)((double)this.motionz + (double)0.04f * factor * Math.cos(tdir) * (double)deltaT);
                    if (this.posy > p.posy + (double)(p.getHeight() / 2.0f)) {
                        this.motiony = (float)((double)this.motiony - (double)(0.02f * deltaT) * factor);
                    }
                    if (this.posy < p.posy + (double)(p.getHeight() / 2.0f)) {
                        this.motiony = (float)((double)this.motiony + (double)(0.06f * deltaT) * factor);
                    }
                }
            }
            if (!this.tried && !this.deadflag && DangerZone.server.entityManager.active_entities > DangerZone.max_entities / 8) {
                List<Entity> nearby_list = null;
                Entity e = null;
                nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(8.0f, this.dimension, this.posx, this.posy, this.posz);
                if (nearby_list != null && !nearby_list.isEmpty()) {
                    ListIterator<Entity> li = nearby_list.listIterator();
                    while (li.hasNext()) {
                        e = li.next();
                        if (e == this || !(e instanceof EntityNoob) || e.deadflag) continue;
                        EntityNoob ex = (EntityNoob)e;
                        ex.setExperience(ex.getExperience() + this.getExperience());
                        ex.deathtimer = 1200;
                        this.deadflag = true;
                        break;
                    }
                }
                this.tried = true;
            }
            if (this.getInLiquid()) {
                this.doInLiquid(1.0f);
                this.motionx *= 0.9f;
                this.motiony *= 0.9f;
                this.motionz *= 0.9f;
                this.doSolidsPushback(0.0f, deltaT);
            }
        } else {
            this.motiony *= 1.0f - 0.05f * deltaT * rate;
            this.motionx *= 1.0f - 0.05f * deltaT * rate;
            this.motionz *= 1.0f - 0.05f * deltaT * rate;
        }
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/misc/noob.png");
        }
        return this.texture;
    }
}

