/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.crafting.Cooking;
import dangerzone.crafting.CookingRecipe;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.items.Items;
import dangerzone.world.World;

public class EntityFurnace
extends Entity {
    public int blocktries = 0;

    public EntityFurnace(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityFurnace";
        this.ignoreCollisions = true;
        this.width = 0.01f;
        this.height = 0.01f;
        this.setVarFloat(4, 0.0f);
        this.setVarFloat(6, 0.0f);
        this.setVarFloat(8, 0.0f);
        this.setVarFloat(10, 0.0f);
        this.setVarFloat(5, 0.0f);
        this.setVarFloat(7, 0.0f);
        this.setVarFloat(9, 0.0f);
        this.setVarFloat(11, 0.0f);
        this.has_inventory = true;
        this.maxrenderdist = 64;
    }

    @Override
    public void update(float deltaT) {
        int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        int meta = this.world.getblockmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        if (bid != this.getBID() && bid != this.getIID() && this.world.isServer) {
            ++this.blocktries;
            if (this.blocktries > 20) {
                this.dumpInventory();
                this.deadflag = true;
            }
        }
        if (!this.deadflag && this.world.isServer) {
            InventoryContainer ic = null;
            int i = 0;
            while (i < 2) {
                float fuel = this.getVarFloat(4 + i);
                if (fuel > 0.0f) {
                    fuel -= 0.1f;
                }
                if (fuel <= 0.0f) {
                    fuel = 0.0f;
                    ic = this.getInventory(2 + i * 3);
                    if (ic != null) {
                        float newfuel = 0.0f;
                        if (ic.bid != 0) {
                            newfuel = Blocks.getBurnTime(ic.bid);
                        }
                        if (ic.iid != 0) {
                            newfuel = Items.getBurnTime(ic.iid);
                        }
                        if (newfuel > 0.0f && this.getInventory(1 + i * 3) != null) {
                            --ic.count;
                            if (ic.count <= 0) {
                                ic = null;
                            }
                            this.setInventory(2 + i * 3, ic);
                            fuel = newfuel;
                        }
                    }
                    this.setVarFloat(6 + i, fuel);
                }
                this.setVarFloat(4 + i, fuel);
                if (fuel > 0.0f) {
                    if (bid == this.getBID()) {
                        this.world.setblockandmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, this.getIID(), meta);
                    }
                    if ((ic = this.getInventory(1 + i * 3)) != null) {
                        InventoryContainer ic2 = this.getInventory(0 + i * 3);
                        boolean canadd = true;
                        int iid = 0;
                        int bbd = 0;
                        CookingRecipe r = null;
                        if (ic.bid != 0) {
                            r = Cooking.find(Blocks.getUniqueName(ic.bid));
                        }
                        if (ic.iid != 0) {
                            r = Cooking.find(Items.getUniqueName(ic.iid));
                        }
                        if (r != null) {
                            iid = Items.findByName(r.outname);
                            bbd = Blocks.findByName(r.outname);
                        } else {
                            canadd = false;
                        }
                        if (ic2 != null) {
                            if (bbd != ic2.bid || iid != ic2.iid) {
                                canadd = false;
                            }
                            if (ic2.count >= ic2.getMaxStack()) {
                                canadd = false;
                            }
                        }
                        if (canadd) {
                            if (this.getVarFloat(10 + i) != 0.0f) {
                                float te = this.getVarFloat(8 + i);
                                float tr = this.getVarFloat(10 + i) - te;
                                te += 0.1f;
                                if (tr > 3.999f && tr < 4.001f) {
                                    this.world.playSound("DangerZone:furnace_ding", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                                }
                                if (te >= this.getVarFloat(10 + i)) {
                                    if (ic2 == null) {
                                        ic2 = new InventoryContainer();
                                        ic2.iid = iid;
                                        ic2.bid = bbd;
                                        ic2.count = 0;
                                        this.setInventory(0 + i * 3, ic2);
                                    }
                                    ++ic2.count;
                                    this.setInventoryChanged(0 + i * 3);
                                    --ic.count;
                                    if (ic.count <= 0) {
                                        ic = null;
                                        this.setInventory(1 + i * 3, ic);
                                    }
                                    this.setInventoryChanged(1 + i * 3);
                                    this.setVarFloat(8 + i, 0.0f);
                                    this.setVarFloat(10 + i, 0.0f);
                                    Utils.spawnExperience(1, this.world, this.dimension, this.posx, this.posy, this.posz);
                                } else {
                                    this.setVarFloat(8 + i, te);
                                }
                            } else {
                                this.setVarFloat(8 + i, 0.0f);
                                this.setVarFloat(10 + i, r.cooktime);
                            }
                        }
                    } else {
                        this.setVarFloat(8 + i, 0.0f);
                        this.setVarFloat(10 + i, 0.0f);
                    }
                } else {
                    this.setVarFloat(4 + i, 0.0f);
                    this.setVarFloat(6 + i, 0.0f);
                    this.setVarFloat(8 + i, 0.0f);
                    this.setVarFloat(10 + i, 0.0f);
                    if (bid == this.getIID()) {
                        this.world.setblockandmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, this.getBID(), meta);
                    }
                }
                ++i;
            }
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        super.update(deltaT);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        if (bid != this.getBID() && bid != this.getIID()) {
            if (this.world.isServer) {
                this.dumpInventory();
            }
            this.deadflag = true;
            return false;
        }
        Blocks.rightClickOnBlock(this.getBID(), p, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, 0);
        return false;
    }

    private void dumpInventory() {
        InventoryContainer ic = null;
        int i = 0;
        while (i < 50) {
            EntityBlockItem e;
            ic = this.getInventory(i);
            if (ic != null && (e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx, this.posy, this.posz)) != null) {
                e.fill(ic);
                e.rotation_pitch = this.world.rand.nextInt(360);
                e.rotation_yaw = this.world.rand.nextInt(360);
                e.rotation_roll = this.world.rand.nextInt(360);
                e.motionx = this.world.rand.nextFloat() - this.world.rand.nextFloat() / 10.0f;
                e.motiony = this.world.rand.nextFloat() / 2.0f;
                e.motionz = this.world.rand.nextFloat() - this.world.rand.nextFloat() / 10.0f;
                this.world.spawnEntityInWorld(e);
            }
            ++i;
        }
    }
}

