/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.KVPair;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.BlockInstability;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.ItemInstability;
import dangerzone.items.Items;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class EntityExtendedRangeDamage
extends Entity {
    public int deathtimer = 60;
    public Entity thrower = null;
    public double oposx = 0.0;
    public double oposy = 0.0;
    public double oposz = 0.0;
    private boolean boomed_once = false;

    public EntityExtendedRangeDamage(World w) {
        super(w);
        this.maxrenderdist = 1;
        this.height = 0.01f;
        this.width = 0.01f;
        this.uniquename = "DangerZone:ExtendedRangeDamage";
        this.movement_friction = false;
        this.canthitme = true;
        this.setAttackDamage(0.0f);
        this.setBID(0);
        this.setMaxHealth(0.0f);
        this.setIID(0);
        this.setItemDamage(0);
        this.setDefense(0.0f);
        this.setGameMode(0);
    }

    @Override
    public void writeSelf(List<KVPair> prop, String tag) {
        super.writeSelf(prop, tag);
        prop.add(new KVPair(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer)));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 60, 60);
    }

    public void setDirectionAndVelocity(float x, float y, float z, float velocity, float variability) {
        this.motionx = x * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motiony = y * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motionz = z * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
    }

    public void setDamageType(int dt) {
        this.setBID(dt);
    }

    public void setExplosivePower(int exp) {
        this.setMaxHealth(exp);
    }

    public void setRange(int rng) {
        this.setIID(rng);
    }

    public void setSpreadRate(float rate) {
        this.setDefense(rate);
    }

    public void setNoFire(boolean tf) {
        if (tf) {
            this.setGameMode(1);
        } else {
            this.setGameMode(0);
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            float dist = (float)Math.sqrt(this.motionx * deltaT * this.motionx * deltaT + this.motiony * deltaT * this.motiony * deltaT + this.motionz * deltaT * this.motionz * deltaT);
            float blockdist = 0.0f;
            float edist = 0.0f;
            boolean hitblock = false;
            boolean hitentity = false;
            int bid = 0;
            List<Entity> nearby_list = null;
            Entity enthit = null;
            Entity ridden = null;
            float spread = this.getDefense();
            if (spread < 0.0f) {
                spread = 0.0f;
            }
            if (spread > 1.0f) {
                spread = 1.0f;
            }
            spread /= 2.0f;
            if (this.oposx == 0.0) {
                this.oposx = this.posx;
                this.oposy = this.posy;
                this.oposz = this.posz;
            }
            nearby_list = this.getItemDamage() != 0 ? DangerZone.server.entityManager.findALLEntitiesInRange(dist + 16.0f, this.dimension, this.posx, this.posy, this.posz) : DangerZone.server.entityManager.findEntitiesInRange(dist + 16.0f, this.dimension, this.posx, this.posy, this.posz);
            int lz = 0;
            int ly = 0;
            int lx = 0;
            if (this.thrower != null && (ridden = this.thrower.getRiddenEntity()) == null) {
                ridden = this.thrower.getRiderEntity();
            }
            double fx = this.posx;
            double fy = this.posy;
            double fz = this.posz;
            while (blockdist < dist) {
                fx = this.posx + (double)(this.motionx * deltaT * blockdist / dist);
                fy = this.posy + (double)(this.motiony * deltaT * blockdist / dist);
                fz = this.posz + (double)(this.motionz * deltaT * blockdist / dist);
                int x = (int)fx;
                int y = (int)fy;
                int z = (int)fz;
                edist = (float)Math.sqrt((this.oposx - fx) * (this.oposx - fx) + (this.oposy - fy) * (this.oposy - fy) + (this.oposz - fz) * (this.oposz - fz));
                if (edist > (float)this.getIID()) {
                    this.deadflag = true;
                    break;
                }
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    enthit = li.next();
                    if (enthit == this || enthit == this.thrower || enthit == ridden || !(fy > enthit.posy - (double)(spread * blockdist)) || !(fy < enthit.posy + (double)enthit.getHeight() + (double)(spread * blockdist))) continue;
                    edist = (float)enthit.getHorizontalDistanceFromEntity(fx, fz);
                    edist -= this.getWidth() / 2.0f;
                    edist -= enthit.getWidth() / 2.0f;
                    if (!((edist -= spread * blockdist) < 0.0f)) continue;
                    if (this.getItemDamage() == 0) {
                        if (enthit.canthitme) continue;
                        hitentity = true;
                        break;
                    }
                    if (enthit instanceof EntityBlockItem) {
                        if (spread == 0.0f) {
                            hitentity = true;
                            break;
                        }
                        if (enthit.deadflag) continue;
                        this.doHitSomething(hitblock, fx, fy, fz, 0, true, enthit);
                        continue;
                    }
                    if (!(enthit instanceof EntityLiving) || enthit.canthitme) continue;
                    hitentity = true;
                    break;
                }
                if (hitentity) break;
                if (x != lx || y != ly || z != lz) {
                    lx = x;
                    ly = y;
                    lz = z;
                    bid = this.world.getblock(this.dimension, x, y, z);
                    if (bid != 0) {
                        hitblock = true;
                        break;
                    }
                }
                blockdist += 0.15f;
            }
            if (hitentity || hitblock) {
                this.motionx = this.motionx * deltaT * blockdist / dist;
                this.motiony = this.motiony * deltaT * blockdist / dist;
                this.motionz = this.motionz * deltaT * blockdist / dist;
                this.doHitSomething(hitblock, fx, fy, fz, bid, hitentity, hitentity ? enthit : null);
                this.deadflag = true;
                return;
            }
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
        }
        super.update(deltaT);
    }

    public void doHitSomething(boolean hb, double x, double y, double z, int bid, boolean he, Entity ent) {
        int nparticle = (int)this.getAttackDamage();
        if (nparticle < 5) {
            nparticle = 5;
        }
        if (nparticle > 50) {
            nparticle = 50;
        }
        if (he && ent != null) {
            if (this.getAttackDamage() > 0.0f) {
                ent.doAttackFrom(this.thrower, this.getBID(), this.getAttackDamage());
            }
            if (ent instanceof EntityBlockItem) {
                Item it;
                EntityBlockItem ebi = (EntityBlockItem)ent;
                ebi.deadflag = true;
                Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleHurt", nparticle, this.dimension, ent.posx, ent.posy + 0.125, ent.posz, 0, 0.5f);
                if (ebi.getItemID() != 0) {
                    Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleItem", 25, this.dimension, ent.posx, ent.posy + 0.125, ent.posz, ebi.getItemID(), 0.5f);
                }
                if (ebi.getBlockID() != 0) {
                    Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleBreak", 25, this.dimension, ent.posx, ent.posy + 0.125, ent.posz, ebi.getBlockID(), 0.5f);
                }
                if ((it = Items.getItem(ebi.getItemID())) != null && it instanceof ItemInstability) {
                    ItemInstability iti = (ItemInstability)it;
                    Explosion.boom(this.thrower, this.world, this.dimension, x, y, z, (int)iti.mypower, true);
                }
            } else {
                Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleHurt", nparticle, this.dimension, x, y, z, 0, 0.25f * (ent.getWidth() + ent.getHeight()) / 4.0f);
            }
        } else {
            this.world.playSound("DangerZone:small_thud", this.dimension, x, y, z, 0.2f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.1f);
            Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleDust", nparticle, this.dimension, x, y, z, 0, 0.25f);
            Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleBreak", nparticle, this.dimension, x, y, z, bid, 0.25f);
            Block bt = Blocks.getBlock(bid);
            if (bt != null && bt instanceof BlockInstability) {
                BlockInstability iti = (BlockInstability)bt;
                Explosion.boom(this.thrower, this.world, this.dimension, x, y, z, iti.maxdamage, true);
            }
        }
        if (this.getMaxHealth() > 0.0f) {
            if (!this.boomed_once) {
                Explosion.boom(this.thrower, this.world, this.dimension, x, y, z, (int)this.getMaxHealth(), true, this.getGameMode() == 0);
            }
            this.boomed_once = true;
        }
    }
}

