/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.InventoryContainer;
import dangerzone.KVPair;
import dangerzone.Player;
import dangerzone.PlayerKeyEvent;
import dangerzone.ToDoList;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.particles.Particle;
import dangerzone.rendering.ModelBase;
import dangerzone.rendering.WorldRendererUtils;
import dangerzone.world.World;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import slick.Texture;

public class Entity {
    public volatile int dimension;
    public volatile double posx;
    public volatile double posy;
    public volatile double posz;
    public volatile float motionx;
    public volatile float motiony;
    public volatile float motionz;
    public volatile float rotation_yaw;
    public volatile float rotation_pitch;
    public volatile float rotation_roll;
    public volatile float rotation_yaw_head;
    public volatile float rotation_pitch_head;
    public volatile float rotation_roll_head;
    public volatile float rotation_yaw_motion;
    public volatile float rotation_pitch_motion;
    public volatile float rotation_roll_motion;
    public int prevdimension;
    public double prevposx;
    public double prevposy;
    public double prevposz;
    public float prevrotation_yaw;
    public float prevrotation_pitch;
    public float prevrotation_roll;
    public float prevrotation_yaw_head;
    public float prevrotation_pitch_head;
    public float prevrotation_roll_head;
    public double display_posx;
    public double display_posy;
    public double display_posz;
    public float display_rotation_yaw;
    public float display_rotation_pitch;
    public float display_rotation_roll;
    public int diff_ticker;
    public float diff_posx;
    public float diff_posy;
    public float diff_posz;
    public float diff_rotpitch;
    public float diff_rotyaw;
    public float diff_rotroll;
    public float diff_rotpitchh;
    public float diff_rotyawh;
    public float diff_rotrollh;
    public double modesync_posx;
    public double modesync_posy;
    public double modesync_posz;
    public float modesync_rotation_yaw;
    public float modesync_rotation_pitch;
    public float modesync_rotation_roll;
    public long modesync_ticker;
    public float modesync_velocity;
    public float modesync_head_pitch;
    public float modesync_head_yaw;
    public float modesync_head_roll;
    public boolean modesync_isvalid = false;
    public float width = 0.75f;
    public float height = 1.95f;
    public float eyeHeight = 0.0f;
    public boolean deadflag = false;
    public int entityID = 0;
    public long lasttime = System.currentTimeMillis();
    public World world = null;
    public int maxrenderdist = 256;
    public String uniquename;
    public long lifetimeticker;
    public int hurtanimationtimer;
    public int madtimer = 0;
    public int diffticker;
    public ModelBase model;
    public Texture texture;
    public static final int MAXVARS = 50;
    public static final int MAXINV = 100;
    public volatile short changed;
    public volatile short[] changes = new short[100];
    public int[] entity_ints = new int[50];
    public float[] entity_floats = new float[50];
    public String[] entity_strings = new String[50];
    public InventoryContainer[] entity_inventory = new InventoryContainer[100];
    public boolean has_inventory = false;
    public boolean takesFallDamage = false;
    public boolean ignoreCollisions = false;
    public boolean canthitme = false;
    public boolean movement_friction = true;
    public int stray_entity_ticker = 0;
    public int firecounter = 0;
    public boolean sit_when_riding = true;
    public boolean always_draw = false;
    public int temperament = 0;
    public boolean canFly = false;
    public boolean canDespawn = true;
    public boolean staying = false;
    public boolean isMilkable = false;
    public boolean isImmuneToFire = false;
    public boolean canBreateUnderWater = false;
    public boolean towerdefensemode = false;
    public List<Effects> effect_list = null;
    public List<PlayerKeyEvent> keyevent_list = null;
    public List<PlayerKeyEvent> mouseevent_list = null;
    public int maxidleupdate = 2000;
    public int squidticker = 0;
    public volatile boolean has_been_saved = false;
    public Lock access_lock = new ReentrantLock();

    public Entity(World w) {
        this.world = w;
        this.posx = 0.0;
        this.posy = 0.0;
        this.posz = 0.0;
        this.rotation_yaw = 0.0f;
        this.rotation_pitch = 0.0f;
        this.rotation_roll = 0.0f;
        this.rotation_yaw_head = 0.0f;
        this.rotation_pitch_head = 0.0f;
        this.rotation_roll_head = 0.0f;
        this.dimension = 1;
        this.prevdimension = 1;
        this.prevposz = 0.0;
        this.prevposy = 0.0;
        this.prevposx = 0.0;
        this.prevrotation_roll = 0.0f;
        this.prevrotation_pitch = 0.0f;
        this.prevrotation_yaw = 0.0f;
        this.prevrotation_roll_head = 0.0f;
        this.prevrotation_pitch_head = 0.0f;
        this.prevrotation_yaw_head = 0.0f;
        this.deadflag = false;
        this.lifetimeticker = 0L;
        this.uniquename = "DangerZone:BaseEntity";
        this.changed = 0;
        this.squidticker = 0;
        int i = 0;
        while (i < 50) {
            this.entity_ints[i] = 0;
            this.entity_floats[i] = 0.0f;
            this.entity_strings[i] = null;
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.changes[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.entity_inventory[i] = null;
            ++i;
        }
        this.hurtanimationtimer = 0;
        this.texture = null;
        this.canthitme = false;
        this.diffticker = 0;
        this.effect_list = new ArrayList<Effects>();
        this.maxidleupdate = 3000 + DangerZone.rand.nextInt(300);
        this.setGroundFactor(1.0f);
        this.setAirFactor(1.5f);
    }

    public void init() {
    }

    public void post_readSelf() {
        int i = this.getVarInt(10);
        int j = this.getVarInt(11);
        this.setVarInt(10, 0);
        this.setVarInt(11, 0);
        this.setVarInt(16, 0);
        if (i != 0 || j != 0) {
            this.setSitting(false);
        }
    }

    public void de_init() {
        int i = this.getVarInt(10);
        int j = this.getVarInt(11);
        this.setVarInt(10, 0);
        this.setVarInt(11, 0);
        this.setVarInt(16, 0);
        if (i != 0 || j != 0) {
            this.setSitting(false);
        }
    }

    public void setSize(float x_size, float y_size) {
        this.width = x_size;
        this.height = y_size;
    }

    public float getWidth() {
        float rwid = 0.0f;
        float retwid = this.width;
        Entity ent = this.getRiddenEntity();
        if (ent != null) {
            rwid = ent == this ? this.width : ent.getWidth();
        }
        if (retwid < rwid) {
            retwid = rwid;
        }
        if (this.isBaby()) {
            return retwid / 4.0f;
        }
        return retwid;
    }

    public float getJustMyHeight() {
        if (this.isBaby()) {
            return this.height / 4.0f;
        }
        return this.height;
    }

    public float getJustMyWidth() {
        if (this.isBaby()) {
            return this.width / 4.0f;
        }
        return this.width;
    }

    public float getHeight() {
        float rwid = 0.0f;
        float retwid = this.height;
        Entity ent = this.getRiddenEntity();
        if (ent != null) {
            rwid = ent == this ? this.height : ent.getHeight();
        }
        if (retwid < rwid) {
            retwid = rwid;
        }
        if (this.getSitting()) {
            retwid /= 2.0f;
        }
        if (this.isBaby()) {
            return retwid / 4.0f;
        }
        return retwid;
    }

    public boolean jump(float js) {
        return false;
    }

    public float getNameHeight() {
        return this.height;
    }

    public float getEyeHeight() {
        return this.eyeHeight;
    }

    public int getVarInt(int index) {
        if (index < 0 || index >= 50) {
            return 0;
        }
        return this.entity_ints[index];
    }

    public float getVarFloat(int index) {
        if (index < 0 || index >= 50) {
            return 0.0f;
        }
        return this.entity_floats[index];
    }

    public String getVarString(int index) {
        if (index < 0 || index >= 50) {
            return null;
        }
        return this.entity_strings[index];
    }

    public InventoryContainer getVarInventory(int index) {
        if (!this.has_inventory) {
            return null;
        }
        if (index < 0 || index >= 100) {
            return null;
        }
        return this.entity_inventory[index];
    }

    public void setVarInt(int index, int val) {
        if (index < 0 || index >= 50) {
            return;
        }
        if (this.entity_ints[index] != val) {
            this.entity_ints[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 1);
            this.changed = 1;
        }
    }

    public void setVarFloat(int index, float val) {
        if (index < 0 || index >= 50) {
            return;
        }
        if (this.entity_floats[index] != val) {
            this.entity_floats[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 2);
            this.changed = 1;
        }
    }

    public void setVarString(int index, String val) {
        if (index < 0 || index >= 50) {
            return;
        }
        if (this.entity_strings[index] != val) {
            this.entity_strings[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 4);
            this.changed = 1;
        }
    }

    public void setVarInventory(int index, InventoryContainer val) {
        if (!this.has_inventory) {
            return;
        }
        if (index < 0 || index >= 100) {
            return;
        }
        if (val == null && this.entity_inventory[index] == null) {
            return;
        }
        this.entity_inventory[index] = val;
        int n = index;
        this.changes[n] = (short)(this.changes[n] | 8);
        this.changed = 1;
    }

    public void setVarInventoryChanged(int index) {
        if (!this.has_inventory) {
            return;
        }
        if (index < 0 || index >= 100) {
            return;
        }
        int n = index;
        this.changes[n] = (short)(this.changes[n] | 8);
        this.changed = 1;
    }

    public void setVarInventoryChanged(InventoryContainer ic) {
        if (!this.has_inventory) {
            return;
        }
        int index = 0;
        while (index < 100) {
            if (this.entity_inventory[index] == ic) {
                int n = index;
                this.changes[n] = (short)(this.changes[n] | 8);
                this.changed = 1;
                break;
            }
            ++index;
        }
    }

    public void setMaxHealth(float f) {
        this.setVarFloat(0, f);
    }

    public float getMaxHealth() {
        if (this.isBaby()) {
            return this.getVarFloat(0) / 16.0f;
        }
        return this.getVarFloat(0);
    }

    public void setHealth(float f) {
        if (f > this.getMaxHealth()) {
            f = this.getMaxHealth();
        }
        this.setVarFloat(1, f);
    }

    public void heal(float f) {
        float mh = this.getMaxHealth();
        float newhealth = this.getHealth() + f;
        if (newhealth > mh) {
            newhealth = mh;
        }
        this.setHealth(newhealth);
    }

    public float getHealth() {
        float f = this.getVarFloat(1);
        if (f > this.getMaxHealth()) {
            f = this.getMaxHealth();
            this.setVarFloat(1, f);
        }
        return f;
    }

    public void setDefense(float f) {
        this.setVarFloat(2, f);
    }

    public float getDefense() {
        return this.getVarFloat(2);
    }

    public void setAttackDamage(float f) {
        this.setVarFloat(3, f);
    }

    public float getAttackDamage() {
        return this.getVarFloat(3);
    }

    public void setMaxHunger(float f) {
        this.setVarFloat(4, f);
    }

    public float getMaxHunger() {
        return this.getVarFloat(4);
    }

    public void setHunger(float f) {
        this.setVarFloat(5, f);
    }

    public float getHunger() {
        return this.getVarFloat(5);
    }

    public void setMaxAir(float f) {
        this.setVarFloat(6, f);
    }

    public float getMaxAir() {
        return this.getVarFloat(6);
    }

    public void setAir(float f) {
        this.setVarFloat(7, f);
    }

    public float getAir() {
        return this.getVarFloat(7);
    }

    public void setBID(int f) {
        this.setVarInt(0, f);
    }

    public int getBID() {
        return this.getVarInt(0);
    }

    public void setIID(int f) {
        this.setVarInt(1, f);
    }

    public int getIID() {
        return this.getVarInt(1);
    }

    public int getGameMode() {
        return this.getVarInt(2);
    }

    public void setGameMode(int f) {
        this.setVarInt(2, f);
    }

    public void sethotbarindex(int f) {
        if (f >= 0 && f <= 9) {
            this.setVarInt(3, f);
        }
    }

    public int gethotbarindex() {
        return this.getVarInt(3);
    }

    public void setItemDamage(int f) {
        this.setVarInt(4, f);
    }

    public int getItemDamage() {
        return this.getVarInt(4);
    }

    public void setAttacking(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 1) : (f &= 0xFFFFFFFE);
        this.setVarInt(5, f);
    }

    public boolean getAttacking() {
        return (this.getVarInt(5) & 1) == 1;
    }

    public void setInLiquid(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 2) : (f &= 0xFFFFFFFD);
        if (this.world != null && !this.world.isServer && this == DangerZone.player && f != this.getVarInt(5)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 5, f);
        }
        this.setVarInt(5, f);
    }

    public boolean getInLiquid() {
        return (this.getVarInt(5) & 2) == 2;
    }

    public void setOnGround(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 4) : (f &= 0xFFFFFFFB);
        if (this.world != null && !this.world.isServer && this == DangerZone.player && f != this.getVarInt(5)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 5, f);
        }
        this.setVarInt(5, f);
    }

    public boolean getOnGround() {
        return (this.getVarInt(5) & 4) == 4;
    }

    public void setStaying(boolean tf) {
        this.staying = tf;
    }

    public boolean getStaying() {
        return this.staying;
    }

    public void setCanDespawn(boolean tf) {
        this.canDespawn = tf;
    }

    public boolean getCanDespawn() {
        return this.canDespawn;
    }

    public void setSitting(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x20) : (f &= 0xFFFFFFDF);
        this.setVarInt(5, f);
    }

    public boolean getSitting() {
        return (this.getVarInt(5) & 0x20) == 32;
    }

    public void setBaby(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x40) : (f &= 0xFFFFFFBF);
        this.setVarInt(5, f);
    }

    public boolean isBaby() {
        return (this.getVarInt(5) & 0x40) == 64;
    }

    public void setQuiet(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x80) : (f &= 0xFFFFFF7F);
        this.setVarInt(5, f);
    }

    public boolean getQuiet() {
        return (this.getVarInt(5) & 0x80) == 128;
    }

    public void setSinging(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x100) : (f &= 0xFFFFFEFF);
        this.setVarInt(5, f);
    }

    public boolean getSinging() {
        return (this.getVarInt(5) & 0x100) == 256;
    }

    public void setArmsUp(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x200) : (f &= 0xFFFFFDFF);
        this.setVarInt(5, f);
    }

    public boolean getArmsUp() {
        return (this.getVarInt(5) & 0x200) == 512;
    }

    public void setFlying(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x400) : (f &= 0xFFFFFBFF);
        if (this.world != null && !this.world.isServer && this == DangerZone.player && f != this.getVarInt(5)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 5, f);
        }
        this.setVarInt(5, f);
    }

    public boolean isFlying() {
        return (this.getVarInt(5) & 0x400) == 1024;
    }

    public void setLadder(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x800) : (f &= 0xFFFFF7FF);
        this.setVarInt(5, f);
    }

    public boolean isLadder() {
        return (this.getVarInt(5) & 0x800) == 2048;
    }

    public void setInvisible(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x1000) : (f &= 0xFFFFEFFF);
        this.setVarInt(5, f);
    }

    public boolean isInvisible() {
        return (this.getVarInt(5) & 0x1000) == 4096;
    }

    public void setSwarming(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x2000) : (f &= 0xFFFFDFFF);
        this.setVarInt(5, f);
    }

    public boolean isSwarming() {
        return (this.getVarInt(5) & 0x2000) == 8192;
    }

    public void setExperience(int f) {
        this.setVarInt(6, f);
    }

    public int getExperience() {
        return this.getVarInt(6);
    }

    public void setInitialized(int f) {
        this.setVarInt(8, f);
    }

    public int getInitialized() {
        return this.getVarInt(8);
    }

    public void setOnFire(int f) {
        this.setVarInt(9, f);
    }

    public void doSetOnFire(int f) {
        this.setOnFire(f);
    }

    public int getOnFire() {
        return this.getVarInt(9);
    }

    public String getOwnerName() {
        return this.getVarString(0);
    }

    public void setOwnerName(String s) {
        this.setVarString(0, s);
    }

    public String getPetName() {
        return this.getVarString(1);
    }

    public void setPetName(String s) {
        this.setVarString(1, s);
    }

    public String getMorphName() {
        return this.getVarString(2);
    }

    public void setMorphName(String s) {
        this.setVarString(2, s);
    }

    public void MountAsPassenger(Entity passenger) {
        if (passenger == null) {
            return;
        }
        this.Mount(passenger);
        this.setVarInt(16, this.entityID);
        passenger.setVarInt(16, this.entityID);
    }

    public void Mount(Entity rider) {
        Entity getoffof;
        if (rider == null) {
            return;
        }
        int was_on = rider.getVarInt(11);
        if (was_on != 0 && DangerZone.server != null && (getoffof = DangerZone.server.entityManager.findEntityByID(was_on)) != null) {
            getoffof.setVarInt(10, 0);
            getoffof.setVarInt(11, 0);
            getoffof.setVarInt(16, 0);
        }
        this.setVarInt(10, rider.entityID);
        this.setVarInt(11, this.entityID);
        this.setVarInt(16, rider.entityID);
        rider.setVarInt(10, rider.entityID);
        rider.setVarInt(11, this.entityID);
        rider.setVarInt(16, rider.entityID);
        if (this.world.isServer) {
            rider.setSitting(this.sit_when_riding);
            rider.posy += (double)this.getRiderYoffset();
            if (rider instanceof Player) {
                Player pl = (Player)rider;
                ToDoList.onRidden(pl, this);
            }
        }
    }

    public void unMount(Entity rider) {
        this.setVarInt(10, 0);
        this.setVarInt(11, 0);
        this.setVarInt(16, 0);
        if (rider != null) {
            rider.setVarInt(10, 0);
            rider.setVarInt(11, 0);
            rider.setVarInt(16, 0);
            rider.posy -= (double)this.getRiderYoffset();
        }
        if (this.world.isServer && rider != null) {
            rider.setSitting(false);
        }
    }

    public boolean isMountedBy(Entity e) {
        return this.getVarInt(10) == e.entityID;
    }

    public Entity getRiddenEntity() {
        Entity mounted = null;
        int i = this.getVarInt(11);
        if (i == 0) {
            return null;
        }
        mounted = this.world.isServer ? DangerZone.server.entityManager.findEntityByID(i) : DangerZone.clientEntityManager.findEntityByID(i);
        return mounted;
    }

    public float getRiderYoffset() {
        return this.getHeight();
    }

    public float getRiderXZoffset() {
        return 0.0f;
    }

    public Entity getRiderEntity() {
        Entity rider = null;
        int i = this.getVarInt(10);
        if (i == 0) {
            return null;
        }
        rider = this.world.isServer ? DangerZone.server.entityManager.findEntityByID(i) : DangerZone.clientEntityManager.findEntityByID(i);
        return rider;
    }

    public void setForward(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 1) : (f &= 0xFFFFFFFE);
        if (!this.world.isServer && this == DangerZone.player && f != this.getVarInt(12)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 12, f);
        }
        this.setVarInt(12, f);
    }

    public boolean getForward() {
        return (this.getVarInt(12) & 1) == 1;
    }

    public void setBackward(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 2) : (f &= 0xFFFFFFFD);
        if (!this.world.isServer && this == DangerZone.player && f != this.getVarInt(12)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 12, f);
        }
        this.setVarInt(12, f);
    }

    public boolean getBackward() {
        return (this.getVarInt(12) & 2) == 2;
    }

    public void setLeft(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 4) : (f &= 0xFFFFFFFB);
        if (!this.world.isServer && this == DangerZone.player && f != this.getVarInt(12)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 12, f);
        }
        this.setVarInt(12, f);
    }

    public boolean getLeft() {
        return (this.getVarInt(12) & 4) == 4;
    }

    public void setRight(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 8) : (f &= 0xFFFFFFF7);
        if (!this.world.isServer && this == DangerZone.player && f != this.getVarInt(12)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 12, f);
        }
        this.setVarInt(12, f);
    }

    public boolean getRight() {
        return (this.getVarInt(12) & 8) == 8;
    }

    public void setUp(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 0x10) : (f &= 0xFFFFFFEF);
        if (!this.world.isServer && this == DangerZone.player && f != this.getVarInt(12)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 12, f);
        }
        this.setVarInt(12, f);
    }

    public boolean getUp() {
        return (this.getVarInt(12) & 0x10) == 16;
    }

    public void setDown(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 0x20) : (f &= 0xFFFFFFDF);
        if (!this.world.isServer && this == DangerZone.player && f != this.getVarInt(12)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 12, f);
        }
        this.setVarInt(12, f);
    }

    public boolean getDown() {
        return (this.getVarInt(12) & 0x20) == 32;
    }

    public int getGameDifficulty() {
        return this.getVarInt(14);
    }

    public void setGameDifficulty(int f) {
        this.setVarInt(14, f);
    }

    public void setRightButtonDownCount(int count) {
        if (!this.world.isServer && this == DangerZone.player && count != this.getVarInt(15)) {
            DangerZone.player.server_connection.sendVarIntMessage(this.entityID, 15, count);
        }
        this.setVarInt(15, count);
    }

    public int getRightButtonDownCount() {
        return this.getVarInt(15);
    }

    public void setDriverEntity(int i) {
        this.setVarInt(16, i);
    }

    public Entity getDriverEntity() {
        Entity driver = null;
        int i = this.getVarInt(16);
        if (i == 0) {
            return null;
        }
        driver = this.world.isServer ? DangerZone.server.entityManager.findEntityByID(i) : DangerZone.clientEntityManager.findEntityByID(i);
        return driver;
    }

    public InventoryContainer getInventory(int i) {
        if (i >= 0 && i <= 49) {
            return this.getVarInventory(i);
        }
        return null;
    }

    public InventoryContainer getHotbar(int i) {
        if (i >= 0 && i <= 9) {
            return this.getVarInventory(i + 50);
        }
        return null;
    }

    public InventoryContainer getArmor(int i) {
        if (i >= 0 && i <= 3) {
            return this.getVarInventory(i + 60);
        }
        return null;
    }

    public InventoryContainer getMouseBite() {
        return this.getVarInventory(64);
    }

    public InventoryContainer getCrafted() {
        return this.getVarInventory(65);
    }

    public InventoryContainer getCrafting(int i) {
        if (i >= 0 && i <= 8) {
            return this.getVarInventory(i + 66);
        }
        return null;
    }

    public void setInventory(int i, InventoryContainer ic) {
        if (i >= 0 && i <= 49) {
            this.setVarInventory(i, ic);
        }
    }

    public void setInventoryChanged(int i) {
        if (i >= 0 && i <= 49) {
            this.setVarInventoryChanged(i);
        }
    }

    public void setHotbar(int i, InventoryContainer ic) {
        if (i >= 0 && i <= 9) {
            this.setVarInventory(i + 50, ic);
        }
    }

    public void setHotbarChanged(int i) {
        if (i >= 0 && i <= 9) {
            this.setVarInventoryChanged(i + 50);
        }
    }

    public void setArmor(int i, InventoryContainer ic) {
        if (i >= 0 && i <= 3) {
            ItemArmor ita;
            Item it;
            InventoryContainer ico = this.getVarInventory(i + 60);
            if (ico != null && (it = ico.getItem()) != null && it instanceof ItemArmor) {
                ita = (ItemArmor)it;
                ita.armorOff(this, i);
            }
            this.setVarInventory(i + 60, ic);
            if (ic != null && (it = ic.getItem()) != null && it instanceof ItemArmor) {
                ita = (ItemArmor)it;
                ita.armorOn(this, i);
            }
        }
    }

    public void setArmorChanged(int i) {
        if (i >= 0 && i <= 3) {
            this.setVarInventoryChanged(i + 60);
        }
    }

    public void setMouseBite(InventoryContainer ic) {
        this.setVarInventory(64, ic);
    }

    public void setMouseBiteChanged() {
        this.setVarInventoryChanged(64);
    }

    public void setCrafted(InventoryContainer ic) {
        this.setVarInventory(65, ic);
    }

    public void setCraftedChanged() {
        this.setVarInventoryChanged(65);
    }

    public void setCrafting(int i, InventoryContainer ic) {
        if (i >= 0 && i <= 8) {
            this.setVarInventory(i + 66, ic);
        }
    }

    public void setCraftingChanged(int i) {
        if (i >= 0 && i <= 8) {
            this.setVarInventoryChanged(i + 66);
        }
    }

    public void setMagic(float mgc) {
        this.setVarFloat(9, mgc);
    }

    public float getMagic() {
        return this.getVarFloat(9);
    }

    public void setMaxMagic(float mgc) {
        this.setVarFloat(10, mgc);
    }

    public float getMaxMagic() {
        return this.getVarFloat(10);
    }

    public void setGroundFactor(float mgc) {
        this.setVarFloat(11, mgc);
    }

    public float getGroundFactor() {
        Entity ent = this.getRiddenEntity();
        if (ent != null && ent != this) {
            return ent.getGroundFactor();
        }
        return this.getVarFloat(11);
    }

    public void setAirFactor(float mgc) {
        this.setVarFloat(12, mgc);
    }

    public float getAirFactor() {
        Entity ent = this.getRiddenEntity();
        if (ent != null && ent != this) {
            return ent.getAirFactor();
        }
        return this.getVarFloat(12);
    }

    public float getMotionFactor() {
        Entity ent = this.getRiddenEntity();
        if (ent != null && ent != this) {
            if (!ent.isFlying()) {
                return ent.getGroundFactor();
            }
            return ent.getAirFactor();
        }
        if (!this.isFlying()) {
            return this.getGroundFactor();
        }
        return this.getAirFactor();
    }

    public void doAttackFrom(Entity e, int dt, float ouch) {
    }

    public void doAttackFromNoKnock(Entity e, int dt, float pain) {
    }

    public void doAttackFromCustom(Entity e, int dt, float pain, boolean addknockback) {
    }

    public void doTargetPrep(Entity e) {
    }

    public boolean takesDamageFrom(int dt) {
        if (dt == 10 && this.isImmuneToFire) {
            return false;
        }
        return dt != 6 || !this.canBreateUnderWater;
    }

    public void doHurtAnimation() {
    }

    public void doDeathParticles() {
    }

    public float getScale() {
        if (this.isBaby()) {
            return 0.25f;
        }
        return 1.0f;
    }

    public void onDeath() {
        Entity ridden = this.getRiddenEntity();
        Entity rider = this.getRiderEntity();
        if (rider != null) {
            this.unMount(rider);
        }
        if (ridden != null) {
            ridden.unMount(this);
        }
    }

    public void addKnockback(Entity hitter, float xz, float y) {
    }

    public void addKnockback(float dir, float xz, float y) {
    }

    public void doArmorDamage(Entity e, int dt, float pain) {
    }

    public boolean jump() {
        return false;
    }

    public float getRightArmAngle() {
        return 0.0f;
    }

    public boolean isHurt() {
        return false;
    }

    public boolean isMad() {
        return false;
    }

    public boolean isDying() {
        return false;
    }

    public String getLivingSound() {
        return null;
    }

    public float getLivingSoundPitch() {
        if (this.isBaby()) {
            return 2.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.2f;
        }
        return 1.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.2f;
    }

    public float getLivingSoundVolume() {
        float voladjust = (float)Math.sqrt(this.getWidth() * this.getHeight());
        if ((voladjust /= 1.15f) > 3.0f) {
            voladjust = 3.0f;
        }
        if (voladjust < 0.125f) {
            voladjust = 0.125f;
        }
        return voladjust;
    }

    public String getHurtSound() {
        return null;
    }

    public String getDeathSound() {
        return null;
    }

    public String getAttackSound() {
        return null;
    }

    public void doDeathAnimation() {
    }

    public float getDeathFactor() {
        return 0.0f;
    }

    private boolean areCloseEnough(float f1, float f2) {
        if (Math.signum(f1) != Math.signum(f2)) {
            return false;
        }
        if (Math.abs(f1) < Math.abs(f2) - Math.abs(f2) * 0.1f) {
            return false;
        }
        return !(Math.abs(f1) > Math.abs(f2) + Math.abs(f2) * 0.1f);
    }

    public void addEffect(Effects ef) {
        Effects eft = null;
        int i = 0;
        while (i < this.effect_list.size()) {
            eft = this.effect_list.get(i);
            if (eft.effect == ef.effect && this.areCloseEnough(eft.amplitude, ef.amplitude)) {
                float f2;
                float f1 = eft.duration;
                if (f1 < 1.0f) {
                    f1 = 1.0f;
                }
                if ((f1 = (f2 = (float)ef.duration) / f1 * f2) > (float)ef.duration) {
                    f1 = ef.duration;
                }
                eft.duration += (int)f1;
                if (eft.duration - eft.duration_counter < ef.duration) {
                    eft.duration = eft.duration_counter + ef.duration;
                }
                return;
            }
            ++i;
        }
        this.effect_list.add(ef);
    }

    public void addEffectFromServer(Effects ef) {
        if (!this.world.isServer) {
            return;
        }
        this.addEffect(ef);
        if (this instanceof Player) {
            Player p = (Player)this;
            p.server_thread.sendNewEffect(ef);
            ToDoList.onAffected(p, ef.effect, ef.duration, ef.amplitude);
        }
    }

    public void removeAllEffects() {
        this.effect_list.clear();
    }

    public void removeEffect(int efid) {
        boolean found = true;
        block0: while (found) {
            found = false;
            int i = 0;
            while (i < this.effect_list.size()) {
                if (this.effect_list.get((int)i).effect == efid) {
                    this.effect_list.remove(i);
                    found = true;
                    continue block0;
                }
                ++i;
            }
        }
    }

    public float getTotalEffect(int efid) {
        float amp = 0.0f;
        int i = 0;
        while (i < this.effect_list.size()) {
            if (this.effect_list.get((int)i).effect == efid) {
                amp += this.effect_list.get((int)i).amplitude;
            }
            ++i;
        }
        return amp;
    }

    public void updateEffects() {
        int i = 0;
        while (i < this.effect_list.size()) {
            ++this.effect_list.get((int)i).duration_counter;
            ++i;
        }
        boolean found = true;
        block1: while (found) {
            found = false;
            int i2 = 0;
            while (i2 < this.effect_list.size()) {
                if (this.effect_list.get((int)i2).duration_counter >= this.effect_list.get((int)i2).duration) {
                    this.effect_list.remove(i2);
                    found = true;
                    continue block1;
                }
                ++i2;
            }
        }
    }

    public void writeSelf(List<KVPair> prop, String tag) {
        InventoryContainer ic = null;
        while (this.rotation_yaw < 0.0f) {
            this.rotation_yaw += 360.0f;
        }
        this.rotation_yaw %= 360.0f;
        while (this.rotation_pitch < 0.0f) {
            this.rotation_pitch += 360.0f;
        }
        this.rotation_pitch %= 360.0f;
        while (this.rotation_roll < 0.0f) {
            this.rotation_roll += 360.0f;
        }
        this.rotation_roll %= 360.0f;
        while (this.rotation_yaw_head < 0.0f) {
            this.rotation_yaw_head += 360.0f;
        }
        this.rotation_yaw_head %= 360.0f;
        while (this.rotation_pitch_head < 0.0f) {
            this.rotation_pitch_head += 360.0f;
        }
        this.rotation_pitch_head %= 360.0f;
        while (this.rotation_roll_head < 0.0f) {
            this.rotation_roll_head += 360.0f;
        }
        this.rotation_roll_head %= 360.0f;
        prop.add(new KVPair(String.format("%s%s", tag, "posx"), String.format("%f", this.posx)));
        prop.add(new KVPair(String.format("%s%s", tag, "posy"), String.format("%f", this.posy)));
        prop.add(new KVPair(String.format("%s%s", tag, "posz"), String.format("%f", this.posz)));
        prop.add(new KVPair(String.format("%s%s", tag, "dimension"), String.format("%d", this.dimension)));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_yaw"), String.format("%f", Float.valueOf(this.rotation_yaw))));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_pitch"), String.format("%f", Float.valueOf(this.rotation_pitch))));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_roll"), String.format("%f", Float.valueOf(this.rotation_roll))));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_yaw_motion"), String.format("%f", Float.valueOf(this.rotation_yaw_motion))));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_pitch_motion"), String.format("%f", Float.valueOf(this.rotation_pitch_motion))));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_roll_motion"), String.format("%f", Float.valueOf(this.rotation_roll_motion))));
        prop.add(new KVPair(String.format("%s%s", tag, "motionx"), String.format("%f", Float.valueOf(this.motionx))));
        prop.add(new KVPair(String.format("%s%s", tag, "motiony"), String.format("%f", Float.valueOf(this.motiony))));
        prop.add(new KVPair(String.format("%s%s", tag, "motionz"), String.format("%f", Float.valueOf(this.motionz))));
        prop.add(new KVPair(String.format("%s%s", tag, "width"), String.format("%f", Float.valueOf(this.width))));
        prop.add(new KVPair(String.format("%s%s", tag, "height"), String.format("%f", Float.valueOf(this.height))));
        prop.add(new KVPair(String.format("%s%s", tag, "maxrenderdist"), String.format("%d", this.maxrenderdist)));
        prop.add(new KVPair(String.format("%s%s", tag, "lifetimeticker"), String.format("%d", this.lifetimeticker)));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_yaw_head"), String.format("%f", Float.valueOf(this.rotation_yaw_head))));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_pitch_head"), String.format("%f", Float.valueOf(this.rotation_pitch_head))));
        prop.add(new KVPair(String.format("%s%s", tag, "rotation_roll_head"), String.format("%f", Float.valueOf(this.rotation_roll_head))));
        prop.add(new KVPair(String.format("%s%s", tag, "squidticker"), String.format("%d", this.squidticker)));
        prop.add(new KVPair(String.format("%s%s", tag, "candespawn"), String.format("%s", this.canDespawn ? "true" : "false")));
        prop.add(new KVPair(String.format("%s%s", tag, "staying"), String.format("%s", this.staying ? "true" : "false")));
        prop.add(new KVPair(String.format("%s%s", tag, "towerdefensemode"), String.format("%s", this.towerdefensemode ? "true" : "false")));
        int i = 0;
        while (i < 50) {
            if (this.getVarInt(i) != 0) {
                prop.add(new KVPair(String.format("%s%s%d", tag, "varint", i), String.format("%d", this.getVarInt(i))));
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            if (this.getVarFloat(i) != 0.0f) {
                prop.add(new KVPair(String.format("%s%s%d", tag, "varfloat", i), String.format("%f", Float.valueOf(this.getVarFloat(i)))));
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            if (this.getVarString(i) != null) {
                prop.add(new KVPair(String.format("%s%s%d", tag, "varstring", i), this.getVarString(i)));
            }
            ++i;
        }
        if (this.has_inventory) {
            int i2 = 0;
            while (i2 < 100) {
                String s = String.format("%sInventory_%d:", tag, i2);
                ic = this.entity_inventory[i2];
                if (ic != null && (ic.count <= 0 || ic.iid == 0 && ic.bid == 0)) {
                    ic = null;
                }
                if (ic != null) {
                    prop.add(new KVPair(String.format("%s%s", s, "data"), "valid"));
                    ic.writeSelf(prop, s);
                } else {
                    prop.add(new KVPair(String.format("%s%s", s, "data"), "null"));
                }
                ++i2;
            }
        }
        int listlen = 0;
        if (this.effect_list != null) {
            listlen = this.effect_list.size();
        }
        prop.add(new KVPair(String.format("%s%s", tag, "effectlistlen"), String.format("%d", listlen)));
        if (this.effect_list != null && listlen > 0) {
            Effects ef = null;
            int i3 = 0;
            while (i3 < listlen) {
                ef = this.effect_list.get(i3);
                prop.add(new KVPair(String.format("%s%s%d", tag, "effect", i3), String.format("%d", ef.effect)));
                prop.add(new KVPair(String.format("%s%s%d_duration", tag, "effect", i3), String.format("%d", ef.duration)));
                prop.add(new KVPair(String.format("%s%s%d_counter", tag, "effect", i3), String.format("%d", ef.duration_counter)));
                prop.add(new KVPair(String.format("%s%s%d_amp", tag, "effect", i3), String.format("%f", Float.valueOf(ef.amplitude))));
                ++i3;
            }
        }
    }

    public void readSelf(Properties prop, String tag) {
        this.posx = Utils.getPropertyDouble(prop, String.format("%s%s", tag, "posx"), 0.0, 2.147483647E9, 10000.0);
        this.posy = Utils.getPropertyDouble(prop, String.format("%s%s", tag, "posy"), 0.0, 256.0, 75.0);
        this.posz = Utils.getPropertyDouble(prop, String.format("%s%s", tag, "posz"), 0.0, 2.147483647E9, 10000.0);
        this.dimension = Utils.getPropertyInt(prop, String.format("%s%s", tag, "dimension"), 1, 256, 1);
        this.rotation_yaw = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw"), 0.0f, 360.0f, 0.0f);
        this.rotation_pitch = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch"), 0.0f, 360.0f, 0.0f);
        this.rotation_roll = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll"), 0.0f, 360.0f, 0.0f);
        this.rotation_yaw_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw_motion"), -300.0f, 300.0f, 0.0f);
        this.rotation_pitch_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch_motion"), -300.0f, 300.0f, 0.0f);
        this.rotation_roll_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll_motion"), -300.0f, 300.0f, 0.0f);
        this.motionx = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motionx"), -10.0f, 10.0f, 0.0f);
        this.motiony = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motiony"), -10.0f, 10.0f, 0.0f);
        this.motionz = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motionz"), -10.0f, 10.0f, 0.0f);
        this.width = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "width"), 0.1f, 30.0f, this.width);
        this.height = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "height"), 0.1f, 50.0f, this.height);
        this.maxrenderdist = Utils.getPropertyInt(prop, String.format("%s%s", tag, "maxrenderdist"), 2, 512, 16 * DangerZone.renderdistance);
        this.lifetimeticker = Utils.getPropertyLong(prop, String.format("%s%s", tag, "lifetimeticker"), 0L, Long.MAX_VALUE, 0L);
        this.rotation_yaw_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw_head"), 0.0f, 360.0f, 0.0f);
        this.rotation_pitch_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch_head"), 0.0f, 360.0f, 0.0f);
        this.rotation_roll_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll_head"), 0.0f, 360.0f, 0.0f);
        this.squidticker = Utils.getPropertyInt(prop, String.format("%s%s", tag, "squidticker"), 0, 100000, 0);
        this.canDespawn = Utils.getPropertyBoolean(prop, String.format("%s%s", tag, "candespawn"), true);
        this.staying = Utils.getPropertyBoolean(prop, String.format("%s%s", tag, "staying"), false);
        this.towerdefensemode = Utils.getPropertyBoolean(prop, String.format("%s%s", tag, "towerdefensemode"), false);
        int i = 0;
        while (i < 50) {
            this.entity_ints[i] = Utils.getPropertyInt(prop, String.format("%s%s%d", tag, "varint", i), Integer.MIN_VALUE, Integer.MAX_VALUE, this.entity_ints[i]);
            if (this.entity_ints[i] != 0) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 1);
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            this.entity_floats[i] = Utils.getPropertyFloat(prop, String.format("%s%s%d", tag, "varfloat", i), -3.4028235E38f, Float.MAX_VALUE, this.entity_floats[i]);
            if (this.entity_floats[i] != 0.0f) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 2);
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            this.entity_strings[i] = Utils.getPropertyString(prop, String.format("%s%s%d", tag, "varstring", i), this.entity_strings[i]);
            if (this.entity_strings[i] != null) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 4);
            }
            ++i;
        }
        if (this.has_inventory) {
            int i2 = 0;
            while (i2 < 100) {
                this.entity_inventory[i2] = null;
                String s = String.format("%sInventory_%d:", tag, i2);
                String n = prop.getProperty(String.format("%s%s", s, "data"));
                if (n != null && !n.equals("null")) {
                    this.entity_inventory[i2] = new InventoryContainer();
                    this.entity_inventory[i2].readSelf(prop, s);
                    this.entity_inventory[i2] = this.entity_inventory[i2].validate();
                }
                ++i2;
            }
        }
        int listlen = 0;
        listlen = Utils.getPropertyInt(prop, String.format("%s%s", tag, "effectlistlen"), 0, 100, 0);
        if (listlen > 0) {
            Effects ef = null;
            int efid = 0;
            int i3 = 0;
            while (i3 < listlen) {
                efid = Utils.getPropertyInt(prop, String.format("%s%s%d", tag, "effect", i3), 1, Integer.MAX_VALUE, 0);
                ef = new Effects();
                ef.effect = efid;
                ef.duration = Utils.getPropertyInt(prop, String.format("%s%s%d_duration", tag, "effect", i3), 1, Integer.MAX_VALUE, 1);
                ef.duration_counter = Utils.getPropertyInt(prop, String.format("%s%s%d_counter", tag, "effect", i3), 1, Integer.MAX_VALUE, 1);
                ef.amplitude = Utils.getPropertyFloat(prop, String.format("%s%s%d_amp", tag, "effect", i3), Float.MIN_VALUE, Float.MAX_VALUE, 1.0f);
                this.effect_list.add(ef);
                ++i3;
            }
        }
    }

    public void doEntityCollisions(float deltaT) {
    }

    public void doEntityAction(float deltaT) {
        if (this.squidticker > 0) {
            --this.squidticker;
            if (this.squidticker <= 0) {
                this.deadflag = true;
            }
        }
    }

    public void doDeathDrops() {
        if (this.has_inventory) {
            float mdst = this.getHeight() * 2.0f;
            if (mdst > 10.0f) {
                mdst = 10.0f;
            }
            int i = 0;
            while (i < 100) {
                InventoryContainer ic = this.getVarInventory(i);
                if (ic != null) {
                    Utils.doDropRand(this.world, ic, mdst, this.dimension, this.posx, this.posy, this.posz);
                    this.setVarInventory(i, null);
                }
                ++i;
            }
        }
    }

    public void update(float deltaT) {
        int different = 0;
        float rate = DangerZone.entityupdaterate;
        rate /= (float)DangerZone.serverentityupdaterate;
        ++this.lifetimeticker;
        if (deltaT > 1.5f) {
            this.lifetimeticker += (long)((int)(deltaT + 0.5f - 1.0f));
        }
        if (this.posy > 512.0 && (this.world.isServer && !(this instanceof Player) || !this.world.isServer && this == DangerZone.player)) {
            this.motiony -= 0.25f;
        }
        if (this.posy > 1024.0 && (this.world.isServer && !(this instanceof Player) || !this.world.isServer && this == DangerZone.player) && this.motiony > 0.0f) {
            this.motiony = -this.motiony;
        }
        if (this.world.isServer) {
            if (this instanceof EntityLiving) {
                EntityLiving me = (EntityLiving)this;
                if (this.posy < -64.0) {
                    me.doAttackFromCustom(null, 15, me.getMaxHealth() / 20.0f, false);
                }
                if (this.posy < -1024.0) {
                    this.deadflag = true;
                }
                if (this.posx < 0.0 || this.posz < 0.0) {
                    me.doAttackFromCustom(null, 15, me.getMaxHealth() / 20.0f, false);
                }
                if (this.posx > 2.147483647E9 || this.posz > 2.147483647E9) {
                    me.doAttackFromCustom(null, 15, me.getMaxHealth() / 20.0f, false);
                }
            } else {
                if (this.posy < -64.0) {
                    this.deadflag = true;
                }
                if (this.posx < 0.0 || this.posz < 0.0) {
                    this.deadflag = true;
                }
                if (this.posx > 2.147483647E9 || this.posz > 2.147483647E9) {
                    this.deadflag = true;
                }
            }
        }
        if (!this.world.isServer && this.effect_list != null && this.world.rand.nextBoolean()) {
            int i = 0;
            while (i < this.effect_list.size()) {
                int k = this.effect_list.get((int)i).effect;
                switch (k) {
                    case 1: {
                        Utils.spawnParticles(this.world, "DangerZone:ParticleSpeed", 1, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), false);
                        break;
                    }
                    case 3: {
                        Utils.spawnParticles(this.world, "DangerZone:ParticleStrength", 1, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), false);
                        break;
                    }
                    case 4: {
                        Utils.spawnParticles(this.world, "DangerZone:ParticleWeakness", 1, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), false);
                        break;
                    }
                    case 5: {
                        Utils.spawnParticles(this.world, "DangerZone:ParticleRegeneration", 1, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), false);
                        break;
                    }
                    case 6: {
                        Utils.spawnParticles(this.world, "DangerZone:ParticlePoison", 1, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), false);
                        break;
                    }
                    case 7: {
                        Utils.spawnParticles(this.world, "DangerZone:ParticleConfusion", 1, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), false);
                        break;
                    }
                    case 8: {
                        Utils.spawnParticles(this.world, "DangerZone:ParticleMorph", 1, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), false);
                        break;
                    }
                    default: {
                        Utils.spawnParticles(this.world, "DangerZone:ParticleSlowness", 1, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), false);
                    }
                }
                ++i;
            }
        }
        Entity en = this.getRiddenEntity();
        Entity er = this.getRiderEntity();
        Entity dvr = this.getDriverEntity();
        different = 0;
        this.movement_friction = this.getOnGround() || this.getInLiquid() || en != null || er != null || dvr != null || this instanceof Player || this.isFlying();
        if (!this.world.isServer) {
            Player p;
            if (this instanceof Player && ((p = (Player)this).getGameMode() == 2 || p.getGameMode() == 3)) {
                this.motiony *= 1.0f - 0.15f * deltaT * rate;
            }
            if (this.movement_friction) {
                float mf = 0.35f * deltaT * rate;
                if (this.isFlying()) {
                    mf = 0.15f * deltaT * rate;
                }
                if (mf > 0.85f) {
                    mf = 0.85f;
                }
                this.motionx *= 1.0f - mf;
                this.motionz *= 1.0f - mf;
                mf = 0.05f * deltaT * rate;
                if (mf > 0.85f) {
                    mf = 0.85f;
                }
                this.motiony *= 1.0f - mf;
                mf = 0.25f * deltaT * rate;
                if (mf > 0.85f) {
                    mf = 0.85f;
                }
                this.rotation_pitch_motion *= 1.0f - mf;
                this.rotation_yaw_motion *= 1.0f - mf;
                this.rotation_roll_motion *= 1.0f - mf;
            }
            if (dvr == null || dvr == this) {
                this.posy += (double)(this.motiony * deltaT * rate);
                this.posx += (double)(this.motionx * deltaT * rate);
                this.posz += (double)(this.motionz * deltaT * rate);
                this.display_posx = this.posx;
                this.display_posy = this.posy;
                this.display_posz = this.posz;
            }
            this.rotation_pitch += this.rotation_pitch_motion * deltaT * rate;
            if (this instanceof Player) {
                this.rotation_yaw_head += this.rotation_yaw_motion * deltaT * rate;
            } else {
                this.rotation_yaw += this.rotation_yaw_motion * deltaT * rate;
            }
            this.rotation_roll += this.rotation_roll_motion * deltaT * rate;
            this.display_rotation_pitch = this.rotation_pitch;
            this.display_rotation_yaw = this.rotation_yaw;
            this.display_rotation_roll = this.rotation_roll;
        } else {
            if (this.movement_friction) {
                float mf = 0.35f * deltaT;
                if (this.isFlying()) {
                    mf = 0.15f * deltaT;
                }
                if (mf > 0.85f) {
                    mf = 0.85f;
                }
                this.motionx *= 1.0f - mf;
                this.motionz *= 1.0f - mf;
                mf = 0.05f * deltaT;
                if (mf > 0.85f) {
                    mf = 0.85f;
                }
                this.motiony *= 1.0f - mf;
                mf = 0.25f * deltaT;
                if (mf > 0.85f) {
                    mf = 0.85f;
                }
                this.rotation_pitch_motion *= 1.0f - mf;
                this.rotation_yaw_motion *= 1.0f - mf;
                this.rotation_roll_motion *= 1.0f - mf;
            }
            if (dvr == null || dvr == this) {
                this.posy += (double)(this.motiony * deltaT);
                this.posx += (double)(this.motionx * deltaT);
                this.posz += (double)(this.motionz * deltaT);
            }
            this.rotation_pitch += this.rotation_pitch_motion * deltaT;
            this.rotation_yaw += this.rotation_yaw_motion * deltaT;
            this.rotation_roll += this.rotation_roll_motion * deltaT;
        }
        while (this.rotation_yaw < 0.0f) {
            this.rotation_yaw += 360.0f;
        }
        this.rotation_yaw %= 360.0f;
        while (this.rotation_pitch < 0.0f) {
            this.rotation_pitch += 360.0f;
        }
        this.rotation_pitch %= 360.0f;
        while (this.rotation_roll < 0.0f) {
            this.rotation_roll += 360.0f;
        }
        this.rotation_roll %= 360.0f;
        while (this.rotation_yaw_head < 0.0f) {
            this.rotation_yaw_head += 360.0f;
        }
        this.rotation_yaw_head %= 360.0f;
        while (this.rotation_pitch_head < 0.0f) {
            this.rotation_pitch_head += 360.0f;
        }
        this.rotation_pitch_head %= 360.0f;
        while (this.rotation_roll_head < 0.0f) {
            this.rotation_roll_head += 360.0f;
        }
        this.rotation_roll_head %= 360.0f;
        if (!this.world.isServer) {
            this.prevdimension = this.dimension;
            this.prevposy = this.posy;
            this.prevposx = this.posx;
            this.prevposz = this.posz;
            this.prevrotation_yaw = this.rotation_yaw;
            this.prevrotation_pitch = this.rotation_pitch;
            this.prevrotation_roll = this.rotation_roll;
            this.prevrotation_yaw_head = this.rotation_yaw_head;
            this.prevrotation_pitch_head = this.rotation_pitch_head;
            this.prevrotation_roll_head = this.rotation_roll_head;
        }
        if (er == dvr && dvr != null) {
            if (en != null && en != this) {
                en.motionx = this.motionx;
                en.motiony = this.motiony;
                en.motionz = this.motionz;
                en.posx = this.posx - Math.sin(Math.toRadians(en.rotation_yaw)) * (double)en.getRiderXZoffset();
                en.posy = this.posy;
                en.posz = this.posz - Math.cos(Math.toRadians(en.rotation_yaw)) * (double)en.getRiderXZoffset();
                if (!this.world.isServer) {
                    en.display_posx = en.posx;
                    en.display_posy = en.posy;
                    en.display_posz = en.posz;
                }
                en.setFlying(this.isFlying());
                en.setOnGround(this.getOnGround());
                en.setBaby(this.isBaby());
                en.setOnFire(this.getOnFire());
                en.setInLiquid(this.getInLiquid());
            }
            if (er != null && er != this) {
                this.motionx = er.motionx;
                this.motiony = er.motiony;
                this.motionz = er.motionz;
                this.posx = er.posx - Math.sin(Math.toRadians(this.rotation_yaw)) * (double)this.getRiderXZoffset();
                this.posy = er.posy;
                this.posz = er.posz - Math.cos(Math.toRadians(this.rotation_yaw)) * (double)this.getRiderXZoffset();
                if (!this.world.isServer) {
                    this.display_posx = this.posx;
                    this.display_posy = this.posy;
                    this.display_posz = this.posz;
                }
                this.setFlying(er.isFlying());
                this.setOnGround(er.getOnGround());
                this.setBaby(er.isBaby());
                this.setOnFire(er.getOnFire());
                this.setInLiquid(er.getInLiquid());
            }
            ++different;
        } else if (dvr != null) {
            if (dvr != this) {
                this.motionx = dvr.motionx;
                this.motiony = dvr.motiony;
                this.motionz = dvr.motionz;
                this.posx = dvr.posx + Math.sin(Math.toRadians(dvr.rotation_yaw)) * (double)dvr.getRiderXZoffset();
                this.posy = dvr.posy;
                this.posz = dvr.posz + Math.cos(Math.toRadians(dvr.rotation_yaw)) * (double)dvr.getRiderXZoffset();
                if (!this.world.isServer) {
                    this.display_posx = this.posx;
                    this.display_posy = this.posy;
                    this.display_posz = this.posz;
                }
                this.setFlying(dvr.isFlying());
                this.setOnGround(dvr.getOnGround());
                this.setBaby(dvr.isBaby());
                this.setOnFire(dvr.getOnFire());
                this.setInLiquid(dvr.getInLiquid());
            } else if (er != null) {
                er.motionx = this.motionx;
                er.motiony = this.motiony;
                er.motionz = this.motionz;
                er.posx = this.posx + Math.sin(Math.toRadians(this.rotation_yaw)) * (double)this.getRiderXZoffset();
                er.posy = this.posy;
                er.posz = this.posz + Math.cos(Math.toRadians(this.rotation_yaw)) * (double)this.getRiderXZoffset();
                if (!this.world.isServer) {
                    er.display_posx = er.posx;
                    er.display_posy = er.posy;
                    er.display_posz = er.posz;
                }
                er.setFlying(this.isFlying());
                er.setOnGround(this.getOnGround());
                er.setBaby(this.isBaby());
                er.setOnFire(this.getOnFire());
                er.setInLiquid(this.getInLiquid());
            }
            ++different;
        }
        if (!this.world.isServer && this != DangerZone.player) {
            return;
        }
        long too_long = DangerZone.most_current_time - this.lasttime;
        if (too_long >= (long)this.maxidleupdate) {
            ++different;
        } else if (!this.world.isServer && too_long < 90L) {
            return;
        }
        if (this.changed != 0) {
            ++different;
        }
        if (this.prevdimension != this.dimension || this.prevposx != this.posx || this.prevposy != this.posy || this.prevposz != this.posz) {
            ++different;
        }
        if (this.prevrotation_yaw != this.rotation_yaw || this.prevrotation_pitch != this.rotation_pitch || this.prevrotation_roll != this.rotation_roll) {
            ++different;
        }
        if (this.prevrotation_yaw_head != this.rotation_yaw_head || this.prevrotation_pitch_head != this.rotation_pitch_head || this.prevrotation_roll_head != this.rotation_roll_head) {
            ++different;
        }
        if (different == 0) {
            ++this.diffticker;
            if (this.diffticker < 3) {
                ++different;
            }
        } else {
            this.diffticker = 0;
        }
        if (different != 0) {
            this.lasttime = DangerZone.most_current_time;
            this.prevdimension = this.dimension;
            this.prevposy = this.posy;
            this.prevposx = this.posx;
            this.prevposz = this.posz;
            this.prevrotation_yaw = this.rotation_yaw;
            this.prevrotation_pitch = this.rotation_pitch;
            this.prevrotation_roll = this.rotation_roll;
            this.prevrotation_yaw_head = this.rotation_yaw_head;
            this.prevrotation_pitch_head = this.rotation_pitch_head;
            this.prevrotation_roll_head = this.rotation_roll_head;
            if (this.world.isServer) {
                DangerZone.server.sendEntityUpdateToAll(this, false);
                if (dvr == this) {
                    if (er != null && er != this) {
                        DangerZone.server.sendEntityUpdateToAll(er, false);
                    }
                    if (en != null && en != this) {
                        DangerZone.server.sendEntityUpdateToAll(en, false);
                    }
                }
            } else {
                DangerZone.server_connection.sendPlayerEntityUpdate(this);
            }
        }
    }

    public void player_morph_update(float deltaT, Player pl) {
    }

    public float getAdjustedFallDamage(float damage) {
        if (!this.takesFallDamage) {
            return 0.0f;
        }
        return damage;
    }

    public double getDistanceFromEntity(Entity p) {
        double d1 = p.posx - this.posx;
        double d2 = p.posy - this.posy;
        double d3 = p.posz - this.posz;
        if (p.dimension != this.dimension) {
            return 9999.0;
        }
        return Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public double getDistanceFromParticle(Particle p) {
        double d1 = p.posx - this.posx;
        double d2 = p.posy - this.posy;
        double d3 = p.posz - this.posz;
        if (p.dimension != this.dimension) {
            return 9999.0;
        }
        return Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public double getDistanceFromEntityCenter(Entity p) {
        if (p.dimension != this.dimension) {
            return 9999.0;
        }
        double d1 = p.posx - this.posx;
        double d2 = p.posy + (double)(p.getHeight() / 2.0f) - (this.posy + (double)(this.getHeight() / 2.0f));
        double d3 = p.posz - this.posz;
        return Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public double getHorizontalDistanceFromEntity(Entity p) {
        if (p.dimension != this.dimension) {
            return 9999.0;
        }
        double d1 = p.posx - this.posx;
        double d3 = p.posz - this.posz;
        return Math.sqrt(d1 * d1 + d3 * d3);
    }

    public double getHorizontalDistanceFromEntity(double x, double z) {
        double d1 = x - this.posx;
        double d3 = z - this.posz;
        return Math.sqrt(d1 * d1 + d3 * d3);
    }

    public double getDistanceFromEntityCenter(double x, double y, double z) {
        double d1 = x - this.posx;
        double d2 = y - (this.posy + (double)(this.getHeight() / 2.0f));
        double d3 = z - this.posz;
        return Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        return false;
    }

    public boolean leftClickedByPlayer(Player p, InventoryContainer ic) {
        return true;
    }

    public void onKill(Entity deadthing) {
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        return true;
    }

    public boolean isFoodForMe(int bid, int iid) {
        return this.isFoodBlock(bid) || this.isFoodItem(iid);
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        return this.isFoodForMe(bid, iid);
    }

    public boolean isFoodBlock(int bid) {
        return false;
    }

    public boolean isFoodItem(int iid) {
        return false;
    }

    public void doDistanceAttack(Entity victim) {
    }

    public void findBlockFood(int maxdistxz, int maxdisty, int healamount, int eatitdistance) {
    }

    public void playburp() {
    }

    public float getSpinz() {
        return 0.0f;
    }

    public void doFromSpawner() {
    }

    public float getLightAtLocation(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return WorldRendererUtils.getTotalLightAt(w, d, x, y, z);
        }
        if (DangerZone.start_client) {
            return WorldRendererUtils.getTotalLightAt(DangerZone.world, d, x, y, z);
        }
        if (w.isDaytime()) {
            return 0.5f + w.rand.nextFloat() * 0.5f;
        }
        return w.rand.nextFloat();
    }

    public boolean CanProbablySee(int d, double x, double y, double z, int distinblocks) {
        double xzoff = this.getWidth() / 2.0f;
        int nblks = distinblocks;
        if (distinblocks < 1) {
            return true;
        }
        double cx = this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double cz = this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        double startx = cx;
        double starty = this.posy + (double)(this.getHeight() * 7.0f / 8.0f);
        double startz = cz;
        double dx = (x - startx) / (double)distinblocks;
        double dy = (y - starty) / (double)distinblocks;
        double dz = (z - startz) / (double)distinblocks;
        if (Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((double)nblks * Math.abs(dx));
            if (dx > 1.0) {
                dx = 1.0;
            }
            if (dx < -1.0) {
                dx = -1.0;
            }
        }
        if (Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((double)nblks * Math.abs(dy));
            if (dy > 1.0) {
                dy = 1.0;
            }
            if (dy < -1.0) {
                dy = -1.0;
            }
        }
        if (Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((double)nblks * Math.abs(dz));
            if (dz > 1.0) {
                dz = 1.0;
            }
            if (dz < -1.0) {
                dz = -1.0;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid(this.world.getblock(d, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)), this.world, d, (int)startx, (int)starty, (int)startz)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean amFacingTarget(Entity e) {
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if ((double)ddiff > 2.356194490192345) {
            return false;
        }
        return !((double)ddiff < -2.356194490192345);
    }

    public boolean CanProbablySeeEntity(Entity e) {
        double xzoff = this.getWidth() / 2.0f;
        double startx = this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double starty = this.posy + (double)(this.getHeight() * 7.0f / 8.0f);
        double startz = this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        double estarty = e.posy + (double)(e.getHeight() * 7.0f / 8.0f);
        double dx = e.posx - startx;
        double dy = estarty - starty;
        double dz = e.posz - startz;
        double nblks = 1.0;
        if (nblks < Math.abs(dx)) {
            nblks = Math.abs(dx);
        }
        if (nblks < Math.abs(dy)) {
            nblks = Math.abs(dy);
        }
        if (nblks < Math.abs(dz)) {
            nblks = Math.abs(dz);
        }
        if (nblks < 1.0) {
            return true;
        }
        if (nblks < (double)(e.getWidth() / 2.0f)) {
            return true;
        }
        dx /= nblks;
        dy /= nblks;
        dz /= nblks;
        int i = 0;
        while (i < (int)(nblks - (double)(e.getWidth() / 2.0f))) {
            if (Blocks.isSolid(this.world.getblock(this.dimension, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)), this.world, this.dimension, (int)startx, (int)starty, (int)startz)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void doInLiquid(float factor) {
        int bid;
        if (this.getInLiquid() && Blocks.isLiquid(bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz))) {
            int meta2;
            int bid2;
            int j;
            int meta = this.world.getblockmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) & 0xF;
            int i = -1;
            while (i <= 1) {
                j = -1;
                while (j <= 1) {
                    bid2 = this.world.getblock(this.dimension, (int)this.posx + i, (int)this.posy, (int)this.posz + j);
                    if (Blocks.isLiquid(bid2) && (meta2 = this.world.getblockmeta(this.dimension, (int)this.posx + i, (int)this.posy, (int)this.posz + j) & 0xF) > meta) {
                        this.motionx += 0.025f * (float)i * factor;
                        this.motionz += 0.025f * (float)j * factor;
                    }
                    ++j;
                }
                ++i;
            }
            i = -1;
            while (i <= 1) {
                j = -1;
                while (j <= 1) {
                    bid2 = this.world.getblock(this.dimension, (int)this.posx + i, (int)this.posy, (int)this.posz + j);
                    if (Blocks.isLiquid(bid2) && (meta2 = this.world.getblockmeta(this.dimension, (int)this.posx + i, (int)this.posy, (int)this.posz + j) & 0xF) < meta) {
                        this.motionx -= 0.025f * (float)i * factor;
                        this.motionz -= 0.025f * (float)j * factor;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void smoothMotion() {
        int mydifft = this.diff_ticker;
        if (mydifft > 0) {
            float dx = this.diff_posx / (float)mydifft;
            if (this.getRiderEntity() == null || this.getDriverEntity() == this) {
                this.posx += (double)dx;
                this.diff_posx -= dx;
                dx = this.diff_posy / (float)mydifft;
                this.posy += (double)dx;
                this.diff_posy -= dx;
                dx = this.diff_posz / (float)mydifft;
                this.posz += (double)dx;
                this.diff_posz -= dx;
            }
            dx = this.diff_rotpitch / (float)mydifft;
            this.rotation_pitch += dx;
            this.diff_rotpitch -= dx;
            while (this.rotation_pitch > 360.0f) {
                this.rotation_pitch -= 360.0f;
            }
            while (this.rotation_pitch < 0.0f) {
                this.rotation_pitch += 360.0f;
            }
            dx = this.diff_rotroll / (float)mydifft;
            this.rotation_roll += dx;
            this.diff_rotroll -= dx;
            while (this.rotation_roll > 360.0f) {
                this.rotation_roll -= 360.0f;
            }
            while (this.rotation_roll < 0.0f) {
                this.rotation_roll += 360.0f;
            }
            dx = this.diff_rotyaw / (float)mydifft;
            this.rotation_yaw += dx;
            this.diff_rotyaw -= dx;
            while (this.rotation_yaw > 360.0f) {
                this.rotation_yaw -= 360.0f;
            }
            while (this.rotation_yaw < 0.0f) {
                this.rotation_yaw += 360.0f;
            }
            dx = this.diff_rotpitchh / (float)mydifft;
            this.rotation_pitch_head += dx;
            this.diff_rotpitchh -= dx;
            while (this.rotation_pitch_head > 360.0f) {
                this.rotation_pitch_head -= 360.0f;
            }
            while (this.rotation_pitch_head < 0.0f) {
                this.rotation_pitch_head += 360.0f;
            }
            dx = this.diff_rotyawh / (float)mydifft;
            this.rotation_yaw_head += dx;
            this.diff_rotyawh -= dx;
            while (this.rotation_yaw_head > 360.0f) {
                this.rotation_yaw_head -= 360.0f;
            }
            while (this.rotation_yaw_head < 0.0f) {
                this.rotation_yaw_head += 360.0f;
            }
            dx = this.diff_rotrollh / (float)mydifft;
            this.rotation_roll_head += dx;
            this.diff_rotrollh -= dx;
            while (this.rotation_roll_head > 360.0f) {
                this.rotation_roll_head -= 360.0f;
            }
            while (this.rotation_roll_head < 0.0f) {
                this.rotation_roll_head += 360.0f;
            }
            --this.diff_ticker;
        }
    }

    public void setMotion() {
        if (this.getRiderEntity() == null || this.getDriverEntity() == this) {
            this.posx += (double)this.diff_posx;
            this.diff_posx = 0.0f;
            this.posy += (double)this.diff_posy;
            this.diff_posy = 0.0f;
            this.posz += (double)this.diff_posz;
            this.diff_posz = 0.0f;
        } else {
            this.diff_posx = 0.0f;
            this.diff_posy = 0.0f;
            this.diff_posz = 0.0f;
        }
        this.rotation_pitch += this.diff_rotpitch;
        this.diff_rotpitch = 0.0f;
        while (this.rotation_pitch > 360.0f) {
            this.rotation_pitch -= 360.0f;
        }
        while (this.rotation_pitch < 0.0f) {
            this.rotation_pitch += 360.0f;
        }
        this.rotation_roll += this.diff_rotroll;
        this.diff_rotroll = 0.0f;
        while (this.rotation_roll > 360.0f) {
            this.rotation_roll -= 360.0f;
        }
        while (this.rotation_roll < 0.0f) {
            this.rotation_roll += 360.0f;
        }
        this.rotation_yaw += this.diff_rotyaw;
        this.diff_rotyaw = 0.0f;
        while (this.rotation_yaw > 360.0f) {
            this.rotation_yaw -= 360.0f;
        }
        while (this.rotation_yaw < 0.0f) {
            this.rotation_yaw += 360.0f;
        }
        this.rotation_pitch_head += this.diff_rotpitchh;
        this.diff_rotpitchh = 0.0f;
        while (this.rotation_pitch_head > 360.0f) {
            this.rotation_pitch_head -= 360.0f;
        }
        while (this.rotation_pitch_head < 0.0f) {
            this.rotation_pitch_head += 360.0f;
        }
        this.rotation_yaw_head += this.diff_rotyawh;
        this.diff_rotyawh = 0.0f;
        while (this.rotation_yaw_head > 360.0f) {
            this.rotation_yaw_head -= 360.0f;
        }
        while (this.rotation_yaw_head < 0.0f) {
            this.rotation_yaw_head += 360.0f;
        }
        this.rotation_roll_head += this.diff_rotrollh;
        this.diff_rotrollh = 0.0f;
        while (this.rotation_roll_head > 360.0f) {
            this.rotation_roll_head -= 360.0f;
        }
        while (this.rotation_roll_head < 0.0f) {
            this.rotation_roll_head += 360.0f;
        }
    }

    public float getBrightness() {
        return 0.0f;
    }

    public boolean hasInInventory(int iid) {
        InventoryContainer ic;
        if (!this.has_inventory) {
            return false;
        }
        int i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic != null && ic.iid == iid && ic.count > 0) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic != null && ic.iid == iid && ic.count > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void decrementInInventory(int iid) {
        InventoryContainer ic;
        if (!this.has_inventory) {
            return;
        }
        if (!this.world.isServer) {
            return;
        }
        int i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic != null && ic.iid == iid) {
                --ic.count;
                if (ic.count <= 0) {
                    ic = null;
                }
                this.setHotbar(i, ic);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic != null && ic.iid == iid) {
                --ic.count;
                if (ic.count <= 0) {
                    ic = null;
                }
                this.setInventory(i, ic);
                return;
            }
            ++i;
        }
    }

    public void lookAtEntity(Entity ent) {
    }

    public void addKeyEvent(int key, boolean updown) {
        if (this.keyevent_list == null) {
            this.keyevent_list = new ArrayList<PlayerKeyEvent>();
        }
        this.keyevent_list.add(new PlayerKeyEvent(key, updown));
    }

    public PlayerKeyEvent getNextKeyEvent() {
        if (this.keyevent_list == null) {
            return null;
        }
        if (this.keyevent_list.size() <= 0) {
            return null;
        }
        return this.keyevent_list.remove(0);
    }

    public void addMouseEvent(int mouse, boolean updown) {
        if (this.mouseevent_list == null) {
            this.mouseevent_list = new ArrayList<PlayerKeyEvent>();
        }
        this.mouseevent_list.add(new PlayerKeyEvent(mouse, updown));
    }

    public PlayerKeyEvent getNextMouseEvent() {
        if (this.mouseevent_list == null) {
            return null;
        }
        if (this.mouseevent_list.size() <= 0) {
            return null;
        }
        return this.mouseevent_list.remove(0);
    }

    public void justCollidedWith(Entity e) {
    }

    public boolean isBoss() {
        return this.getOwnerName() != null && this.getOwnerName().equals(DangerZone.player.myname);
    }

    public String getBossName() {
        String[] hss = null;
        hss = this.uniquename.split(":");
        if (hss.length >= 2) {
            return hss[1];
        }
        return this.uniquename;
    }

    public float getBossHealth() {
        return this.getHealth() / this.getMaxHealth();
    }

    public void setWasShot(int lifetime) {
        this.squidticker = lifetime + this.world.rand.nextInt(lifetime / 2);
    }
}

