/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Butterfly
extends EntityLiving {
    public float myspeed = 0.0f;
    public Texture texture2 = null;
    public Texture texture3 = null;
    public Texture texture4 = null;
    public boolean despawn_fast = false;

    public Butterfly(World w) {
        super(w);
        this.maxrenderdist = 128;
        this.height = 0.25f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:Butterfly";
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(0.5f);
        if (w != null) {
            this.myspeed = 0.05f + this.world.rand.nextFloat() * 0.1f;
        }
        this.takesFallDamage = false;
        this.setBID(-1);
        this.setBID(DangerZone.rand.nextInt(4));
        this.setExperience(1);
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.canFly = true;
        this.setFlying(true);
    }

    @Override
    public void doEntityAction(float deltaT) {
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 25;
            if ((this.despawn_fast || !this.world.isDaytime()) && this.world.rand.nextInt(100) == 1 && this.getCanDespawn()) {
                this.deadflag = true;
            }
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(10) - this.world.rand.nextInt(10)), this.posy + (double)(this.world.rand.nextInt(7) - 2), this.posz + (double)(this.world.rand.nextInt(10) - this.world.rand.nextInt(10)));
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    --keep_trying;
                    this.myspeed = 0.05f + this.world.rand.nextFloat() * 0.1f;
                }
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            float dy = (float)(this.target.targety - this.posy);
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0f) > 0.2f) {
                dy = 0.2f;
            }
            if (dy < -0.2f) {
                dy = -0.2f;
            }
            this.motiony += dy;
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
            Utils.SpawnDustAlongPath(this);
        }
        super.update(deltaT);
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophybutterfly.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Butterfly.png");
            this.texture2 = TextureMapper.getTexture("res/skins/Butterfly2.png");
            this.texture3 = TextureMapper.getTexture("res/skins/Butterfly3.png");
            this.texture4 = TextureMapper.getTexture("res/skins/Butterfly4.png");
        }
        if (this.getBID() == 1) {
            return this.texture2;
        }
        if (this.getBID() == 2) {
            return this.texture3;
        }
        if (this.getBID() == 3) {
            return this.texture4;
        }
        return this.texture;
    }
}

