/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.items.Items;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class Door
extends Block {
    private boolean compiled = false;
    private int squareid3D = 0;
    private float blockrenderwidth = 16.0f;

    public Door(String n, String txt) {
        super(n, txt);
        this.breaksound = "DangerZone:woodbreak";
        this.placesound = "DangerZone:woodplace";
        this.hitsound = "DangerZone:woodhit";
        this.isSolidForRendering = false;
        this.isSolid = true;
        this.hasOwnRenderer = true;
        this.maxdamage = 100;
        this.burntime = 65;
        this.hasFront = true;
        this.showInInventory = false;
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:wood1";
        }
        if (i == 1) {
            return "DangerZone:wood2";
        }
        if (i == 2) {
            return "DangerZone:wood3";
        }
        return "DangerZone:wood4";
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = 0;
        if (!w.isServer) {
            return;
        }
        bid = w.getblock(d, x, y, z);
        if (bid != Blocks.doortop.blockID && bid != Blocks.doorbottom.blockID) {
            return;
        }
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        if (this.blockID == Blocks.doorbottom.blockID) {
            bid = w.getblock(d, x, y + 1, z);
            if (bid != Blocks.doortop.blockID) {
                w.setblock(d, x, y, z, 0);
            }
        } else {
            bid = w.getblock(d, x, y - 1, z);
            if (bid != Blocks.doorbottom.blockID) {
                w.setblock(d, x, y, z, 0);
            }
        }
    }

    @Override
    public boolean getIsSolid(World w, int d, int x, int y, int z) {
        int meta = w.getblockmeta(d, x, y, z);
        return (meta & 1) != 1;
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    @Override
    public int getItemDrop(Player p, World w, int dimension, int x, int y, int z) {
        return Items.door.itemID;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int s) {
        if (p != null && p.world.isServer) {
            int meta = p.world.getblockmeta(p.dimension, x, y, z);
            if ((meta & 1) == 1) {
                meta &= 0xFFFE;
                if (p.world.rand.nextBoolean()) {
                    p.world.playSound("DangerZone:door_close1", dimension, x, y, z, 0.75f, 1.0f);
                } else {
                    p.world.playSound("DangerZone:door_close2", dimension, x, y, z, 0.75f, 1.0f);
                }
            } else {
                meta |= 1;
                if (p.world.rand.nextBoolean()) {
                    p.world.playSound("DangerZone:door_open1", dimension, x, y, z, 0.75f, 1.0f);
                } else {
                    p.world.playSound("DangerZone:door_open2", dimension, x, y, z, 0.75f, 1.0f);
                }
            }
            if (!BreakChecks.canChangeBlock(p, dimension, x, y, z, this.blockID, meta)) {
                return false;
            }
            p.world.setblockandmeta(p.dimension, x, y, z, this.blockID, meta);
            if (this.blockID == Blocks.doortop.blockID) {
                p.world.setblockandmeta(p.dimension, x, y - 1, z, Blocks.doorbottom.blockID, meta);
            } else {
                p.world.setblockandmeta(p.dimension, x, y + 1, z, Blocks.doortop.blockID, meta);
            }
        }
        return false;
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int inmeta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        float xoff = 0.0f;
        int meta = inmeta;
        st = builder.findVBOtextureforblockside(0, bid);
        if (st == null) {
            return;
        }
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        if ((inmeta & 1) == 1) {
            xoff = 7.0f;
            meta = (inmeta & 0x3000) == 0 ? 4096 : ((inmeta & 0x3000) == 4096 ? 8192 : ((inmeta & 0x3000) == 8192 ? 12288 : 0));
        }
        this.addVertextWithRotation(v, 1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin + (st.yoffsetmax - st.yoffsetmin) / 8.0f, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin + (st.yoffsetmax - st.yoffsetmin) / 8.0f, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin + (st.yoffsetmax - st.yoffsetmin) / 8.0f, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin + (st.yoffsetmax - st.yoffsetmin) / 8.0f, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmin + (st.xoffsetmax - st.xoffsetmin) / 8.0f, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmin + (st.xoffsetmax - st.xoffsetmin) / 8.0f, st.yoffsetmax, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin + (st.xoffsetmax - st.xoffsetmin) / 8.0f, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin + (st.xoffsetmax - st.xoffsetmin) / 8.0f, st.yoffsetmax, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta, builder);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmax, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmax, meta, builder);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta, builder);
    }

    public void addVertextWithRotation(VBOBuffer v, float x, float y, float z, float xo, float yo, float zo, float xtx, float ytx, int meta, VBODataBuilderThread builder) {
        if ((meta & 0x3000) == 0) {
            v.addVertexInfoToVBO(z + xo, y + yo, -x + zo, xtx, ytx, builder.cbr, builder.cbg, builder.cbb);
        } else if ((meta & 0x3000) == 4096) {
            v.addVertexInfoToVBO(-x + xo, y + yo, -z + zo, xtx, ytx, builder.cbr, builder.cbg, builder.cbb);
        } else if ((meta & 0x3000) == 8192) {
            v.addVertexInfoToVBO(-z + xo, y + yo, x + zo, xtx, ytx, builder.cbr, builder.cbg, builder.cbb);
        } else {
            v.addVertexInfoToVBO(x + xo, y + yo, z + zo, xtx, ytx, builder.cbr, builder.cbg, builder.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            int stride;
            int textureoff = stride = 12;
            int coloroff = stride += 8;
            stride += 12;
            this.squareid3D = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)this.squareid3D);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            ByteBuffer vbodata = BufferUtils.createByteBuffer(24 * stride);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 0.125f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 0.125f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.125f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.125f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.125f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.125f, 1.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.125f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.125f, 1.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, -1.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            Door.addVertexInfoToBuffer(vbodata, 1.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            int vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        float rot = 0.0f;
        float xoff = 0.0f;
        float zoff = 0.0f;
        if ((meta & 1) == 0) {
            rot = (meta & 0x3000) == 0 ? 270.0f : ((meta & 0x3000) == 4096 ? 180.0f : ((meta & 0x3000) == 8192 ? 90.0f : 0.0f));
        } else if ((meta & 0x3000) == 0) {
            rot = 180.0f;
            xoff = -6.93f;
        } else if ((meta & 0x3000) == 4096) {
            rot = 90.0f;
            zoff = 6.93f;
        } else if ((meta & 0x3000) == 8192) {
            rot = 0.0f;
            xoff = 6.93f;
        } else {
            rot = 270.0f;
            zoff = -6.93f;
        }
        MatrixStack.pushMatrix();
        MatrixStack.rotate(rot, 0.0f, 1.0f, 0.0f);
        if ((meta & 1) == 1) {
            if (xoff != 0.0f) {
                MatrixStack.translate(xoff, 0.0f, 0.0f);
            }
            if (zoff != 0.0f) {
                MatrixStack.translate(0.0f, 0.0f, zoff);
            }
        }
        MatrixStack.sendCurrentStack();
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)this.squareid3D);
        GL11.glDrawArrays((int)7, (int)0, (int)24);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        MatrixStack.popMatrix();
    }

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }
}

