/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class BlockSapling
extends Block {
    private boolean compiled = false;
    private int squareid3D = 0;
    private float blockrenderwidth = 16.0f;

    public BlockSapling(String n, String txt) {
        super(n, txt);
        this.isStone = false;
        this.maxdamage = 5;
        this.mindamage = 1;
        this.breaksound = "DangerZone:dirt_hit";
        this.placesound = "DangerZone:dirt_place";
        this.hitsound = "DangerZone:dirt_hit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            EntityBlockItem e;
            w.setblock(d, x, y, z, 0);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSparkle", 10, d, (float)x + 0.5f, (float)y + 0.25f, (float)z + 0.5f);
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        if (w.getblock(d, x, y + 1, z) != 0) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        if (w.rand.nextInt(15) != 1) {
            return;
        }
        w.setblock(d, x, y, z, 0);
        Trees tr = new Trees();
        if (this.blockID == Blocks.sapling_tallwood.blockID) {
            tr.TallWoodTree(w, d, x, y, z);
        }
        if (this.blockID == Blocks.sapling_cherry.blockID) {
            tr.makeFruitTree(w, d, x, y - 1, z, Blocks.cherryleaves.blockID);
        }
        if (this.blockID == Blocks.sapling_peach.blockID) {
            tr.makeFruitTree(w, d, x, y - 1, z, Blocks.peachleaves.blockID);
        }
        if (this.blockID == Blocks.sapling_apple.blockID) {
            tr.makeFruitTree(w, d, x, y - 1, z, Blocks.appleleaves.blockID);
        }
        if (this.blockID == Blocks.sapling_scragglyredwood.blockID) {
            tr.ScragglyRedwoodTree(w, d, x, y, z);
        }
        if (this.blockID == Blocks.sapling_scraggly.blockID) {
            tr.ScragglyTreeWithBranches(w, d, x, y, z);
        }
        if (this.blockID == Blocks.sapling_bigroundredwood.blockID) {
            tr.MakeBigRoundTree(w, d, x, y, z, Blocks.redwoodlog.blockID, Blocks.redwoodleaves.blockID, 6);
        }
        if (this.blockID == Blocks.sapling_bigroundwillow.blockID) {
            tr.MakeBigRoundTree(w, d, x, y, z, Blocks.willowlog.blockID, Blocks.willowleaves.blockID, 6);
        }
        if (this.blockID == Blocks.sapling_flower.blockID) {
            tr.flowerTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_flowertwo.blockID) {
            tr.flowerTreeTwo(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_scrub.blockID) {
            tr.scrubTree(w, d, x, y - 1, z, w.rand.nextInt(4));
        }
        if (this.blockID == Blocks.sapling_flowernormal.blockID) {
            tr.flowerTreeNormal(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_umbrella.blockID) {
            tr.umbrellaTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_bulb.blockID) {
            tr.bulbTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_looplowspiral.blockID) {
            tr.looplowspiralTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_loop.blockID) {
            tr.loopTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_generic.blockID) {
            tr.makeGenericTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_tallwillow.blockID) {
            tr.TallWillowTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_vase.blockID) {
            tr.vaseTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_spiral.blockID) {
            tr.spiralTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_loopspiral.blockID) {
            tr.loopspiralTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_bowl.blockID) {
            tr.bowlTree(w, d, x, y - 1, z);
        }
        if (this.blockID == Blocks.sapling_doublebowl.blockID) {
            tr.doublebowlTree(w, d, x, y - 1, z);
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        st = builder.findVBOtextureforblockside(0, bid);
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            int stride;
            int textureoff = stride = 12;
            int coloroff = stride += 8;
            stride += 12;
            this.squareid3D = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)this.squareid3D);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            ByteBuffer vbodata = BufferUtils.createByteBuffer(8 * stride);
            BlockSapling.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            BlockSapling.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            BlockSapling.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            BlockSapling.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            BlockSapling.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            BlockSapling.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            BlockSapling.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            BlockSapling.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            int vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)this.squareid3D);
        GL11.glDrawArrays((int)7, (int)0, (int)8);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
    }

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }
}

