/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.blocks.LightStick;
import dangerzone.blocks.ModelBetterTorch;
import dangerzone.entities.Entity;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.World;
import slick.Texture;

public class BetterTorch
extends LightStick {
    private static ModelBetterTorch mbt = null;
    private String fulltexturestring = null;
    private Texture fulltexture = null;

    public BetterTorch(String n, String flattxt, String txt) {
        super(n, flattxt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.brightness = 0.75f;
        this.maxdamage = 1;
        this.randomtick = true;
        this.burntime = 30;
        this.fulltexturestring = txt;
        if (mbt == null) {
            mbt = new ModelBetterTorch();
        }
    }

    @Override
    public Texture getTexture(int side) {
        if (this.texture == null || this.fulltexture == null) {
            this.texture = this.initBlockTexture(this.texturepath);
            this.fulltexture = this.initBlockTexture(this.fulltexturestring);
        }
        if (side == 5) {
            return this.fulltexture;
        }
        return this.texture;
    }

    @Override
    public String getStitchedTextureName(int side) {
        return this.fulltexturestring;
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = builder.findVBOtextureforblockside(5, bid);
        if (st == null) {
            return;
        }
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        switch (meta >> 8) {
            case 0: {
                BetterTorch.mbt.t1base.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BetterTorch.mbt.t1flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                break;
            }
            case 1: {
                BetterTorch.mbt.t2base1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                BetterTorch.mbt.t2base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                BetterTorch.mbt.t2base3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                BetterTorch.mbt.t2flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                break;
            }
            case 2: {
                BetterTorch.mbt.t2base1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 270);
                BetterTorch.mbt.t2base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 270);
                BetterTorch.mbt.t2base3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 270);
                BetterTorch.mbt.t2flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 270);
                break;
            }
            case 3: {
                BetterTorch.mbt.t2base1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                BetterTorch.mbt.t2base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                BetterTorch.mbt.t2base3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                BetterTorch.mbt.t2flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                break;
            }
            case 4: {
                BetterTorch.mbt.t2base1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BetterTorch.mbt.t2base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BetterTorch.mbt.t2base3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BetterTorch.mbt.t2flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                break;
            }
            case 5: {
                BetterTorch.mbt.t3base.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BetterTorch.mbt.t3base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                BetterTorch.mbt.t3flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
            }
        }
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, int bid, boolean isdisplay) {
        if (e == null) {
            return;
        }
        MatrixStack.pushMatrix();
        if (!DangerZone.isVR) {
            if (isdisplay) {
                MatrixStack.translate(4.0f, -1.0f, -4.0f);
            } else {
                MatrixStack.translate(0.0f, -1.0f, -4.0f);
            }
            MatrixStack.scale(3.0f, 3.0f, 3.0f);
        } else {
            MatrixStack.rotate(90.0f, 1.0f, 0.0f, 0.0f);
        }
        MatrixStack.sendCurrentStack();
        this.renderMe(wr, e.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, bid, 0, 0, false);
        MatrixStack.popMatrix();
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        wr.loadtextureforblockside(5, bid, false);
        MatrixStack.pushMatrix();
        switch (meta >> 8) {
            case 0: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BetterTorch.mbt.t1base.render(1.0f);
                BetterTorch.mbt.t1flame.render(1.0f);
                break;
            }
            case 1: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BetterTorch.mbt.t2base1.render(1.0f);
                BetterTorch.mbt.t2base2.render(1.0f);
                BetterTorch.mbt.t2base3.render(1.0f);
                BetterTorch.mbt.t2flame.render(1.0f);
                break;
            }
            case 2: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(270.0f, 0.0f, 1.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BetterTorch.mbt.t2base1.render(1.0f);
                BetterTorch.mbt.t2base2.render(1.0f);
                BetterTorch.mbt.t2base3.render(1.0f);
                BetterTorch.mbt.t2flame.render(1.0f);
                break;
            }
            case 3: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BetterTorch.mbt.t2base1.render(1.0f);
                BetterTorch.mbt.t2base2.render(1.0f);
                BetterTorch.mbt.t2base3.render(1.0f);
                BetterTorch.mbt.t2flame.render(1.0f);
                break;
            }
            case 4: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BetterTorch.mbt.t2base1.render(1.0f);
                BetterTorch.mbt.t2base2.render(1.0f);
                BetterTorch.mbt.t2base3.render(1.0f);
                BetterTorch.mbt.t2flame.render(1.0f);
                break;
            }
            case 5: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                BetterTorch.mbt.t3base.render(1.0f);
                BetterTorch.mbt.t3base2.render(1.0f);
                BetterTorch.mbt.t3flame.render(1.0f);
            }
        }
        MatrixStack.popMatrix();
    }
}

