/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import slick.Audio;
import slick.AudioLoader;
import slick.ResourceLoader;

public class SoundManager {
    Map<String, Soundinfo> soundmap = new HashMap<String, Soundinfo>();
    public int master_volume = 20;
    public int music_master_volume = 20;
    private Audio currentsong = null;
    private static long lasttime = 0L;

    public SoundManager() {
        lasttime = System.currentTimeMillis();
        lasttime -= 600000L;
    }

    public void playMusic() {
        if (DangerZone.f12_on) {
            return;
        }
        if (DangerZone.showcase) {
            return;
        }
        long curtime = System.currentTimeMillis();
        if ((curtime -= lasttime) > 900000L && this.music_master_volume > 0 && (this.currentsong == null || this.currentsong != null && !this.currentsong.isPlaying())) {
            lasttime = System.currentTimeMillis();
            try {
                String newfile = this.getRandomMusicFile();
                if (newfile == null) {
                    return;
                }
                this.currentsong = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("music/" + newfile));
            }
            catch (IOException e) {
                return;
            }
            catch (Exception e) {
                return;
            }
            float mx = this.music_master_volume;
            this.currentsong.playAsMusic(1.0f, 0.125f, false);
            DangerZone.setMusicVolume(mx /= 400.0f);
        }
    }

    public void stopTheMusic() {
        if (this.currentsong == null) {
            return;
        }
        this.currentsong.stop();
        this.currentsong = null;
    }

    public void playThisMusic(String songname) {
        if (DangerZone.f12_on) {
            return;
        }
        if (DangerZone.showcase) {
            return;
        }
        if (songname == null) {
            return;
        }
        if (this.music_master_volume > 0 && (this.currentsong == null || this.currentsong != null && !this.currentsong.isPlaying())) {
            lasttime = System.currentTimeMillis();
            try {
                this.currentsong = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("music/" + songname));
            }
            catch (IOException e) {
                return;
            }
            catch (Exception e) {
                return;
            }
            float mx = this.music_master_volume;
            this.currentsong.playAsMusic(1.0f, 0.125f, false);
            DangerZone.setMusicVolume(mx /= 400.0f);
        }
    }

    public void setMusicVolume() {
        if (this.currentsong != null && this.currentsong.isPlaying()) {
            float mx = this.music_master_volume;
            DangerZone.setMusicVolume(mx /= 400.0f);
        }
    }

    public void registerSound(String soundname, String filepath) {
        this.soundmap.put(soundname, new Soundinfo(filepath));
    }

    public void playSound(String soundname, float vol, float freq, int d, double px, double py, double pz) {
        Soundinfo s = this.soundmap.get(soundname);
        if (s != null && !s.equals("")) {
            if (s.sound == null) {
                try {
                    s.sound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream(s.filepath));
                }
                catch (Exception e) {
                    System.out.printf("Failed to load sound file: %s\n", s.filepath);
                    e.printStackTrace();
                    s.sound = null;
                    this.soundmap.remove(soundname);
                }
            }
            if (s.sound != null && this.master_volume > 0 && DangerZone.start_client && d == DangerZone.player.dimension) {
                double mx = DangerZone.player.getDistanceFromEntityCenter(px, py, pz);
                if ((mx -= 8.0) < 1.0) {
                    mx = 1.0;
                }
                if (mx < 200.0) {
                    mx /= 4.0;
                    mx = (double)vol / mx;
                    if ((mx *= (double)((float)this.master_volume / 100.0f)) > 0.00125) {
                        if (mx > 2.0) {
                            mx = 2.0;
                        }
                        try {
                            s.sound.playAsSoundEffect(freq, (float)mx, false, (float)px, (float)py, (float)pz);
                        }
                        catch (Exception e) {
                            System.out.printf("Sound broke again...\n", new Object[0]);
                        }
                    }
                }
            }
        }
    }

    public void playSoundClose(String soundname, float vol, float freq, int d, double px, double py, double pz) {
        Soundinfo s = this.soundmap.get(soundname);
        if (s != null && !s.equals("")) {
            double mx;
            if (s.sound == null) {
                try {
                    s.sound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream(s.filepath));
                }
                catch (Exception e) {
                    System.out.printf("Failed to load sound file: %s\n", s.filepath);
                    e.printStackTrace();
                    s.sound = null;
                    this.soundmap.remove(soundname);
                }
            }
            if (s.sound != null && this.master_volume > 0 && DangerZone.start_client && d == DangerZone.player.dimension && (mx = DangerZone.player.getDistanceFromEntityCenter(px, py, pz)) < 8.0) {
                mx -= 4.0;
                if ((mx /= 8.0) < 1.0) {
                    mx = 1.0;
                }
                mx *= mx;
                mx = (double)vol / mx;
                if ((mx *= (double)((float)this.master_volume / 100.0f)) > 0.0125) {
                    if (mx > 2.0) {
                        mx = 2.0;
                    }
                    try {
                        s.sound.playAsSoundEffect(freq, (float)mx, false, (float)px, (float)py, (float)pz);
                    }
                    catch (Exception e) {
                        System.out.printf("Sound broke again...\n", new Object[0]);
                    }
                }
            }
        }
    }

    public String getRandomMusicFile() {
        long curtime = System.currentTimeMillis();
        Random rand = new Random(curtime);
        String curdir = System.getProperty("user.dir");
        File[] files = new File(String.valueOf(curdir) + "/music").listFiles();
        int count = 0;
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().endsWith(".wav")) {
                ++count;
            }
            ++n2;
        }
        if (count <= 0) {
            return null;
        }
        int which = 0;
        if (count > 1) {
            which = rand.nextInt(count);
        }
        count = 0;
        File[] fileArray2 = files;
        int n3 = files.length;
        n = 0;
        while (n < n3) {
            File file = fileArray2[n];
            if (file.isFile() && file.getName().endsWith(".wav")) {
                if (which == count) {
                    return file.getName();
                }
                ++count;
            }
            ++n;
        }
        return null;
    }

    private class Soundinfo {
        public String filepath;
        public Audio sound;

        Soundinfo(String f) {
            this.filepath = f;
            this.sound = null;
        }
    }
}

