/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.AltHandleInventory;
import dangerzone.DangerZone;
import dangerzone.DangerZoneBase;
import dangerzone.Explosion;
import dangerzone.InventoryContainer;
import dangerzone.KVPair;
import dangerzone.ServerHooker;
import dangerzone.ToDoList;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.crafting.Crafting;
import dangerzone.crafting.DeskCrafting;
import dangerzone.crafting.DeskRecipe;
import dangerzone.crafting.Recipe;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityFurnace;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.EntityMagic;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemFood;
import dangerzone.items.ItemInstability;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSword;
import dangerzone.items.Items;
import dangerzone.threads.LightingThread;
import dangerzone.threads.ServerConnection;
import dangerzone.threads.ServerThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.Dimensions;
import dangerzone.world.World;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import slick.ResourceLoader;
import slick.Texture;
import slick.TextureLoader;

public class Player
extends EntityLiving {
    public Socket toServer;
    public Socket toClient;
    public ServerThread server_thread;
    public ServerConnection server_connection;
    public byte[] tdata = null;
    public boolean donewtexture = false;
    public String myname = null;
    public int starthealth = 50;
    public int swimdelay = 0;
    public int lightupdatecounter = 0;
    public int inventoryticker = 0;
    public int player_privs = 0;
    public Entity morph = null;
    public Entity morphto = null;
    public boolean do_morph;
    public float morphspeed = -0.01f;
    public float morphscale = 1.0f;
    public int clienthotbarindex = 0;
    public int home_dimension;
    public double home_x;
    public double home_y;
    public double home_z;
    private List<Integer> spread_list = null;
    private boolean wasOnGround = true;
    public AltHandleInventory alt_inv_handler = null;
    public int lasttrd;
    public double lasttrx;
    public double lasttry;
    public double lasttrz;
    public int kills = 0;
    public int deaths = 0;
    public double damage_taken = 0.0;
    public double damage_dealt = 0.0;
    public int blocks_broken = 0;
    public int blocks_placed = 0;
    public int crafted = 0;
    public int bought = 0;
    public int sold = 0;
    public int broken = 0;
    public int traveled = 0;
    public int morphs = 0;
    public int teleports = 0;
    public int eaten = 0;
    public int roachstomps = 0;
    public int hard_landings = 0;
    public int flights = 0;
    public int blocks_colored = 0;
    public int spells = 0;
    public int lastlevel = 0;

    public Player(World w) {
        super(w);
        this.width = 0.65f;
        this.height = 1.75f;
        this.eyeHeight = 1.65f;
        this.uniquename = "DangerZone:Player";
        this.has_inventory = true;
        this.setMaxHealth(this.starthealth);
        this.setHealth(this.starthealth);
        this.setDefense(1.0f);
        this.setMaxHunger(50.0f);
        this.setHunger(50.0f);
        this.setAttackDamage(1.0f);
        this.setMaxAir(50.0f);
        this.setAir(50.0f);
        this.setCanDespawn(false);
        this.do_morph = false;
    }

    @Override
    public void init() {
        super.init();
        this.eyeHeight = 0.943f * this.getHeight();
        this.setSitting(false);
        this.morph = null;
        this.morphto = null;
        this.do_morph = false;
        this.lasttrd = -1;
        this.lasttrz = 0.0;
        this.lasttry = 0.0;
        this.lasttrx = 0.0;
        this.jumpstrength = 1.0f;
    }

    @Override
    public void doDeathDrops() {
        if (!DangerZone.keep_inventory_on_death) {
            super.doDeathDrops();
        }
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.dimension != this.lasttrd || (double)((int)this.posx) != this.lasttrx || (double)((int)this.posy) != this.lasttry || (double)((int)this.posz) != this.lasttrz) {
            if (this.lasttrd != -1 && this.lasttrd != this.dimension) {
                ++this.teleports;
                this.server_thread.sendStatsToPlayer();
                ToDoList.onDimension(this, this.lasttrd, this.dimension);
            }
            this.lasttrd = this.dimension;
            this.lasttrx = (int)this.posx;
            this.lasttry = (int)this.posy;
            this.lasttrz = (int)this.posz;
            ++this.traveled;
            if ((this.traveled & 0xF) == 0) {
                this.server_thread.sendStatsToPlayer();
            }
        }
        if (this.getExperience() / 1000 != this.lastlevel) {
            this.lastlevel = this.getExperience() / 1000;
            this.setMaxMagic(this.lastlevel);
            ToDoList.onLeveled(this, this.getExperience());
        }
        if (this.getMaxMagic() > 0.0f) {
            float remagic = this.getMaxMagic() - this.getMagic();
            if (remagic > this.getMaxMagic() * 0.005f) {
                remagic = this.getMaxMagic() * 0.005f;
            }
            if (remagic > 0.0f) {
                this.setMagic(this.getMagic() + remagic);
            }
        }
    }

    @Override
    public String getHurtSound() {
        if (this.morph != null) {
            return this.morph.getHurtSound();
        }
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ouch1";
        }
        if (i == 1) {
            return "DangerZone:ouch2";
        }
        return "DangerZone:ouch3";
    }

    @Override
    public float getLivingSoundVolume() {
        return 0.25f;
    }

    @Override
    public String getLivingSound() {
        if (this.morph != null) {
            return this.morph.getLivingSound();
        }
        return null;
    }

    @Override
    public float getScale() {
        if (this.do_morph) {
            return this.morphscale;
        }
        return super.getScale();
    }

    @Override
    public float getRightArmAngle() {
        return -this.armangle;
    }

    @Override
    public void update(float deltaT) {
        if (!this.world.isServer && this == DangerZone.player) {
            this.stray_entity_ticker = 0;
        }
        if (this.morph != null) {
            this.morph.posx = this.posx;
            this.morph.posy = this.posy;
            this.morph.posz = this.posz;
            this.morph.rotation_yaw = this.rotation_yaw;
            this.morph.rotation_pitch = this.rotation_pitch;
            this.morph.rotation_roll = this.rotation_roll;
            this.morph.rotation_yaw_head = this.rotation_yaw_head;
            this.morph.rotation_pitch_head = this.rotation_pitch_head;
            this.morph.rotation_roll_head = this.rotation_roll_head;
            this.morph.display_rotation_yaw = DangerZone.player == this ? -this.display_rotation_yaw + 180.0f : this.display_rotation_yaw;
            this.morph.display_rotation_pitch = this.display_rotation_pitch;
            this.morph.display_rotation_roll = this.display_rotation_roll;
            this.morph.player_morph_update(deltaT, this);
        }
        if (!this.world.isServer) {
            if (this.morph != null) {
                this.morph.setFlying(this.isFlying());
                this.morph.setBaby(this.isBaby());
                this.morph.setAttacking(this.getAttacking());
                this.morph.setOnFire(this.getOnFire());
                this.morph.setSitting(this.getSitting());
            }
        } else {
            if (this.getGameMode() != 2 && this.getGameMode() != 3 && this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.02f, this.posz) && this.isFlying()) {
                this.setFlying(false);
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleBreak", 50, this.dimension, this.posx, this.posy, this.posz, this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)0.2f), (int)this.posz));
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleDust", 50, this.dimension, this.posx, this.posy, this.posz, 0);
                this.world.playSound(this.getHurtSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, 0.25f, 1.0f);
            }
            if (this.morph != null && this.world.rand.nextInt(600) == 1) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
        }
        String morphname = this.getMorphName();
        if (!this.do_morph) {
            Entity ent;
            if (this.morph == null) {
                if (morphname != null && (ent = this.world.createEntityByName(morphname, this.dimension, this.posx, this.posy, this.posz)) != null) {
                    ent.init();
                    this.morphto = ent;
                    this.morphspeed = -0.01f;
                    this.do_morph = true;
                    if (!this.world.isServer) {
                        this.world.playSound("DangerZone:morph1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    }
                }
            } else {
                if (!this.morph.uniquename.equals(morphname)) {
                    if (morphname == null) {
                        this.morphto = this;
                        this.morphspeed = -0.01f;
                        this.do_morph = true;
                        if (!this.world.isServer) {
                            this.world.playSound("DangerZone:morph1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                        }
                        this.setMorphName(null);
                    } else if (morphname.equals(this.uniquename)) {
                        this.morphto = this;
                        this.morphspeed = -0.01f;
                        this.do_morph = true;
                        if (!this.world.isServer) {
                            this.world.playSound("DangerZone:morph1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                        }
                        this.setMorphName(null);
                    } else {
                        ent = this.world.createEntityByName(morphname, this.dimension, this.posx, this.posy, this.posz);
                        if (ent != null) {
                            ent.init();
                            this.morphto = ent;
                            this.morphspeed = -0.01f;
                            this.do_morph = true;
                            if (!this.world.isServer) {
                                this.world.playSound("DangerZone:morph1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                            }
                        }
                    }
                }
                if (this.morph.has_inventory) {
                    this.morph.sethotbarindex(this.gethotbarindex());
                    this.morph.setHotbar(this.gethotbarindex(), this.getHotbar(this.gethotbarindex()));
                }
            }
        }
        if (this.do_morph) {
            this.morphscale += this.morphspeed;
            if (this.morphscale < 0.01f) {
                this.morphscale = 0.01f;
                this.morphspeed = 0.01f;
                this.morph = this.morphto;
                this.model = this.morphto.model;
                if (this.morph == this) {
                    this.morph = null;
                    this.model = DangerZoneBase.modelhumanoid;
                }
                if (!this.world.isServer) {
                    this.world.playSound("DangerZone:morph2", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                }
            }
            if (this.morphscale >= 1.0f) {
                this.morphscale = 1.0f;
                this.morphspeed = -0.01f;
                this.do_morph = false;
                if (this.world.isServer) {
                    ++this.morphs;
                    this.server_thread.sendStatsToPlayer();
                }
            }
            if (!this.world.isServer) {
                Utils.spawnParticles(this.world, "DangerZone:ParticleSparkle", 5, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), true);
                Utils.spawnParticles(this.world, "DangerZone:ParticleSmoke", 5, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), true);
                Utils.spawnParticles(this.world, "DangerZone:ParticleFire", 5, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), true);
            }
        }
        if (!(this.getForward() || this.getBackward() || this.getLeft() || this.getRight() || this.getGameMode() == 2 || this.getGameMode() == 3)) {
            float unsquish = 1.0f - 0.05f * (float)DangerZone.character_feel;
            if (this.world.isServer) {
                this.motionx *= 1.0f - 0.35f * deltaT;
                this.motionz *= 1.0f - 0.35f * deltaT;
                this.motionx *= unsquish;
                this.motionz *= unsquish;
            } else {
                float rate = DangerZone.entityupdaterate;
                this.motionx *= 1.0f - 0.35f * deltaT * (rate /= (float)DangerZone.serverentityupdaterate);
                this.motionz *= 1.0f - 0.35f * deltaT * rate;
                this.motionx *= unsquish;
                this.motionz *= unsquish;
            }
        }
        if (this.getGameMode() == 2 || this.getGameMode() == 3) {
            float unsquish = 1.0f - 0.005f * (float)DangerZone.character_feel;
            this.motionx *= unsquish;
            this.motionz *= unsquish;
            this.motiony *= unsquish;
        }
        this.eyeHeight = this.getSitting() ? 0.586f * this.getJustMyHeight() : 0.943f * this.getJustMyHeight();
        if (!this.world.isServer) {
            InventoryContainer ic = null;
            ++this.lightupdatecounter;
            if (this.lightupdatecounter > 5) {
                float lvl;
                ic = this.getHotbar(this.gethotbarindex());
                if (ic != null) {
                    lvl = 0.0f;
                    if (ic.bid != 0) {
                        lvl = Blocks.getLightLevel(ic.bid, this.world, this.dimension, (int)this.posx, (int)(this.posy + 1.25), (int)this.posz);
                    }
                    if (ic.iid != 0) {
                        lvl = Items.getLightLevel(ic.iid);
                    }
                    if (lvl != 0.0f) {
                        LightingThread.addRequest(this.dimension, (int)this.posx, (int)(this.posy + 1.25), (int)this.posz, lvl);
                    }
                }
                lvl = 0.0f;
                int i = 0;
                while (i < 4) {
                    ic = this.getArmor(i);
                    if (ic != null && ic.iid != 0) {
                        lvl += Items.getLightLevel(ic.iid);
                    }
                    ++i;
                }
                if (lvl != 0.0f) {
                    LightingThread.addRequest(this.dimension, (int)this.posx, (int)(this.posy + 1.25), (int)this.posz, lvl);
                }
                this.lightupdatecounter = 0;
            }
        } else {
            double pz;
            double py;
            double px;
            Entity tempent;
            if (this.morph == null) {
                this.setMaxHealth(this.starthealth + this.getExperience() / 1000);
                this.setDefense(1.0f + (float)this.getExperience() / 10000.0f);
                this.setAttackDamage(1.0f + (float)this.getExperience() / 10000.0f);
            }
            if (this.morph != null && (this.getLeft() || this.getRight()) && (tempent = this.world.createEntityByName("DangerZone:Cockroach", this.dimension, (px = (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)))) * 32.0 + this.posx, (py = (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)))) * 32.0 + this.posy, (pz = (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)))) * 32.0 + this.posz)) != null) {
                this.morph.doDistanceAttack(tempent);
            }
            if (this.getGameMode() == 0) {
                if (this.getHunger() > 0.0f) {
                    float hunger = 0.0011f;
                    int diffi = this.getGameDifficulty();
                    if (diffi == -1) {
                        hunger = 5.0E-4f;
                    }
                    if (diffi == -2) {
                        hunger = 1.0E-4f;
                    }
                    if (diffi == 1) {
                        hunger = 0.003f;
                    }
                    if (diffi == 2) {
                        hunger = 0.006f;
                    }
                    this.setHunger(this.getHunger() - hunger);
                }
                if (this.getHealth() >= 0.0f && this.getHealth() < this.getMaxHealth() && this.getHunger() > this.getMaxHunger() / 2.0f) {
                    float regen = 6.0E-4f;
                    int diffi = this.getGameDifficulty();
                    if (diffi == -1) {
                        regen = 0.001f;
                    }
                    if (diffi == -2) {
                        regen = 0.003f;
                    }
                    if (diffi == 1) {
                        regen = 4.0E-4f;
                    }
                    if (diffi == 2) {
                        regen = 2.0E-4f;
                    }
                    this.setHealth(this.getHealth() + this.getMaxHealth() * regen);
                }
                if (this.getHunger() <= 0.0f && this.world.rand.nextInt(50) == 1) {
                    this.doAttackFrom(null, 11, 0.1f);
                }
            } else if (this.getHealth() >= 0.0f && this.getHealth() < this.getMaxHealth() && this.getHunger() > this.getMaxHunger() / 2.0f) {
                float regen = 6.0E-4f;
                int diffi = this.getGameDifficulty();
                if (diffi == -1) {
                    regen = 0.001f;
                }
                if (diffi == -2) {
                    regen = 0.003f;
                }
                if (diffi == 1) {
                    regen = 4.0E-4f;
                }
                if (diffi == 2) {
                    regen = 2.0E-4f;
                }
                this.setHealth(this.getHealth() + this.getMaxHealth() * regen);
            }
        }
        super.update(deltaT);
        if (this.world.isServer) {
            if (this.getOnGround()) {
                if (!this.wasOnGround) {
                    int bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)0.2f), (int)this.posz);
                    Blocks.doblocktick(this.world, this.dimension, (int)this.posx, (int)(this.posy - (double)0.2f), (int)this.posz, bid);
                    Entity roach = this.steppedOnCockroach();
                    if (roach != null) {
                        if (roach.getBID() != 0) {
                            int i = 0;
                            while (i < 256) {
                                int id = (this.dimension + i + 1) % 256;
                                if (Dimensions.DimensionArray[id] != null && !Dimensions.DimensionArray[id].special_hidden) {
                                    this.world.playSound("DangerZone:big_splat", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
                                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHurt", 20, this.dimension, this.posx, this.posy, this.posz);
                                    Utils.doTeleport(this, id, (int)this.posx, (int)this.posy, (int)this.posz);
                                    this.world.playSound("DangerZone:big_splat", id, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
                                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHurt", 20, id, this.posx, this.posy, this.posz);
                                    break;
                                }
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < 256) {
                                int id = (this.dimension - i - 1) % 256;
                                while (id < 0) {
                                    id += 256;
                                }
                                if (Dimensions.DimensionArray[id] != null && !Dimensions.DimensionArray[id].special_hidden) {
                                    this.world.playSound("DangerZone:big_splat", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
                                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHurt", 20, this.dimension, this.posx, this.posy, this.posz);
                                    Utils.doTeleport(this, id, (int)this.posx, (int)this.posy, (int)this.posz);
                                    this.world.playSound("DangerZone:big_splat", id, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
                                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHurt", 20, id, this.posx, this.posy, this.posz);
                                    break;
                                }
                                ++i;
                            }
                        }
                        ++this.roachstomps;
                        this.server_thread.sendStatsToPlayer();
                    } else {
                        this.world.playSound(Blocks.getStepSound(bid), this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.2f);
                    }
                }
                this.wasOnGround = true;
            } else {
                this.wasOnGround = false;
            }
        } else {
            int bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)0.2f), (int)this.posz);
            if (bid != 0) {
                if (!this.wasOnGround && this.motiony < -0.4f) {
                    this.world.playSound("DangerZone:small_thud", this.dimension, this.posx, this.posy, this.posz, 0.1f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.1f);
                    DangerZone.ground_pulse();
                }
                this.wasOnGround = true;
            } else {
                this.wasOnGround = false;
            }
        }
    }

    public void tryfly() {
        Entity ent;
        if (this.morph != null && this.morph.canFly && !this.isFlying()) {
            this.setFlying(true);
            this.posy += (double)0.05f;
            this.motiony += 0.25f;
        }
        if ((ent = this.getRiddenEntity()) != null && ent.canFly && !this.isFlying()) {
            ent.setFlying(true);
            this.setFlying(true);
            this.posy += (double)0.05f;
            this.motiony += 0.25f;
        }
    }

    @Override
    public boolean jump() {
        return this.jump(this.jumpstrength);
    }

    @Override
    public boolean jump(float js) {
        if (this.getInLiquid() && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 1.5), (int)this.posz))) {
            ++this.swimdelay;
            if (this.swimdelay > 40) {
                this.swimdelay = 0;
            }
            if (this.swimdelay > 15) {
                this.motiony += 0.035f;
                if (this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.35f, this.posz)) {
                    this.motiony += 0.55f;
                }
            }
        }
        if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.05f, this.posz)) {
            return false;
        }
        if (Math.abs(this.motiony) > 0.08f) {
            return false;
        }
        float jumpfactor = 0.8f + this.getHeight() / 8.0f;
        float jumpadjust = this.getTotalEffect(3);
        if (jumpadjust != 0.0f) {
            jumpfactor += jumpfactor * jumpadjust / 4.0f;
        }
        if ((jumpadjust = this.getTotalEffect(4)) != 0.0f) {
            jumpfactor /= 1.0f + jumpadjust;
        }
        this.motiony = this.isBaby() ? (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 1, (int)this.posz) != 0 ? (this.motiony += 0.75f * js) : (this.motiony += jumpfactor * 0.95f * js)) : (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 2, (int)this.posz) != 0 || this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 3, (int)this.posz) != 0 ? (this.motiony += 0.75f * js) : (this.motiony += jumpfactor * 0.95f * js));
        if (this.world.isServer) {
            this.server_thread.sendPositionAndVelocityUpdateToPlayer(this);
        }
        return true;
    }

    public void incCurrentUses(InventoryContainer ic) {
        if (ic == null) {
            return;
        }
        if (Items.getMaxStack(ic.iid) == 1) {
            int foo = ic.getAttribute(3);
            int damageodds = 1 + foo * 2;
            if (damageodds <= 1) {
                ++ic.currentuses;
            } else if (this.world.rand.nextInt(damageodds) == 1) {
                ++ic.currentuses;
            }
            this.setHotbarChanged(this.gethotbarindex());
            if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                if (this.world.rand.nextInt(2) == 1) {
                    this.world.playSound("DangerZone:toolbreak1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
                } else {
                    this.world.playSound("DangerZone:toolbreak2", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
                }
                this.setHotbar(this.gethotbarindex(), null);
                ++this.broken;
                this.server_thread.sendStatsToPlayer();
            }
        }
    }

    public void leftclick(World world, int focus_x, int focus_y, int focus_z, int focus_side, int eid, float mp, int mt, double px, double py, double pz) {
        Entity e = null;
        if (this.getGameMode() == 3) {
            return;
        }
        if (world.isServer) {
            this.armdir = 1;
            this.setAttacking(true);
            InventoryContainer ic = this.getHotbar(this.gethotbarindex());
            e = DangerZone.server.entityManager.findEntityByID(eid);
            if (e instanceof EntityBlockItem) {
                Item it;
                EntityBlockItem ebi = (EntityBlockItem)e;
                ebi.deadflag = true;
                Utils.spawnParticlesFromServerScaled(world, "DangerZone:ParticleHurt", 25, this.dimension, e.posx, e.posy + 0.125, e.posz, 0, 0.5f);
                if (ebi.getItemID() != 0) {
                    Utils.spawnParticlesFromServerScaled(world, "DangerZone:ParticleItem", 25, this.dimension, e.posx, e.posy + 0.125, e.posz, ebi.getItemID(), 0.5f);
                }
                if (ebi.getBlockID() != 0) {
                    Utils.spawnParticlesFromServerScaled(world, "DangerZone:ParticleBreak", 25, this.dimension, e.posx, e.posy + 0.125, e.posz, ebi.getBlockID(), 0.5f);
                }
                if ((it = Items.getItem(ebi.getItemID())) != null && it instanceof ItemInstability) {
                    ItemInstability iti = (ItemInstability)it;
                    Explosion.boom(this, world, this.dimension, e.posx, e.posy, e.posz, (int)iti.mypower, true);
                }
                return;
            }
            boolean leftcontinue = true;
            if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    leftcontinue = it.onLeftClick(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    leftcontinue = bl.onLeftClick(this, e, ic);
                }
            }
            if (leftcontinue) {
                if (e != null) {
                    int dt = 0;
                    float damage = this.getAttackDamage();
                    if (ic != null) {
                        if (ic.bid != 0) {
                            dt = 3;
                        } else {
                            if (ic.iid > 0 && ic.iid < 2048) {
                                damage += (float)Items.getAttackStrength(ic.iid);
                                Item it = ic.getItem();
                                if (it != null) {
                                    if (it instanceof ItemSword) {
                                        dt = 1;
                                    }
                                    if (it instanceof ItemPickAxe) {
                                        dt = 2;
                                    }
                                    if (it instanceof ItemAxe) {
                                        dt = 2;
                                    }
                                    if (it instanceof ItemShovel) {
                                        dt = 2;
                                    }
                                }
                            }
                            float damageadjust = (float)ic.getAttribute(2) * 0.5f + 1.0f;
                            damage *= damageadjust;
                        }
                    }
                    if (e.leftClickedByPlayer(this, ic)) {
                        if (e instanceof EntityLiving && ic != null) {
                            EntityLiving el = (EntityLiving)e;
                            int foo = ic.getAttribute(5);
                            el.damage_backoff -= foo;
                        }
                        e.doAttackFrom(this, dt, damage);
                    }
                    if (this.getHunger() > 0.0f && this.getGameMode() == 0) {
                        this.setHunger(this.getHunger() - 0.025f);
                    }
                    if (this.getGameMode() == 0) {
                        this.incCurrentUses(ic);
                    }
                } else if (focus_x > 0 && focus_y > 0 && focus_z > 0) {
                    int bid;
                    if (this.getHunger() > 0.0f && this.getGameMode() == 0) {
                        this.setHunger(this.getHunger() - 0.025f);
                    }
                    if ((bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) > 0) {
                        Blocks.leftClickOnBlock(bid, this, this.dimension, focus_x, focus_y, focus_z, focus_side);
                        if (this.getGameMode() == 0) {
                            this.incCurrentUses(ic);
                        }
                    }
                } else if (ic == null && mp > 0.0f && mt > 0 && mt != 0) {
                    this.make_magic(mp, mt);
                    ToDoList.onSpellCast(this, mt, mp);
                }
            }
        } else {
            e = DangerZone.clientEntityManager.findEntityByID(eid);
            if (e == null) {
                this.server_connection.playerActionToServer(0, 0, 0, focus_x, focus_y, focus_z, focus_side, mp, mt);
            } else {
                this.server_connection.playerActionToServer(0, 0, e.entityID, focus_x, focus_y, focus_z, focus_side, mp, mt);
            }
            InventoryContainer ic = this.getHotbar(this.gethotbarindex());
            boolean leftcontinue = true;
            if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    leftcontinue = it.onLeftClick(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    leftcontinue = bl.onLeftClick(this, e, ic);
                }
            }
            if (leftcontinue) {
                if (e == null) {
                    int bid;
                    if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) > 0 && (Blocks.leftClickOnBlock(bid, this, this.dimension, focus_x, focus_y, focus_z, focus_side) || this.getGameMode() != 0)) {
                        int md;
                        Item it;
                        float dmg = this.getAttackDamage();
                        if (ic != null && ic.iid != 0) {
                            if (Blocks.isWood(bid) || Blocks.isLeaves(bid)) {
                                dmg += (float)Items.getWoodStrength(ic.iid);
                                dmg /= 2.0f;
                            }
                            if (Blocks.isStone(bid)) {
                                dmg += (float)Items.getStoneStrength(ic.iid);
                            }
                            if (Blocks.isDirt(bid)) {
                                dmg += (float)Items.getDirtStrength(ic.iid);
                                dmg /= 2.0f;
                            }
                            if (ic.getItem() instanceof ItemSword && !Blocks.isLeaves(bid)) {
                                dmg = 0.0f;
                            }
                            if (ic.getItem() instanceof ItemSword && Blocks.isLeaves(bid)) {
                                dmg += (float)Items.getAttackStrength(ic.iid);
                            }
                            ic.getItem().leftClickOnBlock(this, this.dimension, focus_x, focus_y, focus_z, focus_side);
                        } else {
                            dmg /= 2.0f;
                            if (Blocks.isStone(bid)) {
                                dmg /= 5.0f;
                            }
                            if (Blocks.isDirt(bid)) {
                                dmg /= 2.0f;
                            }
                        }
                        if (dmg != 0.0f) {
                            float damageadjust = this.getTotalEffect(3);
                            if (damageadjust != 0.0f) {
                                dmg *= damageadjust;
                            }
                            if ((damageadjust = this.getTotalEffect(4)) != 0.0f) {
                                dmg /= damageadjust;
                            }
                            if (ic != null) {
                                damageadjust = (float)ic.getAttribute(2) * 0.5f + 1.0f;
                                dmg *= damageadjust;
                            }
                        }
                        if (DangerZone.isVR) {
                            dmg *= 1.5f;
                        }
                        boolean parts = false;
                        if (ic != null && (it = ic.getItem()) != null) {
                            parts = true;
                            it.onLeftClick(this, null, ic, this.dimension, px, py, pz, focus_x, focus_y, focus_z, bid);
                        }
                        if (!parts) {
                            String particlename = Blocks.getParticleName(bid);
                            if (particlename == null || particlename.equals("")) {
                                particlename = "DangerZone:ParticleBreak";
                            }
                            Utils.spawnParticles(this.world, particlename, 30, this.dimension, (double)focus_x + 0.5, (double)focus_y + 0.5, (double)focus_z + 0.5, bid, true);
                            Utils.spawnParticlesScaled(world, "DangerZone:ParticleBreak", 25, this.dimension, px, py, pz, 0, 0.25f, true);
                        }
                        if (dmg >= (float)(md = Blocks.getMinDamage(bid))) {
                            if (!DangerZone.isVR) {
                                DangerZone.wr.focus_finder.focus_damage += dmg;
                                DangerZone.wr.show_focus_damage += dmg;
                            } else {
                                DangerZone.wr.show_focus_damage += dmg;
                                DangerZone.vrhit.focus_damage += dmg;
                            }
                        }
                        if (dmg != 0.0f && (DangerZone.wr.show_focus_damage >= DangerZone.wr.show_focus_maxdamage || this.getGameMode() != 0)) {
                            world.playSound(Blocks.getBreakSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.15f, 1.0f);
                            this.server_connection.sendBreakBlock(this.dimension, focus_x, focus_y, focus_z, focus_side);
                            if (DangerZone.isVR) {
                                DangerZone.wr.focus_finder.focus_bid = 0;
                                DangerZone.wr.focus_finder.focus_damage = 0;
                                DangerZone.wr.show_focus_bid = 0;
                                DangerZone.wr.show_focus_damage = 0;
                                DangerZone.vrhit.focus_bid = 0;
                                DangerZone.vrhit.focus_damage = 0;
                                DangerZone.wr.focus_finder.focus_z = 0;
                                DangerZone.wr.focus_finder.focus_x = 0;
                                DangerZone.vrhit.focus_z = 0;
                                DangerZone.vrhit.focus_x = 0;
                                DangerZone.wr.show_focus_z = 0;
                                DangerZone.wr.show_focus_x = 0;
                            }
                        } else {
                            world.playSound(Blocks.getHitSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.15f, 1.0f);
                        }
                    }
                } else {
                    Item it;
                    boolean parts = false;
                    if (ic != null && (it = ic.getItem()) != null) {
                        parts = true;
                        it.onLeftClick(this, e, ic, this.dimension, px, py, pz, focus_x, focus_y, focus_z, 0);
                    }
                    if (!parts) {
                        Utils.spawnParticlesScaled(world, "DangerZone:ParticleHurt", 50, this.dimension, px, py, pz, 0, 0.25f * (e.getWidth() + e.getHeight()) / 4.0f, true);
                    }
                }
            }
        }
    }

    public void middleclick(World world, int focus_x, int focus_y, int focus_z, int eid) {
        int bid;
        if (this.getGameMode() == 3) {
            return;
        }
        if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) != 0) {
            world.playSound(Blocks.getHitSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.15f, 1.0f);
            DangerZone.messagetimer = 100;
            DangerZone.messagestring = Blocks.BlockArray[bid].uniquename;
        }
    }

    public void swingstop(World world, int focusx, int focusy, int focusz, int side, int eid, double px, double py, double pz) {
        Entity e = null;
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        boolean delme = false;
        if (this.getGameMode() == 3) {
            return;
        }
        if (!DangerZone.isVR) {
            return;
        }
        if (world.isServer) {
            if (eid != 0) {
                e = DangerZone.server.entityManager.findEntityByID(eid);
            }
            if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    delme = it.onSwingStop(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    delme = bl.onSwingStop(this, e, ic);
                }
                if (this.getGameMode() == 0 && delme) {
                    if (Items.getMaxStack(ic.iid) == 1) {
                        this.incCurrentUses(ic);
                    } else {
                        --ic.count;
                        if (ic.count <= 0) {
                            ic = null;
                        }
                        this.setHotbar(this.gethotbarindex(), ic);
                    }
                }
            }
        } else {
            e = DangerZone.clientEntityManager.findEntityByID(eid);
            if (e != null) {
                this.server_connection.playerActionToServer(0, 7, e.entityID, focusx, focusy, focusz, side, 0.0f, 0);
            } else {
                this.server_connection.playerActionToServer(0, 7, 0, focusx, focusy, focusz, side, 0.0f, 0);
            }
            if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    it.onSwingStop(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    bl.onSwingStop(this, e, ic);
                }
            }
        }
    }

    public void rightclick(World world, int focusx, int focusy, int focusz, int side, int eid, double px, double py, double pz) {
        Entity e = null;
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        boolean delme = false;
        if (this.getGameMode() == 3) {
            return;
        }
        if (world.isServer) {
            Item it;
            boolean hold_still = false;
            if (ic != null && this.getRightButtonDownCount() != 0 && (it = ic.getItem()) != null && it.hold_straight) {
                hold_still = true;
                this.armdir = 0;
                this.armangle = 0.0f;
                this.setAttacking(false);
            }
            if (!hold_still) {
                this.armdir = 1;
                this.setAttacking(true);
            }
            if ((e = DangerZone.server.entityManager.findEntityByID(eid)) != null) {
                if (e.rightClickedByPlayer(this, ic) && this.getGameMode() == 0) {
                    if (ic != null) {
                        --ic.count;
                        if (ic.count <= 0) {
                            ic = null;
                        }
                    }
                    this.setHotbar(this.gethotbarindex(), ic);
                } else if (ic != null) {
                    Block bl;
                    it = ic.getItem();
                    if (it != null) {
                        delme = it.onRightClick(this, e, ic);
                    }
                    if ((bl = ic.getBlock()) != null) {
                        delme = bl.onRightClick(this, e, ic);
                    }
                    if (this.getGameMode() == 0 && delme) {
                        if (Items.getMaxStack(ic.iid) == 1) {
                            this.incCurrentUses(ic);
                        } else {
                            --ic.count;
                            if (ic.count <= 0) {
                                ic = null;
                            }
                            this.setHotbar(this.gethotbarindex(), ic);
                        }
                    }
                }
            } else {
                int bid = 0;
                int iid = 0;
                if (ic != null && ic.count >= 1) {
                    bid = ic.bid;
                    iid = ic.iid;
                }
                if (focusx > 0 && focusy >= 0 && focusz > 0) {
                    int fbid;
                    boolean cont;
                    if (this.getHunger() > 0.0f && this.getGameMode() == 0) {
                        this.setHunger(this.getHunger() - 0.025f);
                    }
                    if ((cont = Blocks.rightClickOnBlock(fbid = world.getblock(this.dimension, focusx, focusy, focusz), this, this.dimension, focusx, focusy, focusz, side)) && bid != 0 && Blocks.doPlaceBlock(bid, fbid, this, world, this.dimension, focusx, focusy, focusz, side)) {
                        int newx = focusx;
                        int newy = focusy;
                        int newz = focusz;
                        switch (side) {
                            case 0: {
                                ++newy;
                                break;
                            }
                            case 1: {
                                ++newz;
                                break;
                            }
                            case 2: {
                                --newz;
                                break;
                            }
                            case 3: {
                                --newx;
                                break;
                            }
                            case 4: {
                                ++newx;
                                break;
                            }
                            case 5: {
                                --newy;
                            }
                        }
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleBreak", 30, this.dimension, (float)newx + 0.5f, (float)newy + 0.5f, (float)newz + 0.5f, bid);
                        if (this.getGameMode() == 0 && ic != null) {
                            --ic.count;
                            this.setHotbarChanged(this.gethotbarindex());
                            if (ic.count <= 0) {
                                this.setHotbar(this.gethotbarindex(), null);
                            }
                        }
                    }
                    if (ic != null && iid != 0) {
                        delme = Items.rightClickOnBlock(iid, this, this.dimension, focusx, focusy, focusz, side);
                        if (delme) {
                            ToDoList.itemRightClickedBlock(this, ic, this.dimension, focusx, focusy, focusz);
                        }
                        world.playSound(Blocks.getHitSound(fbid), this.dimension, focusx, focusy, focusz, 0.15f, 1.0f);
                        if (this.getGameMode() == 0 && delme) {
                            if (Items.getMaxStack(ic.iid) == 1) {
                                this.incCurrentUses(ic);
                            } else {
                                --ic.count;
                                if (ic.count <= 0) {
                                    this.setHotbar(this.gethotbarindex(), null);
                                }
                                this.setHotbarChanged(this.gethotbarindex());
                            }
                        }
                    }
                } else {
                    if (ic != null) {
                        Block bl;
                        Item it2;
                        if (ic.count >= 1) {
                            bid = ic.bid;
                            iid = ic.iid;
                        }
                        if ((it2 = ic.getItem()) != null) {
                            delme = it2.onRightClick(this, null, ic);
                        }
                        if ((bl = ic.getBlock()) != null) {
                            delme = bl.onRightClick(this, null, ic);
                        }
                    }
                    if (delme && ic != null && iid != 0 && this.getGameMode() == 0) {
                        if (Items.getMaxStack(ic.iid) == 1) {
                            this.incCurrentUses(ic);
                        } else {
                            --ic.count;
                            if (ic.count <= 0) {
                                this.setHotbar(this.gethotbarindex(), null);
                            }
                            this.setHotbarChanged(this.gethotbarindex());
                        }
                    }
                }
            }
        } else {
            e = DangerZone.clientEntityManager.findEntityByID(eid);
            if (e != null) {
                this.server_connection.playerActionToServer(0, 1, e.entityID, focusx, focusy, focusz, side, 0.0f, 0);
                e.rightClickedByPlayer(this, ic);
            } else {
                this.server_connection.playerActionToServer(0, 1, 0, focusx, focusy, focusz, side, 0.0f, 0);
                if (focusx > 0 && focusy >= 0 && focusz > 0) {
                    int fbid = world.getblock(this.dimension, focusx, focusy, focusz);
                    Blocks.rightClickOnBlock(fbid, this, this.dimension, focusx, focusy, focusz, side);
                    Utils.spawnParticlesScaled(world, "DangerZone:ParticleBreak", 25, this.dimension, px, py, pz, 0, 0.25f, true);
                    if (ic != null && ic.iid != 0) {
                        Items.rightClickOnBlock(ic.iid, this, this.dimension, focusx, focusy, focusz, side);
                    }
                } else if (ic != null) {
                    Block bl;
                    Item it = ic.getItem();
                    if (it != null) {
                        it.onRightClick(this, null, ic);
                    }
                    if ((bl = ic.getBlock()) != null) {
                        bl.onRightClick(this, null, ic);
                    }
                }
            }
        }
    }

    public void rightclickup(World world, int focusx, int focusy, int focusz, int side, int eid, int holdcount) {
        Item itm;
        if (this.getGameMode() == 3) {
            return;
        }
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        if (ic != null && (itm = ic.getItem()) != null) {
            if (!world.isServer) {
                this.server_connection.playerActionToServer(0, 3, holdcount, focusx, focusy, focusz, side, 0.0f, 0);
                itm.rightclickup(this, ic, holdcount);
            } else {
                boolean doit = itm.rightclickup(this, ic, holdcount);
                if (doit && this.getGameMode() == 0) {
                    this.incCurrentUses(ic);
                }
            }
        }
    }

    public void singleshot(World world, int focusx, int focusy, int focusz, int side, int eid, int holdcount) {
        Item itm;
        if (this.getGameMode() == 3) {
            return;
        }
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        if (ic != null && (itm = ic.getItem()) != null) {
            if (!world.isServer) {
                this.server_connection.playerActionToServer(0, 4, holdcount, focusx, focusy, focusz, side, 0.0f, eid);
                itm.singleshot(this, ic, holdcount);
            } else {
                boolean doit = itm.singleshot(this, ic, holdcount);
                if (doit && this.getGameMode() == 0) {
                    this.incCurrentUses(ic);
                }
            }
        }
    }

    public void semiauto(World world, int focusx, int focusy, int focusz, int side, int eid, int holdcount) {
        Item itm;
        if (this.getGameMode() == 3) {
            return;
        }
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        if (ic != null && (itm = ic.getItem()) != null) {
            if (!world.isServer) {
                this.server_connection.playerActionToServer(0, 5, holdcount, focusx, focusy, focusz, side, 0.0f, eid);
                itm.semiauto(this, ic, holdcount);
            } else {
                boolean doit = itm.semiauto(this, ic, holdcount);
                if (doit && this.getGameMode() == 0) {
                    this.incCurrentUses(ic);
                }
            }
        }
    }

    public void fullauto(World world, int focusx, int focusy, int focusz, int side, int eid, int holdcount) {
        Item itm;
        if (this.getGameMode() == 3) {
            return;
        }
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        if (ic != null && (itm = ic.getItem()) != null) {
            if (!world.isServer) {
                this.server_connection.playerActionToServer(0, 6, holdcount, focusx, focusy, focusz, side, 0.0f, eid);
                itm.fullauto(this, ic, holdcount);
            } else {
                boolean doit = itm.fullauto(this, ic, holdcount);
                if (doit && this.getGameMode() == 0) {
                    this.incCurrentUses(ic);
                }
            }
        }
    }

    public boolean putMeInASlot(InventoryContainer inic) {
        InventoryContainer ic;
        int bid = inic.bid;
        int iid = inic.iid;
        if (this.getGameMode() == 3) {
            return false;
        }
        if (inic.count == 0 || inic.iid == 0 && inic.bid == 0) {
            return true;
        }
        int i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic != null && ic.bid == bid && ic.iid == iid) {
                if (ic.bid != 0 && ic.count < Blocks.getMaxStack(bid)) {
                    ++ic.count;
                    ToDoList.onPickedUp(this, ic);
                    this.setHotbarChanged(i);
                    return true;
                }
                if (ic.iid != 0 && ic.count < Items.getMaxStack(iid)) {
                    ++ic.count;
                    ToDoList.onPickedUp(this, ic);
                    this.setHotbarChanged(i);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic != null && ic.bid == bid && ic.iid == iid) {
                if (ic.bid != 0 && ic.count < Blocks.getMaxStack(bid)) {
                    ++ic.count;
                    ToDoList.onPickedUp(this, ic);
                    this.setInventoryChanged(i);
                    return true;
                }
                if (ic.iid != 0 && ic.count < Items.getMaxStack(iid)) {
                    ++ic.count;
                    ToDoList.onPickedUp(this, ic);
                    this.setInventoryChanged(i);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            if (this.getHotbar(i) == null) {
                this.setHotbar(i, inic);
                ToDoList.onPickedUp(this, inic);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            if (this.getInventory(i) == null) {
                ToDoList.onPickedUp(this, inic);
                this.setInventory(i, inic);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void doEatHeldItem() {
        Item it;
        int hbi = this.gethotbarindex();
        InventoryContainer ic = this.getHotbar(hbi);
        if (ic != null && Items.isFood(ic.iid) && (this.getHunger() < this.getMaxHunger() || Items.eatAnyTime(ic.iid)) && (it = ic.getItem()) != null && it instanceof ItemFood) {
            it.onFoodEaten(this);
            ++this.eaten;
            ToDoList.onEaten(this, ic);
            this.server_thread.sendStatsToPlayer();
            if (this.getGameMode() == 0) {
                --ic.count;
                if (ic.count <= 0) {
                    ic = null;
                }
                this.setHotbar(hbi, ic);
            }
        }
    }

    private Entity steppedOnCockroach() {
        List<Entity> nearby_list = null;
        if (!this.world.isServer) {
            return null;
        }
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(4.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                double dist;
                e = li.next();
                if (!(e instanceof Cockroach) || !((dist = this.getDistanceFromEntity(e)) < 0.75)) continue;
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHurt", 15, this.dimension, e.posx, e.posy, e.posz);
                return e;
            }
        }
        return null;
    }

    @Override
    public Texture getTexture() {
        if (this.morph != null) {
            return this.morph.getTexture();
        }
        if (this.donewtexture) {
            File file = null;
            try {
                file = File.createTempFile("TmpSkin", ".tmp");
                file.deleteOnExit();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int width = 64;
            int height = 32;
            String format = "PNG";
            BufferedImage image = new BufferedImage(width, height, 2);
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int i = (x + width * y) * 4;
                    int r = this.tdata[i] & 0xFF;
                    int g = this.tdata[i + 1] & 0xFF;
                    int b = this.tdata[i + 2] & 0xFF;
                    int a = this.tdata[i + 3] & 0xFF;
                    image.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                    ++y;
                }
                ++x;
            }
            try {
                ImageIO.write((RenderedImage)image, format, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            image.flush();
            if (this.texture != null) {
                this.texture.release();
                this.texture = null;
            }
            try {
                this.texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(file.getPath()));
                this.tdata = this.texture.getTextureData();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.texture = null;
            }
            this.donewtexture = false;
        }
        if (this.texture == null) {
            try {
                this.texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("Player.png"));
                this.tdata = this.texture.getTextureData();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.texture = null;
            }
        }
        return this.texture;
    }

    @Override
    public float getWidth() {
        float mwid = 0.0f;
        float rwid = 0.0f;
        float retwid = 0.0f;
        Entity ent = this.getRiddenEntity();
        if (ent != null) {
            rwid = ent.getWidth();
        }
        if (this.morph != null) {
            mwid = this.morph.getWidth();
        }
        if ((retwid = super.getWidth()) < mwid) {
            retwid = mwid;
        }
        if (retwid < rwid) {
            retwid = rwid;
        }
        return retwid;
    }

    @Override
    public float getEyeHeight() {
        float adjusted = 0.0f;
        Entity ent = this.getRiddenEntity();
        if (ent != null) {
            adjusted = ent.getRiderYoffset();
        }
        if (this.morph != null) {
            return adjusted + this.morph.getEyeHeight();
        }
        return adjusted + super.getEyeHeight();
    }

    @Override
    public float getHeight() {
        float adjusted = 0.0f;
        Entity ent = this.getRiddenEntity();
        if (ent != null) {
            adjusted = ent.getRiderYoffset();
        }
        if (this.morph != null) {
            return adjusted + this.morph.getHeight();
        }
        return adjusted + super.getHeight();
    }

    @Override
    public float getJustMyHeight() {
        if (this.morph != null) {
            return this.morph.getHeight();
        }
        if (this.isBaby()) {
            return this.height / 4.0f;
        }
        return this.height;
    }

    @Override
    public float getNameHeight() {
        float adjusted = 0.0f;
        Entity ent = this.getRiddenEntity();
        if (ent != null) {
            adjusted = ent.getRiderYoffset();
        }
        if (this.morph != null) {
            return adjusted + this.morph.getNameHeight();
        }
        return adjusted + this.height;
    }

    @Override
    public void onKill(Entity victim) {
        if (victim == null) {
            return;
        }
        if (!(victim instanceof EntityLiving)) {
            return;
        }
        float ef = this.getTotalEffect(8);
        if (ef != 0.0f) {
            this.setMorphName(victim.uniquename);
        }
    }

    @Override
    public float getAttackDamage() {
        if (this.morph != null) {
            return this.morph.getAttackDamage();
        }
        return super.getAttackDamage();
    }

    @Override
    public float getDefense() {
        float df = 0.0f;
        if (this.morph != null) {
            df = this.morph.getDefense();
        }
        return df + super.getDefense();
    }

    @Override
    public float getAdjustedFallDamage(float ouch) {
        if (this.morph != null) {
            return this.morph.getAdjustedFallDamage(ouch);
        }
        return ouch;
    }

    @Override
    public void setOnFire(int fire) {
        if (this.morph != null && this.morph.isImmuneToFire) {
            this.morph.setOnFire(0);
            super.setOnFire(0);
            return;
        }
        if (this.morph != null) {
            this.morph.setOnFire(fire);
        }
        super.setOnFire(fire);
    }

    @Override
    public void setAttacking(boolean tf) {
        if (this.morph != null) {
            this.morph.setAttacking(tf);
        }
        super.setAttacking(tf);
    }

    @Override
    public boolean takesDamageFrom(int dt) {
        if (this.morph != null && !this.morph.takesDamageFrom(dt)) {
            return false;
        }
        return super.takesDamageFrom(dt);
    }

    @Override
    public void setFlying(boolean tf) {
        Entity ent;
        if (this.morph != null) {
            this.morph.setFlying(tf);
        }
        if ((ent = this.getRiddenEntity()) != null) {
            ent.setFlying(tf);
        }
        super.setFlying(tf);
    }

    @Override
    public void writeSelf(List<KVPair> prop, String tag) {
        super.writeSelf(prop, tag);
        prop.add(new KVPair(String.format("%s%s", tag, "HomeDimension"), String.format("%d", this.home_dimension)));
        prop.add(new KVPair(String.format("%s%s", tag, "HomePosx"), String.format("%f", this.home_x)));
        prop.add(new KVPair(String.format("%s%s", tag, "HomePosy"), String.format("%f", this.home_y)));
        prop.add(new KVPair(String.format("%s%s", tag, "HomePosz"), String.format("%f", this.home_z)));
        prop.add(new KVPair(String.format("%s%s", tag, "Kills"), String.format("%d", this.kills)));
        prop.add(new KVPair(String.format("%s%s", tag, "Deaths"), String.format("%d", this.deaths)));
        prop.add(new KVPair(String.format("%s%s", tag, "Damage_taken"), String.format("%f", this.damage_taken)));
        prop.add(new KVPair(String.format("%s%s", tag, "Damage_dealt"), String.format("%f", this.damage_dealt)));
        prop.add(new KVPair(String.format("%s%s", tag, "Blocks_broken"), String.format("%d", this.blocks_broken)));
        prop.add(new KVPair(String.format("%s%s", tag, "Blocks_placed"), String.format("%d", this.blocks_placed)));
        prop.add(new KVPair(String.format("%s%s", tag, "Blocks_colored"), String.format("%d", this.blocks_colored)));
        prop.add(new KVPair(String.format("%s%s", tag, "Crafted"), String.format("%d", this.crafted)));
        prop.add(new KVPair(String.format("%s%s", tag, "Bought"), String.format("%d", this.bought)));
        prop.add(new KVPair(String.format("%s%s", tag, "Sold"), String.format("%d", this.sold)));
        prop.add(new KVPair(String.format("%s%s", tag, "Broken"), String.format("%d", this.broken)));
        prop.add(new KVPair(String.format("%s%s", tag, "Traveled"), String.format("%d", this.traveled)));
        prop.add(new KVPair(String.format("%s%s", tag, "Morphs"), String.format("%d", this.morphs)));
        prop.add(new KVPair(String.format("%s%s", tag, "Teleports"), String.format("%d", this.teleports)));
        prop.add(new KVPair(String.format("%s%s", tag, "Eaten"), String.format("%d", this.eaten)));
        prop.add(new KVPair(String.format("%s%s", tag, "RoachStomps"), String.format("%d", this.roachstomps)));
        prop.add(new KVPair(String.format("%s%s", tag, "HardLandings"), String.format("%d", this.hard_landings)));
        prop.add(new KVPair(String.format("%s%s", tag, "Flights"), String.format("%d", this.flights)));
        prop.add(new KVPair(String.format("%s%s", tag, "Spells"), String.format("%d", this.spells)));
        ToDoList.writeSelf(prop, tag);
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.home_dimension = Utils.getPropertyInt(prop, String.format("%s%s", tag, "HomeDimension"), 0, 128, 0);
        this.home_x = Utils.getPropertyDouble(prop, String.format("%s%s", tag, "HomePosx"), 0.0, 2.147483647E9, 100000.0);
        this.home_y = Utils.getPropertyDouble(prop, String.format("%s%s", tag, "HomePosy"), 0.0, 2.147483647E9, 70.0);
        this.home_z = Utils.getPropertyDouble(prop, String.format("%s%s", tag, "HomePosz"), 0.0, 2.147483647E9, 100000.0);
        this.kills = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Kills"), 0, Integer.MAX_VALUE, 0);
        this.deaths = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Deaths"), 0, Integer.MAX_VALUE, 0);
        this.damage_taken = Utils.getPropertyDouble(prop, String.format("%s%s", tag, "Damage_taken"), 0.0, 2.147483647E9, 0.0);
        this.damage_dealt = Utils.getPropertyDouble(prop, String.format("%s%s", tag, "Damage_dealt"), 0.0, 2.147483647E9, 0.0);
        this.blocks_broken = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Blocks_broken"), 0, Integer.MAX_VALUE, 0);
        this.blocks_placed = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Blocks_placed"), 0, Integer.MAX_VALUE, 0);
        this.blocks_colored = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Blocks_colored"), 0, Integer.MAX_VALUE, 0);
        this.crafted = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Crafted"), 0, Integer.MAX_VALUE, 0);
        this.bought = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Bought"), 0, Integer.MAX_VALUE, 0);
        this.sold = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Sold"), 0, Integer.MAX_VALUE, 0);
        this.broken = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Broken"), 0, Integer.MAX_VALUE, 0);
        this.traveled = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Traveled"), 0, Integer.MAX_VALUE, 0);
        this.morphs = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Morphs"), 0, Integer.MAX_VALUE, 0);
        this.teleports = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Teleports"), 0, Integer.MAX_VALUE, 0);
        this.eaten = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Eaten"), 0, Integer.MAX_VALUE, 0);
        this.roachstomps = Utils.getPropertyInt(prop, String.format("%s%s", tag, "RoachStomps"), 0, Integer.MAX_VALUE, 0);
        this.hard_landings = Utils.getPropertyInt(prop, String.format("%s%s", tag, "HardLandings"), 0, Integer.MAX_VALUE, 0);
        this.flights = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Flights"), 0, Integer.MAX_VALUE, 0);
        this.spells = Utils.getPropertyInt(prop, String.format("%s%s", tag, "Spells"), 0, Integer.MAX_VALUE, 0);
        ToDoList.readSelf(prop, tag);
    }

    public void handleInventory(int command, int p1, int p2, int p3, int p4) {
        if (this.alt_inv_handler != null) {
            this.alt_inv_handler.doHandleInventory(this, command, p1, p2, p3, p4);
        } else {
            this.defaultHandleInventory(command, p1, p2, p3, p4);
        }
    }

    public void defaultHandleInventory(int command, int p1, int p2, int p3, int p4) {
        if (this.getGameMode() == 3) {
            return;
        }
        switch (command) {
            case 0: {
                if (!ServerHooker.clickedHotBar(this, p1, p2, p3 != 0)) break;
                this.ClickedHotBar(p1, p2, p3 != 0);
                break;
            }
            case 1: {
                if (!ServerHooker.clickedInventory(this, p1, p2, p3 != 0)) break;
                this.ClickedInventory(p1, p2, p3 != 0);
                break;
            }
            case 2: {
                if (!ServerHooker.clickedEntityInventory(this, p1, p2, p3, p4 != 0)) break;
                this.ClickedEntityInventory(p1, p2, p3, p4 != 0);
                break;
            }
            case 3: {
                if (this.getGameMode() == 0) {
                    return;
                }
                this.ClickedCreativeInventory(p1, p2, p3 != 0);
                break;
            }
            case 4: {
                this.ClickedCrafted(p1, p2 != 0);
                break;
            }
            case 5: {
                this.ClickedCrafting(p1, p2, p3 != 0);
                break;
            }
            case 6: {
                this.SpreadListAdd(p1, p2, p3);
                break;
            }
            case 7: {
                this.SpreadListClear();
                break;
            }
            case 8: {
                this.ClearTable();
                break;
            }
            case 9: {
                if (!ServerHooker.clickedArmor(this, p1, p2, p3 != 0)) break;
                this.ClickedArmor(p1, p2, p3 != 0);
                break;
            }
            case 10: {
                this.DeleteMouseBite();
                break;
            }
            case 11: {
                this.SpitMouseBite();
                break;
            }
            case 12: {
                this.ClickedInventoryWithEntity(p1, p2, p3 != 0, p4);
                break;
            }
            case 13: {
                this.SpitOneHotbar();
                break;
            }
            case 14: {
                this.SellIt(p1, p2, p3, p4);
                break;
            }
            case 15: {
                this.BuyIt(p1, p2, p3, p4);
                break;
            }
            case 16: {
                this.UnStayEntity(p1, p2, p3, p4);
                break;
            }
            case 17: {
                this.MouseBiteToEntity(p1, p2, p3, p4);
                break;
            }
            case 18: {
                this.ClickedDeskCrafted(p1, p2 != 0);
                break;
            }
            case 19: {
                this.ClickedDeskCrafting(p1, p2, p3 != 0);
                break;
            }
        }
    }

    public void MouseBiteToEntity(int eid, int p2, int p3, int p4) {
        Entity ent = DangerZone.server.entityManager.findEntityByID(eid);
        if (ent == null) {
            return;
        }
        InventoryContainer mousebite = this.getMouseBite();
        InventoryContainer eh = ent.getHotbar(0);
        this.setMouseBite(eh);
        ent.setHotbar(0, mousebite);
    }

    public void UnStayEntity(int eid, int p2, int p3, int p4) {
        Entity ent = DangerZone.server.entityManager.findEntityByID(eid);
        if (ent == null) {
            return;
        }
        ent.setStaying(false);
    }

    public void SellIt(int eid, int p2, int p3, int p4) {
        Entity ent = DangerZone.server.entityManager.findEntityByID(eid);
        if (ent == null) {
            return;
        }
        InventoryContainer ic = ent.getHotbar(0);
        if (ic == null) {
            return;
        }
        int cost = ent.getVarInt(30);
        if (cost <= 0) {
            return;
        }
        if (this.getMouseBite() != null) {
            return;
        }
        ent.setHotbar(0, null);
        this.sold += ic.count;
        this.server_thread.sendStatsToPlayer();
        int i = 0;
        while (i < 8) {
            if (ent.getInventory(i) == null) {
                ent.setInventory(i, ic);
                ent.setVarInt(i + 16, cost * 2);
                break;
            }
            ++i;
        }
        while (cost >= 1000) {
            ic = new InventoryContainer("DangerZone:Platinum Coin", 1);
            if (!this.putMeInASlot(ic)) {
                this.setMouseBite(ic);
                this.DropMouseBite();
                this.setMouseBite(null);
            }
            cost -= 1000;
        }
        while (cost >= 100) {
            ic = new InventoryContainer("DangerZone:Gold Coin", 1);
            if (!this.putMeInASlot(ic)) {
                this.setMouseBite(ic);
                this.DropMouseBite();
                this.setMouseBite(null);
            }
            cost -= 100;
        }
        while (cost >= 10) {
            ic = new InventoryContainer("DangerZone:Silver Coin", 1);
            if (!this.putMeInASlot(ic)) {
                this.setMouseBite(ic);
                this.DropMouseBite();
                this.setMouseBite(null);
            }
            cost -= 10;
        }
    }

    public void BuyIt(int which, int eid, int p3, int p4) {
        if (which < 0 || which > 7) {
            return;
        }
        InventoryContainer mousebite = null;
        InventoryContainer ic = null;
        Entity ent = DangerZone.server.entityManager.findEntityByID(eid);
        if (ent == null) {
            return;
        }
        InventoryContainer[] spare_change = new InventoryContainer[2];
        int totalcoins = 0;
        mousebite = this.getMouseBite();
        if (mousebite != null) {
            return;
        }
        int i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic != null) {
                if (ic.iid == Items.coinplatinum.itemID) {
                    totalcoins += 1000 * ic.count;
                }
                if (ic.iid == Items.coingold.itemID) {
                    totalcoins += 100 * ic.count;
                }
                if (ic.iid == Items.coinsilver.itemID) {
                    totalcoins += 10 * ic.count;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic != null) {
                if (ic.iid == Items.coinplatinum.itemID) {
                    totalcoins += 1000 * ic.count;
                }
                if (ic.iid == Items.coingold.itemID) {
                    totalcoins += 100 * ic.count;
                }
                if (ic.iid == Items.coinsilver.itemID) {
                    totalcoins += 10 * ic.count;
                }
            }
            ++i;
        }
        int cost = ent.getVarInt(which + 16);
        if (cost > totalcoins) {
            return;
        }
        mousebite = ent.getInventory(which);
        if (mousebite == null) {
            return;
        }
        this.setMouseBite(mousebite);
        ent.setInventory(which, null);
        this.bought += mousebite.count;
        this.server_thread.sendStatsToPlayer();
        int giveup = 30000;
        while (giveup > 0 && cost > 0) {
            --giveup;
            ic = this.findThis(Items.coinplatinum.itemID, spare_change);
            while (cost >= 1000 && ic != null) {
                ic = this.findThis(Items.coinplatinum.itemID, spare_change);
                if (ic == null || ic.count <= 0) continue;
                --ic.count;
                cost -= 1000;
            }
            ic = this.findThis(Items.coingold.itemID, spare_change);
            while (cost >= 100 && ic != null) {
                ic = this.findThis(Items.coingold.itemID, spare_change);
                if (ic == null || ic.count <= 0) continue;
                --ic.count;
                cost -= 100;
            }
            ic = this.findThis(Items.coinsilver.itemID, spare_change);
            while (cost >= 10 && ic != null) {
                ic = this.findThis(Items.coinsilver.itemID, spare_change);
                if (ic == null || ic.count <= 0) continue;
                --ic.count;
                cost -= 10;
            }
            if (cost <= 0) continue;
            ic = this.findThis(Items.coingold.itemID, spare_change);
            if (ic != null && ic.count > 0) {
                --ic.count;
                this.findThis(Items.coingold.itemID, spare_change);
                spare_change[0] = new InventoryContainer("DangerZone:Silver Coin", 10);
                continue;
            }
            ic = this.findThis(Items.coinplatinum.itemID, spare_change);
            if (ic == null || ic.count <= 0) continue;
            --ic.count;
            this.findThis(Items.coinplatinum.itemID, spare_change);
            spare_change[1] = new InventoryContainer("DangerZone:Gold Coin", 10);
        }
        ic = this.findThis(Items.coinplatinum.itemID, spare_change);
        ic = this.findThis(Items.coingold.itemID, spare_change);
        ic = this.findThis(Items.coinsilver.itemID, spare_change);
        if (spare_change[0] != null && !this.putMeInASlot(spare_change[0])) {
            ic = this.getMouseBite();
            this.setMouseBite(spare_change[0]);
            this.DropMouseBite();
            this.setMouseBite(ic);
        }
        if (spare_change[1] != null && !this.putMeInASlot(spare_change[1])) {
            ic = this.getMouseBite();
            this.setMouseBite(spare_change[1]);
            this.DropMouseBite();
            this.setMouseBite(ic);
        }
    }

    public InventoryContainer findThis(int iid, InventoryContainer[] spare_change) {
        InventoryContainer ic;
        int i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic != null && ic.iid == iid) {
                this.setInventoryChanged(i);
                if (ic.count <= 0) {
                    this.setInventory(i, null);
                } else {
                    return ic;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic != null && ic.iid == iid) {
                this.setHotbarChanged(i);
                if (ic.count <= 0) {
                    this.setHotbar(i, null);
                } else {
                    return ic;
                }
            }
            ++i;
        }
        if (spare_change != null) {
            if (spare_change[0] != null && spare_change[0].iid == iid) {
                if (spare_change[0].count > 0) {
                    return spare_change[0];
                }
                spare_change[0] = null;
            }
            if (spare_change[1] != null && spare_change[1].iid == iid) {
                if (spare_change[1].count > 0) {
                    return spare_change[1];
                }
                spare_change[1] = null;
            }
        }
        return null;
    }

    public void ClickedHotBar(int which, int leftrightmid, boolean shifted) {
        if (which < 0 || which > 9) {
            return;
        }
        InventoryContainer mousebite = null;
        InventoryContainer ic = null;
        if (leftrightmid == 0) {
            if (shifted) {
                mousebite = this.getMouseBite();
                if (mousebite != null) {
                    this.mousebiteToInventory();
                }
                if ((mousebite = this.getMouseBite()) == null) {
                    this.setMouseBite(this.getHotbar(which));
                    this.setHotbar(which, null);
                    this.mousebiteToInventory();
                }
            } else {
                mousebite = this.getMouseBite();
                if (mousebite == null) {
                    this.setMouseBite(this.getHotbar(which));
                    this.setHotbar(which, null);
                } else {
                    ic = this.getHotbar(which);
                    if (ic != null) {
                        if (ic.iid != mousebite.iid || ic.bid != mousebite.bid) {
                            this.setHotbar(which, mousebite);
                            this.setMouseBite(ic);
                        } else {
                            int mx = ic.getMaxStack() - ic.count;
                            if (mx > 0) {
                                if (mx >= mousebite.count) {
                                    ic.count += mousebite.count;
                                    this.setMouseBite(null);
                                    this.setHotbarChanged(which);
                                } else {
                                    mousebite.count -= mx;
                                    ic.count += mx;
                                    this.setMouseBiteChanged();
                                    this.setHotbarChanged(which);
                                }
                            }
                        }
                    } else {
                        this.setHotbar(which, mousebite);
                        this.setMouseBite(null);
                    }
                }
            }
        } else if (leftrightmid == 1) {
            mousebite = this.getMouseBite();
            if (mousebite == null && (ic = this.getHotbar(which)) != null) {
                int half = ic.count / 2;
                if (half == 0) {
                    this.setMouseBite(ic);
                    this.setHotbar(which, null);
                } else {
                    mousebite = new InventoryContainer();
                    mousebite.bid = ic.bid;
                    mousebite.iid = ic.iid;
                    mousebite.count = half;
                    ic.count -= half;
                    this.setMouseBite(mousebite);
                    this.setHotbarChanged(which);
                }
            }
        } else {
            this.setMouseBite(null);
            this.setHotbar(which, null);
        }
    }

    public void ClickedInventory(int which, int leftrightmid, boolean shifted) {
        if (which < 0 || which > 49) {
            return;
        }
        InventoryContainer mousebite = null;
        InventoryContainer ic = null;
        if (leftrightmid == 0) {
            if (shifted) {
                mousebite = this.getMouseBite();
                if (mousebite != null) {
                    this.mousebiteToInventory();
                }
                if ((mousebite = this.getMouseBite()) == null) {
                    this.setMouseBite(this.getInventory(which));
                    this.setInventory(which, null);
                    this.mousebiteToInventory();
                }
            } else {
                mousebite = this.getMouseBite();
                if (mousebite == null) {
                    this.setMouseBite(this.getInventory(which));
                    this.setInventory(which, null);
                } else {
                    ic = this.getInventory(which);
                    if (ic != null) {
                        if (ic.iid != mousebite.iid || ic.bid != mousebite.bid) {
                            this.setInventory(which, mousebite);
                            this.setMouseBite(ic);
                        } else {
                            int mx = ic.getMaxStack() - ic.count;
                            if (mx > 0) {
                                if (mx >= mousebite.count) {
                                    ic.count += mousebite.count;
                                    this.setMouseBite(null);
                                    this.setInventoryChanged(which);
                                } else {
                                    mousebite.count -= mx;
                                    ic.count += mx;
                                    this.setMouseBiteChanged();
                                    this.setInventoryChanged(which);
                                }
                            }
                        }
                    } else {
                        this.setInventory(which, mousebite);
                        this.setMouseBite(null);
                    }
                }
            }
        } else if (leftrightmid == 1) {
            mousebite = this.getMouseBite();
            if (mousebite == null && (ic = this.getInventory(which)) != null) {
                int half = ic.count / 2;
                if (half == 0) {
                    this.setMouseBite(ic);
                    this.setInventory(which, null);
                } else {
                    mousebite = new InventoryContainer();
                    mousebite.bid = ic.bid;
                    mousebite.iid = ic.iid;
                    mousebite.count = half;
                    ic.count -= half;
                    this.setMouseBite(mousebite);
                    this.setInventoryChanged(which);
                }
            }
        } else {
            this.setMouseBite(null);
            this.setInventory(which, null);
        }
    }

    public void ClickedInventoryWithEntity(int which, int leftrightmid, boolean shifted, int eid) {
        if (which < 0 || which > 49) {
            return;
        }
        Entity ent = DangerZone.server.entityManager.findEntityByID(eid);
        if (ent == null) {
            return;
        }
        if (!BreakChecks.canTakeStuff(this, ent)) {
            return;
        }
        InventoryContainer mousebite = null;
        InventoryContainer ic = null;
        if (leftrightmid == 0) {
            if (shifted) {
                mousebite = this.getMouseBite();
                if (mousebite != null) {
                    this.mousebiteToInventory(ent);
                }
                if ((mousebite = this.getMouseBite()) == null) {
                    this.setMouseBite(this.getInventory(which));
                    this.setInventory(which, null);
                    this.mousebiteToInventory(ent);
                }
            } else {
                mousebite = this.getMouseBite();
                if (mousebite == null) {
                    this.setMouseBite(this.getInventory(which));
                    this.setInventory(which, null);
                } else {
                    ic = this.getInventory(which);
                    if (ic != null) {
                        if (ic.iid != mousebite.iid || ic.bid != mousebite.bid) {
                            this.setInventory(which, mousebite);
                            this.setMouseBite(ic);
                        } else {
                            int mx = ic.getMaxStack() - ic.count;
                            if (mx > 0) {
                                if (mx >= mousebite.count) {
                                    ic.count += mousebite.count;
                                    this.setMouseBite(null);
                                    this.setInventoryChanged(which);
                                } else {
                                    mousebite.count -= mx;
                                    ic.count += mx;
                                    this.setMouseBiteChanged();
                                    this.setInventoryChanged(which);
                                }
                            }
                        }
                    } else {
                        this.setInventory(which, mousebite);
                        this.setMouseBite(null);
                    }
                }
            }
        } else if (leftrightmid == 1) {
            mousebite = this.getMouseBite();
            if (mousebite == null && (ic = this.getInventory(which)) != null) {
                int half = ic.count / 2;
                if (half == 0) {
                    this.setMouseBite(ic);
                    this.setInventory(which, null);
                } else {
                    mousebite = new InventoryContainer();
                    mousebite.bid = ic.bid;
                    mousebite.iid = ic.iid;
                    mousebite.count = half;
                    ic.count -= half;
                    this.setMouseBite(mousebite);
                    this.setInventoryChanged(which);
                }
            }
        } else {
            this.setMouseBite(null);
            this.setInventory(which, null);
        }
    }

    public void ClickedEntityInventory(int eid, int which, int leftrightmid, boolean shifted) {
        if (which < 0 || which > 49) {
            return;
        }
        Entity ent = DangerZone.server.entityManager.findEntityByID(eid);
        if (ent == null) {
            return;
        }
        if (!BreakChecks.canTakeStuff(this, ent)) {
            return;
        }
        InventoryContainer mousebite = null;
        InventoryContainer ic = null;
        if (leftrightmid == 0) {
            if (shifted) {
                mousebite = this.getMouseBite();
                if (mousebite != null) {
                    this.mousebiteToInventory();
                }
                if ((mousebite = this.getMouseBite()) == null) {
                    this.setMouseBite(ent.getInventory(which));
                    if (ent instanceof EntityFurnace) {
                        ToDoList.onCrafted(this, this.getMouseBite());
                    }
                    ent.setInventory(which, null);
                    this.mousebiteToInventory();
                }
            } else {
                mousebite = this.getMouseBite();
                if (mousebite == null) {
                    this.setMouseBite(ent.getInventory(which));
                    if (ent instanceof EntityFurnace) {
                        ToDoList.onCrafted(this, this.getMouseBite());
                    }
                    ent.setInventory(which, null);
                } else {
                    ic = ent.getInventory(which);
                    if (ic != null) {
                        if (ic.iid != mousebite.iid || ic.bid != mousebite.bid) {
                            ent.setInventory(which, mousebite);
                            this.setMouseBite(ic);
                        } else {
                            int mx = ic.getMaxStack() - ic.count;
                            if (mx > 0) {
                                if (mx >= mousebite.count) {
                                    ic.count += mousebite.count;
                                    this.setMouseBite(null);
                                    ent.setInventoryChanged(which);
                                } else {
                                    mousebite.count -= mx;
                                    ic.count += mx;
                                    this.setMouseBiteChanged();
                                    ent.setInventoryChanged(which);
                                }
                            }
                        }
                    } else {
                        ent.setInventory(which, mousebite);
                        this.setMouseBite(null);
                    }
                }
            }
        } else if (leftrightmid == 1) {
            mousebite = this.getMouseBite();
            if (mousebite == null && (ic = ent.getInventory(which)) != null) {
                int half;
                if (ent instanceof EntityFurnace) {
                    ToDoList.onCrafted(this, ic);
                }
                if ((half = ic.count / 2) == 0) {
                    this.setMouseBite(ic);
                    ent.setInventory(which, null);
                } else {
                    mousebite = new InventoryContainer();
                    mousebite.bid = ic.bid;
                    mousebite.iid = ic.iid;
                    mousebite.count = half;
                    ic.count -= half;
                    this.setMouseBite(mousebite);
                    ent.setInventoryChanged(which);
                }
            }
        } else {
            this.setMouseBite(null);
            ent.setInventory(which, null);
        }
    }

    public void ClickedCreativeInventory(int iid, int bid, boolean shifted) {
        InventoryContainer ic = null;
        if (Items.isValid(iid)) {
            ic = new InventoryContainer(0, iid, Items.getMaxStack(iid), 0);
        } else if (Blocks.isValid(bid)) {
            ic = new InventoryContainer(bid, 0, Blocks.getMaxStack(bid), 0);
        }
        if (ic != null) {
            ic.onCrafted(this);
        }
        this.setMouseBite(ic);
        if (shifted) {
            this.mousebiteToInventory();
        }
    }

    public DeskRecipe refreshDeskCrafted() {
        DeskRecipe r = DeskCrafting.find(this);
        if (r != null) {
            InventoryContainer ic = new InventoryContainer(r.outname, r.out_count);
            this.setCrafted(ic);
        } else {
            this.setCrafted(null);
        }
        return r;
    }

    public void ClickedDeskCrafted(int leftrightmid, boolean shifted) {
        InventoryContainer mousebite = this.getMouseBite();
        DeskRecipe r = this.refreshDeskCrafted();
        InventoryContainer ic = this.getCrafted();
        if (r != null && ic != null && leftrightmid == 0 && r.exp_cost <= this.getExperience()) {
            if (mousebite == null) {
                this.setMouseBite(ic);
                mousebite = this.getMouseBite();
            } else if (mousebite.iid == ic.iid && mousebite.bid == ic.bid) {
                int df = 0;
                if (ic.iid != 0) {
                    df = Items.getMaxStack(ic.iid);
                }
                if (ic.bid != 0) {
                    df = Blocks.getMaxStack(ic.bid);
                }
                if (mousebite.count + ic.count <= df) {
                    mousebite.count += ic.count;
                } else {
                    return;
                }
            }
            mousebite.onCrafted(this);
            this.crafted += ic.count;
            ToDoList.onCrafted(this, mousebite);
            this.server_thread.sendStatsToPlayer();
            this.setMouseBiteChanged();
            this.setCrafted(null);
            this.setExperience(this.getExperience() - r.exp_cost);
        }
        this.refreshDeskCrafted();
        if (shifted) {
            this.mousebiteToInventory();
        }
    }

    public void ClickedDeskCrafting(int which, int leftrightmid, boolean shifted) {
        if (which < 0 || which > 8) {
            return;
        }
        InventoryContainer mousebite = this.getMouseBite();
        InventoryContainer ic = this.getCrafting(which);
        if (leftrightmid == 0) {
            if (shifted) {
                if (mousebite != null) {
                    this.mousebiteToInventory();
                }
                if ((mousebite = this.getMouseBite()) == null) {
                    this.setMouseBite(this.getCrafting(which));
                    this.setCrafting(which, null);
                    this.mousebiteToInventory();
                }
            } else if (mousebite == null) {
                this.setMouseBite(this.getCrafting(which));
                this.setCrafting(which, null);
            } else {
                ic = this.getCrafting(which);
                if (ic != null) {
                    if (ic.iid != mousebite.iid || ic.bid != mousebite.bid) {
                        this.setCrafting(which, mousebite);
                        this.setMouseBite(ic);
                    } else {
                        int mx = ic.getMaxStack() - ic.count;
                        if (mx > 0) {
                            if (mx >= mousebite.count) {
                                ic.count += mousebite.count;
                                this.setMouseBite(null);
                                this.setCraftingChanged(which);
                            } else {
                                mousebite.count -= mx;
                                ic.count += mx;
                                this.setMouseBiteChanged();
                                this.setCraftingChanged(which);
                            }
                        }
                    }
                } else {
                    this.setCrafting(which, mousebite);
                    this.setMouseBite(null);
                }
            }
        } else if (leftrightmid == 1) {
            if (mousebite == null && (ic = this.getCrafting(which)) != null) {
                int half = ic.count / 2;
                if (half == 0) {
                    this.setMouseBite(ic);
                    this.setCrafting(which, null);
                } else {
                    mousebite = new InventoryContainer();
                    mousebite.bid = ic.bid;
                    mousebite.iid = ic.iid;
                    mousebite.count = half;
                    ic.count -= half;
                    this.setMouseBite(mousebite);
                    this.setCraftingChanged(which);
                }
            }
        } else {
            this.setMouseBite(null);
            this.setCrafting(which, null);
        }
        this.refreshDeskCrafted();
        if (shifted) {
            this.mousebiteToInventory();
        }
    }

    public Recipe refreshCrafted() {
        Recipe r = Crafting.find(this);
        if (r != null) {
            InventoryContainer ic = new InventoryContainer(r.outname, r.out_count);
            this.setCrafted(ic);
        } else {
            this.setCrafted(null);
        }
        return r;
    }

    public void ClickedCrafted(int leftrightmid, boolean shifted) {
        InventoryContainer mousebite = this.getMouseBite();
        Recipe r = this.refreshCrafted();
        InventoryContainer ic = this.getCrafted();
        if (r != null && ic != null && leftrightmid == 0) {
            if (mousebite == null) {
                this.setMouseBite(ic);
                mousebite = this.getMouseBite();
            } else if (mousebite.iid == ic.iid && mousebite.bid == ic.bid) {
                int df = 0;
                if (ic.iid != 0) {
                    df = Items.getMaxStack(ic.iid);
                }
                if (ic.bid != 0) {
                    df = Blocks.getMaxStack(ic.bid);
                }
                if (mousebite.count + ic.count <= df) {
                    mousebite.count += ic.count;
                } else {
                    return;
                }
            }
            mousebite.onCrafted(this);
            this.crafted += ic.count;
            ToDoList.onCrafted(this, mousebite);
            this.server_thread.sendStatsToPlayer();
            this.setMouseBiteChanged();
            this.setCrafted(null);
            r.finishCrafting(this);
        }
        this.refreshCrafted();
        if (shifted) {
            this.mousebiteToInventory();
        }
    }

    public void ClickedCrafting(int which, int leftrightmid, boolean shifted) {
        if (which < 0 || which > 8) {
            return;
        }
        InventoryContainer mousebite = this.getMouseBite();
        InventoryContainer ic = this.getCrafting(which);
        if (leftrightmid == 0) {
            if (shifted) {
                if (mousebite != null) {
                    this.mousebiteToInventory();
                }
                if ((mousebite = this.getMouseBite()) == null) {
                    this.setMouseBite(this.getCrafting(which));
                    this.setCrafting(which, null);
                    this.mousebiteToInventory();
                }
            } else if (mousebite == null) {
                this.setMouseBite(this.getCrafting(which));
                this.setCrafting(which, null);
            } else {
                ic = this.getCrafting(which);
                if (ic != null) {
                    if (ic.iid != mousebite.iid || ic.bid != mousebite.bid) {
                        this.setCrafting(which, mousebite);
                        this.setMouseBite(ic);
                    } else {
                        int mx = ic.getMaxStack() - ic.count;
                        if (mx > 0) {
                            if (mx >= mousebite.count) {
                                ic.count += mousebite.count;
                                this.setMouseBite(null);
                                this.setCraftingChanged(which);
                            } else {
                                mousebite.count -= mx;
                                ic.count += mx;
                                this.setMouseBiteChanged();
                                this.setCraftingChanged(which);
                            }
                        }
                    }
                } else {
                    this.setCrafting(which, mousebite);
                    this.setMouseBite(null);
                }
            }
        } else if (leftrightmid == 1) {
            if (mousebite == null && (ic = this.getCrafting(which)) != null) {
                int half = ic.count / 2;
                if (half == 0) {
                    this.setMouseBite(ic);
                    this.setCrafting(which, null);
                } else {
                    mousebite = new InventoryContainer();
                    mousebite.bid = ic.bid;
                    mousebite.iid = ic.iid;
                    mousebite.count = half;
                    ic.count -= half;
                    this.setMouseBite(mousebite);
                    this.setCraftingChanged(which);
                }
            }
        } else {
            this.setMouseBite(null);
            this.setCrafting(which, null);
        }
        this.refreshCrafted();
        if (shifted) {
            this.mousebiteToInventory();
        }
    }

    public void SpreadListAdd(int which, int shifted, int dir) {
        if (which < 0 || which > 8) {
            return;
        }
        if (shifted != 0) {
            this.ClickedCrafting(which, 0, true);
            this.SpreadListClear();
            return;
        }
        InventoryContainer mousebite = this.getMouseBite();
        InventoryContainer ic = null;
        if (dir == 1) {
            if (mousebite == null) {
                this.setMouseBite(this.getCrafting(which));
                this.setCrafting(which, null);
                this.SpreadListClear();
                return;
            }
            if (this.getCrafting(which) != null) {
                this.ClickedCrafting(which, 0, false);
                this.SpreadListClear();
                return;
            }
            this.spread_list = new ArrayList<Integer>();
            this.spread_list.add(which);
            this.setCrafting(which, mousebite);
            this.setMouseBite(null);
            return;
        }
        if (this.isOnSpreadList(which)) {
            return;
        }
        if (this.spread_list == null) {
            return;
        }
        if (this.spread_list == null) {
            if (mousebite == null) {
                ic = this.getCrafting(which);
                if (ic != null) {
                    this.spread_list = new ArrayList<Integer>();
                    this.spread_list.add(which);
                }
            } else {
                ic = this.getCrafting(which);
                if (ic == null) {
                    this.spread_list = new ArrayList<Integer>();
                    this.spread_list.add(which);
                    this.setCrafting(which, mousebite);
                    this.setMouseBite(null);
                }
            }
            return;
        }
        if (mousebite != null) {
            this.SpreadListClear();
            return;
        }
        ic = this.getCrafting(which);
        if (ic != null) {
            return;
        }
        ic = this.getCrafting(this.spread_list.get(0));
        if (ic.getMaxStack() <= 1) {
            return;
        }
        int i = this.spread_list.size();
        int total = 0;
        int iid = 0;
        int bid = 0;
        while (i > 0) {
            ic = this.getCrafting(this.spread_list.get(i - 1));
            if (ic != null) {
                total += ic.count;
                bid = ic.bid;
                iid = ic.iid;
            }
            this.setCrafting(this.spread_list.get(i - 1), null);
            --i;
        }
        this.spread_list.add(which);
        int newsize = this.spread_list.size();
        i = 0;
        while (total > 0) {
            ic = this.getCrafting(this.spread_list.get(i));
            if (ic == null) {
                ic = new InventoryContainer(bid, iid, 1, 0);
                this.setCrafting(this.spread_list.get(i), ic);
            } else {
                ++ic.count;
                this.setCraftingChanged(this.spread_list.get(i));
            }
            if (++i >= newsize) {
                i = 0;
            }
            --total;
        }
        this.refreshCrafted();
    }

    private boolean isOnSpreadList(int index) {
        if (this.spread_list == null) {
            return false;
        }
        int i = this.spread_list.size();
        while (i > 0) {
            if (index == this.spread_list.get(i - 1)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public void SpreadListClear() {
        this.spread_list = null;
        this.refreshCrafted();
    }

    public void ClearTable() {
        this.DropMouseBite();
        this.setCrafted(null);
        int i = 0;
        while (i < 9) {
            this.setMouseBite(this.getCrafting(i));
            this.DropMouseBite();
            this.setCrafting(i, null);
            ++i;
        }
        this.spread_list = null;
    }

    public void ClickedArmor(int which, int leftrightmid, boolean shifted) {
        if (which < 0 || which > 3) {
            return;
        }
        InventoryContainer mousebite = null;
        InventoryContainer ic = null;
        if (leftrightmid == 0 || leftrightmid == 1) {
            if (shifted) {
                mousebite = this.getMouseBite();
                if (mousebite != null) {
                    this.mousebiteToInventory();
                }
                if ((mousebite = this.getMouseBite()) == null) {
                    this.setMouseBite(this.getArmor(which));
                    this.setArmor(which, null);
                    this.mousebiteToInventory();
                }
            } else {
                mousebite = this.getMouseBite();
                ic = this.getArmor(which);
                if (mousebite == null) {
                    this.setMouseBite(ic);
                    this.setArmor(which, null);
                } else if (ic == null) {
                    Item it = mousebite.getItem();
                    if (it != null && it instanceof ItemArmor) {
                        ItemArmor ia = (ItemArmor)it;
                        if (ia.armortype == which) {
                            this.setArmor(which, mousebite);
                            ToDoList.onArmorPlaced(this, mousebite, which);
                            this.setMouseBite(null);
                        }
                    }
                } else {
                    Item it = mousebite.getItem();
                    if (it != null && it instanceof ItemArmor) {
                        ItemArmor ia = (ItemArmor)it;
                        if (ia.armortype == which) {
                            this.setArmor(which, mousebite);
                            ToDoList.onArmorPlaced(this, mousebite, which);
                            this.setMouseBite(ic);
                        }
                    }
                }
            }
        } else if (leftrightmid == 2) {
            this.setMouseBite(null);
            this.setArmor(which, null);
        }
    }

    public void DeleteMouseBite() {
        this.setMouseBite(null);
    }

    public void SpitMouseBite() {
        InventoryContainer mousebite = this.getMouseBite();
        if (mousebite != null) {
            int i = mousebite.count;
            while (i > 0) {
                EntityBlockItem e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * 2.0f * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 3.0f / 4.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * 2.0f), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * 2.0f * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
                if (e != null) {
                    if (mousebite.count == 1) {
                        e.fill(mousebite);
                    } else {
                        e.fill(mousebite.bid, mousebite.iid, 1, mousebite.currentuses, mousebite.attributes, mousebite.icmeta);
                    }
                    e.rotation_pitch = DangerZone.server_world.rand.nextInt(360);
                    e.rotation_yaw = DangerZone.server_world.rand.nextInt(360);
                    e.rotation_roll = DangerZone.server_world.rand.nextInt(360);
                    e.motionx = (float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)) * 2.0f;
                    e.motiony = -((float)Math.sin(Math.toRadians(this.rotation_pitch_head)));
                    e.motionz = (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)) * 2.0f;
                    this.world.spawnEntityInWorld(e);
                }
                --i;
            }
            this.setMouseBite(null);
        }
    }

    public void SpitOneHotbar() {
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        if (this.getGameMode() == 3) {
            return;
        }
        if (ic != null) {
            EntityBlockItem e;
            if (ic.count > 0 && (e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * 2.0f * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 3.0f / 4.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * 2.0f), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * 2.0f * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))))) != null) {
                if (ic.count == 1) {
                    e.fill(ic);
                } else {
                    e.fill(ic.bid, ic.iid, 1, ic.currentuses, ic.attributes, ic.icmeta);
                }
                e.rotation_pitch = DangerZone.server_world.rand.nextInt(360);
                e.rotation_yaw = DangerZone.server_world.rand.nextInt(360);
                e.rotation_roll = DangerZone.server_world.rand.nextInt(360);
                e.motionx = (float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)) * 3.0f;
                e.motiony = -((float)Math.sin(Math.toRadians(this.rotation_pitch_head)));
                e.motionz = (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)) * 3.0f;
                this.world.spawnEntityInWorld(e);
            }
            if (ic.count > 1) {
                --ic.count;
            } else if (ic.count == 1) {
                ic = null;
            }
            this.setHotbar(this.gethotbarindex(), ic);
        }
    }

    public void DropMouseBite() {
        InventoryContainer mousebite = this.getMouseBite();
        if (mousebite != null) {
            int i = mousebite.count;
            while (i > 0) {
                EntityBlockItem e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * 2.0f * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 3.0f / 4.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * 2.0f), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * 2.0f * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
                if (e != null) {
                    if (mousebite.count == 1) {
                        e.fill(mousebite);
                    } else {
                        e.fill(mousebite.bid, mousebite.iid, 1, mousebite.currentuses, mousebite.attributes, mousebite.icmeta);
                    }
                    e.rotation_pitch = DangerZone.server_world.rand.nextInt(360);
                    e.rotation_yaw = DangerZone.server_world.rand.nextInt(360);
                    e.rotation_roll = DangerZone.server_world.rand.nextInt(360);
                    e.motionx = 0.0f;
                    e.motiony = 0.0f;
                    e.motionz = 0.0f;
                    this.world.spawnEntityInWorld(e);
                }
                --i;
            }
            this.setMouseBite(null);
        }
    }

    public void mousebiteToInventory() {
        int df;
        InventoryContainer mousebite = this.getMouseBite();
        if (mousebite == null) {
            return;
        }
        if (mousebite.iid == 0 && mousebite.bid == 0 || mousebite.count <= 0) {
            this.setMouseBite(null);
            return;
        }
        InventoryContainer ic = null;
        int i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic != null && ic.bid == mousebite.bid && ic.iid == mousebite.iid) {
                df = 0;
                df = ic.bid != 0 ? Blocks.getMaxStack(ic.bid) - ic.count : Items.getMaxStack(ic.iid) - ic.count;
                if (df > 0) {
                    if (df >= mousebite.count) {
                        ic.count += mousebite.count;
                        this.setInventoryChanged(i);
                        mousebite = null;
                        break;
                    }
                    ic.count += df;
                    this.setInventoryChanged(i);
                    mousebite.count -= df;
                }
                if (mousebite.count <= 0) {
                    mousebite = null;
                    break;
                }
            }
            ++i;
        }
        if (mousebite == null) {
            this.setMouseBite(null);
            return;
        }
        i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic != null && ic.bid == mousebite.bid && ic.iid == mousebite.iid) {
                df = 0;
                df = ic.bid != 0 ? Blocks.getMaxStack(ic.bid) - ic.count : Items.getMaxStack(ic.iid) - ic.count;
                if (df > 0) {
                    if (df >= mousebite.count) {
                        ic.count += mousebite.count;
                        this.setHotbarChanged(i);
                        mousebite = null;
                        break;
                    }
                    ic.count += df;
                    this.setHotbarChanged(i);
                    mousebite.count -= df;
                }
                if (mousebite.count <= 0) {
                    mousebite = null;
                    break;
                }
            }
            ++i;
        }
        if (mousebite == null) {
            this.setMouseBite(null);
            return;
        }
        i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic == null) {
                this.setInventory(i, mousebite);
                mousebite = null;
                break;
            }
            ++i;
        }
        if (mousebite == null) {
            this.setMouseBite(null);
            return;
        }
        i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic == null) {
                this.setHotbar(i, mousebite);
                mousebite = null;
                break;
            }
            ++i;
        }
        if (mousebite == null) {
            this.setMouseBite(null);
            return;
        }
        this.setMouseBiteChanged();
    }

    public void mousebiteToInventory(Entity ent) {
        InventoryContainer mousebite = this.getMouseBite();
        if (mousebite == null) {
            return;
        }
        if (mousebite.iid == 0 && mousebite.bid == 0 || mousebite.count <= 0) {
            this.setMouseBite(null);
            return;
        }
        InventoryContainer ic = null;
        int i = 0;
        while (i < 50) {
            ic = ent.getInventory(i);
            if (ic != null && ic.bid == mousebite.bid && ic.iid == mousebite.iid) {
                int df = 0;
                df = ic.bid != 0 ? Blocks.getMaxStack(ic.bid) - ic.count : Items.getMaxStack(ic.iid) - ic.count;
                if (df > 0) {
                    if (df >= mousebite.count) {
                        ic.count += mousebite.count;
                        ent.setInventoryChanged(i);
                        mousebite = null;
                        break;
                    }
                    ic.count += df;
                    ent.setInventoryChanged(i);
                    mousebite.count -= df;
                }
                if (mousebite.count <= 0) {
                    mousebite = null;
                    break;
                }
            }
            ++i;
        }
        if (mousebite == null) {
            this.setMouseBite(null);
            return;
        }
        i = 0;
        while (i < 50) {
            ic = ent.getInventory(i);
            if (ic == null) {
                ent.setInventory(i, mousebite);
                mousebite = null;
                break;
            }
            ++i;
        }
        if (mousebite == null) {
            this.setMouseBite(null);
            return;
        }
        this.setMouseBiteChanged();
    }

    @Override
    public void sethotbarindex(int f) {
        if (f >= 0 && f <= 9) {
            if (!this.world.isServer && this == DangerZone.player) {
                this.clienthotbarindex = f;
            } else {
                this.setVarInt(3, f);
            }
        }
    }

    @Override
    public int gethotbarindex() {
        if (this.world == null) {
            return 0;
        }
        if (!this.world.isServer && this == DangerZone.player) {
            return this.clienthotbarindex;
        }
        return this.getVarInt(3);
    }

    public void make_magic(float power, int type) {
        EntityMagic e;
        int whichattr = 0;
        float attrampf = power * this.getMaxMagic();
        int attramp = 0;
        if (attrampf > this.getMagic()) {
            attrampf = this.getMagic();
        }
        if (attrampf < 1.0f) {
            return;
        }
        attramp = (int)attrampf;
        if (attramp < 0) {
            return;
        }
        ++this.spells;
        this.server_thread.sendStatsToPlayer();
        this.setMagic(this.getMagic() - attrampf);
        if (type == 1) {
            whichattr = 1;
        }
        if (type == 2) {
            whichattr = 0;
        }
        if (type == 3) {
            whichattr = 2;
        }
        if ((e = (EntityMagic)this.world.createEntityByName("DangerZone:EntityMagic", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * (this.getWidth() + 1.0f)), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))))) != null) {
            e.init();
            e.setBID(1);
            e.setIID(-1);
            e.setVarInt(2, attramp);
            e.setVarInt(3, whichattr);
            e.thrower = this;
            e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(this.rotation_pitch_head))), (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), 5.0f, 0.05f);
            this.world.spawnEntityInWorld(e);
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 10 + attramp, this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 9.0f / 10.0f), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
        }
    }
}

