/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.BlockInstability;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlock;
import dangerzone.entities.EntityFire;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;

public class Explosion {
    public static void boom(Entity thrower, World world, int dimension, double x, double y, double z, int pwr, boolean doentitydamage) {
        Explosion.boom(thrower, world, dimension, x, y, z, pwr, doentitydamage, true);
    }

    public static void boom(Entity thrower, World world, int dimension, double x, double y, double z, int pwr, boolean doentitydamage, boolean fire) {
        double fz;
        double fy;
        double fx;
        float dr;
        double dir;
        int which;
        if (!world.isServer) {
            return;
        }
        if (pwr <= 0 || pwr > 20000) {
            return;
        }
        if (pwr < 50) {
            which = world.rand.nextInt(5);
            if (which == 0) {
                world.playSound("DangerZone:small_explosion1", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 1) {
                world.playSound("DangerZone:small_explosion2", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 2) {
                world.playSound("DangerZone:small_explosion3", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 3) {
                world.playSound("DangerZone:small_explosion4", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 4) {
                world.playSound("DangerZone:small_explosion5", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
        } else {
            which = world.rand.nextInt(3);
            if (which == 0) {
                world.playSound("DangerZone:large_explosion1", dimension, x, y, z, 2.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 1) {
                world.playSound("DangerZone:large_explosion2", dimension, x, y, z, 2.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 2) {
                world.playSound("DangerZone:large_explosion3", dimension, x, y, z, 2.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
        }
        float raydist = (float)Math.sqrt(pwr);
        float curdist = 0.0f;
        int nray = pwr * 30;
        int spk = 4;
        if (pwr >= 10) {
            spk = 10;
        }
        if (pwr >= 100) {
            spk = 50;
        }
        if (pwr >= 1000) {
            spk = 250;
        }
        if (pwr >= 5000) {
            spk = 2000;
        }
        if (pwr >= 5000) {
            raydist *= 0.75f;
            nray *= 2;
        }
        int i = 0;
        while (i < nray) {
            int bid;
            int iz;
            int iy;
            int ix;
            dir = Math.toRadians(world.rand.nextDouble() * 360.0);
            double xzscale = Math.toRadians(world.rand.nextDouble() * 360.0);
            double dx = Math.cos(dir);
            double dz = Math.sin(dir);
            double dy = Math.cos(xzscale) / 2.0;
            xzscale = Math.abs(Math.sin(xzscale));
            dx *= xzscale;
            dz *= xzscale;
            float raypower = pwr * 40;
            float powerlost = 0.0f;
            int lz = 0;
            int ly = 0;
            int lx = 0;
            dr = pwr < 500 ? raydist + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f * raydist : raydist + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.1f * raydist;
            curdist = i;
            curdist /= (float)nray;
            curdist *= dr;
            while (curdist < dr) {
                fx = x + dx * (double)curdist;
                fy = y + dy * (double)curdist;
                fz = z + dz * (double)curdist;
                ix = (int)fx;
                iy = (int)fy;
                iz = (int)fz;
                if (ix != lx || iy != ly || iz != lz) {
                    lx = ix;
                    ly = iy;
                    lz = iz;
                    bid = world.getblock(dimension, ix, iy, iz);
                    if (bid != 0) {
                        BlockInstability b;
                        float powerleft = raypower * (dr - curdist) / dr;
                        if ((powerleft -= powerlost) <= 0.0f) break;
                        if (powerleft > (float)Blocks.getMinDamage(bid)) {
                            if (powerleft > (float)Blocks.getMaxDamage(bid)) {
                                if (BreakChecks.canChangeBlock(thrower, dimension, ix, iy, iz, 0, 0)) {
                                    if (Blocks.BlockArray[bid] != null && Blocks.BlockArray[bid] instanceof BlockInstability) {
                                        b = (BlockInstability)Blocks.BlockArray[bid];
                                        b.trigger(world, dimension, ix, iy, iz);
                                    } else if (pwr > 500 && (curdist / dr < 0.9f || i < nray / 2)) {
                                        world.setblockandmetanonotify(dimension, ix, iy, iz, 0, 0);
                                    } else {
                                        world.setblockandmeta(dimension, ix, iy, iz, 0, 0);
                                    }
                                    if (world.rand.nextInt(spk * 2) == 0) {
                                        int ibid = Blocks.getBlockDrop(bid, null, world, dimension, ix, iy, iz);
                                        int iiid = Blocks.getItemDrop(bid, null, world, dimension, ix, iy, iz);
                                        Utils.doDropRand(world, ibid, iiid, 1.0f, dimension, ix, iy, iz);
                                    }
                                }
                                if (world.rand.nextInt(spk) == 0) {
                                    Utils.spawnParticlesFromServer(world, "DangerZone:ParticleSmoke", world.rand.nextInt(3) + 3, dimension, fx, fy, fz);
                                }
                            } else if (BreakChecks.canChangeBlock(thrower, dimension, ix, iy, iz, 0, 0) && Blocks.BlockArray[bid] != null && Blocks.BlockArray[bid] instanceof BlockInstability) {
                                b = (BlockInstability)Blocks.BlockArray[bid];
                                b.trigger(world, dimension, ix, iy, iz);
                            }
                        } else if (BreakChecks.canChangeBlock(thrower, dimension, ix, iy, iz, 0, 0) && Blocks.BlockArray[bid] != null && Blocks.BlockArray[bid] instanceof BlockInstability) {
                            b = (BlockInstability)Blocks.BlockArray[bid];
                            b.trigger(world, dimension, ix, iy, iz);
                        }
                        powerlost += (float)Blocks.getMaxDamage(bid);
                    }
                    if (world.rand.nextInt(spk) == 0) {
                        Utils.spawnParticlesFromServer(world, "DangerZone:ParticleSparkle", 1, dimension, fx, fy, fz);
                    }
                }
                curdist += 0.1701f;
            }
            if (fire) {
                lz = 0;
                ly = 0;
                lx = 0;
                while (curdist < dr * 2.0f) {
                    fx = x + dx * (double)curdist;
                    fy = y + dy * (double)curdist;
                    fz = z + dz * (double)curdist;
                    ix = (int)fx;
                    iy = (int)fy;
                    iz = (int)fz;
                    if (ix != lx || iy != ly || iz != lz) {
                        lx = ix;
                        ly = iy;
                        lz = iz;
                        bid = world.getblock(dimension, ix, iy, iz);
                        if (bid != 0) {
                            EntityFire eb;
                            if (Blocks.getBurnTime(bid) <= 0 || world.rand.nextInt(8) != 1 || (eb = (EntityFire)world.createEntityByName("DangerZone:Fire", dimension, (double)ix + 0.5, (double)iy - 0.0625, (double)iz + 0.5)) == null) break;
                            eb.init();
                            eb.started_by = thrower;
                            world.spawnEntityInWorld(eb);
                            break;
                        }
                    }
                    curdist += 0.3301f;
                }
            }
            ++i;
        }
        if (!doentitydamage) {
            return;
        }
        dr = raydist * 2.0f;
        List<Entity> nearby_list = null;
        Entity enthit = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(8.0f + dr, dimension, x, y, z);
        ListIterator<Entity> li = nearby_list.listIterator();
        while (li.hasNext()) {
            enthit = li.next();
            if (enthit == thrower || enthit.canthitme) continue;
            fx = x - enthit.posx;
            fy = y - enthit.posy;
            fz = z - enthit.posz;
            curdist = (float)Math.sqrt(fx * fx + fy * fy + fz * fz);
            if ((curdist -= enthit.getWidth() / 2.0f) < enthit.getWidth() / 2.0f) {
                curdist = enthit.getWidth() / 2.0f;
            }
            if (curdist < 1.0f) {
                curdist = 1.0f;
            }
            if (!(curdist < dr)) continue;
            if (fire && world.rand.nextInt(4) == 1) {
                enthit.doSetOnFire(25 + world.rand.nextInt(50 + world.rand.nextInt(50)));
            }
            if (!(enthit instanceof EntityBlock)) {
                enthit.doAttackFromCustom(null, 9, (float)pwr / (curdist * curdist), false);
            }
            float knockback = pwr / 8;
            knockback /= enthit.getWidth() * enthit.getHeight();
            if ((knockback /= curdist) > 10.0f) {
                knockback = 10.0f;
            }
            dir = Math.atan2(enthit.posz - z, enthit.posx - x);
            float hdist = (float)Math.sqrt((enthit.posx - x) * (enthit.posx - x) + (enthit.posz - z) * (enthit.posz - z));
            float ydir = (float)Math.atan2(enthit.posy + (double)(enthit.getHeight() / 2.0f) - y, hdist);
            enthit.motionx = (float)((double)enthit.motionx + Math.cos(dir) * (double)knockback * Math.cos(ydir));
            enthit.motionz = (float)((double)enthit.motionz + Math.sin(dir) * (double)knockback * Math.cos(ydir));
            enthit.motiony = (float)((double)enthit.motiony + (double)knockback * Math.sin(ydir));
            if (!(enthit instanceof Player)) continue;
            Player pl = (Player)enthit;
            pl.server_thread.sendVelocityUpdateToPlayer(enthit.motionx, enthit.motiony, enthit.motionz);
        }
    }
}

