/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrHapticsBuffer")
public class OVRHapticsBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;
    public static final int SUBMITMODE;

    public OVRHapticsBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRHapticsBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer Samples(int capacity) {
        return OVRHapticsBuffer.nSamples(this.address(), capacity);
    }

    public int SamplesCount() {
        return OVRHapticsBuffer.nSamplesCount(this.address());
    }

    @NativeType(value="ovrHapticsBufferSubmitMode")
    public int SubmitMode() {
        return OVRHapticsBuffer.nSubmitMode(this.address());
    }

    public OVRHapticsBuffer Samples(@NativeType(value="void *") ByteBuffer value) {
        OVRHapticsBuffer.nSamples(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SamplesCount(int value) {
        OVRHapticsBuffer.nSamplesCount(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SubmitMode(@NativeType(value="ovrHapticsBufferSubmitMode") int value) {
        OVRHapticsBuffer.nSubmitMode(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer set(ByteBuffer Samples, int SamplesCount, int SubmitMode) {
        this.Samples(Samples);
        this.SamplesCount(SamplesCount);
        this.SubmitMode(SubmitMode);
        return this;
    }

    public OVRHapticsBuffer set(OVRHapticsBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRHapticsBuffer malloc() {
        return (OVRHapticsBuffer)OVRHapticsBuffer.wrap(OVRHapticsBuffer.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRHapticsBuffer calloc() {
        return (OVRHapticsBuffer)OVRHapticsBuffer.wrap(OVRHapticsBuffer.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRHapticsBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRHapticsBuffer)OVRHapticsBuffer.wrap(OVRHapticsBuffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRHapticsBuffer create(long address) {
        return (OVRHapticsBuffer)OVRHapticsBuffer.wrap(OVRHapticsBuffer.class, (long)address);
    }

    @Nullable
    public static OVRHapticsBuffer createSafe(long address) {
        return address == 0L ? null : (OVRHapticsBuffer)OVRHapticsBuffer.wrap(OVRHapticsBuffer.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRHapticsBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRHapticsBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRHapticsBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRHapticsBuffer.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRHapticsBuffer.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRHapticsBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRHapticsBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRHapticsBuffer mallocStack() {
        return OVRHapticsBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsBuffer callocStack() {
        return OVRHapticsBuffer.callocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsBuffer mallocStack(MemoryStack stack) {
        return (OVRHapticsBuffer)OVRHapticsBuffer.wrap(OVRHapticsBuffer.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRHapticsBuffer callocStack(MemoryStack stack) {
        return (OVRHapticsBuffer)OVRHapticsBuffer.wrap(OVRHapticsBuffer.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRHapticsBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRHapticsBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRHapticsBuffer.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRHapticsBuffer.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nSamples(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLES)), (int)capacity);
    }

    public static int nSamplesCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLESCOUNT);
    }

    public static int nSubmitMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBMITMODE);
    }

    public static void nSamples(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SAMPLES), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nSamplesCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLESCOUNT, value);
    }

    public static void nSubmitMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBMITMODE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLES)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRHapticsBuffer.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = OVRHapticsBuffer.__struct((Struct.Member[])new Struct.Member[]{OVRHapticsBuffer.__member((int)POINTER_SIZE), OVRHapticsBuffer.__member((int)4), OVRHapticsBuffer.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
        SUBMITMODE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRHapticsBuffer, Buffer>
    implements NativeResource {
        private static final OVRHapticsBuffer ELEMENT_FACTORY = OVRHapticsBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRHapticsBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer Samples(int capacity) {
            return OVRHapticsBuffer.nSamples(this.address(), capacity);
        }

        public int SamplesCount() {
            return OVRHapticsBuffer.nSamplesCount(this.address());
        }

        @NativeType(value="ovrHapticsBufferSubmitMode")
        public int SubmitMode() {
            return OVRHapticsBuffer.nSubmitMode(this.address());
        }

        public Buffer Samples(@NativeType(value="void *") ByteBuffer value) {
            OVRHapticsBuffer.nSamples(this.address(), value);
            return this;
        }

        public Buffer SamplesCount(int value) {
            OVRHapticsBuffer.nSamplesCount(this.address(), value);
            return this;
        }

        public Buffer SubmitMode(@NativeType(value="ovrHapticsBufferSubmitMode") int value) {
            OVRHapticsBuffer.nSubmitMode(this.address(), value);
            return this;
        }
    }
}

