/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class GLFWVulkan {
    protected GLFWVulkan() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="int")
    public static boolean glfwVulkanSupported() {
        long __functionAddress = Functions.VulkanSupported;
        return JNI.invokeI((long)__functionAddress) != 0;
    }

    public static long nglfwGetRequiredInstanceExtensions(long count) {
        long __functionAddress = Functions.GetRequiredInstanceExtensions;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const **")
    public static PointerBuffer glfwGetRequiredInstanceExtensions() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = GLFWVulkan.nglfwGetRequiredInstanceExtensions(MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nglfwGetInstanceProcAddress(long instance, long procname) {
        long __functionAddress = Functions.GetInstanceProcAddress;
        return JNI.invokePPP((long)instance, (long)procname, (long)__functionAddress);
    }

    @NativeType(value="GLFWvkproc")
    public static long glfwGetInstanceProcAddress(@Nullable VkInstance instance, @NativeType(value="char const *") ByteBuffer procname) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)procname);
        }
        return GLFWVulkan.nglfwGetInstanceProcAddress(MemoryUtil.memAddressSafe((Pointer)instance), MemoryUtil.memAddress((ByteBuffer)procname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLFWvkproc")
    public static long glfwGetInstanceProcAddress(@Nullable VkInstance instance, @NativeType(value="char const *") CharSequence procname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(procname, true);
            long procnameEncoded = stack.getPointerAddress();
            long l = GLFWVulkan.nglfwGetInstanceProcAddress(MemoryUtil.memAddressSafe((Pointer)instance), procnameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="int")
    public static boolean glfwGetPhysicalDevicePresentationSupport(VkInstance instance, VkPhysicalDevice device, @NativeType(value="uint32_t") int queuefamily) {
        long __functionAddress = Functions.GetPhysicalDevicePresentationSupport;
        return JNI.invokePPI((long)instance.address(), (long)device.address(), (int)queuefamily, (long)__functionAddress) != 0;
    }

    public static int nglfwCreateWindowSurface(long instance, long window, long allocator, long surface) {
        long __functionAddress = Functions.CreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
            if (allocator != 0L) {
                VkAllocationCallbacks.validate((long)allocator);
            }
        }
        return JNI.invokePPPPI((long)instance, (long)window, (long)allocator, (long)surface, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int glfwCreateWindowSurface(VkInstance instance, @NativeType(value="GLFWwindow *") long window, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks allocator, @NativeType(value="VkSurfaceKHR *") LongBuffer surface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)surface, (int)1);
        }
        return GLFWVulkan.nglfwCreateWindowSurface(instance.address(), window, MemoryUtil.memAddressSafe((Pointer)allocator), MemoryUtil.memAddress((LongBuffer)surface));
    }

    @NativeType(value="VkResult")
    public static int glfwCreateWindowSurface(VkInstance instance, @NativeType(value="GLFWwindow *") long window, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks allocator, @NativeType(value="VkSurfaceKHR *") long[] surface) {
        long __functionAddress = Functions.CreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
            Checks.check((long[])surface, (int)1);
            if (allocator != null) {
                VkAllocationCallbacks.validate((long)allocator.address());
            }
        }
        return JNI.invokePPPPI((long)instance.address(), (long)window, (long)MemoryUtil.memAddressSafe((Pointer)allocator), (long[])surface, (long)__functionAddress);
    }

    static {
        String path;
        FunctionProvider fp;
        if (Platform.get() == Platform.MACOSX && (fp = VK.getFunctionProvider()) instanceof SharedLibrary && (path = ((SharedLibrary)fp).getPath()) != null) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                long _glfw_vulkan_library = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"_glfw_vulkan_library");
                MemoryUtil.memPutAddress((long)_glfw_vulkan_library, (long)MemoryUtil.memAddress((ByteBuffer)stack.UTF8((CharSequence)path)));
                GLFWVulkan.glfwVulkanSupported();
                MemoryUtil.memPutAddress((long)_glfw_vulkan_library, (long)0L);
            }
        }
    }

    public static final class Functions {
        public static final long VulkanSupported = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwVulkanSupported");
        public static final long GetRequiredInstanceExtensions = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetRequiredInstanceExtensions");
        public static final long GetInstanceProcAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetInstanceProcAddress");
        public static final long GetPhysicalDevicePresentationSupport = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetPhysicalDevicePresentationSupport");
        public static final long CreateWindowSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwCreateWindowSurface");

        private Functions() {
        }
    }
}

