/*
 * Decompiled with CFR 0.152.
 */
package gamerunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.List;

public class Runnit {
    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        if (os == null) {
            throw new IllegalStateException("os.name");
        }
        os = os.toLowerCase();
        return os.startsWith("windows");
    }

    public static File getJreExecutable() throws FileNotFoundException {
        String version;
        File exe = new File("./java/", "bin/java.exe");
        if (exe.isFile()) {
            return exe;
        }
        String jreDirectory = System.getProperty("java.home");
        if (jreDirectory == null) {
            jreDirectory = "./java/";
        }
        if (!(version = System.getProperty("java.version")).startsWith("1.8")) {
            throw new IllegalStateException("java.version");
        }
        exe = Runnit.isWindows() ? new File(jreDirectory, "bin/java.exe") : new File(jreDirectory, "bin/java");
        if (!exe.isFile()) {
            throw new FileNotFoundException(exe.toString());
        }
        return exe;
    }

    public static int launch(String which, List<String> cmdarray, int maxlines) throws IOException, InterruptedException {
        int r;
        byte[] buffer = new byte[1024];
        ProcessBuilder processBuilder = new ProcessBuilder(cmdarray);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        InputStream in = process.getInputStream();
        GregorianCalendar gcalendar = new GregorianCalendar();
        int nowmonth = gcalendar.get(2);
        int nowday = gcalendar.get(5);
        int nowhour = gcalendar.get(11);
        int nowminute = gcalendar.get(12);
        int nowyear = gcalendar.get(1);
        String st = "";
        if (which.equals("server")) {
            st = String.format("_%4d%2d%2d_%2d%2d", nowyear, nowmonth, nowday, nowhour, nowminute);
        }
        String filepath = "logs/" + which + st + ".log";
        File f = new File(filepath);
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        f.getParentFile().mkdirs();
        int linelimit = 0;
        os = new FileOutputStream(filepath);
        bos = new BufferedOutputStream(os, 10000);
        while ((r = in.read(buffer)) > 0) {
            if (linelimit > maxlines) continue;
            bos.write(buffer, 0, r);
            ++linelimit;
        }
        bos.close();
        os.close();
        return process.waitFor();
    }
}

