/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIQuaternion;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiQuatKey")
public class AIQuatKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;

    public AIQuatKey(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIQuatKey.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIQuatKey.nmTime(this.address());
    }

    @NativeType(value="struct aiQuaternion")
    public AIQuaternion mValue() {
        return AIQuatKey.nmValue(this.address());
    }

    public AIQuatKey mTime(double value) {
        AIQuatKey.nmTime(this.address(), value);
        return this;
    }

    public AIQuatKey mValue(@NativeType(value="struct aiQuaternion") AIQuaternion value) {
        AIQuatKey.nmValue(this.address(), value);
        return this;
    }

    public AIQuatKey mValue(Consumer<AIQuaternion> consumer) {
        consumer.accept(this.mValue());
        return this;
    }

    public AIQuatKey set(double mTime, AIQuaternion mValue) {
        this.mTime(mTime);
        this.mValue(mValue);
        return this;
    }

    public AIQuatKey set(AIQuatKey src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIQuatKey malloc() {
        return (AIQuatKey)AIQuatKey.wrap(AIQuatKey.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIQuatKey calloc() {
        return (AIQuatKey)AIQuatKey.wrap(AIQuatKey.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIQuatKey create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIQuatKey)AIQuatKey.wrap(AIQuatKey.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIQuatKey create(long address) {
        return (AIQuatKey)AIQuatKey.wrap(AIQuatKey.class, (long)address);
    }

    @Nullable
    public static AIQuatKey createSafe(long address) {
        return address == 0L ? null : (AIQuatKey)AIQuatKey.wrap(AIQuatKey.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIQuatKey.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIQuatKey.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIQuatKey.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIQuatKey.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIQuatKey.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIQuatKey.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIQuatKey.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIQuatKey mallocStack() {
        return AIQuatKey.mallocStack(MemoryStack.stackGet());
    }

    public static AIQuatKey callocStack() {
        return AIQuatKey.callocStack(MemoryStack.stackGet());
    }

    public static AIQuatKey mallocStack(MemoryStack stack) {
        return (AIQuatKey)AIQuatKey.wrap(AIQuatKey.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIQuatKey callocStack(MemoryStack stack) {
        return (AIQuatKey)AIQuatKey.wrap(AIQuatKey.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIQuatKey.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIQuatKey.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIQuatKey.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIQuatKey.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static double nmTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)MTIME);
    }

    public static AIQuaternion nmValue(long struct) {
        return AIQuaternion.create(struct + (long)MVALUE);
    }

    public static void nmTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)MTIME, value);
    }

    public static void nmValue(long struct, AIQuaternion value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MVALUE), (long)AIQuaternion.SIZEOF);
    }

    static {
        Struct.Layout layout = AIQuatKey.__struct((Struct.Member[])new Struct.Member[]{AIQuatKey.__member((int)8), AIQuatKey.__member((int)AIQuaternion.SIZEOF, (int)AIQuaternion.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIQuatKey, Buffer>
    implements NativeResource {
        private static final AIQuatKey ELEMENT_FACTORY = AIQuatKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIQuatKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double mTime() {
            return AIQuatKey.nmTime(this.address());
        }

        @NativeType(value="struct aiQuaternion")
        public AIQuaternion mValue() {
            return AIQuatKey.nmValue(this.address());
        }

        public Buffer mTime(double value) {
            AIQuatKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(@NativeType(value="struct aiQuaternion") AIQuaternion value) {
            AIQuatKey.nmValue(this.address(), value);
            return this;
        }

        public Buffer mValue(Consumer<AIQuaternion> consumer) {
            consumer.accept(this.mValue());
            return this;
        }
    }
}

