/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMetadataEntry")
public class AIMetaDataEntry
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTYPE;
    public static final int MDATA;

    public AIMetaDataEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMetaDataEntry.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="aiMetadataType")
    public int mType() {
        return AIMetaDataEntry.nmType(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer mData(int capacity) {
        return AIMetaDataEntry.nmData(this.address(), capacity);
    }

    public AIMetaDataEntry mType(@NativeType(value="aiMetadataType") int value) {
        AIMetaDataEntry.nmType(this.address(), value);
        return this;
    }

    public AIMetaDataEntry mData(@NativeType(value="void *") ByteBuffer value) {
        AIMetaDataEntry.nmData(this.address(), value);
        return this;
    }

    public AIMetaDataEntry set(int mType, ByteBuffer mData) {
        this.mType(mType);
        this.mData(mData);
        return this;
    }

    public AIMetaDataEntry set(AIMetaDataEntry src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIMetaDataEntry malloc() {
        return (AIMetaDataEntry)AIMetaDataEntry.wrap(AIMetaDataEntry.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIMetaDataEntry calloc() {
        return (AIMetaDataEntry)AIMetaDataEntry.wrap(AIMetaDataEntry.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIMetaDataEntry create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIMetaDataEntry)AIMetaDataEntry.wrap(AIMetaDataEntry.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIMetaDataEntry create(long address) {
        return (AIMetaDataEntry)AIMetaDataEntry.wrap(AIMetaDataEntry.class, (long)address);
    }

    @Nullable
    public static AIMetaDataEntry createSafe(long address) {
        return address == 0L ? null : (AIMetaDataEntry)AIMetaDataEntry.wrap(AIMetaDataEntry.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIMetaDataEntry.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIMetaDataEntry.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIMetaDataEntry.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMetaDataEntry.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIMetaDataEntry.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIMetaDataEntry.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIMetaDataEntry.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIMetaDataEntry mallocStack() {
        return AIMetaDataEntry.mallocStack(MemoryStack.stackGet());
    }

    public static AIMetaDataEntry callocStack() {
        return AIMetaDataEntry.callocStack(MemoryStack.stackGet());
    }

    public static AIMetaDataEntry mallocStack(MemoryStack stack) {
        return (AIMetaDataEntry)AIMetaDataEntry.wrap(AIMetaDataEntry.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMetaDataEntry callocStack(MemoryStack stack) {
        return (AIMetaDataEntry)AIMetaDataEntry.wrap(AIMetaDataEntry.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMetaDataEntry.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMetaDataEntry.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIMetaDataEntry.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIMetaDataEntry.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MTYPE);
    }

    public static ByteBuffer nmData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MDATA)), (int)capacity);
    }

    public static void nmType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MTYPE, value);
    }

    public static void nmData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MDATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MDATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMetaDataEntry.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AIMetaDataEntry.__struct((Struct.Member[])new Struct.Member[]{AIMetaDataEntry.__member((int)4), AIMetaDataEntry.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTYPE = layout.offsetof(0);
        MDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIMetaDataEntry, Buffer>
    implements NativeResource {
        private static final AIMetaDataEntry ELEMENT_FACTORY = AIMetaDataEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIMetaDataEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="aiMetadataType")
        public int mType() {
            return AIMetaDataEntry.nmType(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer mData(int capacity) {
            return AIMetaDataEntry.nmData(this.address(), capacity);
        }

        public Buffer mType(@NativeType(value="aiMetadataType") int value) {
            AIMetaDataEntry.nmType(this.address(), value);
            return this;
        }

        public Buffer mData(@NativeType(value="void *") ByteBuffer value) {
            AIMetaDataEntry.nmData(this.address(), value);
            return this;
        }
    }
}

