/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrMirrorTextureDesc")
public class OVRMirrorTextureDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MISCFLAGS;

    public OVRMirrorTextureDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRMirrorTextureDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrTextureFormat")
    public int Format() {
        return OVRMirrorTextureDesc.nFormat(this.address());
    }

    public int Width() {
        return OVRMirrorTextureDesc.nWidth(this.address());
    }

    public int Height() {
        return OVRMirrorTextureDesc.nHeight(this.address());
    }

    @NativeType(value="unsigned int")
    public int MiscFlags() {
        return OVRMirrorTextureDesc.nMiscFlags(this.address());
    }

    public OVRMirrorTextureDesc Format(@NativeType(value="ovrTextureFormat") int value) {
        OVRMirrorTextureDesc.nFormat(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc Width(int value) {
        OVRMirrorTextureDesc.nWidth(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc Height(int value) {
        OVRMirrorTextureDesc.nHeight(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc MiscFlags(@NativeType(value="unsigned int") int value) {
        OVRMirrorTextureDesc.nMiscFlags(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc set(int Format, int Width, int Height, int MiscFlags) {
        this.Format(Format);
        this.Width(Width);
        this.Height(Height);
        this.MiscFlags(MiscFlags);
        return this;
    }

    public OVRMirrorTextureDesc set(OVRMirrorTextureDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRMirrorTextureDesc malloc() {
        return (OVRMirrorTextureDesc)OVRMirrorTextureDesc.wrap(OVRMirrorTextureDesc.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRMirrorTextureDesc calloc() {
        return (OVRMirrorTextureDesc)OVRMirrorTextureDesc.wrap(OVRMirrorTextureDesc.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRMirrorTextureDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRMirrorTextureDesc)OVRMirrorTextureDesc.wrap(OVRMirrorTextureDesc.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRMirrorTextureDesc create(long address) {
        return (OVRMirrorTextureDesc)OVRMirrorTextureDesc.wrap(OVRMirrorTextureDesc.class, (long)address);
    }

    @Nullable
    public static OVRMirrorTextureDesc createSafe(long address) {
        return address == 0L ? null : (OVRMirrorTextureDesc)OVRMirrorTextureDesc.wrap(OVRMirrorTextureDesc.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRMirrorTextureDesc.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRMirrorTextureDesc.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRMirrorTextureDesc.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRMirrorTextureDesc.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRMirrorTextureDesc.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRMirrorTextureDesc.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRMirrorTextureDesc.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRMirrorTextureDesc mallocStack() {
        return OVRMirrorTextureDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRMirrorTextureDesc callocStack() {
        return OVRMirrorTextureDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRMirrorTextureDesc mallocStack(MemoryStack stack) {
        return (OVRMirrorTextureDesc)OVRMirrorTextureDesc.wrap(OVRMirrorTextureDesc.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRMirrorTextureDesc callocStack(MemoryStack stack) {
        return (OVRMirrorTextureDesc)OVRMirrorTextureDesc.wrap(OVRMirrorTextureDesc.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRMirrorTextureDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRMirrorTextureDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRMirrorTextureDesc.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRMirrorTextureDesc.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int nMiscFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)MISCFLAGS);
    }

    public static void nFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nMiscFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MISCFLAGS, value);
    }

    static {
        Struct.Layout layout = OVRMirrorTextureDesc.__struct((Struct.Member[])new Struct.Member[]{OVRMirrorTextureDesc.__member((int)4), OVRMirrorTextureDesc.__member((int)4), OVRMirrorTextureDesc.__member((int)4), OVRMirrorTextureDesc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        MISCFLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRMirrorTextureDesc, Buffer>
    implements NativeResource {
        private static final OVRMirrorTextureDesc ELEMENT_FACTORY = OVRMirrorTextureDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRMirrorTextureDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrTextureFormat")
        public int Format() {
            return OVRMirrorTextureDesc.nFormat(this.address());
        }

        public int Width() {
            return OVRMirrorTextureDesc.nWidth(this.address());
        }

        public int Height() {
            return OVRMirrorTextureDesc.nHeight(this.address());
        }

        @NativeType(value="unsigned int")
        public int MiscFlags() {
            return OVRMirrorTextureDesc.nMiscFlags(this.address());
        }

        public Buffer Format(@NativeType(value="ovrTextureFormat") int value) {
            OVRMirrorTextureDesc.nFormat(this.address(), value);
            return this;
        }

        public Buffer Width(int value) {
            OVRMirrorTextureDesc.nWidth(this.address(), value);
            return this;
        }

        public Buffer Height(int value) {
            OVRMirrorTextureDesc.nHeight(this.address(), value);
            return this;
        }

        public Buffer MiscFlags(@NativeType(value="unsigned int") int value) {
            OVRMirrorTextureDesc.nMiscFlags(this.address(), value);
            return this;
        }
    }
}

