/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrInputState")
public class OVRInputState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TIMEINSECONDS;
    public static final int BUTTONS;
    public static final int TOUCHES;
    public static final int INDEXTRIGGER;
    public static final int HANDTRIGGER;
    public static final int THUMBSTICK;
    public static final int CONTROLLERTYPE;
    public static final int INDEXTRIGGERNODEADZONE;
    public static final int HANDTRIGGERNODEADZONE;
    public static final int THUMBSTICKNODEADZONE;
    public static final int INDEXTRIGGERRAW;
    public static final int HANDTRIGGERRAW;
    public static final int THUMBSTICKRAW;

    public OVRInputState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRInputState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double TimeInSeconds() {
        return OVRInputState.nTimeInSeconds(this.address());
    }

    @NativeType(value="unsigned int")
    public int Buttons() {
        return OVRInputState.nButtons(this.address());
    }

    @NativeType(value="unsigned int")
    public int Touches() {
        return OVRInputState.nTouches(this.address());
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTrigger() {
        return OVRInputState.nIndexTrigger(this.address());
    }

    public float IndexTrigger(int index) {
        return OVRInputState.nIndexTrigger(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTrigger() {
        return OVRInputState.nHandTrigger(this.address());
    }

    public float HandTrigger(int index) {
        return OVRInputState.nHandTrigger(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer Thumbstick() {
        return OVRInputState.nThumbstick(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f Thumbstick(int index) {
        return OVRInputState.nThumbstick(this.address(), index);
    }

    @NativeType(value="ovrControllerType")
    public int ControllerType() {
        return OVRInputState.nControllerType(this.address());
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTriggerNoDeadzone() {
        return OVRInputState.nIndexTriggerNoDeadzone(this.address());
    }

    public float IndexTriggerNoDeadzone(int index) {
        return OVRInputState.nIndexTriggerNoDeadzone(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTriggerNoDeadzone() {
        return OVRInputState.nHandTriggerNoDeadzone(this.address());
    }

    public float HandTriggerNoDeadzone(int index) {
        return OVRInputState.nHandTriggerNoDeadzone(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer ThumbstickNoDeadzone() {
        return OVRInputState.nThumbstickNoDeadzone(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f ThumbstickNoDeadzone(int index) {
        return OVRInputState.nThumbstickNoDeadzone(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTriggerRaw() {
        return OVRInputState.nIndexTriggerRaw(this.address());
    }

    public float IndexTriggerRaw(int index) {
        return OVRInputState.nIndexTriggerRaw(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTriggerRaw() {
        return OVRInputState.nHandTriggerRaw(this.address());
    }

    public float HandTriggerRaw(int index) {
        return OVRInputState.nHandTriggerRaw(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer ThumbstickRaw() {
        return OVRInputState.nThumbstickRaw(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f ThumbstickRaw(int index) {
        return OVRInputState.nThumbstickRaw(this.address(), index);
    }

    public static OVRInputState malloc() {
        return (OVRInputState)OVRInputState.wrap(OVRInputState.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRInputState calloc() {
        return (OVRInputState)OVRInputState.wrap(OVRInputState.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRInputState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRInputState)OVRInputState.wrap(OVRInputState.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRInputState create(long address) {
        return (OVRInputState)OVRInputState.wrap(OVRInputState.class, (long)address);
    }

    @Nullable
    public static OVRInputState createSafe(long address) {
        return address == 0L ? null : (OVRInputState)OVRInputState.wrap(OVRInputState.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRInputState.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRInputState.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRInputState.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRInputState.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRInputState.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRInputState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRInputState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRInputState mallocStack() {
        return OVRInputState.mallocStack(MemoryStack.stackGet());
    }

    public static OVRInputState callocStack() {
        return OVRInputState.callocStack(MemoryStack.stackGet());
    }

    public static OVRInputState mallocStack(MemoryStack stack) {
        return (OVRInputState)OVRInputState.wrap(OVRInputState.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRInputState callocStack(MemoryStack stack) {
        return (OVRInputState)OVRInputState.wrap(OVRInputState.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRInputState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRInputState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRInputState.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRInputState.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static double nTimeInSeconds(long struct) {
        return UNSAFE.getDouble(null, struct + (long)TIMEINSECONDS);
    }

    public static int nButtons(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUTTONS);
    }

    public static int nTouches(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOUCHES);
    }

    public static FloatBuffer nIndexTrigger(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)INDEXTRIGGER), (int)2);
    }

    public static float nIndexTrigger(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)INDEXTRIGGER + Checks.check((int)index, (int)2) * 4L);
    }

    public static FloatBuffer nHandTrigger(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)HANDTRIGGER), (int)2);
    }

    public static float nHandTrigger(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)HANDTRIGGER + Checks.check((int)index, (int)2) * 4L);
    }

    public static OVRVector2f.Buffer nThumbstick(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICK, 2);
    }

    public static OVRVector2f nThumbstick(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICK + Checks.check((int)index, (int)2) * (long)OVRVector2f.SIZEOF);
    }

    public static int nControllerType(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONTROLLERTYPE);
    }

    public static FloatBuffer nIndexTriggerNoDeadzone(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)INDEXTRIGGERNODEADZONE), (int)2);
    }

    public static float nIndexTriggerNoDeadzone(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)INDEXTRIGGERNODEADZONE + Checks.check((int)index, (int)2) * 4L);
    }

    public static FloatBuffer nHandTriggerNoDeadzone(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)HANDTRIGGERNODEADZONE), (int)2);
    }

    public static float nHandTriggerNoDeadzone(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)HANDTRIGGERNODEADZONE + Checks.check((int)index, (int)2) * 4L);
    }

    public static OVRVector2f.Buffer nThumbstickNoDeadzone(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICKNODEADZONE, 2);
    }

    public static OVRVector2f nThumbstickNoDeadzone(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICKNODEADZONE + Checks.check((int)index, (int)2) * (long)OVRVector2f.SIZEOF);
    }

    public static FloatBuffer nIndexTriggerRaw(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)INDEXTRIGGERRAW), (int)2);
    }

    public static float nIndexTriggerRaw(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)INDEXTRIGGERRAW + Checks.check((int)index, (int)2) * 4L);
    }

    public static FloatBuffer nHandTriggerRaw(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)HANDTRIGGERRAW), (int)2);
    }

    public static float nHandTriggerRaw(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)HANDTRIGGERRAW + Checks.check((int)index, (int)2) * 4L);
    }

    public static OVRVector2f.Buffer nThumbstickRaw(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICKRAW, 2);
    }

    public static OVRVector2f nThumbstickRaw(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICKRAW + Checks.check((int)index, (int)2) * (long)OVRVector2f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRInputState.__struct((Struct.Member[])new Struct.Member[]{OVRInputState.__member((int)8), OVRInputState.__member((int)4), OVRInputState.__member((int)4), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)OVRVector2f.SIZEOF, (int)OVRVector2f.ALIGNOF, (int)2), OVRInputState.__member((int)4), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)OVRVector2f.SIZEOF, (int)OVRVector2f.ALIGNOF, (int)2), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)OVRVector2f.SIZEOF, (int)OVRVector2f.ALIGNOF, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TIMEINSECONDS = layout.offsetof(0);
        BUTTONS = layout.offsetof(1);
        TOUCHES = layout.offsetof(2);
        INDEXTRIGGER = layout.offsetof(3);
        HANDTRIGGER = layout.offsetof(4);
        THUMBSTICK = layout.offsetof(5);
        CONTROLLERTYPE = layout.offsetof(6);
        INDEXTRIGGERNODEADZONE = layout.offsetof(7);
        HANDTRIGGERNODEADZONE = layout.offsetof(8);
        THUMBSTICKNODEADZONE = layout.offsetof(9);
        INDEXTRIGGERRAW = layout.offsetof(10);
        HANDTRIGGERRAW = layout.offsetof(11);
        THUMBSTICKRAW = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<OVRInputState, Buffer>
    implements NativeResource {
        private static final OVRInputState ELEMENT_FACTORY = OVRInputState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRInputState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double TimeInSeconds() {
            return OVRInputState.nTimeInSeconds(this.address());
        }

        @NativeType(value="unsigned int")
        public int Buttons() {
            return OVRInputState.nButtons(this.address());
        }

        @NativeType(value="unsigned int")
        public int Touches() {
            return OVRInputState.nTouches(this.address());
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTrigger() {
            return OVRInputState.nIndexTrigger(this.address());
        }

        public float IndexTrigger(int index) {
            return OVRInputState.nIndexTrigger(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTrigger() {
            return OVRInputState.nHandTrigger(this.address());
        }

        public float HandTrigger(int index) {
            return OVRInputState.nHandTrigger(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer Thumbstick() {
            return OVRInputState.nThumbstick(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f Thumbstick(int index) {
            return OVRInputState.nThumbstick(this.address(), index);
        }

        @NativeType(value="ovrControllerType")
        public int ControllerType() {
            return OVRInputState.nControllerType(this.address());
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTriggerNoDeadzone() {
            return OVRInputState.nIndexTriggerNoDeadzone(this.address());
        }

        public float IndexTriggerNoDeadzone(int index) {
            return OVRInputState.nIndexTriggerNoDeadzone(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTriggerNoDeadzone() {
            return OVRInputState.nHandTriggerNoDeadzone(this.address());
        }

        public float HandTriggerNoDeadzone(int index) {
            return OVRInputState.nHandTriggerNoDeadzone(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer ThumbstickNoDeadzone() {
            return OVRInputState.nThumbstickNoDeadzone(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f ThumbstickNoDeadzone(int index) {
            return OVRInputState.nThumbstickNoDeadzone(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTriggerRaw() {
            return OVRInputState.nIndexTriggerRaw(this.address());
        }

        public float IndexTriggerRaw(int index) {
            return OVRInputState.nIndexTriggerRaw(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTriggerRaw() {
            return OVRInputState.nHandTriggerRaw(this.address());
        }

        public float HandTriggerRaw(int index) {
            return OVRInputState.nHandTriggerRaw(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer ThumbstickRaw() {
            return OVRInputState.nThumbstickRaw(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f ThumbstickRaw(int index) {
            return OVRInputState.nThumbstickRaw(this.address(), index);
        }
    }
}

