package dangerzone.threads;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import java.util.Iterator;

import dangerzone.CreatureTypes;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.ServerHooker;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.rendering.Fastmath;
import dangerzone.world.Chunk;
import dangerzone.world.Dimensions;
import dangerzone.world.Spawnlist;
import dangerzone.world.SpawnlistEntry;
import dangerzone.world.World;


public class SpawnerThread implements Runnable {
	public int spawnmax = 12; //chunks!
	public int spawnmin = 4;

	public void run() {
		int i, j;
		Player p;
		
		//Let things settle down a little first...
		try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		while(DangerZone.gameover == 0){
			
			try {
				Thread.sleep(5000);				
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			if(DangerZone.gameover != 0)return;
			if(DangerZone.f12_on)continue; //PAUSED		
			
			//pick a random block some distance away	
			spawnmax = DangerZone.renderdistance - 4; //chunks!
			if(spawnmax < 12)spawnmax = 12;
			spawnmin = 4;
			
			i = DangerZone.server_world.rand.nextInt(spawnmax-spawnmin);
			j = DangerZone.server_world.rand.nextInt(spawnmax-spawnmin);
			i += spawnmin;
			j += spawnmin;

			
			p = DangerZone.server.getRandomPlayer(DangerZone.server_world.rand); //Tick all active dimensions!
			if(p == null)continue;
			float v = (float) Math.sqrt((p.motionx*p.motionx)+(p.motionz*p.motionz));
			//System.out.printf("v = %f\n",v);
			
			if(DangerZone.showcase || v > 0.2f) { //walking appears to be about 0.43f
				//target spawning in the general direction the player is traveling!
				//make it more interesting!
				if(Math.abs(p.motionx) > 2*Math.abs(p.motionz)) {
					if(p.motionx < 0)i = -i;
				}else if(Math.abs(p.motionz) > 2*Math.abs(p.motionx)) {
					if(p.motionz < 0)j = -j;
				}else {
					if(p.motionx < 0)i = -i;
					if(p.motionz < 0)j = -j;
				}
			}else {			
				if(Fastmath.nextBoolean())i = -i;
				if(Fastmath.nextBoolean())j = -j;
			}
			
			if(!tickChunk(DangerZone.server_world, p.dimension, (i<<4)+(int)p.posx, (j<<4)+(int)p.posz, CreatureTypes.TRANSIENT))continue;	//do TRANSIENT spawning only!
			
			//and now spawn a cloud or two..
			i = DangerZone.server_world.rand.nextInt((DangerZone.entityupdatedist/16)-1);
			j = DangerZone.server_world.rand.nextInt((DangerZone.entityupdatedist/16)-1);

			if(Fastmath.nextBoolean())i = -i;
			if(Fastmath.nextBoolean())j = -j;
			
			if(Dimensions.DimensionArray[p.dimension].cloud_enable && Fastmath.nextInt(5) == 1){
				Entity eb = DangerZone.server_world.createEntityByName("DangerZone:Cloud", p.dimension, (i<<4)+(int)p.posx, 200, (j<<4)+(int)p.posz);
				if(eb != null){
					eb.init();
					DangerZone.server_world.spawnEntityInWorld(eb);
				}
			}	
			
		}
	}
	
	public boolean tickChunk(World w, int dim, int xrel, int zrel, int perm){	
		if(!w.serverchunkcache.DecoratedChunkExists(dim, xrel, 0, zrel))return false;
		Chunk c = w.serverchunkcache.getDecoratedChunk(dim, xrel, 0, zrel);
		if(c == null)return false;
		doSpawnChunk(c, w, dim, xrel, zrel, perm);
		return true;
	}
		
	//also called by the chunk decorator!		
	public static void doSpawnChunk(Chunk c, World w, int dim, int xrel, int zrel, int perm){
		int i, j, k, bid;
		
		Iterator<SpawnlistEntry> ii = Spawnlist.spawnlist.iterator();
		SpawnlistEntry st;		
		while(ii.hasNext()){
			st = ii.next();
			if(st.permanence != perm)continue; //do the correct type!
			
			if(st.more_rare){ //extra rareness!!!
				if(w.rand.nextInt(16)!=1)continue;
			}
						
			//System.out.printf("check spawning %s\n", st.whatToSpawn.uniquename);
			if(st.chance >= w.rand.nextInt(1000)){	//YES 1000!!! allows better control.			
				if(st.dimensionname != null){
					if(!Dimensions.DimensionArray[dim].isNameMatch(st.dimensionname, c.chunkX,  c.chunkZ)){
						continue;
					}
				}
				if(st.biomename != null){
					if(!st.biomename.equals(w.getBiome(c.dimension, xrel, 0, zrel).uniquename)){
						continue;
					}
				}			
				
				if(!ServerHooker.canSpawnHere(w, dim, (c.chunkX<<4),  (c.chunkZ<<4), st))continue;
				if(!Dimensions.DimensionArray[dim].canSpawnHere(w, dim, (c.chunkX<<4),  (c.chunkZ<<4), st))continue;
				
				//if(perm == CreatureTypes.TRANSIENT)System.out.printf("try spawning %s\n", st.whatToSpawn.uniquename);
				
				//match! Let's do this thing!
				for(int tries = 0;tries < st.tries; tries++){
					int iy;
					int xpos = 2 + w.rand.nextInt(14); //try to stay in chunk
					int zpos = 2 + w.rand.nextInt(14);
					
					if(st.type == CreatureTypes.LAND){ 
						int ih = (int) (st.whatToSpawn.getHeight() + 1);

						iy = st.maxy;						
						for(;iy > st.miny; iy--){
							bid = w.getblock(c.dimension, (c.chunkX<<4)+xpos, iy, (c.chunkZ<<4)+zpos);
							if(Blocks.isLiquid(bid))break;
							if(bid == 0)continue;
							if(Blocks.isLeaves(bid))continue;
							if(!Blocks.isDirt(bid) && !Blocks.isStone(bid))continue;
							if(!Blocks.isSolid(bid))continue;
							//bid = w.getblock(c.dimension, (c.chunkX<<4)+xpos, iy+1, (c.chunkZ<<4)+zpos);
							//if(bid != 0 && bid != Blocks.grass.blockID)break; //Don't go underground!
							if(isSolidAtLevel(w, c.dimension, (c.chunkX<<4)+xpos, iy, (c.chunkZ<<4)+zpos, st.whatToSpawn.getWidth())){
								if(!isSolidAtLevel(w, c.dimension, (c.chunkX<<4)+xpos, iy+1, (c.chunkZ<<4)+zpos, st.whatToSpawn.getWidth())){
									//found an empty spot over a solid. See if we fit here...
									boolean fits = true;
									if(ih > 1){
										for(j=2;j<=ih && fits;j++){
											if(isSolidAtLevel(w, c.dimension, (c.chunkX<<4)+xpos, iy+j, (c.chunkZ<<4)+zpos, st.whatToSpawn.getWidth()))fits = false;
										}
									}
									if(fits){
										//System.out.printf("entity %s fits!\n", st.whatToSpawn.uniquename);
										if(st.permanence == CreatureTypes.PERMANENT || st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (int)((c.chunkX<<4)+xpos), (int)(iy+1.01f), (int)((c.chunkZ<<4)+zpos))){
											//System.out.printf("spawning %s @ %d, %d, %d, %d\n", st.whatToSpawn.uniquename, c.dimension, (int)((c.chunkX<<4)+xpos+0.5f), (int)(iy+0.5f), (int)((c.chunkZ<<4)+zpos+0.5f));
											Entity eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (c.chunkX<<4)+xpos, (double)iy+1.01f, (c.chunkZ<<4)+zpos);
											if(eb != null){
												eb.init();
												w.spawnEntityInWorld(eb);
											}
											//System.out.printf("Spawned %s at %d,  %d, %d\n", st.whatToSpawn.uniquename, (int)((c.chunkX<<4)+xpos), (int)(iy+1.01f), (int)((c.chunkZ<<4)+zpos));
											break;
										}				
									}
									
								}
								break; //we tried here once. Don't try underground...
							}
						}
					}else if(st.type == CreatureTypes.AIR){	
						iy = w.rand.nextInt((st.maxy-st.miny)+1);
						iy += st.miny;
						int iw = (int) (st.whatToSpawn.getWidth()/2 + 0.5f);
						int ih = (int) (st.whatToSpawn.getHeight() + 1);
						boolean fits = true;
						//System.out.printf("%s: iw, ih, iy %d, %d, %d\n", st.whatToSpawn.uniquename, iw, ih, iy);
						for(i=-iw;i<=iw && fits;i++){
							for(k=-iw;k<=iw && fits;k++){
								for(j=0;j<=ih && fits;j++){
									bid = w.getblock(c.dimension, (c.chunkX<<4)+xpos+i, iy+j, (c.chunkZ<<4)+zpos+k);
									//System.out.printf("bid = %d\n",  bid);
									if(bid != 0 && (Blocks.isSolid(bid))) { //NOT over water!
										//System.out.printf("fit is false\n");
										fits = false;
									}
								}
							}
						}
						if(fits) { //double-check NOT over water!
							for(i = iy+1;i>30;i--){	
								bid = w.getblock(c.dimension, (c.chunkX<<4)+xpos, i, (c.chunkZ<<4)+zpos);
								if(Blocks.isLiquid(bid)) {
									//System.out.printf("liquid fit is false\n");
									fits = false;
									break;
								}
							}
						}
						if(fits){
							//System.out.printf("entity %s fits!\n", st.whatToSpawn.uniquename);
							if(st.permanence == CreatureTypes.PERMANENT || st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (int)((c.chunkX<<4)+xpos), (int)(iy+0.5f), (int)((c.chunkZ<<4)+zpos))){
								//System.out.printf("spawning %s @ %d, %d, %d, %d\n", st.whatToSpawn.uniquename, c.dimension, (int)((c.chunkX<<4)+xpos), (int)(iy+0.5f), (int)((c.chunkZ<<4)+zpos));
								Entity eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (c.chunkX<<4)+xpos, (double)iy+0.5f, (c.chunkZ<<4)+zpos);
								if(eb != null){
									eb.init();
									w.spawnEntityInWorld(eb);
								}
							}
						}
					}else if(st.type == CreatureTypes.WATER){ 
						int ih = (int) (st.whatToSpawn.getHeight() + 1);
						iy = st.maxy;	
						//System.out.printf("water entity %s\n", st.whatToSpawn.uniquename);
						for(;iy>st.miny;iy--){							
							bid = w.getblock(c.dimension, (c.chunkX<<4)+xpos, iy, (c.chunkZ<<4)+zpos);
							if(bid != Blocks.water.blockID && bid != Blocks.waterstatic.blockID)continue;
							if(w.getblock(c.dimension, (c.chunkX<<4)+xpos, iy+1, (c.chunkZ<<4)+zpos) == 0){
								//found an empty spot over water. See if we fit here...
								//System.out.printf("entity %s trying\n", st.whatToSpawn.uniquename);
								boolean fits = true;
								if(ih > 1){
									for(j=2;j<=ih && fits;j++){
										if(isSolidAtLevel(w, c.dimension, (c.chunkX<<4)+xpos, iy+j, (c.chunkZ<<4)+zpos, st.whatToSpawn.getWidth()))fits = false;
									}
								}
								if(fits){
									//System.out.printf("entity %s fits!\n", st.whatToSpawn.uniquename);
									if(st.permanence == CreatureTypes.PERMANENT || st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (int)((c.chunkX<<4)+xpos), (int)(iy+1.01f), (int)((c.chunkZ<<4)+zpos))){
										//System.out.printf("spawning %s @ %d, %d, %d, %d\n", st.whatToSpawn.uniquename, c.dimension, (int)((c.chunkX<<4)+xpos+0.5f), (int)(iy+0.5f), (int)((c.chunkZ<<4)+zpos+0.5f));
										Entity eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (c.chunkX<<4)+xpos, (double)iy+1.01f, (c.chunkZ<<4)+zpos);
										if(eb != null){
											eb.init();
											w.spawnEntityInWorld(eb);
										}
										break;
									}
								}
								break;
							}
						}
					}else if(st.type == CreatureTypes.UNDERGROUND){ 
						int ih = (int) (st.whatToSpawn.getHeight() + 1);
						iy = st.miny;
						//start at bottom, and go UP.
						for(;iy<st.maxy;iy++){
							if(isSolidAtLevel(w, c.dimension, (c.chunkX<<4)+xpos, iy, (c.chunkZ<<4)+zpos, st.whatToSpawn.getWidth())){
								if(!isSolidAtLevel(w, c.dimension, (c.chunkX<<4)+xpos, iy+1, (c.chunkZ<<4)+zpos, st.whatToSpawn.getWidth())
										&& !Blocks.isLiquid(w.getblock(c.dimension, (c.chunkX<<4)+xpos, iy+1, (c.chunkZ<<4)+zpos))){
									//found an empty spot over a solid. See if we fit here...
									boolean fits = true;
									if(ih > 1){
										for(j=2;j<=ih && fits;j++){
											if(isSolidAtLevel(w, c.dimension, (c.chunkX<<4)+xpos, iy+j, (c.chunkZ<<4)+zpos, st.whatToSpawn.getWidth()))fits = false;
										}
									}
									if(fits){
										//System.out.printf("entity %s fits!\n", st.whatToSpawn.uniquename);
										if(st.permanence == CreatureTypes.PERMANENT || st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (int)((c.chunkX<<4)+xpos), (int)(iy+1.01f), (int)((c.chunkZ<<4)+zpos))){
											//System.out.printf("spawning %s @ %d, %d, %d, %d\n", st.whatToSpawn.uniquename, c.dimension, (int)((c.chunkX<<4)+xpos+0.5f), (int)(iy+0.5f), (int)((c.chunkZ<<4)+zpos+0.5f));
											Entity eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (c.chunkX<<4)+xpos, (double)iy+1.01f, (c.chunkZ<<4)+zpos);
											if(eb != null){
												eb.init();
												w.spawnEntityInWorld(eb);
											}
										}
										break;
									}
								}
							}
						}
					}
				}
				//System.out.printf("done trying spawning %s\n", st.whatToSpawn.uniquename);
			}
		}
	}
	
	//Check all around the entity WIDTH to see if it is solid.
	//Used for Y collisions
	public static boolean isSolidAtLevel(World w, int d, int x, int y, int z, float width){
		int intwidth = (int)((width/2.0f)+0.5f);
		int i, j;
		int itemp;
		double dx, dz;
		for(i=-intwidth;i<=intwidth;i++){
			for(j=-intwidth;j<=intwidth;j++){
				if(Blocks.isSolid(w.getblock(d, (int)x+i, (int)y, (int)z+j))){
					itemp = (int)(x)+i;
					dx = (double)x - ((double)itemp + 0.5f);
					dx = Math.abs(dx);
					if(dx < (0.49f + (width/2.0f))){
						itemp = (int)(z)+j;
						dz = (double)z - ((double)itemp + 0.5f);
						dz = Math.abs(dz);
						if(dz < (0.49f + (width/2.0f))){
							return true;
						}
					}
				}
			}
		}
		return false;
	}
	
	
}
