package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.blocks.Blocks;
import dangerzone.rendering.Fastmath;
import dangerzone.world.World;

public class CaveBuilder implements Runnable {
	
	World w;
	int d, cx, cz, rr;
	float mx, mxl;
	double stx, sty, stz;

	public  CaveBuilder(World world, int dimension, int chunkx, int chunkz, int recur, float mxw, float mxlen, double startx, double starty, double startz) {
		w = world;
		d = dimension;
		cx = chunkx;
		cz = chunkz;
		rr = recur;
		mx = mxw;
		mxl = mxlen;
		stx = startx;
		sty = starty;
		stz = startz;
	}
	
	public void run()  {
		add_a_cave(w, d, cx, cz, rr, mx, mxl, stx, sty, stz);
	}
		
	
	/*
	 * Generates a cave. Der....
	 */
	public void add_a_cave(World world, int dimension, int chunkx, int chunkz, int recur, float mxw, float mxlen, double startx, double starty, double startz){
		//double startx, starty, startz;
		double dxz, dy;
		double ddxz, ddy;
		double width;
		double length;
		double currentwidth;
		double currad;
		double curx, cury, curz;
		double tx, tz;
		double ty;
		double dirang;
		double tt;
		double dirax, diraz;
		int da;
		int bid;
		
		if(!DangerZone.generatecaves)return;
		if(recur > 2)return;
		if(mxw < 0)return;
		if(mxlen < 10)return;
		
		//caves are somewhat rare, but when they do occur, they tend to be clumpy and awesome...
		if(recur == 0){
			if(Fastmath.nextInt(32+((chunkx)&0x3f)*8 + ((chunkz)&0x3f)*8) != 0)return; //clumpy, but not too many or it overloads the graphics memory...
		}
		
		dxz = Fastmath.nextFloat()*360f;
		dy = (Fastmath.nextFloat()-Fastmath.nextFloat())*25f;
		ddxz = Fastmath.nextFloat()-Fastmath.nextFloat();
		ddy = Fastmath.nextFloat()-Fastmath.nextFloat();
		ddxz *= 2;
		width = 2 + Fastmath.nextFloat()*mxw;
		length = mxlen + Fastmath.nextFloat()*mxlen;
		curx = startx;
		cury = starty;
		curz = startz;
		for(int i = 0;i<length;i++){
			if(cury > 35){
				if(dy>0)dy=-dy;
				if(ddy>0)ddy=-ddy;
			}
			if(cury < 0){
				if(dy<0)dy=-dy;
				if(ddy<0)ddy=-ddy;
			}
			
			if(Fastmath.nextInt(25) == 1){
				Thread.yield();
				add_a_cave(world, dimension, chunkx, chunkz, recur+1, (float)(mxw-1), (float)(length/2), curx, cury, curz);
			}
			currentwidth = (float) Fastmath.sin((float)i/length*Math.PI)*width;
			if(currentwidth > 1){
				da = 10;
				if(currentwidth < 4)da = 15;
				if(currentwidth > 6)da = 5;
				dirang = (float) Math.toRadians(dxz-90);
				dirax = (float) Fastmath.cos(dirang);
				diraz = (float) Fastmath.sin(dirang);
				for(int j=0;j<360;j+=da){
					currad = 0;				
					ty = (float) Fastmath.sin(Math.toRadians(j));
					tt = (float) Fastmath.cos(Math.toRadians(j));
					tx = (float) (dirax*tt);
					tz = (float) (diraz*tt);				
					while(currad < currentwidth){
						currad += 0.20f;
						if((int)(cury + ty*currad) > 0){
							bid = world.getblock(dimension, (int)(curx + tx*currad), (int)(cury + ty*currad), (int)(curz + tz*currad));
							if(Blocks.isSolid(bid))world.setblocknonotify(dimension, (int)(curx + tx*currad), (int)(cury + ty*currad), (int)(curz + tz*currad), 0);
						}
					}				
				}
			}
			curx += Fastmath.cos(Math.toRadians(dxz));
			curz += Fastmath.sin(Math.toRadians(dxz));
			dxz += ddxz;
			cury += Fastmath.sin(Math.toRadians(dy));
			dy += ddy;
			//maybe do some direction changes...
			if(Fastmath.nextInt(20) == 1){
				dy = (Fastmath.nextFloat()-Fastmath.nextFloat())*25f;
				ddy = Fastmath.nextFloat()-Fastmath.nextFloat();
			}
			if(Fastmath.nextInt(50) == 1){
				dxz += Fastmath.nextFloat()*45f;
				ddxz = Fastmath.nextFloat()-Fastmath.nextFloat();
				ddxz *= 2;
			}
		}
		
		//Give up some time. We just hammered things...
		Thread.yield();
	}

}
