package dangerzone.rendering;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */




import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import slick.ColorSlick;
import slick.TrueTypeFont;
import slick.Texture;
import slick.TextureImpl;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.world.Dimensions;
import dangerzone.world.World;



public class WorldRendererUtils {
	
	
	private static boolean square3D_compiled = false;
	private static int squareid3D;
	
	private static final int blockrenderwidth = 16;
	public static Texture hotbarbackground = null;
	public static Texture firetexture = null;
	private static boolean fire_compiled = false;
	private static int fire_list1, fire_list2, fire_list3, fire_list4;
	private static int fire_list5, fire_list6, fire_list7, fire_list8;
	private static float sunspin = 0;
	private static int blink = 0;
	private static Entity curr_entity = null;
	private static int curr_entity_count = 0; //60 frames per second, so 60 == 1 second!
	private static float pitchdir = 0.3f;
	private static float yawdir = 0.35f;
	private static float ticker = 0;
	private static float curr_yaw = 0;
	private static float curr_pitch = 0;


	
	public static void drawShowcaseMonster(int whichview){
		
		while(curr_entity == null){
			curr_entity = Entities.random_entity();
			
			if(Fastmath.nextInt(100)==1)curr_entity = DangerZone.player; //show the player too!
			//must have model and texture!!!
			if(curr_entity.model == null)curr_entity = null;
			if(curr_entity != null){
				if(curr_entity.getTexture() == null)curr_entity = null;
			}
			if(curr_entity != null){
				curr_entity.init();
				curr_yaw = Fastmath.nextInt(360);
				curr_pitch = Fastmath.nextInt(60)-30;				
				if(DangerZone.world != null && curr_entity != DangerZone.player){
					curr_entity.world = DangerZone.world; //Don't mess with player world, just because...					
					if(DangerZone.monitor_enable) { //Don't play if monitor is off!
						DangerZone.world.playSound(curr_entity.getLivingSound(), DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.5f, 1);
					}
				}
				curr_entity_count = 450;
				if(Fastmath.nextInt(100)>49)yawdir = -yawdir;			
			}			
		}
		
		if(whichview == 0) {
			ticker++;
			if(ticker > 1000000)ticker = 0;
			curr_yaw += yawdir;
			curr_pitch += pitchdir;
			if(curr_pitch > 30)pitchdir = -0.25f;
			if(curr_pitch < -30)pitchdir = 0.25f;
			curr_entity_count--;
		}
		
		
		MatrixStack.identity();//get this ready!		
		MatrixStack.translate(DangerZone.wr.shift_x, -((curr_entity.getHeight()/2)*blockrenderwidth)+DangerZone.wr.shift_y, 
							-((2.5f + curr_entity.getWidth()*2.5f + curr_entity.getHeight()*1.75f)*blockrenderwidth));
		
		MatrixStack.sendCurrentStack();
		MatrixStack.pushMatrix();//get this ready!
		//Rotate it around								
		
		if(curr_yaw != 0)MatrixStack.rotate( curr_yaw, 0.0f, 1.0f, 0.0f); // Rotate The Entity On X, Y & Z
		if(curr_pitch != 0)MatrixStack.rotate( curr_pitch, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
		
		MatrixStack.sendCurrentStack();
		MatrixStack.pushMatrix();//get this ready!
		
		GL11.glColor3f(0.95f, 0.95f, 0.95f);
		//Now all it has to do is draw itself.
		
		ModelBase emodel = curr_entity.model;
		loadtexture(curr_entity.getTexture()); 		//Get a texture for it	
		
		emodel.doScale(curr_entity);	
		MatrixStack.sendCurrentStack();
		emodel.render(curr_entity, ticker, 0.11f, 0, 0, 0, 1f);	//Draw!	
		
		MatrixStack.popMatrix();	
		MatrixStack.popMatrix();	
		/*
		 * Get into menu mode...
		 */		
		GL20.glUseProgram( 0 ); //stop with the shaders already...	
		//puts 0,0 (x,y) at lower left of screen!
		GL11.glDisable(GL11.GL_DEPTH_TEST);
		GL11.glMatrixMode(GL11.GL_PROJECTION);
		GL11.glLoadIdentity();
		//puts 0,0 (x,y) at lower left of screen!
		GL11.glOrtho(0,DangerZone.screen_width,0,DangerZone.screen_height,-320,320);
	
		GL11.glMatrixMode(GL11.GL_MODELVIEW);
		GL11.glLoadIdentity();
		GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

		
		//Put up the entity name!
		textAt(DangerZone.font, DangerZone.get_left(whichview)+50, DangerZone.get_bottom(whichview)+150, curr_entity.uniquename);
		
		if(curr_entity_count <= 0)curr_entity = null;
	}
	
	public static void loadtexture(Texture lt){
		if(lt == null)return;
		TextureImpl.unbind(); //force reset
		lt.bind();
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_NEAREST);
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_NEAREST);
		GL11.glAlphaFunc ( GL11.GL_GREATER, 0.1f ) ;
		GL11.glEnable ( GL11.GL_ALPHA_TEST ) ;	
		GL11.glEnable(GL14.GL_COLOR_SUM);
	}

	
	public static void textAt(TrueTypeFont ff, float xpos, float ypos, String text){
							
		GL11.glTranslatef(xpos, ypos, 0f); 
		GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!			
		ff.drawString(0, 0, text, ColorSlick.lightGray);		
		GL11.glRotatef(-180.0f, 1.0f, 0.0f, 0.0f);
		GL11.glTranslatef(-xpos, -ypos, 0f); 
	}
	
	
	public static void textAt3D(TrueTypeFont ff, float xpos, float ypos, String text){
				
		GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!
		GL11.glAlphaFunc ( GL11.GL_GREATER, 0.1f ) ;
		GL11.glEnable ( GL11.GL_ALPHA_TEST ) ;	
		GL11.glEnable(GL14.GL_COLOR_SUM);
					
		MatrixStack.translate(xpos, ypos, 0f); 
		MatrixStack.rotate(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!
		MatrixStack.sendCurrentStack();
		ff.drawString3D(0, 0, text, ColorSlick.lightGray);		

	}
	
	//Mostly for items, which are almost never solid
	public static void drawSquare(){

		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(1,0);
		GL11.glVertex3f(blockrenderwidth/2, blockrenderwidth/2, 0); // Flat square
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(-blockrenderwidth/2, blockrenderwidth/2, 0); // 
		GL11.glTexCoord2f(0,1);
		GL11.glVertex3f(-blockrenderwidth/2, -blockrenderwidth/2, 0); // 
		GL11.glTexCoord2f(1,1);
		GL11.glVertex3f(blockrenderwidth/2, -blockrenderwidth/2, 0); // 
		GL11.glEnd(); // Done Drawing The Quad

		GL11.glDisable(GL11.GL_BLEND);
	}
	
    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }
	
	public static void drawSquare3D(){
		
		if(!square3D_compiled){
			//squareid3D = DangerZone.wr.getNextRenderID();
			//GL11.glNewList(squareid3D, GL11.GL_COMPILE);
			//GL11.glBegin(GL11.GL_QUADS);	
			//GL11.glTexCoord2f(1,0);
			//GL11.glVertex3f(blockrenderwidth/2, blockrenderwidth/2, 0); // Flat square
			//GL11.glTexCoord2f(0,0);
			//GL11.glVertex3f(-blockrenderwidth/2, blockrenderwidth/2, 0); // 
			//GL11.glTexCoord2f(0,1);
			//GL11.glVertex3f(-blockrenderwidth/2, -blockrenderwidth/2, 0); // 
			//GL11.glTexCoord2f(1,1);
			//GL11.glVertex3f(blockrenderwidth/2, -blockrenderwidth/2, 0); // 
			//GL11.glEnd(); // Done Drawing The Quad
			//GL11.glEndList();
			int stride = 3*4; //xyz coord size (floats!)
			int textureoff = stride;
			stride += 2*4; //texture coord size
			int coloroff = stride;
			stride += 3*4; //rgb (brightness bytes!)	
			
			squareid3D = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(squareid3D);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);		
			
	    	ByteBuffer vbodata = BufferUtils.createByteBuffer(4*stride); // size   	    	
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, 0, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, 0, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1, 1f, 1f, 1f);
	    		    	
	    	vbodata.flip();
	    	int vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
	    	
			square3D_compiled = true;
		}
		
		MatrixStack.sendFinalStack();
		
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);
		
		GL30.glBindVertexArray(squareid3D);
		
		GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);
				
		GL30.glBindVertexArray(0);
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);
		
		//GL11.glCallList(squareid);
		GL11.glDisable(GL11.GL_BLEND);
	}
	
	public static float getLightMapValue(World w, int d, int x, int y, int z){
		return w.chunkcache.getDecoratedChunkLightmapVal(d, x, y, z);
	}
	
	public static float getTotalLightAt(World w, int d, int x, int y, int z){
		return getBrightnessForLevel(d, y) + w.chunkcache.getDecoratedChunkLightmapVal(d, x, y, z);
	}
	
	public static float getBrightnessForLevel(int d, int yp){
		float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
		float fsin = (float) Math.sin(Math.toRadians((tod/(float)DangerZone.world.lengthOfDay)*360f));
		fsin *= 1.75f;
		if(fsin > 1)fsin = 1;
		if(DangerZone.no_dark) {
			if(fsin < -0.25f )fsin = -0.25f;
		}
		if(fsin < -1)fsin = -1;
		float f = 0.50f + 0.45f*fsin;
		if(yp < 50 && Dimensions.DimensionArray[d].fade_light_level){
			if(yp < 0)yp = 0;
			float f2 = (float)yp/(50.0f + (50f-yp));
			f *= f2;
		}
		return f;
	}
	
	//convenience box...
	public static void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize){
		DangerZone.wr.forceloadtexture(t);
		float w = t.getWidth();
		float h = t.getHeight();
		GL11.glPushMatrix(); //save position
		GL11.glTranslatef(xpos, ypos, 0f); 
		GL11.glScalef(xsize/t.getWidth(), ysize/t.getHeight(), 1f);
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(w,0);
		GL11.glVertex3f(1, 1, 0); // Top Right
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(0, 1, 0); // Top Left
		GL11.glTexCoord2f(0,h);
		GL11.glVertex3f(0, 0, 0); // Bottom left
		GL11.glTexCoord2f(w,h);
		GL11.glVertex3f(1, 0, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		GL11.glPopMatrix();
	}
	

	private static void drawhotbarbackground(){
		if(hotbarbackground == null){
			hotbarbackground = TextureMapper.getTexture("res/menus/bkg1.png");
		}
		//GL11.glTranslatef(0, 0, 0f);
		GL11.glScalef(3.25f, 3.25f, 3.25f);					
		DangerZone.wr.loadtexture(hotbarbackground);
		drawSquare();
		GL11.glScalef(1.0f/3.25f, 1.0f/3.25f, 1.0f/3.25f);
		//GL11.glTranslatef(-8, 8, 0f);
	}
	
	
	public static void textAt( float xpos, float ypos, String text){
		DangerZone.wr.loadtexture(Blocks.stone.getTexture(0)); //it just wants a texture loaded, or it gets mad....
		GL11.glPushMatrix(); //save position
		GL11.glTranslatef(xpos, ypos+DangerZone.font.getHeight(), 0f); 
		GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!
		DangerZone.font.drawString(0, 0, text, ColorSlick.white);	
		GL11.glPopMatrix();  //restore position
	}
	
	public static void drawcoloredsquare(int xpos, int ypos, int xsize, int ysize, float r, float g, float b, float a){
		GL11.glPushMatrix(); //save position
		GL11.glDisable(GL11.GL_TEXTURE_2D);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		GL11.glTranslatef(xpos, ypos, 0f); 		
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glColor4f(r, g, b, a);
		GL11.glVertex3f(xsize, ysize, 0); // Top Right
		GL11.glColor4f(r, g, b, a);
		GL11.glVertex3f(0, ysize, 0); // Top Left
		GL11.glColor4f(r, g, b, a);
		GL11.glVertex3f(0, 0, 0); // Bottom left
		GL11.glColor4f(r, g, b, a);
		GL11.glVertex3f(xsize, 0, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		GL11.glDisable(GL11.GL_BLEND);		
		GL11.glEnable(GL11.GL_TEXTURE_2D);	
		GL11.glPopMatrix();
	}
	
	public static void drawBoss(World world, int inview ) {
		
		if(DangerZone.current_gui != null)return;
		
		Entity ent = find_focus_entity(world);
		if(ent == null)return; //nothing to do!
			
		if(!ent.isBoss())return;
		
		String crittername = ent.getBossName();
		if(crittername == null)return;
		float critterhealth = ent.getBossHealth();
		if(critterhealth < 0)critterhealth = 0f;
		if(critterhealth > 1)critterhealth = 1f;
		
		DangerZone.wr.setBrightnessNonFocus();		
		GL11.glPushMatrix();
		
		int middle = DangerZone.get_middle(inview);		
		int top = DangerZone.get_top(inview);
		
		
		//GL11.glTranslatef((middle) - (30*10), 30, 0f);
					
		textAt(middle - (crittername.length()*5), top-70, crittername);
		
		drawcoloredsquare(middle - 201, top-91, 402, 7, 0, 0, 0, 255);
		drawcoloredsquare(middle - 200, top-90, (int)(400f*critterhealth), 5, 1.0f-critterhealth, critterhealth, 0, 255);
		
		GL11.glPopMatrix();		
	}
	
	public static void drawHotbar(World world, int inview){
		
		if(DangerZone.current_gui != null)return;
		InventoryContainer ic = null;
		DangerZone.wr.setBrightnessNonFocus();		
		GL11.glPushMatrix();
		
		int middle = DangerZone.get_middle(inview);
				
		GL11.glTranslatef((middle) - (30*10), 30, 0f);
		if(inview != 0)GL11.glTranslatef(0, DangerZone.get_bottom(inview), 0f);
		for(int i=0;i<10;i++){
			WorldRenderer.last_texture = -1; //force reload after text!
			if(i == DangerZone.player.gethotbarindex())DangerZone.wr.setBrightnessFocus();
			drawhotbarbackground();
			
			ic = DangerZone.player.getHotbar(i);
			if(ic != null){			
				if(ic.bid != 0){
					GL11.glScalef(2.0f, 2.0f, 2.0f);
					if(Blocks.showTop(ic.bid)){
						DangerZone.wr.drawTexturedSquare(0, Blocks.isSolidForRender(ic.bid), ic.bid);
					}else{
						DangerZone.wr.drawTexturedSquare(1, Blocks.isSolidForRender(ic.bid), ic.bid);
					}
					GL11.glScalef(0.5f, 0.5f, 0.5f);
				}
				if(ic.iid != 0){
					GL11.glScalef(2.0f, 2.0f, 2.0f);					
					DangerZone.wr.loadtexture(Items.getTexture(ic.iid));
					drawSquare();
					GL11.glScalef(0.5f, 0.5f, 0.5f);
					//Now draw the damage bar!
					if(ic.count == 1){
						if(ic.currentuses > 0){
							if(ic.getMaxStack() == 1){
								Item it = ic.getItem();
								if(it != null){
									int md = it.maxuses;
									if(md > 0){
										float pu = (float)ic.currentuses/(float)md;										
										if(pu > 1)pu = 1;
										if(pu < 0)pu = 0;
										float xs = 32 * (1f - pu);
										if(xs < 1)xs = 1;
										GL11.glPushMatrix(); //save position
										GL11.glDisable(GL11.GL_TEXTURE_2D);
										GL11.glTranslatef(-16, -18, 0f); //just a little lower...
										GL11.glScalef(1f, 1f, 1f);
										GL11.glBegin(GL11.GL_QUADS);	
										GL11.glColor3f(pu, 1f-pu, 0);
										GL11.glVertex3f(xs, 2, 0); // Top Right
										GL11.glColor3f(pu, 1f-pu, 0);
										GL11.glVertex3f(0, 2, 0); // Top Left
										GL11.glColor3f(pu, 1f-pu, 0);
										GL11.glVertex3f(0, 0, 0); // Bottom left
										GL11.glColor3f(pu, 1f-pu, 0);
										GL11.glVertex3f(xs, 0, 0); // Bottom right		
										GL11.glEnd(); // Done Drawing The Quad
										GL11.glEnable(GL11.GL_TEXTURE_2D);
										GL11.glPopMatrix();
									}
								}
							}
						}
					}
				}
				//Display the count
				if(ic.count > 1){
					if(ic.count > 9){ //two chars
						WorldRendererUtils.textAt(DangerZone.wr.font, -12, 10, String.format("%d", ic.count));
					}else{ //one char
						WorldRendererUtils.textAt(DangerZone.wr.font, -6, 10, String.format("%d", ic.count));
					}
				}
				//Always reset brightness after text!
				DangerZone.wr.setBrightnessNonFocus();
			}
			//Always reset brightness after text!
			DangerZone.wr.setBrightnessNonFocus();
			
			GL11.glTranslatef(60, 0, 0f);
		}
		GL11.glPopMatrix();
	}
	
	public static void drawHealth(World world, int inview){		
		if(DangerZone.current_gui != null)return;
		if(WorldRenderer.heart_texture == null || WorldRenderer.unheart_texture == null)return;
		DangerZone.wr.setBrightnessNonFocus();		
		GL11.glPushMatrix();
		
		int middle = DangerZone.get_middle(inview);
		
		GL11.glTranslatef(((middle) - (30*10)) - 14, 65, 0f);
		if(inview != 0)GL11.glTranslatef(0, DangerZone.get_bottom(inview), 0f);
		float h = DangerZone.player.getHealth()/DangerZone.player.getMaxHealth();
		h *= 20;
		for(int i=0;i<20;i++){
			if(h > (float)i+0.5f){
				DangerZone.wr.loadtexture(WorldRenderer.heart_texture);
			}else{
				DangerZone.wr.loadtexture(WorldRenderer.unheart_texture);
			}
			WorldRendererUtils.drawSquare();
			GL11.glTranslatef(30, 0, 0f);
		}
		GL11.glPopMatrix();

	}
	
	public static void drawHunger(World world, int inview){		
		if(DangerZone.current_gui != null)return;
		if(WorldRenderer.hungerfull_texture == null || WorldRenderer.hungerempty_texture == null)return;
		DangerZone.wr.setBrightnessNonFocus();		
		GL11.glPushMatrix();
		
		int middle = DangerZone.get_middle(inview);
		
		GL11.glTranslatef(((middle) - (30*9.5f)) - 14, 75, 0f);
		if(inview != 0)GL11.glTranslatef(0, DangerZone.get_bottom(inview), 0f);
		float h = DangerZone.player.getHunger()/DangerZone.player.getMaxHunger();
		h *= 19;
		for(int i=0;i<19;i++){
			if(h > (float)i+0.5f){
				DangerZone.wr.loadtexture(WorldRenderer.hungerfull_texture);
			}else{
				DangerZone.wr.loadtexture(WorldRenderer.hungerempty_texture);
			}
			WorldRendererUtils.drawSquare();
			GL11.glTranslatef(30, 0, 0f);
		}
		GL11.glPopMatrix();

	}
	
	public static void drawMagic(World world, int inview){		
		if(DangerZone.current_gui != null)return;
		if(DangerZone.player.getMaxMagic() < 1f)return;
		blink++;
		if(WorldRenderer.magic_texture == null || WorldRenderer.magicempty_texture == null)return;
		DangerZone.wr.setBrightnessNonFocus();		
		GL11.glPushMatrix();
		
		int middle = DangerZone.get_middle(inview);
		
		GL11.glTranslatef(((middle) - (30*9f)) - 14, 85, 0f);
		if(inview != 0)GL11.glTranslatef(0, DangerZone.get_bottom(inview), 0f);
		float h = DangerZone.player.getMagic()/DangerZone.player.getMaxMagic();
		h *= 18;
		for(int i=0;i<18;i++){
			if(h > (float)i+0.5f){
				DangerZone.wr.loadtexture(WorldRenderer.magic_texture);	
				if(DangerZone.magic_power != 0){
					if((blink & 0x07) > 3 || (float)i+0.5f > DangerZone.magic_power*18){
						WorldRendererUtils.drawSquare();
					}
				}else{
					WorldRendererUtils.drawSquare();
				}
			}else{
				DangerZone.wr.loadtexture(WorldRenderer.magicempty_texture);
				WorldRendererUtils.drawSquare();
			}			
			
			GL11.glTranslatef(30, 0, 0f);
		}
		//String mt = null;
		//if(DangerZone.magic_type == 1)mt = "Heal";
		//if(DangerZone.magic_type == 2)mt = "Harm";
		//if(DangerZone.magic_type == 3)mt = "Destroy";
		//if(mt != null)WorldRendererUtils.textAt(DangerZone.wr.font, 10, 15, mt);
		GL11.glPopMatrix();

	}
	
	public static void drawAir(World world, int inview){		
		if(DangerZone.current_gui != null)return;
		if(WorldRenderer.bubble_texture == null)return;
		if(!Blocks.isLiquid(world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy+DangerZone.player.getEyeHeight()),(int)DangerZone.player.posz)))return;	
		DangerZone.wr.setBrightnessNonFocus();		
		GL11.glPushMatrix();
		
		int middle = DangerZone.get_middle(inview);
		
		GL11.glTranslatef(((middle) - (30*8.5f)) - 14, 95, 0f);
		if(inview != 0)GL11.glTranslatef(0, DangerZone.get_bottom(inview), 0f);
		float h = DangerZone.player.getAir()/DangerZone.player.getMaxAir();
		h *= 17;
		for(int i=0;i<17;i++){
			if(h > (float)i+0.5f){
				DangerZone.wr.loadtexture(WorldRenderer.bubble_texture);			
				WorldRendererUtils.drawSquare();
			}
			GL11.glTranslatef(30, 0, 0f);
		}
		GL11.glPopMatrix();

	}
	
	
	
	public static void drawSunAndMoon(World world, boolean spinit){

		double sposx, sposy, sposz;
		double dist = (254.0f*DangerZone.renderdistance);
		//float dist = (154.0f*DangerZone.renderdistance);
		float scale = (float)DangerZone.renderdistance/24f;
		int tod = world.getTimeOfDay();
		int lod = world.getLengthOfDay();
		boolean moon = false;
		if(tod > lod/2){
			tod -= lod/2;
			moon = true;
		}
		sposx = (DangerZone.player.posx%16f)*16f;
		sposy =  (dist * Math.sin(Math.toRadians(((float)tod/(float)lod)*360f)));
		sposz =  (dist * Math.cos(Math.toRadians(((float)tod/(float)lod)*360f))) + (DangerZone.player.posz%16f)*16f;
			
		
		//MatrixStack.sendCurrentStack();	
		MatrixStack.pushMatrix(); //save/set original position		
		MatrixStack.translate((float)sposx, (float)(sposy+DangerZone.player.posy*16), (float)sposz); //position to draw from
				
		DangerZone.wr.setBrightness(1.0f);				
		if(!moon){
			DangerZone.wr.loadtexture(WorldRenderer.sun_texture);
		}else{
			DangerZone.wr.loadtexture(WorldRenderer.moon_texture);
		}
		//if(DangerZone.fog_enable)GL11.glDisable(GL11.GL_FOG);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		
		MatrixStack.sendCurrentStack();	
		MatrixStack.pushMatrix();
		//add scale and one rotation
		MatrixStack.scale(20f*scale, 20f*scale, 20f*scale); 
		if(!moon) {
			MatrixStack.scale(2, 2, 2); 
		}		
		MatrixStack.rotate(((float)tod/(float)lod)*360f, 1, 0, 0); //face player
		
		if(spinit && !moon){ //need more rotation
			sunspin += 0.15f;
			MatrixStack.sendCurrentStack();	
			MatrixStack.pushMatrix();
			MatrixStack.rotate(sunspin%360, 0, 0, 1); //add spin	
		}		
				
		MatrixStack.sendCurrentStack();	
		WorldRendererUtils.drawSquare3D();
		
		GL11.glDisable(GL11.GL_BLEND);
		//if(DangerZone.fog_enable)GL11.glEnable(GL11.GL_FOG);
		DangerZone.wr.setBrightness();
		if(spinit && !moon)MatrixStack.popMatrix();
		MatrixStack.popMatrix();
		MatrixStack.popMatrix();//restore/set original position
		
	}
	
	//Renders the fire of an entity that is on fire...
	public static void drawEntityOnFire(Entity ent){
		if(firetexture == null){
			firetexture = TextureMapper.getTexture("res/misc/"+ "fire_side.png");
		}
		if(!fire_compiled){
			int stride = 3*4; //xyz coord size (floats!)
			int textureoff = stride;
			stride += 2*4; //texture coord size
			int coloroff = stride;
			stride += 3*4; //rgb (brightness bytes!)	
			
			ByteBuffer vbodata = BufferUtils.createByteBuffer(4*stride); // size (1 side)  	
			int vbo_buffer;
			
			float offinc = 0;

			fire_list1 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(fire_list1);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			offinc += 0.125f;
			fire_list2 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(fire_list2);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			offinc += 0.125f;
			fire_list3 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(fire_list3);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			offinc += 0.125f;
			fire_list4 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(fire_list4);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			offinc += 0.125f;
			fire_list5 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(fire_list5);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			offinc += 0.125f;
			fire_list6 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(fire_list6);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			offinc += 0.125f;
			fire_list7 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(fire_list7);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			offinc += 0.125f;
			fire_list8 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(fire_list8);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();		
			
			fire_compiled = true;
		}
		
		DangerZone.wr.loadtexture(firetexture);
		
		int which = Fastmath.nextInt(8);
		//GL11.glColor4f(1f, 1f, 1f, 0.80f);	
		
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		
		//use width and height because entity was already scaled elsewhere!
		
		MatrixStack.translate(0, 10, 0); //go up a little...
		
		MatrixStack.scale(ent.getWidth(), ent.getHeight()*1.25f, 1);
		
		MatrixStack.sendCurrentStack();
		
		MatrixStack.sendFinalStack();
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);		
		
		switch(which){
		case 0:
			GL30.glBindVertexArray(fire_list1);		
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
			GL30.glBindVertexArray(0);
			break;
		case 1:
			GL30.glBindVertexArray(fire_list2);		
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
			GL30.glBindVertexArray(0);
			break;
		case 2:
			GL30.glBindVertexArray(fire_list3);		
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
			GL30.glBindVertexArray(0);
			break;
		case 3:
			GL30.glBindVertexArray(fire_list4);		
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
			GL30.glBindVertexArray(0);
			break;
		case 4:
			GL30.glBindVertexArray(fire_list5);		
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
			GL30.glBindVertexArray(0);
			break;
		case 5:
			GL30.glBindVertexArray(fire_list6);		
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
			GL30.glBindVertexArray(0);
			break;
		case 6:
			GL30.glBindVertexArray(fire_list7);		
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
			GL30.glBindVertexArray(0);
			break;
		case 7:
			GL30.glBindVertexArray(fire_list8);		
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
			GL30.glBindVertexArray(0);
			break;
		default:
		}
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);
		
		//GL11.glColor4f(1f, 1f, 1f, 1.0f);	
		GL11.glEnable(GL11.GL_BLEND);
		
	}
	
	public static Entity find_focus_entity(World w){
		double dir, dx, dz, dy;
		double delta = 0.0d;
		double xzscale;
		double dist;
		int x,y,z;
		double fx,fy,fz;
		int lx, ly, lz;
		int bid;
		float sightdist = 16f;
		Entity tempe = null;
		List<Entity> nearby_list = null;
		List<Entity> check_list = new ArrayList<Entity>();
		ListIterator<Entity> li;
		int riddenid = 0;
		Entity ridden = DangerZone.player.getRiddenEntity();
		if(ridden != null )riddenid = ridden.entityID;

		fx =  DangerZone.player.posx;
		fy = DangerZone.player.posy+DangerZone.player.getEyeHeight()+DangerZone.eyeheight_adjust;
		fz =  DangerZone.player.posz;
		x = (int) fx;
		y = (int) fy;
		z = (int) fz;

		dir = Math.toRadians((DangerZone.player.rotation_yaw_head-90)%360f); 
		dx = Math.cos(dir);
		dz = Math.sin(dir);
		dy = Math.sin(Math.toRadians((DangerZone.player.rotation_pitch_head)%360f));
		xzscale = Math.abs(Math.cos(Math.toRadians((DangerZone.player.rotation_pitch_head)%360f)));
		dx *= xzscale;
		dz *= xzscale;
		dy = -dy;

		//pre-filter to take out things we cannot possibly or shouldn't hit!
		nearby_list = DangerZone.clientEntityManager.findEntitiesInRange(25.0f, DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				li = nearby_list.listIterator();
				while(li.hasNext()){
					tempe = (Entity)li.next();
					dist = Math.sqrt((fx-tempe.posx)*(fx-tempe.posx)+(fy-tempe.posy)*(fy-tempe.posy)+(fz-tempe.posz)*(fz-tempe.posz));
					dist -= 0.25f; //width of sword or whatever
					dist -= (tempe.getWidth()/2); //general hitbox of entity
					if(tempe != DangerZone.player && !tempe.canthitme && dist < sightdist){					
						//don't hit mount unless looking almost straight down!
						if(tempe.entityID != riddenid || dy < -0.75f){
							//System.out.printf("added %d\n", tempe.entityID);
							check_list.add(tempe);
						}
					}
				}
			}
		}
		if(check_list.isEmpty())return null;
		
		lx = ly = lz = 0;

		//increment along the axis looking for a block or an entity
		while(delta < sightdist){
			fx =  (DangerZone.player.posx + dx*delta);
			fy =  ((DangerZone.player.posy+DangerZone.player.getEyeHeight()+DangerZone.eyeheight_adjust) + dy*delta);
			fz =  (DangerZone.player.posz + dz*delta);
			x = (int) fx;
			y = (int) fy;
			z = (int) fz;

			li = check_list.listIterator();
			while(li.hasNext()){
				tempe = (Entity)li.next();
				if(fy > tempe.posy-0.25f && fy < tempe.posy+tempe.getHeight()+0.25f){
					dist = Math.sqrt((fx-tempe.posx)*(fx-tempe.posx)+(fz-tempe.posz)*(fz-tempe.posz));
					dist -= 0.25f; //width of sword or whatever
					dist -= (tempe.getWidth()/2); //general hitbox of entity
					//System.out.printf("entity dist %d, d = %f\n", tempe.entityID, dist);
					if(dist < 0){
						//System.out.printf("entity hit %d, dy = %f\n", tempe.entityID, dy);								
						return tempe;
					}
				}
			}

			//wait until block actually changes
			if(x != lx || y != ly || z != lz){
				lx = x; ly = y; lz = z;
				bid = w.getblock(DangerZone.player.dimension, x, y, z);
				if(DangerZone.player.getInLiquid() && Blocks.isLiquid(bid))bid = 0;
				if(bid != 0){ //Hit a block!!!						
					return null;
				}
			}
			delta += 0.25d;
		}

		return null;
	}
	
	
	//calling this a few times should be a lot faster than sorting through the list a bazillion times!
	private static int find_farthest(List<Integer> inlist, EntityLiving me) {
		int found = 0;
		double farthest = -1;
		double dist;
		Entity pst;
		Iterator<Integer> li = inlist.iterator();
		int indx = 0;
		int ipst = 0;
		
		while(li.hasNext()){			
			ipst = li.next();
			if(ipst <= 0 || ipst >= DangerZone.max_entities)continue;
			pst = DangerZone.clientEntityManager.entities[ipst];
			if(pst == null)continue;
			dist = pst.getDistanceFromEntity(me);
			if(dist > farthest) {
				farthest = dist;
				found = indx; //assumes that hasNext and indx++ are equivalent!!!
			}
			indx++;
		}
		
		return found;
	}
	
	//Finds N visible entities because VR (new vbo graphics!) lags like a bitch.
	//vbo buffers may be fine for a few very large objects, but for many many little objects
	//each with a vbo, they appears to suck big-time. Draw-lists were much more efficient for that.
	public static void findClosest(List<Integer> DrawMe, int howmany, float maxdist, EntityLiving me, float inyaw, int dim, double x, double y, double z){
		
		List<Integer> retlistEB = new ArrayList<Integer>();
		List<Integer> retlistO = new ArrayList<Integer>();
		int inext;
		Entity ent;
		double dist;
		double pi = 3.1415926545D;
		double rdd, rr, rhdir;
		float use_fov = DangerZone.fieldOfView;
		double farthestEL = -1;
		int farthest_indexEL = 0;
		double farthestEB = -1;
		int farthest_indexEB = 0;
		double farthestO = -1;
		int farthest_indexO = 0;
		int prd;
		int distmul = 1;
		if(DangerZone.graphics_mode >= 0)distmul = 2;
		if(DangerZone.graphics_mode >= 3)distmul = 3;
		
		if(DangerZone.isVR)use_fov += 15f; //wider!!! isVR!!!
		
		//Generate a list of everything we can see
		for(inext = 0; inext < DangerZone.max_entities; inext++){
			ent = DangerZone.clientEntityManager.entities[inext];
			if(ent != null){
				//entcount++;
				if(ent.dimension == dim && (ent.entityID != me.entityID || me.always_draw)){
					dist = me.getDistanceFromEntity(ent);
					prd = ent.maxrenderdist*distmul;
					if(dist <= prd && dist <= maxdist ){		
						//filter out some entities that we can't see...
						rr = (float) Math.atan2((ent.display_posz-z), (ent.display_posx-x));					
						rhdir = Math.toRadians((inyaw-90)%360f); 
						rdd = Math.abs(rr - rhdir)%(pi*2.0D);
						if(rdd > pi)rdd = rdd-(pi*2.0D);
						rdd = Math.abs(rdd); //Total differential, minus sign.	
						if(!ent.always_draw){
							if(me.rotation_pitch_head < 45 || me.rotation_pitch_head > 315){ //NOT looking down or up?						
								if(dist > 16 && rdd > pi/2*use_fov/45.0f){
									if(!DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side){
										continue; //Don't render what we can't see!
									}
								}
							}
						}
						if(ent.isInvisible())continue;

						if(ent.model != null){	
							
							if(howmany < 0) {
								DrawMe.add(inext); // they want everything
							}else {
								
								if((ent instanceof EntityLiving)) {	

									if(DrawMe.size() < howmany) {
										if(dist > farthestEL) {
											farthestEL = dist;
											farthest_indexEL = DrawMe.size();
										}
										DrawMe.add(inext);
									}else {
										if(dist < farthestEL) {
											DrawMe.remove(farthest_indexEL);
											DrawMe.add(inext);
											farthest_indexEL = find_farthest(DrawMe, me);
										}
									}

								}else if((ent instanceof EntityBlockItem)) {	

									if(retlistEB.size() < howmany) {
										if(dist > farthestEB) {
											farthestEB = dist;
											farthest_indexEB = retlistEB.size();
										}
										retlistEB.add(inext);
									}else {
										if(dist < farthestEB) {
											retlistEB.remove(farthest_indexEB);
											retlistEB.add(inext);
											farthest_indexEB = find_farthest(retlistEB, me);
										}
									}

								}else {
									//exp and all the rest
									if(retlistO.size() < howmany) {
										if(dist > farthestO) {
											farthestO = dist;
											farthest_indexO = retlistO.size();
										}
										retlistO.add(inext);
									}else {
										if(dist < farthestO) {
											retlistO.remove(farthest_indexO);
											retlistO.add(inext);
											farthest_indexO = find_farthest(retlistO, me);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		
		//really java? No append() for lists? omg...
		Iterator<Integer> li = retlistEB.iterator();		
		while(li.hasNext()){			
			DrawMe.add(li.next());
		}
		li = retlistO.iterator();		
		while(li.hasNext()){			
			DrawMe.add(li.next());
		}
		
	}


	//calling this a few times should be a lot faster than sorting through the list a bazillion times!
	private static int find_farthestP(List<Particle> inlist, EntityLiving me) {
		int found = 0;
		double farthest = -1;
		double dist;
		Particle pst;
		Iterator<Particle> li = inlist.iterator();
		int indx = 0;
		
		while(li.hasNext()){			
			pst = li.next();
			dist = pst.getDistanceFromEntity(me);
			if(dist > farthest) {
				farthest = dist;
				found = indx; //assumes that hasNext and indx++ are equivalent!!!
			}
			indx++;
		}
		
		return found;
	}
	
	//Finds N visible particles because VR (new vbo graphics!) lags like a bitch.
	public static void findClosestP(List<Particle> DrawMeP, int howmany, float maxdist, EntityLiving me, float inyaw, int dim, double x, double y, double z){
		Particle pst;
		//int inext = 0;
		double dist;
		double farthest = -1;
		int farthest_index = 0;
		double pi = 3.1415926545D;
		double rdd, rr, rhdir;
		float use_fov = DangerZone.fieldOfView;
		int prd;
		int distmul = 1;
		if(DangerZone.graphics_mode >= 0)distmul = 2;
		if(DangerZone.graphics_mode >= 3)distmul = 3;
		
		if(DangerZone.isVR)use_fov += 15f; //wider!!! isVR!!!
				
		DangerZone.clientParticleManager.particle_list_lock.lock();

		Iterator<Particle> li = DangerZone.clientParticleManager.particle_list.iterator();
		while(li.hasNext()){			
			pst = li.next();				
			dist = pst.getDistanceFromEntity(me);
			prd = pst.maxrenderdist*distmul;
			if(dist <= prd && dist <= maxdist ){					
				//filter out some particles that we can't see... saves a lot of CPU for rain!
				rr = (float) Math.atan2((pst.posz-z), (pst.posx-x));					
				rhdir = Math.toRadians((inyaw-90)%360f); 
				rdd = Math.abs(rr - rhdir)%(pi*2.0D);
				if(rdd > pi)rdd = rdd-(pi*2.0D);
				rdd = Math.abs(rdd); //Total differential, minus sign.				
				if(me.rotation_pitch_head < 45 || me.rotation_pitch_head > 315){ //NOT looking down or up?						
					if(dist > 4 && rdd > pi/2*use_fov/45.0f){
						if(!DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side){
							//inext++;
							continue; //Don't render what we can't see!
						}
					}
				}	
				if(pst.model != null){		
					//ok, now, build the list!
					if(howmany < 0) {
						DrawMeP.add(pst); //they want everything
					}else {
						if(DrawMeP.size() < howmany) {
							if(dist > farthest) {
								farthest = dist;
								farthest_index = DrawMeP.size();
							}
							DrawMeP.add(pst);
						}else {
							if(dist < farthest) {
								DrawMeP.remove(farthest_index);
								DrawMeP.add(pst);
								farthest_index = find_farthestP(DrawMeP, me);
							}
						}
					}
				}
			}
		}
		
		DangerZone.clientParticleManager.particle_list_lock.unlock();
		

	}
	



}
