package dangerzone.rendering;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import java.awt.Font;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import slick.TrueTypeFont;
import slick.Texture;
import slick.TextureImpl;
import dangerzone.DangerZone;
import dangerzone.Focus_Finder;
import dangerzone.GameModes;
import dangerzone.InventoryContainer;
import dangerzone.ItemAttribute;
import dangerzone.Player;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.biomes.Biome;
import dangerzone.biomes.BiomeManager;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.BlockFlower;
import dangerzone.blocks.BlockLeaves;
import dangerzone.entities.Entity;
import dangerzone.items.Item;
import dangerzone.items.ItemBow;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.threads.CleanerThread;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.Chunk;
import dangerzone.world.Dimension;
import dangerzone.world.Dimensions;
import dangerzone.world.World;



public class WorldRenderer {
	
	public volatile List<long[]> VBO_delete_list; // a list of VBO lists that need to be deleted from chunks!
	public Lock VBOlistlock = new ReentrantLock();
		
	public static Texture heart_texture = null;
	public static Texture unheart_texture = null;
	public static Texture hungerfull_texture = null;
	public static Texture hungerempty_texture = null;
	public static Texture bubble_texture = null;
	public static Texture sun_texture = null;
	public static Texture moon_texture = null;
	public static Texture magic_texture = null;
	public static Texture magicempty_texture = null;
	public static Texture focus_texture = null;
	public static int last_texture = -1;
	public static StitchedTextureFile[] stitches = null;
	public static int next_stitch = 0;
	public volatile int oneblock = -1;
	
	public int blockrenderwidth = 16;
	public int show_focus_x, show_focus_y, show_focus_z, show_focus_side;
	public int show_focus_bid, show_focus_meta;
	public float show_focus_damage = 0;
	public float show_focus_maxdamage = 0;
	public float show_focus_dist = 0;
	public Entity show_focus_entity = null;
	public double show_poi_x, show_poi_y, show_poi_z;
	
	public Focus_Finder focus_finder = null;

	public static volatile boolean do_draw_focus = false;	

	public float linewidth = 3f;
	public int topid, bottomid, leftid, rightid, frontid, backid;
	public Font awtfont = null;
	public TrueTypeFont font = null;
	public static  float brightness_red;
	public static float brightness_green;
	public static float brightness_blue;
	public float sky_red, sky_green, sky_blue;
	private static Lock lock = new ReentrantLock();
	private long lasttime = 0, nowtime = 0;
	public int fps = 30;
	private int fpscounter = 0;
	private int pps = 0;
	private int cps = 0;
	private float bounce = 0;
	private float lastbounce = 0;
	private float eatbounce = 0;
	private int hit_cycles = 7;
	private int hit_cycle_count = 0;
	private int hit_cycle_dir = 1;	
	private float hitx = -5.0f;
	private float hity = -9.2f;
	private float hitz = 2.5f;
	private float hitp = -19.7f;
	private float hitw = -27.6f;
	private float hitr = 11.5f;
	private float hitxn = -0.2f;
	private float hityn = -2.4f;
	private float hitzn = -5.3f;
	private float hitpn = -12.4f;
	private float hitwn = -47.5f;
	private float hitrn = 0.7f;
	private int eat_cycles = 7;
	private int eat_cycle_count = 0;
	private int eat_cycle_dir = 1;
	private int eat_delay_count = 0;
	//private float eatx = -10.5f;
	//private float eaty = -2.1f;
	//private float eatz = 18.5f;
	//private float eatp = -58.1f;
	//private float eatw = -80.8f;
	//private float eatr = 59.0f;
	private float eatxn = 5f;
	private float eatyn = -5f;
	private float eatzn = -7.9f;
	private float eatpn = -69.6f;
	private float eatwn = -16.5f;
	private float eatrn = 0.7f;
	
	private float hitxb = -5.4f;
	private float hityb = 2.9f;
	private float hitzb = -8.1f;
	private float hitpb = 0.8f;
	private float hitwb = -0.8f;
	private float hitrb = -27.7f;
	
	public float f5x, f5y, f5z, f5yaw, f5pitch;
	private float cdir, tdir, pdiff, ydiff, rdiff;

	public volatile long nextVBOid;
	public volatile  Map<Long , VBOBuffer> VBOmap = null;
	public volatile List<VBOBuffer> translucentVBOs; // a list of VBOs that need to be drawn LAST. Blocks with translucent parts or wholes.
	public volatile int VBOmemorysize;
	public int lastplayerdimension = 0;
	private boolean eat_sound = true;
	private double traveled = 0;
	public long framecounter = 0;
	public volatile int vbocount = 0;
	public VBODataBuilderThread builder = null;
	public VBODataBuilderThread builder_two = null;
	private int usex, usey, usez, uses;
	public Entity usee = null;
	private FloatBuffer wrfogColor = null;
	public Entity ViewFromEntity = null;
	
	public boolean normal_sun = true;
	public float shift_x = 0.0f;
	public float shift_z = 0.0f;
	public float shift_y = 0.0f;
	public float eyeadjust = 0;
	public float ref_pitch = 0;
	public float ref_yaw = 0;
	public float ref_roll = 0;
	public int ref_dim = 0;
	
	//TODO TEST me! (maglev, raft)
	//TODO TEST me! (maglev, raft)
	//TODO TEST me! (maglev, raft)
	//TODO TEST me! (maglev, raft)
	
	public double ref_posx = 0;
	public double ref_posy = 0;
	public double ref_posz = 0;
	
	
	
	//private int temp_counter = 0;
	
	public List<Integer> DrawMe = null;	
	public List<Particle> DrawMeP = null;
	
	boolean doforce = false;

	public WorldRenderer(){

		heart_texture = TextureMapper.getTexture("res/menus/heart.png");
		unheart_texture = TextureMapper.getTexture("res/menus/unheart.png");
		hungerfull_texture = TextureMapper.getTexture("res/menus/hungerfull.png");
		hungerempty_texture = TextureMapper.getTexture("res/menus/hungerempty.png");
		bubble_texture = TextureMapper.getTexture("res/menus/bubble.png");
		magic_texture = TextureMapper.getTexture("res/menus/star.png");
		magicempty_texture = TextureMapper.getTexture("res/menus/star_empty.png");
		focus_texture = TextureMapper.getTexture("res/misc/focus_block.png");
		
		int stride = 3*4; //xyz coord size (floats!)
		int textureoff = stride;
		stride += 2*4; //texture coord size
		int coloroff = stride;
		stride += 3*4; //rgb (brightness bytes!)	
		
		ByteBuffer vbodata = BufferUtils.createByteBuffer(4*stride); // size (1 side)  	
		int vbo_buffer;
		
		GregorianCalendar gcalendar = new GregorianCalendar();
		int nowmonth, nowday;
		nowmonth = gcalendar.get(Calendar.MONTH);
		nowday = gcalendar.get(Calendar.DATE);
		//System.out.printf("month,  day = %d, %d\n", nowmonth, nowday);
		//month is 0-based. Day is actual.
		if(nowmonth == 9 && nowday == 31){ //If it is Halloween, ghosts are everywhere! :)
			sun_texture = TextureMapper.getTexture("res/misc/sunpumpkin.png");
			normal_sun = false;
		}else{
			sun_texture = TextureMapper.getTexture("res/misc/sun.png");
		}
		

		moon_texture = TextureMapper.getTexture("res/misc/moon.png");

		stitches = new StitchedTextureFile[20]; //Should be enough, ya think? :)
		nextVBOid = 1;
		VBOmap = new HashMap<Long, VBOBuffer>();
		VBO_delete_list = new ArrayList<long[]>();
		translucentVBOs = new ArrayList<VBOBuffer>();
		framecounter = 0;
		vbocount = 0;
		VBOmemorysize = 0;

		if(font == null){
			awtfont = new Font("Times New Roman", Font.PLAIN, 24);
			font = new TrueTypeFont(awtfont, false);
		}
		oneblock = -1;

		//topid = getNextRenderID();
		//GL11.glNewList(topid, GL11.GL_COMPILE);
		//GL11.glBegin(GL11.GL_QUADS);	
		//GL11.glTexCoord2f(1,0);
		//GL11.glVertex3f(blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2); // Top Right Of The Quad (Top)
		//GL11.glTexCoord2f(0,0);
		//GL11.glVertex3f(-blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2); // Top Left Of The Quad (Top)
		//GL11.glTexCoord2f(0,1);
		//GL11.glVertex3f(-blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2); // Bottom Left Of The Quad (Top)
		//GL11.glTexCoord2f(1,1);
		//GL11.glVertex3f(blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2); // Bottom Right Of The Quad (Top)
		//GL11.glEnd(); // Done Drawing The Quad
		//GL11.glEndList();
		topid = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(topid);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);					    	
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);   		    	
    	vbodata.flip();
    	vbo_buffer = GL15.glGenBuffers();
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
    	GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		
		vbodata.rewind();
		
		//bottomid = getNextRenderID();
		//GL11.glNewList(bottomid, GL11.GL_COMPILE);
		//GL11.glBegin(GL11.GL_QUADS);	
		//GL11.glTexCoord2f(1,0);
		//GL11.glVertex3f(blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2); // Top Right Of The Quad (Bottom)
		//GL11.glTexCoord2f(0,0);
		//GL11.glVertex3f(-blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2); // Top Left Of The Quad (Bottom)
		//GL11.glTexCoord2f(0,1);
		//GL11.glVertex3f(-blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2); // Bottom Left Of The Quad (Bottom)
		//GL11.glTexCoord2f(1,1);
		//GL11.glVertex3f(blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2); // Bottom Right Of The Quad (Bottom)
		//GL11.glEnd(); // Done Drawing The Quad
		//GL11.glEndList();
		bottomid = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(bottomid);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);					    	
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 1, 1, 1f, 1f, 1f);   		    	
    	vbodata.flip();
    	vbo_buffer = GL15.glGenBuffers();
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
    	GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		
		vbodata.rewind();

		//frontid = getNextRenderID();
		//GL11.glNewList(frontid, GL11.GL_COMPILE);
		//GL11.glBegin(GL11.GL_QUADS);	
		//GL11.glTexCoord2f(1,0);
		//GL11.glVertex3f(blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2); // Top Right Of The Quad (Front)
		//GL11.glTexCoord2f(0,0);
		//GL11.glVertex3f(-blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2); // Top Left Of The Quad (Front)
		//GL11.glTexCoord2f(0,1);
		//GL11.glVertex3f(-blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2); // Bottom Left Of The Quad (Front)
		//GL11.glTexCoord2f(1,1);
		//GL11.glVertex3f(blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2); // Bottom Right Of The Quad (Front)
		//GL11.glEnd(); // Done Drawing The Quad
		//GL11.glEndList();		
		frontid = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(frontid);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);					    	
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);   		    	
    	vbodata.flip();
    	vbo_buffer = GL15.glGenBuffers();
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
    	GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		
		vbodata.rewind();
		
		//backid = getNextRenderID();
		//GL11.glNewList(backid, GL11.GL_COMPILE);
		//GL11.glBegin(GL11.GL_QUADS);	
		//GL11.glTexCoord2f(1,0);
		//GL11.glVertex3f(-blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2); // Top Left Of The Quad (Back)
		//GL11.glTexCoord2f(0,0);
		//GL11.glVertex3f(blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2); // Top Right Of The Quad (Back)
		//GL11.glTexCoord2f(0,1);
		//GL11.glVertex3f(blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2); // Bottom Right Of The Quad (Back)
		//GL11.glTexCoord2f(1,1);
		//GL11.glVertex3f(-blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2); // Bottom Left Of The Quad (Back)
		//GL11.glEnd(); // Done Drawing The Quad
		//GL11.glEndList();
		backid = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(backid);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);				   	    	
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 1, 1, 1f, 1f, 1f);   		    	
    	vbodata.flip();
    	vbo_buffer = GL15.glGenBuffers();
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
    	GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		
		vbodata.rewind();
		
		//leftid = getNextRenderID();
		//GL11.glNewList(leftid, GL11.GL_COMPILE);
		//GL11.glBegin(GL11.GL_QUADS);	
		//GL11.glTexCoord2f(1,0);
		//GL11.glVertex3f(-blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2); // Top Right Of The Quad (Left)
		//GL11.glTexCoord2f(0,0);
		//GL11.glVertex3f(-blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2); // Top Left Of The Quad (Left)
		//GL11.glTexCoord2f(0,1);
		//GL11.glVertex3f(-blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2); // Bottom Left Of The Quad (Left)
		//GL11.glTexCoord2f(1,1);
		//GL11.glVertex3f(-blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2); // Bottom Right Of The Quad (Left)
		//GL11.glEnd(); // Done Drawing The Quad
		//GL11.glEndList();
		leftid = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(leftid);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);				   	    	
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);   		    	
    	vbodata.flip();
    	vbo_buffer = GL15.glGenBuffers();
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
    	GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		
		vbodata.rewind();

		//rightid = getNextRenderID();
		//GL11.glNewList(rightid, GL11.GL_COMPILE);
		//GL11.glBegin(GL11.GL_QUADS);	
		//GL11.glTexCoord2f(1,0);
		//GL11.glVertex3f(blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2); // Top Right Of The Quad (Right)
		//GL11.glTexCoord2f(0,0);
		//GL11.glVertex3f(blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2); // Top Left Of The Quad (Right)
		//GL11.glTexCoord2f(0,1);
		//GL11.glVertex3f(blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2); // Bottom Left Of The Quad (Right)
		//GL11.glTexCoord2f(1,1);
		//GL11.glVertex3f(blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2); // Bottom Right Of The Quad (Right)
		//GL11.glEnd(); // Done Drawing The Quad
		//GL11.glEndList();
		rightid = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(rightid);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);				   	    	
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 1, 1, 1f, 1f, 1f);   		    	
    	vbodata.flip();
    	vbo_buffer = GL15.glGenBuffers();
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
    	GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		
		vbodata.rewind();

		wrfogColor = BufferUtils.createFloatBuffer(4);
		wrfogColor.put(0.75f);
		wrfogColor.put(0.75f);
		wrfogColor.put(0.75f);
		wrfogColor.put(1.0f);
		wrfogColor.position(0);	
		
		ViewFromEntity = DangerZone.player;
		ref_yaw = DangerZone.player.rotation_yaw_head;
		ref_pitch = DangerZone.player.rotation_pitch_head;
		ref_roll = DangerZone.player.rotation_roll_head;
		ref_posx = DangerZone.player.display_posx;
		ref_posy = DangerZone.player.display_posy;
		ref_posz = DangerZone.player.display_posz;
		
		focus_finder = new Focus_Finder();
		
		show_focus_x = 0;
		show_focus_y = 0;
		show_focus_z = 0;
		show_focus_side = 0;
		show_focus_bid = 0;
		show_focus_meta = 0;
		show_focus_damage = 0;
		show_focus_maxdamage = 0;
		show_focus_dist = 0;
		show_focus_entity = null;
		show_poi_x = show_poi_y = show_poi_z = 0; 
		
		DrawMe = new ArrayList<Integer>(); //so it is not null!
		DrawMeP = new ArrayList<Particle>(); //so it is not null!

	}
	
    private void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }
	
	/*
	 * Preloads ALL the block textures from ALL the mods.
	 */
	public void loadBlockTextures(){
		int side, bid;
		StitchedTexture st = null;
		for(bid=0;bid<Blocks.blocksMAX;bid++){
			if(Blocks.BlockArray[bid] != null){
				for(side=0;side<6;side++){
					st = Blocks.BlockArray[bid].getStitchedTexture(side);
					if(st.texturesindex < 0){
						//Add this thing!
						StitchedTextureFile stf = stitches[next_stitch];
						if(stf == null){
							stitches[next_stitch] = new StitchedTextureFile();
						}
						stf = stitches[next_stitch];
						if(stf.nexty >= 32){ //filled up!
							//if(!DangerZone.isVR)stitches[next_stitch].doMakeMipMaps();
							stitches[next_stitch].doMakeMipMaps();
							next_stitch++;
							stitches[next_stitch] = new StitchedTextureFile();
						}
						st.texturesindex = next_stitch;
						StitchedTexture stnew = stitches[next_stitch].doAddTextureToBuffer(Blocks.BlockArray[bid].getStitchedTextureName(side));
						if(stnew != null){
							st.yoffsetmax = stnew.yoffsetmax;
							st.yoffsetmin = stnew.yoffsetmin;
							st.xoffsetmax = stnew.xoffsetmax;
							st.xoffsetmin = stnew.xoffsetmin;
						}
					}
				}
			}
		}
		//if(!DangerZone.isVR)stitches[next_stitch].doMakeMipMaps();
		stitches[next_stitch].doMakeMipMaps();
	}
	
	public void loadOneBlockTexture(int bid){
		int side;
		StitchedTexture st = null;		
		if(Blocks.BlockArray[bid] != null){
			for(side=0;side<6;side++){
				st = Blocks.BlockArray[bid].getStitchedTexture(side);
				if(st.texturesindex < 0){
					//Add this thing!
					StitchedTextureFile stf = stitches[next_stitch];
					if(stf == null){
						stitches[next_stitch] = new StitchedTextureFile();
					}
					stf = stitches[next_stitch];
					if(stf.nexty >= 32){ //filled up!
						next_stitch++;
						stitches[next_stitch] = new StitchedTextureFile();
					}
					st.texturesindex = next_stitch;
					StitchedTexture stnew = stitches[next_stitch].doAddTexture(Blocks.BlockArray[bid].getStitchedTextureName(side));
					if(stnew != null){
						st.yoffsetmax = stnew.yoffsetmax;
						st.yoffsetmin = stnew.yoffsetmin;
						st.xoffsetmax = stnew.xoffsetmax;
						st.xoffsetmin = stnew.xoffsetmin;
					}
				}
			}
		}
	}
	
	private void doHouseKeeping(World world, int inview){
		
		framecounter++;
		if(builder == null){
			//Let's get to making some data!
			builder = new VBODataBuilderThread(world);
			builder.odd_even = 0;
			Thread cwt = new Thread(builder);
			cwt.setPriority(Thread.NORM_PRIORITY);
			cwt.start();
			builder_two = new VBODataBuilderThread(world);
			builder_two.odd_even = 1;
			Thread cwt_two = new Thread(builder_two);
			cwt_two.setPriority(Thread.NORM_PRIORITY);
			cwt_two.start();
		}
				
		fpscounter++;
		nowtime = System.currentTimeMillis();
		if(nowtime - lasttime > 1000){
			fps = ((fps*2) + fpscounter)/3; //smoothed just a little....
			fps++;
			if(fps < 1)fps = 1; //divide by zero protection for things...
			fpscounter = 0;
			lasttime = nowtime;
			pps = DangerZone.packets_per_second;
			DangerZone.packets_per_second = 0;
			cps = DangerZone.chunks_per_second;
			DangerZone.chunks_per_second = 0;
		}
		
		//
		// DIMENSION CHANGE! CLEAN EVERYTHING!
		//
		if(lastplayerdimension != DangerZone.player.dimension){
			//EMERGENCY VBO CLEANUP! Can't have two dimensions at once on some machines...
			//can cause out-of-memory problems. Don't need the old ones anyway!
			world.chunkcache.releaseAllVBOs();
			lastplayerdimension = DangerZone.player.dimension;
			CleanerThread.cleanmenowplease = true;
			while(CleanerThread.cleanmenowplease){
				Thread.yield();
			}
		}
		
		//reload a texture... coloring block?
		if(oneblock != -1){
			loadOneBlockTexture(oneblock);
			oneblock = -1;
		}
		
		/*
		 * VBO housekeeping.
		 * We keep a maximum number in the map, and delete the oldest as we run over...
		 * We can do this, because when a chunk looks up a vboid in the map and it is invalid,
		 * it will automatically create a new one.
		 * But first, see if there are any on the delete list!
		 */
				
		VBOlistlock.lock();
		if(!VBO_delete_list.isEmpty()){
			Iterator<long[]> ii = VBO_delete_list.iterator();
			long[] st;
			int vdx;
			while(ii.hasNext()){
				st = ii.next();
				if(st != null){
					for(vdx=0;vdx<20;vdx++){
						if(st[vdx] == 0)continue;
						VBOBuffer v = VBOmap.get(st[vdx]);
						if(v != null){
							VBOmap.remove(v.VBOid);
							vbocount--;
							v.free();
							//System.out.printf("VBOid %d removed\n", v.VBOid);
							//System.out.printf("VBOFAIL: normal delete\n");
						}
						st[vdx] = 0;
					}
				}
				ii.remove();
			}
		}	
		
		int maxvbo = 5000;
		int maxdirect = 2000;
		
		if(DangerZone.renderdistance <= 16){ //Player hurting for speed, hack down on memory usage!
			maxvbo = 3000;
			maxdirect = 1000;
		}
						
		//if STILL too many...
		if(vbocount > maxvbo || VBOmemorysize/(1024*1024) > maxdirect){ //Too many hanging around?
			//blast them down below threshold again.
			//System.out.printf("count, size at start == %d, %d\n", vbocount, VBOmemorysize/(1024*1024));
			Iterator<Entry<Long, VBOBuffer>> it = VBOmap.entrySet().iterator();
			while(it.hasNext()){
				@SuppressWarnings("rawtypes")
				Map.Entry pair = (Map.Entry)it.next();
				VBOBuffer v = (VBOBuffer) pair.getValue();
				if(v != null){ //should never be null
					if(framecounter-v.lastusedframe > 10){ //if hasn't been drawn in the last 10 frames, wipe it.
						vbocount--;
						v.free();
						it.remove();
					}
				}
			}
			//System.out.printf("----count, size at end == %d, %d\n", vbocount, VBOmemorysize/(1024*1024));
		}
		
		VBOlistlock.unlock();
		
		
		//viewing entity got killed?
		if(ViewFromEntity != DangerZone.player){
			if(ViewFromEntity == null){
				ViewFromEntity = DangerZone.player;
				ref_yaw = DangerZone.player.rotation_yaw_head;
			}
			if(ViewFromEntity.deadflag){
				ViewFromEntity = DangerZone.player;
				ref_yaw = DangerZone.player.rotation_yaw_head;
			}
		}
		
		//if(ViewFromEntity.dimension != DangerZone.player.dimension){
			//System.out.printf("OOoops! %d,  %d\n", ViewFromEntity.dimension, DangerZone.player.dimension);
			ViewFromEntity.dimension = DangerZone.player.dimension;
		//}
		
	}
	
	private void calcBounceAndFocus(World world){
		double rdd;
		
		eyeadjust = (float) (ViewFromEntity.getEyeHeight() + DangerZone.eyeheight_adjust);
		if(eyeadjust < 0)eyeadjust = 0;
		
		if(ViewFromEntity != DangerZone.player){
			bounce = lastbounce = 0;
			ViewFromEntity.rotation_pitch_head = ViewFromEntity.rotation_pitch_head % 360;
			ViewFromEntity.rotation_yaw_head = ViewFromEntity.rotation_yaw_head % 360;
			ViewFromEntity.rotation_roll_head = ViewFromEntity.rotation_roll_head % 360;
			ref_yaw = (360f-((ViewFromEntity.rotation_yaw_head+180)%360)); //it's bass-ackward, yes...
			ref_pitch = ViewFromEntity.rotation_pitch_head;
			ref_roll = ViewFromEntity.rotation_roll_head;
			ref_posx = ViewFromEntity.display_posx;
			ref_posy = ViewFromEntity.display_posy;
			ref_posz = ViewFromEntity.display_posz;
			ref_dim = ViewFromEntity.dimension;
			return;
		}
		
		
		
		if(!DangerZone.isVR) {
			ref_pitch = DangerZone.player.rotation_pitch_head;
			ref_yaw = DangerZone.player.rotation_yaw_head;
			ref_roll = DangerZone.player.rotation_roll_head;
			ref_posx = ViewFromEntity.display_posx;
			ref_posy = ViewFromEntity.display_posy;
			ref_posz = ViewFromEntity.display_posz;
			ref_dim = ViewFromEntity.dimension;
		}else {
			ref_pitch = DangerZone.headset.display_pitch;
			ref_yaw = DangerZone.headset.display_yaw;
			ref_roll = DangerZone.headset.display_roll;	
			ref_posx = ViewFromEntity.display_posx;
			ref_posy = ViewFromEntity.display_posy;
			ref_posz = ViewFromEntity.display_posz;
			ref_dim = ViewFromEntity.dimension;
		}
		
		
		/*
		 * Add some bounce to our step!
		 */
		if(DangerZone.player.getGameMode() != GameModes.GHOST && DangerZone.player.getGameMode() != GameModes.LIMBO && DangerZone.player.getRiddenEntity() == null){
			rdd = Math.sqrt(DangerZone.player.motionx*DangerZone.player.motionx + DangerZone.player.motionz*DangerZone.player.motionz);
			if(DangerZone.player.isLadder())rdd = Math.abs(DangerZone.player.motiony*2);
			traveled += rdd;
			if(DangerZone.player.isBaby()){
				traveled += rdd;
				rdd /= 2;
			}
			rdd /= 18; //this is velocity!!!! NOT amplitude....
			
			//System.out.printf("rdd = %f, trvled = %f\n", (float)rdd, (float)traveled);			
			//get SMOOTHER with speed!
			rdd *= (0.35f-rdd)*2.0f;
			if(rdd < 0)rdd = 0;
			
			if(DangerZone.gofast != 0){
				bounce = (float) (rdd * Math.cos(Math.toRadians(traveled*11.3d)));				
			}else{
				bounce = (float) (rdd * Math.cos(Math.toRadians(traveled*13.3d)));
				bounce *= 2.5;
			}
			
			if(!DangerZone.player.getOnGround() && !DangerZone.player.isLadder()){
				bounce = 0;
			}

		}else{
			bounce = 0;
		}
		
		if(bounce != 0){
			if((lastbounce > 0 && bounce < 0) || (lastbounce < 0 && bounce > 0)){
				DangerZone.world.playSound(Blocks.getStepSound(DangerZone.world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy-0.1f), (int)DangerZone.player.posz)), 
						DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 
						0.25f, 1.0f + ((DangerZone.rand.nextFloat()-DangerZone.rand.nextFloat())*0.2f));
			}
			
		}
		
		lastbounce = bounce;
		
		//just a barely noticeable little swagger...
		DangerZone.player.posx += Math.cos(Math.toRadians(DangerZone.player.rotation_yaw))*bounce/12f;
		DangerZone.player.posz += Math.sin(Math.toRadians(DangerZone.player.rotation_yaw))*bounce/12f;
		
		if(bounce < 0)bounce = -bounce;
		
		DangerZone.player.rotation_pitch_head = DangerZone.player.rotation_pitch_head % 360;
		DangerZone.player.rotation_yaw_head = DangerZone.player.rotation_yaw_head % 360;
		DangerZone.player.rotation_roll_head = DangerZone.player.rotation_roll_head % 360;
		
		//what are we looking at?
		boolean changed = focus_finder.find_focus(world);
		
		if(!DangerZone.isVR || changed) {
			show_focus_x = focus_finder.focus_x;
			show_focus_y = focus_finder.focus_y;
			show_focus_z = focus_finder.focus_z;
			show_focus_side = focus_finder.focus_side;
			show_focus_bid = focus_finder.focus_bid;
			show_focus_meta = focus_finder.focus_meta;
			show_focus_damage = focus_finder.focus_damage;
			show_focus_maxdamage = focus_finder.focus_maxdamage;
			show_focus_dist = focus_finder.focus_dist;
			show_focus_entity = focus_finder.focus_entity;
			show_poi_x = focus_finder.poi_x;
			show_poi_y = focus_finder.poi_y;
			show_poi_z = focus_finder.poi_z; 
		}
	}
	
		
	private void lookAtSelf(World world){
		
		f5x = f5y = f5z = f5yaw = f5pitch = 0;
		
		if(DangerZone.f5_front){
			float t;
			float dst = ViewFromEntity.getHeight()*3.25f;
			if(dst < 6)dst = 6;
			Entity e = ViewFromEntity.getRiddenEntity();
			if(e != null){
				float ddst = e.getHeight()*3.25f;
				if(dst < ddst)dst = ddst;
			}
			t = (float) Math.cos(Math.toRadians(ref_pitch));
			f5y = (float) Math.sin(Math.toRadians(ref_pitch))*dst*blockrenderwidth;
			f5x = (float) Math.cos(Math.toRadians(ref_yaw+90f))*dst*blockrenderwidth*Math.abs(t);
			f5z = (float) Math.sin(Math.toRadians(ref_yaw+90f))*dst*blockrenderwidth*Math.abs(t);
			f5yaw = 180f;
			f5pitch = ref_pitch*2;
			if(!DangerZone.isVR)f5pitch = -ref_pitch*2;
		}
		if(DangerZone.f5_back){
			float t;
			float dst = ViewFromEntity.getHeight()*4.25f;
			if(dst < 8)dst = 8;
			Entity e = ViewFromEntity.getRiddenEntity();
			if(e != null){
				float ddst = e.getHeight()*4.25f;
				if(dst < ddst)dst = ddst;
			}
			t = (float) Math.cos(Math.toRadians(ref_pitch));
			f5y = -(float) Math.sin(Math.toRadians(ref_pitch))*dst*blockrenderwidth;
			f5x = -(float) Math.cos(Math.toRadians(ref_yaw+90f))*dst*blockrenderwidth*Math.abs(t);
			f5z = -(float) Math.sin(Math.toRadians(ref_yaw+90f))*dst*blockrenderwidth*Math.abs(t);
			f5yaw = 0f;
			f5pitch = 0f;
		}		
		if(DangerZone.f5_side){
			float t;
			float dst = ViewFromEntity.getHeight()*3.25f;
			if(dst < 6)dst = 6;
			Entity e = ViewFromEntity.getRiddenEntity();
			if(e != null){
				float ddst = e.getHeight()*3.25f;
				if(dst < ddst)dst = ddst;
			}
			t = (float) Math.cos(Math.toRadians(ref_pitch));
			f5y = (float) Math.sin(Math.toRadians(ref_pitch))*dst*blockrenderwidth;
			f5x = -(float) Math.cos(Math.toRadians(ref_yaw-35))*dst*blockrenderwidth*Math.abs(t);
			f5z = -(float) Math.sin(Math.toRadians(ref_yaw-35))*dst*blockrenderwidth*Math.abs(t);
			f5yaw = 270f-35f;
			f5pitch = 0;
			if(!DangerZone.isVR)f5pitch = -ref_pitch*2;
		}
		
		if(DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side){
			Scalef5toSolid();
		}
	}
	
	private void doClickyStuff(World world){
		int i;
		
		if(ViewFromEntity != DangerZone.player)return;
		if(DangerZone.player.getGameMode() == GameModes.LIMBO) {
			hit_cycle_count = 0;
			DangerZone.do_hit_cycle = 0;
			eat_cycle_count = 0;
			DangerZone.do_food_cycle = 0;
			DangerZone.dorightclickup = false;
			DangerZone.rightbuttondowncounter = 0;			
			DangerZone.vrdorightclickup = false;
			DangerZone.vrrightbuttondowncounter = 0;			
			DangerZone.singleshot = false;		
			DangerZone.vrsingleshot = false;			
			DangerZone.semiauto = false;		
			DangerZone.vrsemiauto = false;		
			DangerZone.fullauto = false;		
			DangerZone.vrfullauto = false;
			return; //nope!
		}
		
		if(hit_cycle_count != 0){
			//scale to fps
			i = fps/10;
			if(i < 1)i = 1;
			if(i > 6)i = 6;
			hit_cycles = i+1;			
			hit_cycle_count += hit_cycle_dir;
			if(hit_cycle_count >= hit_cycles){
				if(DangerZone.doleftclick || DangerZone.vrdoleftclick){
					DangerZone.player.leftclick(world, usex, usey, usez, uses, usee==null?0:usee.entityID, DangerZone.magic_power, DangerZone.magic_type, show_poi_x, show_poi_y, show_poi_z);
					DangerZone.doleftclick = false;
					DangerZone.vrdoleftclick = false;
					DangerZone.magic_power = 0;
					
				}
				if(DangerZone.dorightclick || DangerZone.vrdorightclick){
					DangerZone.player.rightclick(world, usex, usey, usez, uses, usee==null?0:usee.entityID, show_poi_x, show_poi_y, show_poi_z);
					DangerZone.dorightclick = false;
					DangerZone.vrdorightclick = false;
					DangerZone.magic_power = 0;
				}
				hit_cycle_dir = -1;
				//hit_cycle_count = hit_cycles;
			}
		}else{
			if(DangerZone.do_hit_cycle != 0){
				//DangerZone.do_hit_cycle = 0;
				hit_cycle_count = 1;
				hit_cycle_dir = 1;
				usex = show_focus_x;
				usey = show_focus_y;
				usez = show_focus_z;
				uses = show_focus_side;
				usee = show_focus_entity;
				if(DangerZone.doleftclick){
					int which = DangerZone.player.world.rand.nextInt(6);
					if(which == 0)DangerZone.player.world.playSound("DangerZone:swish3", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
					if(which == 1)DangerZone.player.world.playSound("DangerZone:swish4", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
					if(which == 2)DangerZone.player.world.playSound("DangerZone:swish5", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
					if(which == 3)DangerZone.player.world.playSound("DangerZone:swish6", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
					if(which == 4)DangerZone.player.world.playSound("DangerZone:swish7", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
					if(which == 5)DangerZone.player.world.playSound("DangerZone:swish8", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
				}
			}
		}
		
		if(eat_cycle_count != 0){			
			//scale to fps
			i = fps/2;
			if(i < 1)i = 1;
			if(i > 30)i = 30;
			eat_cycles = i+1;			
			eat_cycle_count += eat_cycle_dir;
			if(eat_cycle_count >= eat_cycles){
				InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
				eat_cycle_count = eat_cycles;
				if(eat_delay_count > 0){
					if(eat_sound){
						world.playSound("DangerZone:eating", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
					}
					eat_sound = false;
					eat_delay_count--;
				}else{
					if(ic != null && Items.isFood(ic.iid)){
						if(DangerZone.player.getHunger() < DangerZone.player.getMaxHunger()  || Items.eatAnyTime(ic.iid)){
							Item itm = ic.getItem();							
							if(itm != null){
								itm.onFoodEaten(DangerZone.player); //client side callback!
								DangerZone.server_connection.playerActionToServer(0, 2, itm.itemID, 0, 0, 0, 0, 0, 0);
								if(ic != null && Items.isFood(ic.iid)){									
									Utils.spawnParticlesScaled(DangerZone.player.world, "DangerZone:ParticleItem", 10, DangerZone.player.dimension, 
											DangerZone.player.posx+(float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head-90))*0.25f*(float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)),
											DangerZone.player.posy+(DangerZone.player.height*9.25f/10) - (float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head))*0.25f,
											DangerZone.player.posz+(float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head-90))*0.25f*(float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)),
											ic.iid, 0.25f, true);	
								}
								

							}
						}
					}
					eat_cycle_dir = -1;
				}
			}
		}else{
			if(DangerZone.do_food_cycle != 0){
				InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
				if(ic != null && Items.isFood(ic.iid)){
					if(DangerZone.player.getHunger() < DangerZone.player.getMaxHunger() || Items.eatAnyTime(ic.iid)){
						eat_cycle_count = 1;
						eat_cycle_dir = 1;
						eat_delay_count = fps+10;
						eat_sound = true;
					}
				}
			}
		}
		
		if(DangerZone.dorightclickup){			
			//do something here!
			DangerZone.player.rightclickup(world, usex, usey, usez, uses, usee==null?0:usee.entityID, (DangerZone.rightbuttondowncounter*100)/fps);			
			DangerZone.dorightclickup = false;
			DangerZone.rightbuttondowncounter = 0;
		}
		
		if(DangerZone.vrdorightclickup){			
			//do something here!
			DangerZone.player.rightclickup(world, usex, usey, usez, uses, usee==null?0:usee.entityID, (DangerZone.vrrightbuttondowncounter*100)/fps);			
			DangerZone.vrdorightclickup = false;
			DangerZone.vrrightbuttondowncounter = 0;
		}
		
		if(DangerZone.singleshot){			
			//System.out.printf("Worldrenderer.bothdown %d\n", (DangerZone.rightbuttondowncounter*100)/fps);
			DangerZone.player.singleshot(world, usex, usey, usez, uses, usee==null?0:usee.entityID, (DangerZone.rightbuttondowncounter*100)/fps);			
			DangerZone.singleshot = false;
		}
		if(DangerZone.vrsingleshot){			
			//System.out.printf("Worldrenderer.bothdown %d\n", (DangerZone.rightbuttondowncounter*100)/fps);
			DangerZone.player.singleshot(world, usex, usey, usez, uses, usee==null?0:usee.entityID, (DangerZone.vrrightbuttondowncounter*100)/fps);			
			DangerZone.vrsingleshot = false;
		}
		
		if(DangerZone.semiauto){			
			//System.out.printf("Worldrenderer.semiauto %d\n", (DangerZone.rightbuttondowncounter*100)/fps);
			DangerZone.player.semiauto(world, usex, usey, usez, uses, usee==null?0:usee.entityID, (DangerZone.rightbuttondowncounter*100)/fps);			
			DangerZone.semiauto = false;
		}
		if(DangerZone.vrsemiauto){			
			//System.out.printf("Worldrenderer.semiauto %d\n", (DangerZone.rightbuttondowncounter*100)/fps);
			DangerZone.player.semiauto(world, usex, usey, usez, uses, usee==null?0:usee.entityID, (DangerZone.vrrightbuttondowncounter*100)/fps);			
			DangerZone.vrsemiauto = false;
		}
		
		if(DangerZone.fullauto){			
			//System.out.printf("Worldrenderer.fullauto %d\n", (DangerZone.rightbuttondowncounter*100)/fps);
			DangerZone.player.fullauto(world, usex, usey, usez, uses, usee==null?0:usee.entityID, (DangerZone.rightbuttondowncounter*100)/fps);			
			DangerZone.fullauto = false;
		}
		if(DangerZone.vrfullauto){			
			//System.out.printf("Worldrenderer.fullauto %d\n", (DangerZone.rightbuttondowncounter*100)/fps);
			DangerZone.player.fullauto(world, usex, usey, usez, uses, usee==null?0:usee.entityID, (DangerZone.vrrightbuttondowncounter*100)/fps);			
			DangerZone.vrfullauto = false;
		}

		if(DangerZone.vrrightbuttondowncounter > 0) {
			DangerZone.player.setRightButtonDownCount((DangerZone.vrrightbuttondowncounter*100)/fps);
		}else {
			DangerZone.player.setRightButtonDownCount((DangerZone.rightbuttondowncounter*100)/fps); //so other people can see too! Goes to server...	
		}

	}
	
	private void drawPlayerHeldItem(World world){
		if(DangerZone.isVR) {
			drawPlayerHeldItem_VR(world);
		}else {
			drawPlayerHeldItem_3D(world);
		}
	}
	
	private void drawPlayerHeldItem_VR(World world){
		if(ViewFromEntity != DangerZone.player)return;

		InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
		//Draw the currently held item!
		//If not looking at self! Otherwise, humanoid renderer will draw it...
		if(ic != null && !DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side){

			TargetInfo ti = DangerZone.weapon_controller;

			recalcBrightness(DangerZone.player.dimension, (int)(DangerZone.player.posy+(DangerZone.player.getHeight()/2)));
			setBrightness(WorldRendererUtils.getLightMapValue(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy+(DangerZone.player.getHeight()/2)), (int)DangerZone.player.posz));

			//recenter
			//MatrixStack.sendCurrentStack();
			//MatrixStack.pushMatrix();	
			
			//TODO FIXME !!! Should TRANSLATE shift_xyz first, then rotate_world_view. This is probably why held items have different perspective!
			//TODO FIXME !!! Should TRANSLATE shift_xyz first, then rotate_world_view. This is probably why held items have different perspective!
			//TODO FIXME !!! Should TRANSLATE shift_xyz first, then rotate_world_view. This is probably why held items have different perspective!
			//TODO FIXME !!! Should TRANSLATE shift_xyz first, then rotate_world_view. This is probably why held items have different perspective!
			//TODO FIXME !!! Should TRANSLATE shift_xyz first, then rotate_world_view. This is probably why held items have different perspective!
			//????

			rotate_world_view();

			MatrixStack.sendCurrentStack();
			MatrixStack.pushMatrix();				
						
			// get into position where player is holding it
			MatrixStack.translate((float)(ti.rel_posx-DangerZone.headset.rel_posx)*16+shift_x, (float)(ti.rel_posy-DangerZone.headset.rel_posy)*16+shift_y, (float)(ti.rel_posz-DangerZone.headset.rel_posz)*16+shift_z);
			//MatrixStack.translate((float)DangerZone.testx, (float)DangerZone.testy, (float)DangerZone.testz);	
			
			
			MatrixStack.sendCurrentStack();
			MatrixStack.pushMatrix();				
			
			MatrixStack.rotate(ti.display_pitch, 1.0f, 0.0f, 0.0f);
			MatrixStack.rotate(ti.display_yaw, 0.0f, 1.0f, 0.0f);		
			MatrixStack.rotate(ti.display_roll, 0.0f, 0.0f, 1.0f);			
			
			if(ic.iid != 0){
				Item it = ic.getItem();
				if(it != null) {

					GL11.glEnable(GL11.GL_BLEND);
					GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);					
					MatrixStack.scale(0.45f, 0.45f, 0.45f);

					/*
					//for ALIGHNMENT
					MatrixStack.scale(0.25f, 0.25f, 0.25f);				
					GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.25f);	
					forceloadtexture(Blocks.BlockArray[Blocks.hitbox.blockID].getTexture(0)); 	
					MatrixStack.sendCurrentStack();
					drawTexturedCube(0xff, false, Blocks.hitbox.blockID, 0, false);				
					MatrixStack.scale(4, 4, 4);
					*/
					

					MatrixStack.sendCurrentStack();
					MatrixStack.pushMatrix();	
					
					//adjust on a per-item basis					
					//MatrixStack.rotate(DangerZone.testr+it.roll_off, 0.0f, 0.0f, 1.0f);	
					//MatrixStack.rotate(DangerZone.testw+it.yaw_off, 0.0f, 1.0f, 0.0f);
					//MatrixStack.rotate(DangerZone.testp+it.pitch_off, 1.0f, 0.0f, 0.0f); // Rotate The item On X, Y & Z
					//MatrixStack.translate((float)DangerZone.testx+it.xoff, (float)DangerZone.testy+it.yoff, (float)DangerZone.testz+it.zoff);	
					
					//System.out.printf("Item %s: %f, %f, %f : %f, %f, %f\n", it.uniquename, DangerZone.testp+it.pitch_off, DangerZone.testw+it.yaw_off, DangerZone.testr+it.roll_off,
					//		(float)DangerZone.testx+it.xoff, (float)DangerZone.testy+it.yoff, (float)DangerZone.testz+it.zoff);
					
					
					MatrixStack.rotate(it.roll_off, 0.0f, 0.0f, 1.0f);	
					MatrixStack.rotate(it.yaw_off, 0.0f, 1.0f, 0.0f);
					MatrixStack.rotate(it.pitch_off, 1.0f, 0.0f, 0.0f); // Rotate The item On X, Y & Z
					MatrixStack.translate(it.xoff, it.yoff, it.zoff);							


					forceloadtexture(Items.getTexture(ic.iid));
					
					MatrixStack.sendCurrentStack();
					Items.renderMeHeld(this, DangerZone.player, ic, true);

					/*
				temp_counter++;
				if(temp_counter > 60) {
					temp_counter = 0;

					//System.out.printf("Plyer %f, a %f\n", DangerZone.player.posx, DangerZone.player.posx-DangerZone.lastx+DangerZone.active_posx+DangerZone.testx+5.4f);
					EntityArrow e = (EntityArrow)DangerZone.server_world.createEntityByName("DangerZone:EntityArrow", 
							DangerZone.player.dimension, 
							ti.real_posx,
							ti.real_posy+ViewFromEntity.getEyeHeight(),
							ti.real_posz);

					if(e != null){
						//System.out.printf("Arrow!\n");
						e.init();
						e.setBID(0);
						e.setIID(Items.arrow.itemID);
						e.thrower = DangerZone.player;
						e.setDirectionAndVelocity(
								ti.dx, 
								ti.dy,
								ti.dz,
								2f , 0.2f);
						e.setAttackDamage(1f);
						DangerZone.server_world.spawnEntityInWorld(e);
					}



				Utils.spawnParticlesFromServerScaled(DangerZone.server_world, "DangerZone:ParticleDust", 20, DangerZone.player.dimension, 
						ti.real_posx, ti.real_posy+ViewFromEntity.getEyeHeight(), ti.real_posz,
						0, 0.25f*(DangerZone.player.getWidth()+DangerZone.player.getHeight())/4);

				}
					 */

					MatrixStack.popMatrix();
					//Items.renderMe(this, world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz, ic.iid);
					GL11.glDisable(GL11.GL_BLEND);
				}
			}

			if(ic.bid != 0) {

				MatrixStack.scale(0.20f, 0.20f, 0.20f);
				MatrixStack.sendCurrentStack();
				if(Blocks.hasOwnRenderer(ic.bid)){
					Blocks.renderMeHeld(DangerZone.wr, DangerZone.player, ic.bid, true);
				}else{
					drawTexturedCube(0xff, Blocks.isSolidForRender(ic.bid), ic.bid, 0, false);
				}

			}

			MatrixStack.popMatrix();
			MatrixStack.popMatrix();
			MatrixStack.adjustStackDepthDown();
		}
	}
	
	private void drawPlayerHeldItem_3D(World world){
		
		if(ViewFromEntity != DangerZone.player)return;
		
		InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
		//Draw the currently held item!
		//If not looking at self! Otherwise, humanoid renderer will draw it...
		if(ic != null && !DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side){
			

			recalcBrightness(DangerZone.player.dimension, (int)(DangerZone.player.posy+(DangerZone.player.getHeight()/2)));
			setBrightness(WorldRendererUtils.getLightMapValue(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy+(DangerZone.player.getHeight()/2)), (int)DangerZone.player.posz));

			if(ic.bid != 0){
				Block bl = Blocks.BlockArray[ic.bid];
				if(bl instanceof BlockFlower || bl instanceof BlockLeaves){
					if(hit_cycle_count >= hit_cycles){
						Utils.spawnParticlesScaled(DangerZone.player.world, "DangerZone:ParticleDust", 4, DangerZone.player.dimension, 
								DangerZone.player.posx+(float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head-90))*2*(float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)),
								DangerZone.player.posy+(DangerZone.player.height*9.5f/10) - (float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head))*2,
								DangerZone.player.posz+(float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head-90))*2*(float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)),
								0, 0.125f, false);	
					}
				}
			}
			
			
			MatrixStack.sendCurrentStack();
			MatrixStack.pushMatrix();	
			//am flat and rot 0 to player/camera here.
			
			MatrixStack.translate(6f, -(4+(bounce*2)), -12f*45f/DangerZone.fieldOfView);
			MatrixStack.rotate(-15f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
						
			MatrixStack.sendCurrentStack();
			MatrixStack.pushMatrix();	
			if(ic.bid != 0){
				MatrixStack.scale(0.20f, 0.20f, 0.20f);				

				if(hit_cycle_count != 0){					
					MatrixStack.translate(0.2f+hitxb*((float)hit_cycle_count/hit_cycles), -1.2f+hityb*((float)hit_cycle_count/hit_cycles), -0.1f+hitzb*((float)hit_cycle_count/hit_cycles));
					MatrixStack.rotate(4.3f+hitpb*((float)hit_cycle_count/hit_cycles), 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
					MatrixStack.rotate(-2.5f+hitwb*((float)hit_cycle_count/hit_cycles), 0.0f, 1.0f, 0.0f);
					MatrixStack.rotate(-0.1f+hitrb*((float)hit_cycle_count/hit_cycles), 0.0f, 0.0f, 1.0f);
				}else {
					MatrixStack.translate(0.2f, -1.2f, -0.1f);
					MatrixStack.rotate(4.3f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
					MatrixStack.rotate(-2.5f, 0.0f, 1.0f, 0.0f);
					MatrixStack.rotate(-0.1f, 0.0f, 0.0f, 1.0f);
				}

				MatrixStack.sendCurrentStack();
				if(Blocks.hasOwnRenderer(ic.bid)){
					//Blocks.renderMe(this, world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz, ic.bid, 0, 0xff, false);
					Blocks.renderMeHeld(DangerZone.wr, DangerZone.player, ic.bid, true);
				}else{
					drawTexturedCube(0xff, Blocks.isSolidForRender(ic.bid), ic.bid, 0, false);
				}

			}else{
				
				
				if(ic.iid != 0){
					MatrixStack.scale(0.35f, 0.35f, 0.35f);
					GL11.glEnable(GL11.GL_BLEND);
					GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
					
					//OK, this has gotten ugly and most of it should probably be in the item routine.... ugh....
					if(Items.isFlipped(ic.iid)){
						
						if(Items.getfullholdcount(ic.iid)!=0 && (DangerZone.rightbuttondowncounter != 0 || DangerZone.rapidfire_delay != 0)){	
							//There is no flipped with holdcount
							/*
							//System.out.printf("isFlipped holdcount\n");
							//TODO - not implemented!
							//MatrixStack.translate((float)0, (float)0, (float)0);
							MatrixStack.rotate(251.6f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
							MatrixStack.rotate(38.5f+(bounce*4), 0.0f, 1.0f, 0.0f);
							MatrixStack.rotate(-81.7f+(bounce*4), 0.0f, 0.0f, 1.0f);
							*/						
						}else if(hit_cycle_count != 0){	
							//System.out.printf("isFlipped hit\n");
							//DONE
							MatrixStack.translate((float)hitx*((float)hit_cycle_count/hit_cycles), (float)hity*((float)hit_cycle_count/hit_cycles), (float)hitz*((float)hit_cycle_count/hit_cycles));
							MatrixStack.rotate(hitp*((float)hit_cycle_count/hit_cycles)+251.6f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
							MatrixStack.rotate(hitw*((float)hit_cycle_count/hit_cycles)+38.5f+(bounce*4), 0.0f, 1.0f, 0.0f);
							MatrixStack.rotate(hitr*((float)hit_cycle_count/hit_cycles)-81.7f+(bounce*4), 0.0f, 0.0f, 1.0f);
							
						}else if(eat_cycle_count != 0){
							//There is no flipped food.
							/*
							eatbounce = bounce;
							if(eat_cycle_count >= eat_cycles){						
								if(eat_delay_count > 0){
									eatbounce = (float) (Math.cos(Math.toRadians(DangerZone.player.lifetimeticker*25.3f)));
								}
							}
							System.out.printf("isFlipped eatcount\n");
							MatrixStack.translate(1+eatx*((float)eat_cycle_count/eat_cycles), 3+eaty*((float)eat_cycle_count/eat_cycles), 3+eatz*((float)eat_cycle_count/eat_cycles));
							MatrixStack.rotate(-91+eatp*((float)eat_cycle_count/eat_cycles), 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
							MatrixStack.rotate(102+(eatbounce*4)+eatw*((float)eat_cycle_count/eat_cycles), 0.0f, 1.0f, 0.0f);
							MatrixStack.rotate(-124+(eatbounce*4)+eatr*((float)eat_cycle_count/eat_cycles), 0.0f, 0.0f, 1.0f);
							*/
							
						}else{
							//ray gun
							//System.out.printf("isFlipped\n");
							//DONE
							MatrixStack.translate((float)0f, (float)0.8f, (float)0f);
							MatrixStack.rotate(248.5f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
							MatrixStack.rotate(57.1f+(bounce*4), 0.0f, 1.0f, 0.0f);
							MatrixStack.rotate(-76.8f+(bounce*4), 0.0f, 0.0f, 1.0f);
							
						}
					}else{
						//other way
						//System.out.printf("!isFlipped\n");
						if(Items.getfullholdcount(ic.iid)!=0 && (DangerZone.rightbuttondowncounter != 0 || DangerZone.rapidfire_delay != 0)){	
							//Bow!
							//DONE
							if(ic.getItem() instanceof ItemBow) {
								MatrixStack.translate(-1.3f, -0.5f, -0.2f);
								MatrixStack.rotate(64.0f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
								MatrixStack.rotate(-51.2f+(bounce*4), 0.0f, 1.0f, 0.0f);
								MatrixStack.rotate(-109.7f+(bounce*4), 0.0f, 0.0f, 1.0f);
							}else {
								MatrixStack.translate((float)0.1f, (float)0.8f, (float)0.5f);
								MatrixStack.rotate(-92.4f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
								MatrixStack.rotate(59.2f+(bounce*4), 0.0f, 1.0f, 0.0f);
								MatrixStack.rotate(-86.8f+(bounce*4), 0.0f, 0.0f, 1.0f);
							}
						}else if(hit_cycle_count != 0){
							
							//DONE
							MatrixStack.translate((float)0.1f+hitxn*((float)hit_cycle_count/hit_cycles), (float)0.8f+hityn*((float)hit_cycle_count/hit_cycles), (float)-0.1f+hitzn*((float)hit_cycle_count/hit_cycles));	
							MatrixStack.rotate(-91.5f+hitpn*((float)hit_cycle_count/hit_cycles), 1.0f, 0.0f, 0.0f);	
							MatrixStack.rotate(-3.1f+(bounce*4)+hitwn*((float)hit_cycle_count/hit_cycles), 0.0f, 1.0f, 0.0f);
							MatrixStack.rotate(-88.2f+(bounce*4)+hitrn*((float)hit_cycle_count/hit_cycles), 0.0f, 0.0f, 1.0f); // Rotate The item On X, Y & Z
												
						}else if(eat_cycle_count != 0){
							eatbounce = bounce;
							if(eat_cycle_count >= eat_cycles){						
								if(eat_delay_count > 0){
									eatbounce = (float) (Math.cos(Math.toRadians(DangerZone.player.lifetimeticker*25.3f)));
								}
							}
							
							//DONE
							//System.out.printf("!isFlipped eat cycle\n");
							MatrixStack.translate(0.1f+eatxn*((float)eat_cycle_count/eat_cycles), 0.8f +eatyn*((float)eat_cycle_count/eat_cycles), 0.5f+eatzn*((float)eat_cycle_count/eat_cycles));
							MatrixStack.rotate(-92.4f+eatpn*((float)eat_cycle_count/eat_cycles), 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
							MatrixStack.rotate(59.2f+(eatbounce*4)+eatwn*((float)eat_cycle_count/eat_cycles), 0.0f, 1.0f, 0.0f);
							MatrixStack.rotate(-86.8f+(eatbounce*4)+eatrn*((float)eat_cycle_count/eat_cycles), 0.0f, 0.0f, 1.0f);
							
						}else{
							
							if(Items.isFlopped(ic.iid)){
								//Bow!
								//System.out.printf("isFlopped\n");
								//DONE
								MatrixStack.translate((float)-1.3f, (float)-0.5f, (float)-0.2f);
								MatrixStack.rotate(64.0f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
								MatrixStack.rotate(-51.2f+(bounce*4), 0.0f, 1.0f, 0.0f);
								MatrixStack.rotate(-109.7f+(bounce*4), 0.0f, 0.0f, 1.0f);
							}else{
								//sword! MOST ITEMS!!!
								//System.out.printf("!isFlopped\n");
								//DONE								
								MatrixStack.translate((float)0.1f, (float)0.8f, (float)0.5f);
								MatrixStack.rotate(-92.4f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
								MatrixStack.rotate(59.2f+(bounce*4), 0.0f, 1.0f, 0.0f);
								MatrixStack.rotate(-86.8f+(bounce*4), 0.0f, 0.0f, 1.0f);

							}
/*							
							MatrixStack.translate((float)DangerZone.testx, (float)DangerZone.testy, (float)DangerZone.testz);
							MatrixStack.rotate(DangerZone.testp, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
							MatrixStack.rotate(DangerZone.testw+(bounce*4), 0.0f, 1.0f, 0.0f);
							MatrixStack.rotate(DangerZone.testr+(bounce*4), 0.0f, 0.0f, 1.0f);
*/							
						}

					}
					forceloadtexture(Items.getTexture(ic.iid));
					MatrixStack.sendCurrentStack();
					Items.renderMeHeld(this, DangerZone.player, ic, true);
					//Items.renderMe(this, world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz, ic.iid);
					GL11.glDisable(GL11.GL_BLEND);
				}
			}
			MatrixStack.popMatrix();
			MatrixStack.popMatrix();
			MatrixStack.adjustStackDepthDown();
		}
		
	}
	
	/*
	 * ****************************************************************************************************************************************
	 */
	public void rotate_world_view(){

			MatrixStack.rotate( -ref_roll, 0.0f, 0.0f, 1.0f); // Rotate The View On X, Y & Z - works! But is weird! :)
			MatrixStack.rotate( -(ref_yaw+f5yaw), 0.0f, 1.0f, 0.0f); // Rotate The View On X, Y & Z	
			MatrixStack.rotate( -(ref_pitch+f5pitch), 1.0f, 0.0f, 0.0f); // Rotate The View On X, Y & Z

	}
	
	public void do_boring_things(World world, int inview) {
		//clean up some memory and buffers
		doHouseKeeping(world, inview);

		//player movement and focus
		//also set correct display yaw, since player and server actually don't agree!
		calcBounceAndFocus(world);

		//looking at self?
		lookAtSelf(world);
		
		recalcSkyBrightness();
	}


	//FIXME TODO
	//FIXME TODO
	//FIXME TODO
	//FIXME TODO
	//FIXME TODO
	//Nothing, just making it easier to find!
	public void renderWorld(World world, int inview) {

		if(!DangerZone.isVR || (DangerZone.isVR && (inview == 1))){
			if(DangerZone.refresh_rate == 120 && (DangerZone.frame_scaler&0x01)==0) {
				do_boring_things(world, inview);
			}else if(DangerZone.refresh_rate == 90 && (DangerZone.frame_scaler%3)!=0) {
				do_boring_things(world, inview);
			}else { //60
				do_boring_things(world, inview);
			}
		}

		doClickyStuff(world);	

		//have to set background color early!
		if((DangerZone.f12_on && DangerZone.current_gui == null )
				||(inview == 0 && !DangerZone.monitor_enable)){
			sky_red = sky_green = sky_blue = 0.15f;
		}


		//All that work, and then it was as easy as just using the vector... omg...
		//Well, this shouldn't work as well as it does, but good enough for now!
		if(DangerZone.isVR) {
			if(inview == 1){ //left eye
				//change perspective just a little, left eye vs right eye!				
				shift_z = (float)DangerZone.headset.dx/2;
				shift_x = -(float)DangerZone.headset.dz/2;
				shift_y = (float)DangerZone.headset.dy/2;
			}
			if(inview == 2){ //right eye
				shift_z = -(float)DangerZone.headset.dx/2;
				shift_x = (float)DangerZone.headset.dz/2;				
				shift_y = -(float)DangerZone.headset.dy/2;
			}
			if(inview == 0) { //default
				shift_x = 0;
				shift_z = 0;
				shift_y = 0;
			}
			shift_x *= DangerZone.ipd;
			shift_y *= DangerZone.ipd;
			shift_z *= DangerZone.ipd;			
		}


		//GL20.glUseProgram( DangerZone.model_shader );	
		//DangerZone.current_shader = DangerZone.model_shader;
		DangerZone.set_shader_projection(inview, DangerZone.model_shader, DangerZone.screen_width, DangerZone.screen_height);	

		GL11.glClearColor(sky_red, sky_green, sky_blue, 0.0f);
		GL11.glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_DEPTH_BUFFER_BIT); // Clear The Screen And The Depth Buffer

		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_NEAREST);
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_NEAREST);
		GL14.glSecondaryColor3f(0.0f, 0.0f, 0.0f);
		GL11.glDisable(GL11.GL_BLEND);
		/* Enables Depth Testing */
		GL11.glDisable(GL11.GL_CULL_FACE);
		GL11.glEnable(GL11.GL_DEPTH_TEST); // Enables Depth Testing
		GL11.glDepthFunc(GL11.GL_LEQUAL); // The Type Of Depth Test To Do
		//GL11.glClear(GL11.GL_DEPTH_BUFFER_BIT);

		GL11.glEnable(GL11.GL_TEXTURE_2D); 
		GL11.glAlphaFunc ( GL11.GL_GREATER, 0.1f ) ;
		GL11.glEnable ( GL11.GL_ALPHA_TEST ) ;	
		GL11.glEnable(GL14.GL_COLOR_SUM);

		//F12 or monitor screen disabled
		if((DangerZone.f12_on && DangerZone.current_gui == null )
				||(inview == 0 && !DangerZone.monitor_enable)){

			WorldRendererUtils.drawShowcaseMonster(inview);

			GL11.glFlush();
			return;
		}



		//if(DangerZone.fog_enable){
		//	wrfogColor.position(0);
		//	wrfogColor.put(sky_red);
		//	wrfogColor.put(sky_green);
		//	wrfogColor.put(sky_blue);
		//	wrfogColor.put(1.0f);
		//	wrfogColor.position(0);
		//	GL11.glFogfv (GL11.GL_FOG_COLOR, wrfogColor);
		//}




		int i,j;
		double pi = 3.1415926545D;
		double rdd, rr, rhdir;
		int torender = 6;
		float velocity;
		double dist = 0;
		Entity ent;

		ModelBase modl = null;	
		Entity morphent = null;


		recalcBrightness(ref_dim, 60);
		setBrightness();
		last_texture = -1;

		//Let's draw!!! -----------------------------------------------------------------------------------------------------------------------------------------
		MatrixStack.identity();		
		//Ow. The next line hurts...
		MatrixStack.translate( (float)-((((ref_posx)*blockrenderwidth))%(16*blockrenderwidth))+blockrenderwidth/2 + f5x + shift_x, 
				(float)-(((ref_posy+bounce+eyeadjust)-0.5f)*blockrenderwidth) + f5y+shift_y, 
				(float)-((((ref_posz)*blockrenderwidth))%(16*blockrenderwidth))+blockrenderwidth/2 + f5z + shift_z);

		rotate_world_view();					
		MatrixStack.sendCurrentStack();	


		if(ref_pitch < 45 || ref_pitch > 315){ //looking down or up?
			torender = DangerZone.renderdistance;
		}else{
			torender = DangerZone.renderdistance - 2;
		}
		if(torender < 3)torender = 3;
		do_draw_focus = false;

		float use_fov = DangerZone.fieldOfView;
		if(inview != 0)use_fov += 15f; //wider!!!

		//First pass Chunks and sky -----------------------------------------------------------------------------------------------------------------------------------------

		WorldRendererUtils.drawSunAndMoon(world, normal_sun);

		//int skipped = 0;
		for(i=-torender;i<=torender;i++){
			for(j=-torender;j<=torender;j++){ 
				dist = (float) Math.sqrt(i*i + j*j);
				if(dist<=torender){
					rr = (float) Math.atan2((j*16), (i*16));					
					rhdir = (((ref_yaw+f5yaw)-90)%360f)*0.0174533D; //ToRadians()
					rdd = (rr - rhdir)%(pi*2.0D);
					if(rdd<0)rdd = -rdd;
					if(rdd > pi)rdd = rdd-(pi*2.0D);
					if(rdd<0)rdd = -rdd; //Total differential, minus sign.

					if(ref_pitch < 45 || ref_pitch > 315){ //NOT looking down or up?
						if(dist > 8 && rdd > pi/3*use_fov/45.0f){
							//skipped++;
							continue; //Don't render what we can't see!
						}
						if(dist > 4 && rdd > pi/2*use_fov/45.0f){
							//skipped++;
							continue; //Don't render what we can't see!
						}
						if(dist > 1 && rdd > pi*3/4*use_fov/45.0f){
							//skipped++;
							if(!DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side)continue; //Don't render what we can't see!
						}
					}	

					renderChunk(world, i, j, ref_dim, ref_posx, ref_posy, ref_posz);					
				}
			}
		}


		//Focus block -----------------------------------------------------------------------------------------------------------------------------------------		

		if(show_focus_bid != 0 && show_focus_x != 0 && show_focus_z != 0){
			//it HAS focus
			//but should we draw it?
			if(ViewFromEntity.getDistanceFromEntityCenter(show_focus_x, show_focus_y, show_focus_z) > 16) {
				show_focus_x = show_focus_y = show_focus_z = show_focus_bid = show_focus_meta = 0; //can happen in VR
				show_focus_damage = show_focus_maxdamage = 0;
			}else {
				int pbid = world.getblock(ref_dim, (int)ref_posx, (int)(ref_posy+ViewFromEntity.getEyeHeight()), (int)ref_posz);
				if(pbid == 0 || !Blocks.isSolid(pbid) || Blocks.isLiquid(pbid)){

					MatrixStack.identity();

					//Ow. The next line hurts...
					MatrixStack.translate(-(float)((((ref_posx)-((double)show_focus_x+0.5f))*blockrenderwidth))+f5x+ shift_x, 
							-(float)((((ref_posy)+bounce+eyeadjust)-((double)show_focus_y+0.5f))*blockrenderwidth)+f5y+shift_y, 
							-(float)(((ref_posz)-((double)show_focus_z+0.5f))*blockrenderwidth)+f5z+ shift_z);

					rotate_world_view();

					MatrixStack.sendCurrentStack();	
					MatrixStack.pushMatrix();
					//Damaged block animation
					if(show_focus_damage != 0 && show_focus_maxdamage > 0){	
						if(show_focus_damage > show_focus_maxdamage)show_focus_damage = show_focus_maxdamage;
						MatrixStack.scale(1.0f - (0.65f*show_focus_damage/show_focus_maxdamage), 1.0f - (0.65f*show_focus_damage/show_focus_maxdamage), 1.0f - (0.65f*show_focus_damage/show_focus_maxdamage));
						MatrixStack.rotate((float) (15f*show_focus_damage/show_focus_maxdamage*Math.cos(Math.toRadians(ViewFromEntity.lifetimeticker*3))), 1.0f, 0, 0 );
						MatrixStack.rotate((float) (15f*show_focus_damage/show_focus_maxdamage*Math.cos(Math.toRadians(ViewFromEntity.lifetimeticker*7))), 0, 1.0f, 0 );
						MatrixStack.rotate((float) (15f*show_focus_damage/show_focus_maxdamage*Math.cos(Math.toRadians(ViewFromEntity.lifetimeticker*5))), 0, 0, 1.0f );
					}else{
						MatrixStack.scale(1.001f, 1.001f, 1.001f);
					}
					setBrightnessFocusBlock();
					MatrixStack.sendCurrentStack();	
					MatrixStack.pushMatrix();
					if(Blocks.hasOwnRenderer(show_focus_bid)){
						//GL11.glPushMatrix(); // 2
						Blocks.renderMe(this, world, ref_dim, show_focus_x, show_focus_y, show_focus_z, show_focus_bid, show_focus_meta, 0xff, true);
						drawTexturedCube(0, true, show_focus_bid, 0, true); //draw outline!
						//GL11.glPopMatrix(); // 2								
					}else{
						drawTexturedCube(0xff, Blocks.isSolidForRender(show_focus_bid), show_focus_bid, show_focus_meta, true);
					}
					MatrixStack.popMatrix();
					setBrightness();
					//GL11.glPopMatrix(); //1
					MatrixStack.popMatrix();
				}
			}
		}


		//Entities -----------------------------------------------------------------------------------------------------------------------------------------

		draw_entities(world, inview);

		if(inview == 2 || !DangerZone.isVR) {
			//fetch the latest list
			DrawMe.clear();
			DangerZone.displaysorterthread.LDrawMelock.lock();
			Iterator<Integer> li = DangerZone.displaysorterthread.LDrawMe.iterator();	
			while(li.hasNext()) {
				DrawMe.add(li.next());
			}
			DangerZone.displaysorterthread.LDrawMelock.unlock();			
		}

		//particles -----------------------------------------------------------------------------------------------------------------------------------------
		//Now draw some particles!	

		draw_particles(world, inview);

		if(inview == 2 || !DangerZone.isVR) {
			//fetch the latest list
			DrawMeP.clear();
			DangerZone.displaysorterthread.LDrawMePlock.lock();
			Iterator<Particle> li = DangerZone.displaysorterthread.LDrawMeP.iterator();	
			while(li.hasNext()) {
				DrawMeP.add(li.next());
			}
			DangerZone.displaysorterthread.LDrawMePlock.unlock();		
		}


		//Selfie -----------------------------------------------------------------------------------------------------------------------------------------
		//Draw self!!!! LOOK AT MEEEEEEEEEEEE! :)
		if((DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side) && ViewFromEntity == DangerZone.player){				
			boolean washurt;
			float ouch = 1f;

			//Draw self!
			modl = ViewFromEntity.model;
			morphent = null;
			if(ViewFromEntity == DangerZone.player)morphent = DangerZone.player.morph;
			ent = ViewFromEntity;
			if(!ent.isInvisible()){

				float fyw = 360f-((ent.rotation_yaw+180)%360); //WTF?

				MatrixStack.sendCurrentStack();	
				MatrixStack.pushMatrix();  
				//put the entitiy where it goes.
				MatrixStack.translate((float)-((((ref_posx)-ent.posx)*blockrenderwidth))+f5x+ shift_x, 
						(float)-((((ref_posy)+bounce+eyeadjust)-ent.posy)*blockrenderwidth)+f5y+shift_y, 
						(float)-(((ref_posz)-ent.posz)*blockrenderwidth)+f5z+ shift_z);
				MatrixStack.sendCurrentStack();
				MatrixStack.pushMatrix(); 
				//Rotate it around						
				//if(ent.display_rotation_roll != 0)MatrixStack.rotate(ent.display_rotation_roll, 0.0f, 0.0f, 1.0f); // Rotate The Entity On X, Y & Z
				MatrixStack.rotate(-fyw, 0.0f, 1.0f, 0.0f); // Rotate The Entity On X, Y & Z				
				MatrixStack.rotate(ent.rotation_pitch, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z

				recalcBrightness(ref_dim, (int)(ref_posy+(ViewFromEntity.getHeight()/2)));
				setBrightness(WorldRendererUtils.getLightMapValue(world, ref_dim, (int)ref_posx, (int)(ref_posy+(ent.getHeight()/2)), (int)ref_posz));

				//Now all it has to do is draw itself.
				MatrixStack.sendCurrentStack();
				MatrixStack.pushMatrix();  //3 SAVE! - because model can scale and throw off name!

				if(morphent != null){
					loadtexture(modl.getTexture(morphent)); 		//Get a texture for it	
					modl.doScale(morphent);	
				}else{
					loadtexture(modl.getTexture(ent)); 		//Get a texture for it	
					modl.doScale(ent);	
				}

				ouch = 1.0f;//Let it scale itself
				washurt = ent.isHurt();
				if(washurt){
					ouch = 1.1f;
					//GL11.glColor3f(1.0f, 0.15f, 0.15f);
					setHurt();
				}
				if(ent.getDeathFactor() > 0){
					ouch = ent.getDeathFactor();
					//System.out.printf("Entity Death %f\n", ouch);
				}
				velocity = (float) Math.sqrt((ent.motionx*ent.motionx)+(ent.motiony*ent.motiony)+(ent.motionz*ent.motionz));
				//ent.model.render(ent, (float)ent.lifetimeticker, velocity, 0, 0, 0, ouch);
				//System.out.printf("ph,  p, yh, y == %f, %f, %f, %f\n", ent.rotation_pitch_head, ent.rotation_pitch, ent.rotation_yaw_head, ent.rotation_yaw );
				cdir = (float) Math.toRadians(ent.rotation_pitch);
				tdir = (float) Math.toRadians(ent.rotation_pitch_head);
				pdiff = tdir - cdir;
				while(pdiff>Math.PI)pdiff -= Math.PI*2;
				while(pdiff<-Math.PI)pdiff += Math.PI*2;
				pdiff = (float) Math.toDegrees(pdiff);

				cdir = (float) Math.toRadians(ent.rotation_yaw);
				tdir = (float) Math.toRadians(ent.rotation_yaw_head);
				ydiff = tdir - cdir;
				while(ydiff>Math.PI)ydiff -= Math.PI*2;
				while(ydiff<-Math.PI)ydiff += Math.PI*2;
				ydiff = (float) Math.toDegrees(ydiff);

				cdir = (float) Math.toRadians(ent.rotation_roll);
				tdir = (float) Math.toRadians(ent.rotation_roll_head);
				rdiff = tdir - cdir;
				while(rdiff>Math.PI)rdiff -= Math.PI*2;
				while(rdiff<-Math.PI)rdiff += Math.PI*2;
				rdiff = (float) Math.toDegrees(rdiff);						
				MatrixStack.sendCurrentStack();
				if(morphent != null){
					modl.render(morphent, (float)ent.lifetimeticker, velocity, pdiff, -ydiff, rdiff, ouch);	//Draw!	
				}else{
					modl.render(ent, (float)ent.lifetimeticker, velocity, pdiff, -ydiff, rdiff, ouch);	//Draw!	
				}

				MatrixStack.popMatrix();

				if(ent.getPetName() != null){
					MatrixStack.sendCurrentStack();
					MatrixStack.pushMatrix(); 
					MatrixStack.translate(- (font.getWidth(ent.getPetName())/2), -((ent.getNameHeight() * 125)+25), 0);
					if(ent.isBaby())MatrixStack.scale(0.25f, 0.25f, 0.25f);
					MatrixStack.scale(0.15f, 0.15f, 0.15f);
					WorldRendererUtils.textAt3D(font, 0, 0, ent.getPetName());	
					MatrixStack.popMatrix();
				}

				if(ent.getOnFire() > 0){
					MatrixStack.sendCurrentStack();
					MatrixStack.pushMatrix(); 
					WorldRendererUtils.drawEntityOnFire(ent);
					MatrixStack.popMatrix();
				}
				
				if(washurt && DangerZone.showhitbox){
					MatrixStack.identity();								
					if(ent.rotation_pitch != 0) {								
						MatrixStack.rotate(ent.rotation_pitch, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
					}
					if(ent.rotation_yaw != 0) {
						MatrixStack.rotate(ent.rotation_yaw, 0.0f, 1.0f, 0.0f); // Rotate The Entity On X, Y & Z
					}
					if(ent.rotation_roll != 0) {								
						MatrixStack.rotate(ent.rotation_roll, 0.0f, 0.0f, 1.0f); // Rotate The Entity On X, Y & Z
					}									
					if(ent.isBaby())MatrixStack.scale(0.25f, 0.25f, 0.25f);
					MatrixStack.translate(0, 8, 0);
					MatrixStack.scale(ent.getWidth(), ent.getHeight(), ent.getWidth());
					//GL11.glColor4f(1f, 1f, 1f, 0.25f);	
					forceloadtexture(Blocks.BlockArray[Blocks.hitbox.blockID].getTexture(0)); 
					MatrixStack.sendCurrentStack();
					drawTexturedCube(0xff, false, Blocks.hitbox.blockID, 0, false);								
				}								
				if(washurt)setBrightness(0);
				MatrixStack.popMatrix();
				MatrixStack.popMatrix();
			}
		}
		
		
		//Player held item -----------------------------------------------------------------------------------------------------------------------------------------

		if(!DangerZone.showcase) {
			MatrixStack.identity();
			drawPlayerHeldItem(world);
		}
		
		GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixr"), 1f);	
		GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixg"), 1f);	
		GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixb"), 1f);	
		MatrixStack.identity();		


		//translucent chunks -----------------------------------------------------------------------------------------------------------------------------------------
		//Ow. The next line hurts...
		MatrixStack.translate( (float)-((((ref_posx)*blockrenderwidth))%(16*blockrenderwidth))+blockrenderwidth/2 + f5x + shift_x, 
				(float)-(((ref_posy+bounce+eyeadjust)-0.5f)*blockrenderwidth) + f5y+shift_y, 
				(float)-((((ref_posz)*blockrenderwidth))%(16*blockrenderwidth))+blockrenderwidth/2 + f5z + shift_z);

		rotate_world_view();

		MatrixStack.sendCurrentStack();	

		//Now go back and draw the VBOs with translucent blocks!!!
		//Water!!!
		if(!translucentVBOs.isEmpty()){
			Iterator<VBOBuffer> iitr = translucentVBOs.iterator();
			VBOBuffer sstr = null;

			while(iitr.hasNext()){
				sstr = iitr.next();

				//draw the VBOs for this chunk!
				//MatrixStack.sendCurrentStack();	
				MatrixStack.pushMatrix();				
				MatrixStack.translate(sstr.xoff, 0, sstr.zoff); //position to draw from
				MatrixStack.sendCurrentStack();	

				loadStitchedtexture(sstr.textureindex);
				sstr.lastusedframe = framecounter;
				sstr.draw();
				MatrixStack.popMatrix();
			}

			translucentVBOs.clear();
			MatrixStack.adjustStackDepthDown();
		}


		//MENUS -----------------------------------------------------------------------------------------------------------------------------------------

		recalcBrightness(DangerZone.player.dimension, 60);
		setBrightness();

		//GL11.glFlush();

		//it's all flat from here on out!
		GL20.glUseProgram( 0 );
		//DangerZone.current_shader = 0;

		

			GL11.glDisable(GL11.GL_DEPTH_TEST);
			GL11.glMatrixMode(GL11.GL_PROJECTION);
			GL11.glLoadIdentity();
			//puts 0,0 (x,y) at lower left of screen!
			GL11.glOrtho(0,DangerZone.screen_width,0,DangerZone.screen_height,-320,320);

			GL11.glMatrixMode(GL11.GL_MODELVIEW);
			GL11.glLoadIdentity();

			//Draw a little X in the middle of the screen!
			if(!DangerZone.showcase && DangerZone.overlays_on && !DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side && !DangerZone.isVR){

				//DangerZone.wr.loadtexture(Blocks.stone.getTexture(0)); //it just wants a texture loaded, or it gets mad....
				GL11.glDisable(GL11.GL_TEXTURE_2D);

				GL11.glLineWidth(2.0f);		
				GL11.glBegin(GL11.GL_LINE_STRIP);
				GL11.glColor4f(0.75f, 0.75f, 0.75f, 1f);
				GL11.glVertex3f((DangerZone.screen_width/2)-10f, DangerZone.screen_height/2, 0);
				GL11.glColor4f(0.75f, 0.75f, 0.75f, 1f);
				GL11.glVertex3f((DangerZone.screen_width/2)+10f, DangerZone.screen_height/2, 0);
				GL11.glEnd();
				GL11.glBegin(GL11.GL_LINE_STRIP);
				GL11.glColor4f(0.75f, 0.75f, 0.75f, 1f);
				GL11.glVertex3f((DangerZone.screen_width/2), (DangerZone.screen_height/2)-10f, 0);
				GL11.glColor4f(0.75f, 0.75f, 0.75f, 1f);
				GL11.glVertex3f((DangerZone.screen_width/2), (DangerZone.screen_height/2)+10f, 0);
				GL11.glEnd();

			}

			GL11.glEnable(GL11.GL_TEXTURE_2D);
			GL11.glEnable(GL11.GL_BLEND);
			GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

			if(DangerZone.overlays_on)doMenuThings(world, inview);

		

		/*
		 * DONE! Push it all out to the screen!		
		 */		
		//GL11.glFlush();

	}

				
	private void doMenuThings(World world, int inview){
		
		int i;
		
		if(ViewFromEntity != DangerZone.player)return;
		
		int startx = DangerZone.get_left(inview);
		int middle = DangerZone.get_middle(inview);
		int starty = DangerZone.get_top(inview);
		int bottom = DangerZone.get_bottom(inview);

		/*
		 * Draw health/hotbar/etc
		 */
		if(inview != 0) {			
			GL11.glTranslatef(0, 100, 0f);
		}
		
		if(!DangerZone.showcase) {			
			WorldRendererUtils.drawHotbar(world, inview);
			WorldRendererUtils.drawHealth(world, inview);
			WorldRendererUtils.drawHunger(world, inview);
			WorldRendererUtils.drawMagic(world, inview);
			WorldRendererUtils.drawAir(world, inview);
			//WorldRendererUtils.drawBoss(world, inview, focus_entity, DangerZone.vrhit.focus_entity );
			WorldRendererUtils.drawBoss(world, inview );


			//this goes down low towards bottom
			DangerZone.wr.setBrightnessNonFocus();		

			//Let's do some text overlays!
			if(DangerZone.messagetimer > 0 && DangerZone.messagestring != null){
				//System.out.printf("Messagetimer = %d\n",  DangerZone.messagetimer);
				if((!DangerZone.isVR) || inview == 1)DangerZone.messagetimer--;
				WorldRendererUtils.drawRectangleWithTexture(DangerZone.textinputtexture, startx+30, bottom + 120, 600, 30);
				WorldRendererUtils.textAt(font, startx+50, bottom + 150, DangerZone.messagestring);
			}
			if(DangerZone.hotmessagetimer > 0 && DangerZone.hotmessagestring != null){
				//System.out.printf("HotMessagetimer = %d\n",  DangerZone.hotmessagetimer);
				if((!DangerZone.isVR) || inview == 1)DangerZone.hotmessagetimer--;
				WorldRendererUtils.drawRectangleWithTexture(DangerZone.textinputtexture, middle - (5 * DangerZone.hotmessagestring.length()) - 50, bottom + 105, 
						(13 * DangerZone.hotmessagestring.length())+20, 30);
				WorldRendererUtils.textAt(font, middle - (5 * DangerZone.hotmessagestring.length()) - 30, bottom + 135, DangerZone.hotmessagestring);
				InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
				if(DangerZone.current_gui == null && ic != null && ic.iid != 0 && ic.count == 1 && ic.getMaxStack() == 1 && ic.attributes != null){
					int ayoff = bottom + 250;
					if(inview != 0)startx += 200;
					for(i=1;i<10;i++){
						int val = ic.getAttribute(i);
						if(val > 0){
							String outtext = "";
							if(i == ItemAttribute.ACCURACY)outtext = 	"Accuracy:   ";
							if(i == ItemAttribute.DAMAGE)outtext = 		"Damage:     ";
							if(i == ItemAttribute.DURABILITY)outtext = 	"Durability: ";
							if(i == ItemAttribute.REACH)outtext = 		"Reach:      ";
							if(i == ItemAttribute.SPAM)outtext = 		"Spam:       ";
							outtext += String.format("%d", val);
							WorldRendererUtils.textAt(font, startx + 20, ayoff, outtext);
							ayoff -= 25;
						}					
					}
					if(inview != 0)startx -= 200;
				}
			}else{
				if(DangerZone.current_gui == null){
					String s = String.format("%d", DangerZone.player.getExperience());
					WorldRendererUtils.textAt(font, middle - (5 * s.length()) - 30, bottom + 140, s);
				}
			}
		}
		

				
		if(DangerZone.f3_on && DangerZone.current_gui == null){
			int modepos = 10;
			
			//this goes up high
			if(inview != 0) {			
				startx += 250;
				middle += 350;
			}
			DangerZone.wr.setBrightnessNonFocus();		
			String s = String.format("Version: %s", DangerZone.versionstring);
			WorldRendererUtils.textAt(font, startx+10, starty-10, s);
			s = String.format("FPS: %d at Render Distance: %d", fps, DangerZone.renderdistance);
			WorldRendererUtils.textAt(font, startx+10, starty-50, s);
			
			if(DangerZone.server != null && DangerZone.server_chunk_cache != null){
				Dimension dd = Dimensions.DimensionArray[DangerZone.player.dimension];
				if(dd != null){
					s = String.format("Dimension: %s", dd.getDisplayName());				
					WorldRendererUtils.textAt(font, middle, starty-10, s);
					BiomeManager bm = dd.getBiomeManager();
					if(bm != null){
						Biome bb = bm.getBiomeForChunk(null, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
						if(bb != null){
							s = String.format("Biome: %s", bb.uniquename);
							WorldRendererUtils.textAt(font, middle, starty-50, s);
						}
					}
				}
				modepos = 90;
			}
			s = "Survival";
			if(DangerZone.player.getGameMode() == GameModes.CREATIVE)s = "Creative";
			if(DangerZone.player.getGameMode() == GameModes.GHOST)s = "Ghost";
			if(DangerZone.player.getGameMode() == GameModes.LIMBO)s = "Limbo";		
			s = String.format("GameMode: %s", s);				
			WorldRendererUtils.textAt(font, middle, starty-modepos, s);
			
			s = "Normal";
			if(DangerZone.player.getGameDifficulty() == -1)s = "Easy";
			if(DangerZone.player.getGameDifficulty() == -2)s = "Girly";
			if(DangerZone.player.getGameDifficulty() == 1)s = "Hard";	
			if(DangerZone.player.getGameDifficulty() == 2)s = "Brutal";	
			s = String.format("Difficulty: %s", s);				
			WorldRendererUtils.textAt(font, middle, starty-(modepos+40), s);
			
			Chunk c = world.chunkcache.getChunk(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
			if(c != null){	
				List<String>owners = c.ownernames;
				if(owners != null){
					int olen = owners.size();
					i = 0;
					s = "Chunk Owners: ";
					while(olen > 0){
						s += owners.get(i);
						s += ", ";
						olen--;
						i++;
					}
					WorldRendererUtils.textAt(font, middle, starty-(modepos+80), s);
				}
				c = null;
			}
			
			
			s = String.format("XPOS: %d", (int)DangerZone.player.posx);
			WorldRendererUtils.textAt(font, startx + 10, starty-90, s);
			s = String.format("YPOS: %d", (int)DangerZone.player.posy);
			WorldRendererUtils.textAt(font, startx + 10, starty-130, s);
			s = String.format("ZPOS: %d", (int)DangerZone.player.posz);
			WorldRendererUtils.textAt(font, startx + 10, starty-170, s);
			s = String.format("Packets: %d", (int)pps);
			WorldRendererUtils.textAt(font,startx +  10, starty-210, s);
			s = String.format("VBO memory: %d MB", VBOmemorysize/(1024*1024));
			WorldRendererUtils.textAt(font, startx + 10, starty-250, s);
			s = String.format("Light LVL: %f", WorldRendererUtils.getTotalLightAt(DangerZone.player.world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz));
			WorldRendererUtils.textAt(font, startx + 10, starty-290, s);
			if(DangerZone.server != null){
				s = String.format("Entity Freelist: %d", DangerZone.server.entityManager.entity_free_list.size());
				WorldRendererUtils.textAt(font, startx + 10, starty-330, s);
				s = String.format("Entities: %d", DangerZone.server.entityManager.entity_list.size());
				WorldRendererUtils.textAt(font, startx + 10, starty-370, s);
				if(DangerZone.clientParticleManager != null){
					s = String.format("Particles: %d", DangerZone.clientParticleManager.particle_list.size());
					WorldRendererUtils.textAt(font,startx +  10, starty-410, s);
				}
			}else{
				s = String.format("Server Latency(ms): %d", DangerZone.server_connection.lastaverageloop);				
				WorldRendererUtils.textAt(font, startx + 10, starty-330, s);
				s = String.format("Chunks: %d", (int)cps);
				WorldRendererUtils.textAt(font,startx +  10, starty-370, s);
				//int cx = (int)DangerZone.player.posx;
				//int cz = (int)DangerZone.player.posz;
				//cx >>= 4;
				//cz >>= 4;
				//s = String.format("ChunkFile: %s/Dimension-%d/%2x/%d_%d.dat", DangerZone.worldname,DangerZone.player.dimension,(cx+cz)&0xff,cx,cz);			
				//WorldRendererUtils.textAt(font, 10, DangerZone.screen_height-370, s);
				
			}
		}

	}
	


    

	
/*
This routine just does the drawing. The actual VBO vertex data is generated in the VBODataBuilderThread.
In theory, this greatly reduces the possibility of "lag".
In practice, well, it's java. We'll see...
ALL graphics calls are done here, in this thread.
*/
	private void renderChunk(World world, int xrel, int zrel, int dim, double px, double py, double pz){
		int xpos, zpos;	
		VBOBuffer v = null;
		int itemp;

		xpos = (xrel*16)+(int)px;
		zpos = (zrel*16)+(int)pz;

		//This call is special. If the chunk is not in cache, it will just be ignored, but a request is sent to fetch it.
		Chunk c = world.chunkcache.getDecoratedChunkForRenderer(dim, xpos, 0, zpos);
		if(c == null){
			return;
		}
		
		
		VBOlistlock.lock();
		//first make sure VBOs are all valid! Else we have to redraw anyway...
		for(itemp=0;itemp<=20;itemp++){
			if(c.VBOids[itemp] <= 0)break; //end of list. done.
			v = VBOmap.get(c.VBOids[itemp]);
			if(v == null){
				//System.out.printf("VBOFAIL: invalid vbo\n");
				//oops. at least one is no longer valid.
				for(int ivi=0;ivi<20;ivi++){
					//invalidate and free all of them!
					if(c.VBOids[ivi] <= 0)continue;
					v = VBOmap.get(c.VBOids[ivi]);
					if(v != null){					
						VBOmap.remove(v.VBOid);
						vbocount--;
						v.free();
					}					
					c.VBOids[ivi] = 0;
				}
				VBOlistlock.unlock();
				return;
			}
		}
		VBOlistlock.unlock();

		//GL11.glPushMatrix();
		//draw the VBOs for this chunk!	
		//MatrixStack.sendCurrentStack();	
		MatrixStack.pushMatrix();
		
		MatrixStack.translate((xrel*16*blockrenderwidth), 0, (zrel*16*blockrenderwidth)); //position to draw from
		MatrixStack.sendCurrentStack();	
		for(itemp=0;itemp<=20;itemp++){
			if(c.VBOids[itemp] <= 0)break;
			VBOlistlock.lock();
			v = VBOmap.get(c.VBOids[itemp]);
			VBOlistlock.unlock();
			if(v != null){
				v.xoff = (xrel*16*blockrenderwidth);
				v.zoff = (zrel*16*blockrenderwidth);
				if(!v.isTranslucent){				
					loadStitchedtexture(v.textureindex);
					v.lastusedframe = framecounter;
					v.draw(); //this will check for and load new data, or simply redraw old data.
				}else{
					translucentVBOs.add(v);
				}
			}
		}
		MatrixStack.popMatrix();

	}
	 

	/*
	 * Standard block drawing.
	 */
	public void drawTexturedCube(int sides, boolean isSolid, int bid, int meta, boolean focus) {
		if(bid <= 0 || bid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[bid] == null)return;
		
		//Allow non-solid cubes!
		if(!isSolid){
			GL11.glEnable(GL11.GL_BLEND);
			GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		}	
		
		if((meta&0xfc00)!=0){ //There is rotation!
			MatrixStack.sendCurrentStack();
			MatrixStack.pushMatrix();
			//High two bits
			if((meta&0xc000) == 0x4000){//twist
				MatrixStack.rotate(90f, 1, 0, 0);
			}
			if((meta&0xc000) == 0x8000){//twist
				MatrixStack.rotate(180f, 1, 0, 0);
			}
			if((meta&0xc000) == 0xc000){//twist
				MatrixStack.rotate(270f, 1, 0, 0);
			}
			//next bits
			if((meta&0x3000) == 0x3000){//twist
				MatrixStack.rotate(90f, 0, 1, 0);
			}
			if((meta&0x3000) == 0x2000){//twist
				MatrixStack.rotate(180f, 0, 1, 0);
			}
			if((meta&0x3000) == 0x1000){//twist
				MatrixStack.rotate(270f, 0, 1, 0);
			}
			//next bits
			if((meta&0x0c00) == 0x0400){//twist
				MatrixStack.rotate(90f, 0, 0, 1);
			}
			if((meta&0x0c00) == 0x0800){//twist
				MatrixStack.rotate(180f, 0, 0, 1);
			}
			if((meta&0x0c00) == 0x0c00){//twist
				MatrixStack.rotate(270f, 0, 0, 1);
			}
			
			sides = 0xff; //Draw all sides, because we don't know which is where any more... 
		}
		
		MatrixStack.sendCurrentStack();
		
		MatrixStack.sendFinalStack();
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);
		

		if((sides & 0x20) != 0){
			if(loadtextureforblockside(0, bid, isSolid)){ //TOP
				GL30.glBindVertexArray(topid);		
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
				GL30.glBindVertexArray(0);
			}
		}
		
		if((sides & 0x10) != 0){
			if(loadtextureforblockside(5, bid, isSolid)){ //BOTTOM
				GL30.glBindVertexArray(bottomid);		
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
				GL30.glBindVertexArray(0);
			}
		}

		if((sides & 0x08) != 0){
			if(loadtextureforblockside(1, bid, isSolid)){ //FRONT
				GL30.glBindVertexArray(frontid);		
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
				GL30.glBindVertexArray(0);
			}						
		}

		if((sides & 0x04) != 0){
			if(loadtextureforblockside(2, bid, isSolid)){ //BACK
				GL30.glBindVertexArray(backid);		
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
				GL30.glBindVertexArray(0);
			}
		}

		if((sides & 0x01) != 0){
			if(loadtextureforblockside(3, bid, isSolid)){ //LEFT
				GL30.glBindVertexArray(leftid);		
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
				GL30.glBindVertexArray(0);
			}
		}

		if((sides & 0x02) != 0){
			if(loadtextureforblockside(4, bid, isSolid)){ //RIGHT
				GL30.glBindVertexArray(rightid);		
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
				GL30.glBindVertexArray(0);
			}
		}
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);
		
		if((meta&0xfc00)!=0){ //There was rotation!
			MatrixStack.popMatrix();
		}
		
		if(!isSolid){
			GL11.glDisable(GL11.GL_BLEND);
		}
		
		if(focus){	
			
			forceloadtexture(focus_texture);
			
			MatrixStack.scale(1.01f, 1.01f, 1.01f);
			MatrixStack.sendCurrentStack();
			
			MatrixStack.sendFinalStack();
			
			if(show_focus_side == 0){	
				GL30.glBindVertexArray(topid);		
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
				GL30.glBindVertexArray(0);
			}
			if(show_focus_side == 5){
				GL30.glBindVertexArray(bottomid);		
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
				GL30.glBindVertexArray(0);				
			}
			
			if(show_focus_side == 1){				
					GL30.glBindVertexArray(frontid);		
					GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
					GL30.glBindVertexArray(0);										
			}

			if(show_focus_side == 2){				
					GL30.glBindVertexArray(backid);		
					GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
					GL30.glBindVertexArray(0);				
			}

			if(show_focus_side == 3){				
					GL30.glBindVertexArray(leftid);		
					GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
					GL30.glBindVertexArray(0);				
			}

			if(show_focus_side == 4){				
					GL30.glBindVertexArray(rightid);		
					GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);				
					GL30.glBindVertexArray(0);				
			}
			

		}

	}
	
	public void drawTexturedSquare(int side, boolean isSolid, int bid) {
		if(bid <= 0 || bid >= Blocks.blocksMAX)return;
		if(Blocks.BlockArray[bid] == null)return;
		
		//Allow non-solid cubes!
		if(!isSolid){
			GL11.glEnable(GL11.GL_BLEND);
			GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		}		

		if(loadtextureforblockside(side, bid, isSolid)){ //TOP
			
			//GL11.glCallList(frontid);			
			WorldRendererUtils.drawSquare();			
			
		}
		
		if(!isSolid){
			GL11.glDisable(GL11.GL_BLEND);
		}			

	}


	public void loadStitchedtexture(int which){	
		if(which < 0 || which > 19)return; //error! Something has a bad texture
		if(stitches[which] != null){
			if(last_texture != stitches[which].textureID){
				stitches[which].bind();	
				last_texture = stitches[which].textureID;
			}
		}
	}

	public boolean loadtextureforblockside(int side, int bid, boolean solid){
		
		Texture lt = Blocks.BlockArray[bid].getTexture(side);
		if(lt == null)return false;
		if(last_texture != lt.getTextureID()){
			TextureImpl.unbind(); //force reset
			lt.bind();
			last_texture = lt.getTextureID();
			//if(!solid){
				GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_NEAREST);
				GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_NEAREST);
			//}else{
			//	GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_NEAREST_MIPMAP_NEAREST); 
			//	GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_NEAREST);
			//}

		}
		
		return true;
	}
	
	public boolean forceloadtexture(Texture lt){
		if(lt == null)return false;
		last_texture = -1;
		TextureImpl.unbind(); //force reset
		lt.bind();
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_NEAREST);
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_NEAREST);
		return true;
	}
	
	public boolean loadtexture(Texture lt){
		if(lt == null)return false;
		if(last_texture != lt.getTextureID()){
			last_texture = lt.getTextureID();
			TextureImpl.unbind(); //force reset
			lt.bind();
			GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_NEAREST);
			GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_NEAREST);
		}
		return true;
	}
		
	public static void recalcBrightness(int d, int yp){			
			float f = WorldRendererUtils.getBrightnessForLevel(d, yp);
			if(f < 0)f = 0;
			if(f > 1)f = 1;
			brightness_red = brightness_green = brightness_blue = f;			
	}
		
	public void recalcSkyBrightness(){
		float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
		float fsin = (float) Math.sin(Math.toRadians((tod/(float)DangerZone.world.lengthOfDay)*360f));
		fsin *= 1.75f;
		if(fsin > 1)fsin = 1;
		if(DangerZone.no_dark) {
			if(fsin < -0.25f )fsin = -0.25f;
		}
		if(fsin < -1)fsin = -1;
		float fsky = 0.50f + 0.45f*fsin;
		float maxfsky = 1.0f - 0.50f*((float)DangerZone.thundercount/(float)300);
		if(maxfsky<0.5f)maxfsky = 0.5f;
		if(fsky > maxfsky)fsky = maxfsky;		
		
		//sky color is variable per dimension!
		int pld = DangerZone.player.dimension;
		sky_red = Dimensions.DimensionArray[pld].sky_red * fsky;
		sky_green = Dimensions.DimensionArray[pld].sky_green * fsky;
		sky_blue = Dimensions.DimensionArray[pld].sky_blue * fsky;		
	
	}
	
	public void setBrightness(){
		//GL11.glColor3f(brightness_red, brightness_green, brightness_blue);
	}
	
	public void setHurt(){
		
		//if(DangerZone.current_shader == DangerZone.model_shader) {
			GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixr"), 0.95f);	
			GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixg"), 0.10f);	
			GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixb"), 0.10f);	
		//}
	}
	
	
	public void setBrightness(float m){
		float flr, flg, flb;
		flr = brightness_red + m;
		if(flr < 0)flr = 0;
		if(flr > 1)flr = 1;
		flg = brightness_green + m;
		if(flg < 0)flg = 0;
		if(flg > 1)flg = 1;
		flb = brightness_blue + m;
		if(flb < 0)flb = 0;
		if(flb > 1)flb = 1;
		//GL11.glColor3f(flr, flg, flb);
		
		//if(DangerZone.current_shader == DangerZone.model_shader) {
			GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixr"), flr);	
			GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixg"), flg);	
			GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixb"), flb);	
		//}
	}
	

	
	public void setBrightnessFocus(){
		float bval = 1.0f;
		if(!DangerZone.world.isDaytime())bval = 0.75f;
		GL11.glColor3f(bval, bval, bval);
	}
	
	public void setBrightnessFocusBlock(){
		float bval = WorldRendererUtils.getTotalLightAt(DangerZone.world, DangerZone.player.dimension, show_focus_x, show_focus_y, show_focus_z);
		//if(!DangerZone.world.isDaytime())bval = 0.75f;
		if(bval > 1)bval = 1;
		if(bval < 0)bval = 0;
		if(bval > 0.65f){
			bval -= 0.35f;
		}else{
			bval += 0.35f;
		}
		GL11.glColor3f(bval, bval, bval);
	}
	
	public void setBrightnessNonFocus(){
		float bval = 0.75f;
		if(!DangerZone.world.isDaytime())bval = 0.50f;
		GL11.glColor3f(bval, bval, bval);
	}
	
	public int getNextRenderID(){
		int i;
		lock.lock();
		i = GL11.glGenLists(1); //fetch a new display list
		lock.unlock();
		return i;
	}
	
	public long getNextVBOid(){
		long i;
		lock.lock();
		i = nextVBOid;
		nextVBOid++;
		lock.unlock();
		return i;
	}
	

	public void deleteVBOlist(long[] vboids){
		VBOlistlock.lock();
		VBO_delete_list.add(vboids); 
		VBOlistlock.unlock();
	}

	/*
	 * Don't allow seeing through things.
	 * Start at eye level and scan outwards until we find max f5 distance.
	 */
	private void Scalef5toSolid(){
		float dx, dy, dz;
		float dst = 0; 
		dx = dy = dz = 0;
		int bid;
		int ix, iy, iz;
		int lx, ly, lz;
		lx = ly = lz = 0;		
		
		while(dst <= 8f){
			dx = f5x*dst/8f;
			dy = f5y*dst/8f;
			dz = f5z*dst/8f;
			ix = (int) (ref_posx - dx/blockrenderwidth);
			iy = (int) (ref_posy + ViewFromEntity.getEyeHeight() - dy/blockrenderwidth);
			iz = (int) (ref_posz - dz/blockrenderwidth);
			if(ix != lx || iy != ly || iz != lz){ //wait until block change to actually go get one...
				lx = ix;
				ly = iy;
				lz = iz;
				bid = DangerZone.world.getblock(ref_dim, ix, iy, iz);
				if(bid != 0 && Blocks.isSolidForRender(bid)){
					dst -= 0.25f; //back up a bit!
					if(dst < 0)dst = 0;
					dx = f5x*dst/8f;
					dy = f5y*dst/8f;
					dz = f5z*dst/8f;
					break;
				}
			}		
			dst += 0.1f;			
		}
		
		f5x = dx;
		f5y = dy;
		f5z = dz;
	}
	

	
	public void setup_vr_menu() {
		DangerZone.set_shader_ortho(DangerZone.model_shader);
	}

	public void teardown_vr_menu() {		
	}

	private void draw_entities(World world, int inview) {
		
		float velocity;
		ModelBase modl = null;	
		Entity morphent = null;
		String petname =  null;
		double use_posx = 0; 
		double use_posy = 0;
		double use_posz = 0;
		float use_rotation_yaw = 0;
		float use_rotation_pitch = 0;
		float use_rotation_roll = 0;
		long use_ticker = 0;
		float use_velocity = 0;
		float use_head_pitch = 0;
		float use_head_yaw = 0;
		float use_head_roll = 0;
		Entity ent;
		boolean washurt;
		float ouch = 1f;
		
		doforce = false;
		
		MatrixStack.identity();			

		rotate_world_view();
		
		MatrixStack.sendCurrentStack();	

		//Pre-sort the entities we can actually see...
		if(DrawMe == null || DrawMe.isEmpty()) {
			//if(DangerZone.isVR) {
			//	WorldRendererUtils.findClosest(DrawMe, DangerZone.vr_max_entity, DangerZone.renderdistance*8,
			//			(EntityLiving)ViewFromEntity, ref_yaw+f5yaw, ref_dim, ref_posx, ref_posy, ref_posz);
			//}else {
			//	WorldRendererUtils.findClosest(DrawMe, -1, DangerZone.renderdistance*16, 
			//			(EntityLiving)ViewFromEntity, ref_yaw+f5yaw, ref_dim, ref_posx, ref_posy, ref_posz);
			//}
			return;
		}
		
		Iterator<Integer> ii = DrawMe.iterator();
		int ient = 0;
		
		//got a list. Draw them!
		while(ii.hasNext()) {
			ient = ii.next();	
			if(ient <= 0 || ient >= DangerZone.max_entities)continue;
			ent = DangerZone.clientEntityManager.entities[ient];
			if(ent == null)continue;

			modl = ent.model;
			if(modl == null)continue; //should not happen. filtered out in list generator.
			
			morphent = null;
			if(ent instanceof Player){
				Player pp = (Player)ent;
				modl = pp.model;
				morphent = pp.morph;
			}

			velocity = (float) Math.sqrt((ent.motionx*ent.motionx)+(ent.motiony*ent.motiony)+(ent.motionz*ent.motionz));

			cdir = (float) Math.toRadians(ent.display_rotation_pitch);
			tdir = (float) Math.toRadians(ent.rotation_pitch_head);
			pdiff = tdir - cdir;
			while(pdiff>Math.PI)pdiff -= Math.PI*2;
			while(pdiff<-Math.PI)pdiff += Math.PI*2;
			pdiff = (float) Math.toDegrees(pdiff);

			cdir = (float) Math.toRadians(ent.display_rotation_yaw);
			tdir = (float) Math.toRadians(ent.rotation_yaw_head);
			ydiff = tdir - cdir;
			while(ydiff>Math.PI)ydiff -= Math.PI*2;
			while(ydiff<-Math.PI)ydiff += Math.PI*2;
			ydiff = (float) Math.toDegrees(ydiff);

			cdir = (float) Math.toRadians(ent.display_rotation_roll);
			tdir = (float) Math.toRadians(ent.rotation_roll_head);
			rdiff = tdir - cdir;
			while(rdiff>Math.PI)rdiff -= Math.PI*2;
			while(rdiff<-Math.PI)rdiff += Math.PI*2;
			rdiff = (float) Math.toDegrees(rdiff);				

			//set
			use_posx = -((((ref_posx)-ent.display_posx)*blockrenderwidth)); 
			use_posy = -((((ref_posy)+bounce+eyeadjust)-ent.display_posy)*blockrenderwidth);
			use_posz = -(((ref_posz)-ent.display_posz)*blockrenderwidth);
			use_rotation_yaw = -ent.display_rotation_yaw;
			use_rotation_pitch = -ent.display_rotation_pitch;
			use_rotation_roll = ent.display_rotation_roll;
			use_ticker = ent.lifetimeticker;
			use_velocity = velocity;
			use_head_pitch = pdiff;
			use_head_yaw = ydiff;
			use_head_roll = rdiff;

			if(inview == 1) {
				//save
				ent.modesync_rotation_yaw = use_rotation_yaw;
				ent.modesync_rotation_pitch = use_rotation_pitch;
				ent.modesync_rotation_roll = use_rotation_roll;
				ent.modesync_velocity = use_velocity;
				ent.modesync_ticker = use_ticker;
				ent.modesync_head_pitch = use_head_pitch;
				ent.modesync_head_yaw = use_head_yaw;
				ent.modesync_head_roll = use_head_roll;
				ent.modesync_posx = use_posx;
				ent.modesync_posy = use_posy;
				ent.modesync_posz = use_posz;
				ent.modesync_isvalid = true;
			}

			if(inview == 2) {
				//use saved values so eyes are in sync!!!
				if(!ent.modesync_isvalid)continue; //oops! Probably a new entity just came into range.
				use_rotation_yaw = ent.modesync_rotation_yaw;
				use_rotation_pitch = ent.modesync_rotation_pitch;
				use_rotation_roll = ent.modesync_rotation_roll;
				use_velocity = ent.modesync_velocity;
				use_ticker = ent.modesync_ticker;
				use_head_pitch = ent.modesync_head_pitch;
				use_head_yaw = ent.modesync_head_yaw;
				use_head_roll = ent.modesync_head_roll;
				use_posx = ent.modesync_posx;
				use_posy = ent.modesync_posy;
				use_posz = ent.modesync_posz;
				ent.modesync_isvalid = false; //no longer valid
			}

			//MatrixStack.sendCurrentStack();	
			MatrixStack.pushMatrix();  //1

			//Rotate it around																			
			if(use_rotation_pitch != 0) {								
				MatrixStack.rotate(use_rotation_pitch, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
			}
			if(use_rotation_yaw != 0) {
				MatrixStack.rotate(use_rotation_yaw, 0.0f, 1.0f, 0.0f); // Rotate The Entity On X, Y & Z
			}
			if(use_rotation_roll != 0) {								
				MatrixStack.rotate(use_rotation_roll, 0.0f, 0.0f, 1.0f); // Rotate The Entity On X, Y & Z
			}	

			//put the entity where it goes.
			MatrixStack.translate((float)use_posx + f5x + shift_x, 
					(float)use_posy + f5y + shift_y, 
					(float)use_posz + f5z + shift_z);

			MatrixStack.sendCurrentStack();
			MatrixStack.pushMatrix();  //2

			recalcBrightness(ref_dim, (int)(ent.display_posy+(ent.getHeight()/2)));
			setBrightness(ent.getBrightness()+WorldRendererUtils.getLightMapValue(ent.world, ent.dimension, (int)ent.display_posx, (int)(ent.display_posy+(ent.getHeight()/2)), (int)ent.display_posz));
			//Now all it has to do is draw itself.

			ouch = 1.0f;//Let it scale itself
			washurt = ent.isHurt();
			if(washurt){
				ouch = 1.1f;					
				//GL11.glColor3f(1.0f, 0.15f, 0.15f);	
				setHurt();
			}
			if(ent.getDeathFactor() > 0){
				ouch = ent.getDeathFactor();
				//System.out.printf("Entity Death %f\n", ouch);
			}

			if(morphent != null){
				if(doforce){									
					forceloadtexture(modl.getTexture(morphent)); 		//Get a texture for it	
					doforce = false;
				}else{
					loadtexture(modl.getTexture(morphent)); 		//Get a texture for it	
				}							
				modl.doScale(morphent);	
				MatrixStack.sendCurrentStack();
				MatrixStack.pushMatrix();
				modl.render(morphent, (float)use_ticker, use_velocity, use_head_pitch, use_head_yaw, use_head_roll, ouch);	//Draw!	
				MatrixStack.popMatrix();
			}else{
				if(doforce){
					forceloadtexture(modl.getTexture(ent)); 		//Get a texture for it	
					doforce = false;
				}else{
					loadtexture(modl.getTexture(ent)); 		//Get a texture for it	
				}
				modl.doScale(ent);
				MatrixStack.sendCurrentStack();
				MatrixStack.pushMatrix();
				modl.render(ent, (float)use_ticker, use_velocity, use_head_pitch, use_head_yaw, use_head_roll, ouch);	//Draw!	
				MatrixStack.popMatrix();
			}


			petname = ent.getPetName();
			if(petname != null || ent.getOnFire() > 0 || (washurt && DangerZone.showhitbox)){

				MatrixStack.popMatrix();//2
				MatrixStack.identity();

				//Get back into position
				MatrixStack.translate((float)use_posx + f5x + shift_x, 
						(float)use_posy + f5y + shift_y, 
						(float)use_posz + f5z + shift_z);

				MatrixStack.sendCurrentStack();
				MatrixStack.pushMatrix();//2

				MatrixStack.rotate((ref_yaw+f5yaw), 0.0f, 1.0f, 0.0f); // Rotate FLAT to player

				if(petname != null){
					doforce = true;
					MatrixStack.sendCurrentStack();
					MatrixStack.pushMatrix();	
					//get into position
					MatrixStack.translate(- (font.getWidth(petname)/2), -((ent.getNameHeight() * 125)+25), 0);
					//scale everything down
					if(ent.isBaby())MatrixStack.scale(0.25f, 0.25f, 0.25f);
					MatrixStack.scale(0.15f, 0.15f, 0.15f);
					WorldRendererUtils.textAt3D(font, 0, 0, petname);	
					MatrixStack.popMatrix();
				}							
				if(ent.getOnFire() > 0){
					MatrixStack.sendCurrentStack();
					MatrixStack.pushMatrix();  //3 
					WorldRendererUtils.drawEntityOnFire(ent);
					MatrixStack.popMatrix();	//3 
				}								

				//Last, so it shows fire inside too!
				if(washurt && DangerZone.showhitbox){
					MatrixStack.identity();								
					if(use_rotation_pitch != 0) {								
						MatrixStack.rotate(use_rotation_pitch, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
					}
					if(use_rotation_yaw != 0) {
						MatrixStack.rotate(use_rotation_yaw, 0.0f, 1.0f, 0.0f); // Rotate The Entity On X, Y & Z
					}
					if(use_rotation_roll != 0) {								
						MatrixStack.rotate(use_rotation_roll, 0.0f, 0.0f, 1.0f); // Rotate The Entity On X, Y & Z
					}									
					if(ent.isBaby())MatrixStack.scale(0.25f, 0.25f, 0.25f);
					MatrixStack.translate(0, 8, 0);
					MatrixStack.scale(ent.getWidth(), ent.getHeight(), ent.getWidth());
					//GL11.glColor4f(1f, 1f, 1f, 0.25f);	
					forceloadtexture(Blocks.BlockArray[Blocks.hitbox.blockID].getTexture(0)); 
					MatrixStack.sendCurrentStack();
					drawTexturedCube(0xff, false, Blocks.hitbox.blockID, 0, false);								
				}

			}


			if(washurt)setBrightness(0);


			MatrixStack.popMatrix(); 
			MatrixStack.popMatrix(); 
			//MatrixStack.adjustStackDepthDown();

		}
		petname =  null;
		ent = null;

	}
	
	private void draw_particles(World world, int inview) {
		
		//Pre-sort the particles we can actually see...
		if(DrawMeP == null || DrawMeP.isEmpty()) {
			//if(DangerZone.isVR) {
			//	WorldRendererUtils.findClosestP(DrawMeP, DangerZone.vr_max_particle, DangerZone.renderdistance*8, //severely throttled because VR lags so bad
			//			(EntityLiving)ViewFromEntity, ref_yaw+f5yaw, ref_dim, ref_posx, ref_posy, ref_posz);
			//}else {
			//	WorldRendererUtils.findClosestP(DrawMeP, -1, DangerZone.renderdistance*16, 
			//			(EntityLiving)ViewFromEntity, ref_yaw+f5yaw, ref_dim, ref_posx, ref_posy, ref_posz);
			//}
			return;
		}

		Iterator<Particle> iip = DrawMeP.iterator();
		Particle pst;

		//got a list. Draw them!
		while(iip.hasNext()) {
			pst = iip.next();	
			if(pst.model != null) {

				//MatrixStack.sendCurrentStack();	
				MatrixStack.pushMatrix();  //1
				//put the entitiy where it goes.
				MatrixStack.translate((float)-((((ref_posx)-pst.posx)*blockrenderwidth))+f5x+ shift_x, 
						(float)-((((ref_posy)+bounce+eyeadjust)-pst.posy)*blockrenderwidth)+f5y+shift_y, 
						(float)-(((ref_posz)-pst.posz)*blockrenderwidth)+f5z+ shift_z);
				MatrixStack.sendCurrentStack();
				MatrixStack.pushMatrix();  //2

				MatrixStack.rotate(pst.rotation_roll, 0.0f, 0.0f, 1.0f); // Rotate The Entity On X, Y & Z
				MatrixStack.rotate(pst.rotation_yaw, 0.0f, 1.0f, 0.0f); // Rotate The Entity On X, Y & Z
				MatrixStack.rotate(pst.rotation_pitch, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
				
				recalcBrightness(ref_dim, (int)pst.posy);
				setBrightness(pst.brightness + WorldRendererUtils.getLightMapValue(world, pst.dimension, (int)pst.posx, (int)(pst.posy), (int)pst.posz));
				MatrixStack.scale(pst.renderscale, pst.renderscale, pst.renderscale);
				//Now all it has to do is draw itself.
				MatrixStack.sendCurrentStack();

				if(doforce){
					forceloadtexture(pst.model.getTexture(pst)); 		//Get a texture for it	
					doforce = false;
				}else{
					loadtexture(pst.model.getTexture(pst)); 		//Get a texture for it	
				}

				pst.model.renderParticle(pst);	//Draw!	
				
				MatrixStack.popMatrix();
				MatrixStack.popMatrix();
				//MatrixStack.adjustStackDepthDown();
				
			}
		}
	}
	
	
}