package dangerzone.rendering;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;


public class MatrixStack {
	
	/*
	 * Yeah, I'm as baffled as you are. Not sure why this works.
	 * Should have been faster to do all the multiplies in the graphics card,
	 * but for some reason it wasn't getting done there even though I had all
	 * the logic in the shader. It ended up being done in the CPU, and so
	 * inefficiently, that it was slower than dog poo. So, I moved it here with
	 * the intent to optimize it, and, oddly enough, it worked. There are a
	 * few other minor optimizations that can be made perhaps, but for now,
	 * it works by magic, so I'm gonna leave it alone.
	 */
	
	private static final int SIZE = 4;
	private static final int DEPTH = 15;
	private static float[][] elements_trans = new float[DEPTH][SIZE * SIZE];
	private static float[][] elements_rotxx = new float[DEPTH][SIZE * SIZE];
	private static float[][] elements_rotyy = new float[DEPTH][SIZE * SIZE];
	private static float[][] elements_rotzz = new float[DEPTH][SIZE * SIZE];
	private static float[][] elements_scale = new float[DEPTH][SIZE * SIZE];
	private static int[] orders = new int[DEPTH]; //3 bits each, 0 = unused!
	private static int[] orders_next = new int[DEPTH];
	private static int next = 0;
	
	//private static float[][] save_elements_trans = new float[DEPTH][SIZE * SIZE];
	//private static float[][] save_elements_rotxx = new float[DEPTH][SIZE * SIZE];
	//private static float[][] save_elements_rotyy = new float[DEPTH][SIZE * SIZE];
	//private static float[][] save_elements_rotzz = new float[DEPTH][SIZE * SIZE];
	//private static float[][] save_elements_scale = new float[DEPTH][SIZE * SIZE];
	//private static float[][] save_mats = new float[DEPTH][SIZE * SIZE];
	private static int[] save_orders = new int[DEPTH];
	private static int[] save_orders_next = new int[DEPTH];	
	//private static int save_next = 0;
	
	private static float[] elements_trans_cleared = new float[SIZE * SIZE];
	private static float[] elements_rotxx_cleared = new float[SIZE * SIZE];
	private static float[] elements_rotyy_cleared = new float[SIZE * SIZE];
	private static float[] elements_rotzz_cleared = new float[SIZE * SIZE];
	private static float[] elements_scale_cleared = new float[SIZE * SIZE];
	
	private static float[][] mats = new float[DEPTH][SIZE * SIZE];
	private static float[] proj_save = new float[SIZE * SIZE];
	private static float[] temp = new float[SIZE * SIZE];
	
	public static void reset(float[] proj) {
		next = 0;
		//save_next = 0;
		for(int i=0;i<DEPTH;i++) {
			orders[i] = 0;
			orders_next[i] = 0;
			save_orders[i] = 0;
			save_orders_next[i] = 0;
		}
				
		for (int i = 0; i < SIZE; i++) {
			for (int j = 0; j < SIZE; j++) {
				elements_trans_cleared[(i * SIZE) + j] = 0;
				elements_rotxx_cleared[(i * SIZE) + j] = 0;
				elements_rotyy_cleared[(i * SIZE) + j] = 0;
				elements_rotzz_cleared[(i * SIZE) + j] = 0;
				elements_scale_cleared[(i * SIZE) + j] = 0;
				mats[0][(i * SIZE) + j] = proj[(i * SIZE) + j]; //copy in! This is our "identity"
				proj_save[(i * SIZE) + j] = proj[(i * SIZE) + j];
			}
		}
				
		elements_trans_cleared[0] = 1;
		elements_rotxx_cleared[0] = 1;
		elements_rotxx_cleared[0] = 1;
		elements_rotxx_cleared[0] = 1;
		elements_scale_cleared[0] = 1;
		
		elements_trans_cleared[(SIZE) + 1] = 1;
		elements_rotxx_cleared[(SIZE) + 1] = 1;
		elements_rotyy_cleared[(SIZE) + 1] = 1;
		elements_rotzz_cleared[(SIZE) + 1] = 1;
		elements_scale_cleared[(SIZE) + 1] = 1;
		
		elements_trans_cleared[(2 * SIZE) + 2] = 1;
		elements_rotxx_cleared[(2 * SIZE) + 2] = 1;
		elements_rotyy_cleared[(2 * SIZE) + 2] = 1;
		elements_rotzz_cleared[(2 * SIZE) + 2] = 1;
		elements_scale_cleared[(2 * SIZE) + 2] = 1;
		
		elements_trans_cleared[(3 * SIZE) + 3] = 1;
		elements_rotxx_cleared[(3 * SIZE) + 3] = 1;
		elements_rotyy_cleared[(3 * SIZE) + 3] = 1;
		elements_rotzz_cleared[(3 * SIZE) + 3] = 1;
		elements_scale_cleared[(3 * SIZE) + 3] = 1;
		
		//These are different! Set them to "0" rotation!
		rotate_clear(0, 1, 0, 0);
		rotate_clear(0, 0, 1, 0);
		rotate_clear(0, 0, 0, 1);			
		
		identity();
	}
	
	public static void identity () {
		
		//Initialize current stack to "1".		
		orders[next] = 0;
		orders_next[next] = 0;
		
		for (int i = 0; i < SIZE*SIZE; i++) {
			//for (int j = 0; j < SIZE; j++) {
				elements_trans[next][i] = elements_trans_cleared[i];
				elements_rotxx[next][i] = elements_rotxx_cleared[i];
				elements_rotyy[next][i] = elements_rotyy_cleared[i];
				elements_rotzz[next][i] = elements_rotzz_cleared[i];
				elements_scale[next][i] = elements_scale_cleared[i];
			//}
		}
		
		if(next == 0) {
			for (int i = 0; i < SIZE*SIZE; i++) {
				//for (int j = 0; j < SIZE; j++) {
					mats[0][i] = proj_save[i];
				//}
			}
		}				
	}

	/*
	public static void saveMatrix() {
		
		for (int i = 0; i < SIZE; i++) {
			for (int j = 0; j < SIZE; j++) {
				save_elements_trans[save_next][(j * SIZE) + i] = elements_trans[next][(j * SIZE) + i];
				save_elements_rotxx[save_next][(j * SIZE) + i] = elements_rotxx[next][(j * SIZE) + i];
				save_elements_rotyy[save_next][(j * SIZE) + i] = elements_rotyy[next][(j * SIZE) + i];
				save_elements_rotzz[save_next][(j * SIZE) + i] = elements_rotzz[next][(j * SIZE) + i];
				save_elements_scale[save_next][(j * SIZE) + i] = elements_scale[next][(j * SIZE) + i];
				save_mats[save_next][(j * SIZE) + i] = mats[next][(j * SIZE) + i];
			}
		}
		save_orders[save_next] = orders[next];
		save_orders_next[save_next] = orders_next[next];
		
		if(save_next+1 >= DEPTH)return;	
		save_next++;
	}
	
	public static void restoreMatrix() {
		if(save_next <= 0)return;
		save_next--;
		
		for (int i = 0; i < SIZE; i++) {
			for (int j = 0; j < SIZE; j++) {
				elements_trans[next][(j * SIZE) + i] = save_elements_trans[save_next][(j * SIZE) + i];
				elements_rotxx[next][(j * SIZE) + i] = save_elements_rotxx[save_next][(j * SIZE) + i];
				elements_rotyy[next][(j * SIZE) + i] = save_elements_rotyy[save_next][(j * SIZE) + i];
				elements_rotzz[next][(j * SIZE) + i] = save_elements_rotzz[save_next][(j * SIZE) + i];
				elements_scale[next][(j * SIZE) + i] = save_elements_scale[save_next][(j * SIZE) + i];
				mats[next][(j * SIZE) + i] = save_mats[save_next][(j * SIZE) + i];
			}
		}
		orders[next] = save_orders[save_next];
		orders_next[next] = save_orders_next[save_next];
		
	}
	*/
	
	//PUSH AND SAVE ARE TWO VERY DIFFERENT THINGS!!!
	//Push will increment next and preserve the current matrixes for the graphics.
	//Save just makes a copy.
	public static void pushMatrix() {
		
		//if(orders[next] == 0)return; //NO! This happens a lot!!!
		//adjustStackDepthUp(); //make sure orders is reset to 0 if nothing happened!
			
		if(next+1 >= DEPTH)return;	
		
		//multiply out current stack
		if(next == 0) {
			//mats[0] = proj_save;
			for(int k=0;k<SIZE*SIZE;k++)mats[0][k] = proj_save[k];
		}else {
			//mats[next] = mats[next-1]; //fetch previous
			for(int k=0;k<SIZE*SIZE;k++)mats[next][k] = mats[next-1][k];
		}
		
		mul_it_out(next);
		
		next++;
		
		//Initialize next stack to "1".		
		identity();		
		
	}
	
	public static void popMatrix() {
		if(next <= 0)return;
		orders[next] = 0;
		orders_next[next] = 0;
		next--;		
		//adjustStackDepthDown();
	}
	
	
	//multiplies into temp
	private static void mul(float[] right, float[] left) { 
		int isz;
		for (int i = 0; i < SIZE; i++) {
			isz = i*SIZE;
			for (int j = 0; j < SIZE; j++) {
				temp[isz + j] = (left[isz] * right[j]) +
								   (left[isz + 1] * right[SIZE + j]) +
								   (left[isz + 2] * right[2*SIZE + j]) +
								   (left[isz + 3] * right[3*SIZE + j]);
			}
		}		
	}
	
	private static void mul_it_out(int which) {
		
		if(orders[which] == 0)return; //nothing to do.
		
		for(int i=4;i>=0;i--){	//order here counts! Loop order too!		
			if(is_next(which, i+1, 0)) {				
				mul(elements_trans[which], mats[which]);
				for(int k=0;k<SIZE*SIZE;k++)mats[which][k] = temp[k];
				continue;
			}
			if(is_next(which, i+1, 9)) {				
				mul(elements_rotyy[which], mats[which]);
				for(int k=0;k<SIZE*SIZE;k++)mats[which][k] = temp[k];
				continue;
			}
			if(is_next(which, i+1, 6)) {				
				mul(elements_rotxx[which], mats[which]);
				for(int k=0;k<SIZE*SIZE;k++)mats[which][k] = temp[k];
				continue;
			}
			if(is_next(which, i+1, 12)) {				
				mul(elements_rotzz[which], mats[which]);
				for(int k=0;k<SIZE*SIZE;k++)mats[which][k] = temp[k];
				continue;
			}
			if(is_next(which, i+1, 3)) {				
				mul(elements_scale[which], mats[which]);
				for(int k=0;k<SIZE*SIZE;k++)mats[which][k] = temp[k];
			}
		}
	}	
	
	private static Boolean is_next(int lvel, int nxt, int shift){
		if(((orders[lvel]>>shift)&0x07) == nxt)return true;
		return false;
	}
	
	public static void set_order(int which, int bits, int shift) {
		if((orders[which] & (bits << shift)) != 0)return; //already has an order
		if(orders_next[which] >= 5)return; //already did 5!
		orders_next[which]++;
		orders[which] |= (orders_next[which] << shift); 
	}
	
	public static boolean is_used(int which, int bits, int shift) {
		if((orders[which] & (bits<<shift)) != 0)return true;
		return false;
	}
	
	//These next two are CUMULATIVE
	public static void translate(float x, float y, float z) {	
		set_order(next, 0x07, 0); //trans bits, mask, and shift!
		elements_trans[next][3] += x;
		elements_trans[next][SIZE + 3] += y;
		elements_trans[next][(2 * SIZE) + 3] += z;
	}
	
	public static void scale(float x, float y, float z) {	
		set_order(next, 0x07, 3); //trans bits, mask, and shift!
		elements_scale[next][0] *= x;
		elements_scale[next][SIZE + 1] *= y;
		elements_scale[next][(2 * SIZE) + 2] *= z;
	}
	
	/*
	public static void set_rotation(Matrix4f mat, float x, float y, float z) {
		if(x != 0) {
			set_order(next, 0x07, 6); //trans bits, mask, and shift!
			for(int i=0;i<SIZE;i++) {
				for(int j=0;j<SIZE;j++) {
					elements_rotxx[next][(j * SIZE) + i] = mat.get(j, i); //might be backwards, I dunno...
				}
			}
		}
		if(y != 0) {
			set_order(next, 0x07, 9); //trans bits, mask, and shift!
			for(int i=0;i<SIZE;i++) {
				for(int j=0;j<SIZE;j++) {
					elements_rotyy[next][(j * SIZE) + i] = mat.get(j, i); //might be backwards, I dunno...
				}
			}
		}
		if(z != 0) {
			set_order(next, 0x07, 12); //trans bits, mask, and shift!
			for(int i=0;i<SIZE;i++) {
				for(int j=0;j<SIZE;j++) {
					elements_rotzz[next][(j * SIZE) + i] = mat.get(j, i); //might be backwards, I dunno...
				}
			}
		}
	}
	*/
	
	public static void rotate(float angle, float x, float y, float z) {
		
		if(angle == 0)return;
		
		float cos = (float) Fastmath.cos(Math.toRadians(angle));
		float sin = (float) Fastmath.sin(Math.toRadians(angle));
		float C = 1 - cos;
		
		if(x != 0) {
			set_order(next, 0x07, 6); //trans bits, mask, and shift!
			elements_rotxx[next][0] = cos + (x * x * C);
			elements_rotxx[next][(SIZE)] = (x * y * C) - (z * sin);
			elements_rotxx[next][(2 * SIZE)] = (x * z * C) + (y * sin);
			elements_rotxx[next][1] = (y * x * C) + (z * sin);
			elements_rotxx[next][(SIZE) + 1] = cos + (y * y * C);
			elements_rotxx[next][(2 * SIZE) + 1] = (y * z * C) - (x * sin);
			elements_rotxx[next][2] = (z * x * C) - (y * sin);
			elements_rotxx[next][(SIZE) + 2] = (z * y * C) + (x * sin);
			elements_rotxx[next][(2 * SIZE) + 2] = cos + (z * z * C);
		}
		if(y != 0) {
			set_order(next, 0x07, 9); //trans bits, mask, and shift!
			elements_rotyy[next][0] = cos + (x * x * C);
			elements_rotyy[next][(SIZE)] = (x * y * C) - (z * sin);
			elements_rotyy[next][(2 * SIZE)] = (x * z * C) + (y * sin);
			elements_rotyy[next][1] = (y * x * C) + (z * sin);
			elements_rotyy[next][(SIZE) + 1] = cos + (y * y * C);
			elements_rotyy[next][(2 * SIZE) + 1] = (y * z * C) - (x * sin);
			elements_rotyy[next][2] = (z * x * C) - (y * sin);
			elements_rotyy[next][(SIZE) + 2] = (z * y * C) + (x * sin);
			elements_rotyy[next][(2 * SIZE) + 2] = cos + (z * z * C);
		}
		if(z != 0) {
			set_order(next, 0x07, 12); //trans bits, mask, and shift!
			elements_rotzz[next][0] = cos + (x * x * C);
			elements_rotzz[next][(SIZE)] = (x * y * C) - (z * sin);
			elements_rotzz[next][(2 * SIZE)] = (x * z * C) + (y * sin);
			elements_rotzz[next][1] = (y * x * C) + (z * sin);
			elements_rotzz[next][(SIZE) + 1] = cos + (y * y * C);
			elements_rotzz[next][(2 * SIZE) + 1] = (y * z * C) - (x * sin);
			elements_rotzz[next][2] = (z * x * C) - (y * sin);
			elements_rotzz[next][(SIZE) + 2] = (z * y * C) + (x * sin);
			elements_rotzz[next][(2 * SIZE) + 2] = cos + (z * z * C);	
		}
		
	}
	
	public static void rotate_clear(float angle, float x, float y, float z) {
		
		float cos = (float) Math.cos(Math.toRadians(angle));
		float sin = (float) Math.sin(Math.toRadians(angle));
		float C = 1 - cos;
		
		if(x != 0) {
			elements_rotxx_cleared[(0 * SIZE) + 0] = cos + (x * x * C);
			elements_rotxx_cleared[(1 * SIZE) + 0] = (x * y * C) - (z * sin);
			elements_rotxx_cleared[(2 * SIZE) + 0] = (x * z * C) + (y * sin);
			elements_rotxx_cleared[(0 * SIZE) + 1] = (y * x * C) + (z * sin);
			elements_rotxx_cleared[(1 * SIZE) + 1] = cos + (y * y * C);
			elements_rotxx_cleared[(2 * SIZE) + 1] = (y * z * C) - (x * sin);
			elements_rotxx_cleared[(0 * SIZE) + 2] = (z * x * C) - (y * sin);
			elements_rotxx_cleared[(1 * SIZE) + 2] = (z * y * C) + (x * sin);
			elements_rotxx_cleared[(2 * SIZE) + 2] = cos + (z * z * C);			
		}
		if(y != 0) {
			elements_rotyy_cleared[(0 * SIZE) + 0] = cos + (x * x * C);
			elements_rotyy_cleared[(1 * SIZE) + 0] = (x * y * C) - (z * sin);
			elements_rotyy_cleared[(2 * SIZE) + 0] = (x * z * C) + (y * sin);
			elements_rotyy_cleared[(0 * SIZE) + 1] = (y * x * C) + (z * sin);
			elements_rotyy_cleared[(1 * SIZE) + 1] = cos + (y * y * C);
			elements_rotyy_cleared[(2 * SIZE) + 1] = (y * z * C) - (x * sin);
			elements_rotyy_cleared[(0 * SIZE) + 2] = (z * x * C) - (y * sin);
			elements_rotyy_cleared[(1 * SIZE) + 2] = (z * y * C) + (x * sin);
			elements_rotyy_cleared[(2 * SIZE) + 2] = cos + (z * z * C);
		}
		if(z != 0) {
			elements_rotzz_cleared[(0 * SIZE) + 0] = cos + (x * x * C);
			elements_rotzz_cleared[(1 * SIZE) + 0] = (x * y * C) - (z * sin);
			elements_rotzz_cleared[(2 * SIZE) + 0] = (x * z * C) + (y * sin);
			elements_rotzz_cleared[(0 * SIZE) + 1] = (y * x * C) + (z * sin);
			elements_rotzz_cleared[(1 * SIZE) + 1] = cos + (y * y * C);
			elements_rotzz_cleared[(2 * SIZE) + 1] = (y * z * C) - (x * sin);
			elements_rotzz_cleared[(0 * SIZE) + 2] = (z * x * C) - (y * sin);
			elements_rotzz_cleared[(1 * SIZE) + 2] = (z * y * C) + (x * sin);
			elements_rotzz_cleared[(2 * SIZE) + 2] = cos + (z * z * C);	
		}		
	}
	
	public static void sendCurrentStack() {
		//old way
	}
	
	public static void adjustStackDepthUp() {
		//old way
	}
	
	public static void adjustStackDepthDown() {
		//old way
	}
	
	public static void send_part(int which, String tr, String sc, String rx, String ry, String rz) {
		//old way
	}
	
	public static void sendFinalStack() {
		//multiply out current stack
		if(next == 0) {
			//mats[0] = proj_save;
			for(int k=0;k<SIZE*SIZE;k++)mats[0][k] = proj_save[k];
		}else {
			//mats[next] = mats[next-1]; //fetch previous
			for(int k=0;k<SIZE*SIZE;k++)mats[next][k] = mats[next-1][k];
		}
		
		mul_it_out(next);
		
		//current stack is the culmination of everything. It is all that needs to be sent.
		GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(GL11.glGetInteger(GL20.GL_CURRENT_PROGRAM), "projection"), true, mats[next]);
	}
	


}
