package dangerzone.items;


import dangerzone.Effects;
import dangerzone.InventoryContainer;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;

public class ItemPoisoned extends ItemSword {
	
	public ItemPoisoned(String name, String tx, int uses, int damage){
		super(name, tx, uses, damage);
	}
	
	public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic){
		if(holder != null && clickedon != null && holder.world.isServer){
			if(clickedon instanceof EntityLiving){
				Effects ef = new Effects(Effects.POISON, 1.25f, 20000);
				clickedon.addEffectFromServer(ef);
			}
		}
		return true;
	}

}