package dangerzone.items;


import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.entities.Entity;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;

public class ItemAutoPistol extends ItemPistol {

	ModelAutoPistol ap = null;
	
	public ItemAutoPistol(String n, String txt, int att, int uses) {
		super(n, txt, att, uses);
	}
	
	public boolean singleshot(Entity holder, InventoryContainer ic, int holdcount){
		return false;
	}
	
	public boolean semiauto(Entity holder, InventoryContainer ic, int holdcount){
		return false;
	}
	
	public boolean fullauto(Entity holder, InventoryContainer ic, int holdcount){
		ic.tmpi = 10; //start animation!
		return shoot_a_shot(holder, ic, holdcount);
	}
	
	public void renderMe(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay){
		
		if(texturebig == null){
			texturebig = TextureMapper.getTexture("res/items/AutoPistoltexture.png");
		}
		DangerZone.wr.loadtexture(texturebig);
		
		if(ap == null){
			ap = new ModelAutoPistol();
		}		
			
				
		//MatrixStack.translate((float)DangerZone.testx, (float)DangerZone.testy, (float)DangerZone.testz);
		//MatrixStack.rotate(180f + DangerZone.testp, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
		//MatrixStack.rotate(DangerZone.testw, 0.0f, 1.0f, 0.0f);
		//MatrixStack.rotate(DangerZone.testr, 0.0f, 0.0f, 1.0f);
		
	    MatrixStack.pushMatrix();
		
		MatrixStack.rotate(5.5f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
		MatrixStack.rotate(-75.1f, 0.0f, 1.0f, 0.0f);
		MatrixStack.rotate(149.7f, 0.0f, 0.0f, 1.0f);
		MatrixStack.translate(1.5f, 18.1f, -4.4f);
			    
	    MatrixStack.sendCurrentStack();
	    
		if(ap != null)ap.render(e, ic);
		
		MatrixStack.popMatrix();
		
		
		
	}

}
