package dangerzone.items;
import slick.Texture;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.entities.Entity;
import dangerzone.gui.InventoryMenus;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelRenderer;
import dangerzone.rendering.TextureMapper;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class ItemArmor extends Item {
	
	 // 0 = helmet, 1 = chestplate, 2 = leggings, 3 = boots
	
	public float protection = 0.0f; //added to players defense when attacked
	public Texture armortexture = null;
	public String armortexturepath = null;
	public Texture armortexture2 = null; //leggings
	public String armortexturepath2 = null; //leggings
	public int armortype = 0;

	public ItemArmor(String n, String txt, String armortxt, String leggingstxt, float protvalue, int durability, int type) {
		super(n, txt);
		armortype = type; // 0 = helmet, 1 = chestplate, 2 = leggings, 3 = boots
		armortexturepath = armortxt;
		armortexturepath2 = leggingstxt;
		protection = protvalue;
		maxuses = durability;
		maxstack = 1;
		burntime = 0;
		menu = InventoryMenus.HARDWARE;
	}
	
	public void armorTick(Entity e, InventoryContainer ic, int armorindex){		
		//called when being worn, 10x a sec...
		//this is DIFFERENT from Item.inUseTick().
	}
	
	//server side only
	public void armorHit(Entity weareer, Entity hitter, InventoryContainer ic, int armorindex){		

	}
	
	public void armorOn(Entity ent, int armorindex) {
//		if(ent instanceof Player) {
//			Player p = (Player)ent;
//			if(p.world.isServer) {
				
//			}			
//		}
	}
	
	public void armorOff(Entity ent, int armorindex) {

	}
	
	public Texture getArmorTexture(int id){
		if(armortexture == null){
			armortexture = TextureMapper.getTexture(armortexturepath);
		}
		return armortexture;
	}
	
	public Texture getArmorTexture2(int id){
		if(armortexture2 == null){
			armortexture2 = TextureMapper.getTexture(armortexturepath2);
		}
		return armortexture2;
	}
	
	//defaults just scale the original humanoid parts up a little and draw over them.
	public void drawHelmet(Entity ent, ModelRenderer head, float deathfactor){
		  DangerZone.wr.loadtexture(getArmorTexture(0));
		  //MatrixStack.sendCurrentStack();
		  MatrixStack.pushMatrix();
		  MatrixStack.translate(0f, -3.0f, 0f); //translate down a little because we will scale differently...
		  MatrixStack.scale(1.125f, 1.125f, 1.125f); //scale up
		  head.rotationPointY = 0.5f; //rotate off center a little
		  MatrixStack.sendCurrentStack();
		  head.render(deathfactor); //texture is in same place in the file!
		  head.rotationPointY = 0.0f; //restore this!!!!!
		  MatrixStack.popMatrix();
	}
	
	public void drawLeggings(Entity ent, ModelRenderer body, ModelRenderer leftleg, ModelRenderer rightleg, float deathfactor){
		  //MatrixStack.sendCurrentStack();
		  MatrixStack.pushMatrix(); 
		  DangerZone.wr.loadtexture(getArmorTexture2(0)); //2!
		  MatrixStack.scale(1.10f, 1.10f, 1.10f);
		  MatrixStack.translate(0f, -1.1f, 0f);
		  MatrixStack.translate(-0.18f, 0f, 0f);
		  MatrixStack.sendCurrentStack();
		  leftleg.render(deathfactor);
		  MatrixStack.translate(0.36f, 0f, 0f);	
		  MatrixStack.sendCurrentStack();
		  rightleg.render(deathfactor);
		  MatrixStack.popMatrix();
		  //around the waist!
		  //MatrixStack.sendCurrentStack();
		  MatrixStack.pushMatrix(); 
		  MatrixStack.scale(1.10f, 1.10f, 1.10f);
		  MatrixStack.translate(0f, -1.8f, 0f); //translate down a little because we scaled differently...
		  MatrixStack.sendCurrentStack();
		  body.render(deathfactor);
		  MatrixStack.popMatrix();
	}
	
	public void drawChestplate(Entity ent, ModelRenderer body, ModelRenderer leftarm, ModelRenderer rightarm, float deathfactor){
		  //MatrixStack.sendCurrentStack();
		  MatrixStack.pushMatrix();
		  DangerZone.wr.loadtexture(getArmorTexture(0));
		  MatrixStack.scale(1.15f, 1.15f, 1.15f);
		  MatrixStack.translate(0f, -2.9f, 0f); //translate down a little because we scaled differently...
		  MatrixStack.sendCurrentStack();
		  body.render(deathfactor);
		  MatrixStack.translate(-0.6f, 0f, 0f);
		  MatrixStack.sendCurrentStack();
		  leftarm.render(deathfactor);
		  MatrixStack.translate(1.2f, 0f, 0f);
		  MatrixStack.sendCurrentStack();
		  rightarm.render(deathfactor);
		  MatrixStack.popMatrix();
	}
	
	public void drawBoots(Entity ent, ModelRenderer leftleg, ModelRenderer rightleg, float deathfactor){
		  //MatrixStack.sendCurrentStack();
		  MatrixStack.pushMatrix();
		  DangerZone.wr.loadtexture(getArmorTexture(0));
		  MatrixStack.scale(1.15f, 1.15f, 1.15f);
		  MatrixStack.translate(0f, -1.3f, 0f); //translate down a little because we scaled differently...
		  MatrixStack.translate(-0.18f, 0f, 0f);
		  MatrixStack.sendCurrentStack();
		  leftleg.render(deathfactor);
		  MatrixStack.translate(0.36f, 0f, 0f);
		  MatrixStack.sendCurrentStack();
		  rightleg.render(deathfactor);
		  MatrixStack.popMatrix();
	}

}
