package dangerzone.items;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import slick.Texture;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.gui.InventoryMenus;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;



public class Item {
	public int itemID;
	public String texturepath;
	public String uniquename;
	private Texture texture = null;
	public int maxstack = 64;
	//private int compiled_quads_id;
    private boolean compiled = false;
    private int vao = 0;
    private int vbo_buffer = 0;
    private  ByteBuffer vbodata = null;
    private  int vcount = 0;
	private int stride = 0;
	private int textureoff = 0;
	private int coloroff = 0;
	public int maxuses;
	public int attackstrength;
	public int stonestrength;
	public int woodstrength;
	public int dirtstrength;
	public int energy = 0;
	public boolean showInInventory = true;
	public float brightness = 0.0f; //range -2.0 to about 2.0 - adder! less than 0 = darker, greater than 0 = brighter
	public boolean isfood = false;
	public boolean eatanytime = false;
	public float foodvalue = 0;
	public int burntime = 0;
	public int menu = InventoryMenus.GENERIC;
	public boolean flipped = false; //rendering flag
	public boolean flopped = false; //another rendering flag
	public boolean hold_straight = false;
	public boolean do_shoot_clicks = false; //stops renderer from hit and eat animations!
	public boolean nocombo = false; 
	public float xoff, yoff, zoff;
	public float pitch_off, yaw_off, roll_off;
	private float use_r, use_g, use_b;
	private float use_tx, use_ty;
	public float itemreach = 0.5f;
	public float itemwidth = 0.125f;

	
	public Item(String n, String txt){
		texturepath = null;
		itemID = 0;
		texturepath = txt;
		uniquename = n;
		maxstack = 64;
		compiled = false;
		attackstrength = stonestrength = woodstrength = dirtstrength = 1;
		maxuses = 0;
		isfood = false;
		eatanytime = false;
		foodvalue = 0;
				
		xoff = 0f;
		yoff = 0f;
		zoff = -3.2f;
		pitch_off = 42.3f;
		yaw_off = 88.1f;
		roll_off = 179.6f;
	}
	
	public void inUseTick(Entity e, InventoryContainer ic, int invindex){
		//Ticks the currently Held Item! (client AND server)
	}
	
	public void inventoryTick(Entity e, InventoryContainer ic, int invindex){
		//Ticks the item anywhere in inventory (server only)
	}
		
	/*
	 * Default 3D item renderer. Override it if you have your own special item rendering.
	 * Used for EntityBlockItems (drops) and while being held by Player.
	 * 
	 * Inventory drawing uses a standard square and your default texture, not this routine.
	 */
	public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay){
		//texture is already auto-loaded for us
		if(!compiled){
			compile_item();
			compiled = true;
		}
		if(vao != 0){	
			
			MatrixStack.sendFinalStack();
			
			//GL20.glEnableVertexAttribArray(0);
			//GL20.glEnableVertexAttribArray(1);
			//GL20.glEnableVertexAttribArray(2);
			
			GL30.glBindVertexArray(vao);
			
			GL11.glDrawArrays(GL11.GL_QUADS, 0, vcount);
					
			GL30.glBindVertexArray(0);
			
			//GL20.glDisableVertexAttribArray(2);
			//GL20.glDisableVertexAttribArray(1);
			//GL20.glDisableVertexAttribArray(0);
		}
	}
	
	public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic){
		return true; //continue with normal left click logic, else it is handled special here
	}
	
	//client side only!
	public void onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic, int d, double px, double py, double pz, int fx, int fy, int fz, int bid){
		if(clickedon != null) {
			Utils.spawnParticlesScaled(holder.world, "DangerZone:ParticleHurt", 50, d, px, py, pz, 0, 0.25f*(clickedon.getWidth()+clickedon.getHeight())/4f, true);
		}else {
			if(bid == 0)return;
			String particlename = Blocks.getParticleName(bid);
			if(particlename == null || particlename.equals(""))particlename = "DangerZone:ParticleBreak";
			Utils.spawnParticles(holder.world, particlename, 30, d, (double)fx+0.5f, (double)fy+0.5f, (double)fz+0.5f, bid, true);
			Utils.spawnParticlesScaled(holder.world, "DangerZone:ParticleBreak", 25, d, px, py, pz, 0, 0.5f*0.5f, true);
		}
	}
	
	//called only if NOT clicked on a block. (air or entity)
	public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic){
		return false; //return TRUE if your item did something and should be deleted/decremented
	}
	
	//VR only!
	public boolean onSwingStop(Entity holder, Entity clickedon, InventoryContainer ic){
		return false; //return TRUE if your item did something and should be deleted/decremented
	}
	
	public boolean rightclickup(Entity ent, InventoryContainer ic, int holdcount){
		//holdcount is roughly tenths of a second
		return false; //inc currentuses
	}
	
	//Implement ONLY ONE of the next three (if you even want any!)
	
	//right should be down for holdcount before left goes down. both must then come up.
	public boolean singleshot(Entity ent, InventoryContainer ic, int holdcount){
		//holdcount is roughly tenths of a second
		return false; //inc currentuses
	}
	
	//right should be down for holdcount before left goes down, but then left can go up/down as it wants
	public boolean semiauto(Entity ent, InventoryContainer ic, int holdcount){
		//holdcount is roughly tenths of a second
		return false; //inc currentuses
	}
	
	//right should be down for holdcount before left goes down, then left is just held down
	public boolean fullauto(Entity ent, InventoryContainer ic, int holdcount){
		//holdcount is roughly tenths of a second
		return false; //inc currentuses
	}
	
	public float getfullholdcount(){
		//for display so we can scale, stretch, fill something, whatever, to show progress.
		return 0;
	}
	
	public void onCrafted(Player p, InventoryContainer ic){
	}
	
	
	//Don't look. This is ugly.
	private int count_verts(byte[] data) {
		int i, j;
		int count = 0;
		int curval;

		if(!flopped){
			for(i=0;i<16;i++){
				for(j=0;j<16;j++){
					curval = gimmedataat(data, i, j); //Get a pixel
					if(curval >= 0){					
						count += 4;
						count += 4;				
						if(gimmedataat(data, i-1, j) < 0){
							count += 4;
						}					
						if(gimmedataat(data, i+1, j) < 0){
							count += 4;
						}					
						if(gimmedataat(data, i, j-1) < 0){
							count += 4;
						}					
						if(gimmedataat(data, i, j+1) < 0){
							count += 4;
						}
					}
				}
			}

		}else{
			//item Bow!
			for(i=0;i<16;i++){
				for(j=0;j<16;j++){
					curval = gimmedataat(data, i, j); //Get a pixel
					if(curval >= 0){					
						count += 4;
						count += 4;						
						if(gimmedataat(data, i+1, j) < 0){
							count += 4;
						}						
						if(gimmedataat(data, i-1, j) < 0){
							count += 4;
						}						
						if(gimmedataat(data, i, j+1) < 0){
							count += 4;
						}						
						if(gimmedataat(data, i, j-1) < 0){
							count += 4;
						}
					}
				}
			}

		}

		return count;
	}
	
	/*
	 * ONLY works with 16*16 8-bit RGBA .png files.
	 * Draws only the exterior of the item by checking each side of each pixel.
	 */
	private void compile_item(){

		int curval;
		int i, j;
		byte[] data;
		Texture t;

		t = getTexture();
		if(t == null)return;
		data = t.getTextureData();
		
		vcount = count_verts(data);
		begin_compile(vcount);
		
		if(!flopped){

		for(i=0;i<16;i++){
			for(j=0;j<16;j++){
				curval = gimmedataat(data, i, j); //Get a pixel
				if(curval >= 0){					
					/*
					 * The -8, -8 moves the center to the center of the image.
					 */
					
					set_use_color(0.98f, 0.98f, 0.98f);
					set_use_tex((float)j/16f+0.0625f, (float)i/16f);
					add_vertex(-8+j+1, -8+i+1, 0); // Top Right
					set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
					add_vertex(-8+j+1, -8+i+0, 0); // Bottom Right
					set_use_tex((float)j/16f, (float)i/16f+0.0625f);
					add_vertex(-8+j+0, -8+i+0, 0); // Bottom Left					
					set_use_tex((float)j/16f, (float)i/16f);
					add_vertex(-8+j+0, -8+i+1, 0); // Top Left

					
					set_use_color(0.98f, 0.98f, 0.98f);
					set_use_tex((float)j/16f+0.0625f, (float)i/16f);
					add_vertex(-8+j+1, -8+i+1, 1); // Top Right
					set_use_tex((float)j/16f, (float)i/16f);
					add_vertex(-8+j+0, -8+i+1, 1); // Top Left
					set_use_tex((float)j/16f, (float)i/16f+0.0625f);
					add_vertex(-8+j+0, -8+i+0, 1); // Bottom Left
					set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
					add_vertex(-8+j+1, -8+i+0, 1); // Bottom Right
					
					
					if(gimmedataat(data, i-1, j) < 0){
						set_use_color(0.96f, 0.96f, 0.96f);
						set_use_tex((float)j/16f+0.0625f, (float)i/16f);
						add_vertex(-8+j+1, -8+i+0, 1); // Top Right
						set_use_tex((float)j/16f, (float)i/16f);
						add_vertex(-8+j+0, -8+i+0, 1); // Top Left
						set_use_tex((float)j/16f, (float)i/16f+0.0625f);
						add_vertex(-8+j+0, -8+i+0, 0); // Bottom Left
						set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
						add_vertex(-8+j+1, -8+i+0, 0); // Bottom Right
					}

					
					if(gimmedataat(data, i+1, j) < 0){
						set_use_color(0.96f, 0.96f, 0.96f);
						set_use_tex((float)j/16f+0.0625f, (float)i/16f);
						add_vertex(-8+j+1, -8+i+1, 1); // Top Right
						set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
						add_vertex(-8+j+1, -8+i+1, 0); // Bottom Right
						set_use_tex((float)j/16f, (float)i/16f+0.0625f);
						add_vertex(-8+j+0, -8+i+1, 0); // Bottom Left						
						set_use_tex((float)j/16f, (float)i/16f);
						add_vertex(-8+j+0, -8+i+1, 1); // Top Left
					}

					
					if(gimmedataat(data, i, j-1) < 0){
						set_use_color(1f, 1f, 1f);
						set_use_tex((float)j/16f+0.0625f, (float)i/16f);
						add_vertex(-8+j+0, -8+i+1, 0); // Top Right
						set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
						add_vertex(-8+j+0, -8+i+0, 0); // Bottom Right
						set_use_tex((float)j/16f, (float)i/16f+0.0625f);
						add_vertex(-8+j+0, -8+i+0, 1); // Bottom Left	
						set_use_tex((float)j/16f, (float)i/16f);
						add_vertex(-8+j+0, -8+i+1, 1); // Top Left
					}

					
					if(gimmedataat(data, i, j+1) < 0){
						set_use_color(1f, 1f, 1f);
						set_use_tex((float)j/16f+0.0625f, (float)i/16f);
						add_vertex(-8+j+1, -8+i+1, 1); // Top Right
						set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
						add_vertex(-8+j+1, -8+i+0, 1); // Bottom Right
						set_use_tex((float)j/16f, (float)i/16f+0.0625f);
						add_vertex(-8+j+1, -8+i+0, 0); // Bottom Left
						set_use_tex((float)j/16f, (float)i/16f);
						add_vertex(-8+j+1, -8+i+1, 0); // Top Left
					}
				}
			}
		}
		
		}else{
			//item Bow!
			for(i=0;i<16;i++){
				for(j=0;j<16;j++){
					curval = gimmedataat(data, i, j); //Get a pixel
					if(curval >= 0){					
						/*
						 * The -8, -8 moves the center to the center of the image.
						 */
						///x
						set_use_color(0.98f, 0.98f, 0.98f);
						set_use_tex((float)j/16f+0.0625f, (float)i/16f);
						add_vertex(8-j+1, 8-i+1, 0); // Top Right					
						set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
						add_vertex(8-j+1, 8-i+0, 0); // Bottom Right						
						set_use_tex((float)j/16f, (float)i/16f+0.0625f);
						add_vertex(8-j+0, 8-i+0, 0); // Bottom Left											
						set_use_tex((float)j/16f, (float)i/16f);
						add_vertex(8-j+0, 8-i+1, 0); // Top Left
					
						set_use_color(0.98f, 0.98f, 0.98f);
						set_use_tex((float)j/16f+0.0625f, (float)i/16f);
						add_vertex(8-j+1, 8-i+1, 1); // Top Right
						set_use_tex((float)j/16f, (float)i/16f);
						add_vertex(8-j+0, 8-i+1, 1); // Top Left
						set_use_tex((float)j/16f, (float)i/16f+0.0625f);
						add_vertex(8-j+0, 8-i+0, 1); // Bottom Left
						set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
						add_vertex(8-j+1, 8-i+0, 1); // Bottom Right
						
						
						if(gimmedataat(data, i+1, j) < 0){
							set_use_color(0.96f, 0.96f, 0.96f);
							set_use_tex((float)j/16f+0.0625f, (float)i/16f);
							add_vertex(8-j+1, 8-i+0, 1); // Top Right
							set_use_tex((float)j/16f, (float)i/16f);
							add_vertex(8-j+0, 8-i+0, 1); // Top Left
							set_use_tex((float)j/16f, (float)i/16f+0.0625f);
							add_vertex(8-j+0, 8-i+0, 0); // Bottom Left
							set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
							add_vertex(8-j+1, 8-i+0, 0); // Bottom Right
						}

						
						if(gimmedataat(data, i-1, j) < 0){
							///x
							set_use_color(0.96f, 0.96f, 0.96f);
							set_use_tex((float)j/16f+0.0625f, (float)i/16f);
							add_vertex(8-j+1, 8-i+1, 1); // Top Right
							set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
							add_vertex(8-j+1, 8-i+1, 0); // Bottom Right
							set_use_tex((float)j/16f, (float)i/16f+0.0625f);
							add_vertex(8-j+0, 8-i+1, 0); // Bottom Left						
							set_use_tex((float)j/16f, (float)i/16f);
							add_vertex(8-j+0, 8-i+1, 1); // Top Left
						}

						
						if(gimmedataat(data, i, j+1) < 0){
							//x
							set_use_color(1f, 1f, 1f);
							set_use_tex((float)j/16f+0.0625f, (float)i/16f);
							add_vertex(8-j+0, 8-i+1, 0); // Top Right
							set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
							add_vertex(8-j+0, 8-i+0, 0); // Bottom Right
							set_use_tex((float)j/16f, (float)i/16f+0.0625f);
							add_vertex(8-j+0, 8-i+0, 1); // Bottom Left
							set_use_tex((float)j/16f, (float)i/16f);
							add_vertex(8-j+0, 8-i+1, 1); // Top Left
						}

						
						if(gimmedataat(data, i, j-1) < 0){
							//x
							set_use_color(1f, 1f, 1f);
							set_use_tex((float)j/16f+0.0625f, (float)i/16f);
							add_vertex(8-j+1, 8-i+1, 1); // Top Right
							set_use_tex((float)j/16f+0.0625f, (float)i/16f+0.0625f);
							add_vertex(8-j+1, 8-i+0, 1); // Bottom Right
							set_use_tex((float)j/16f, (float)i/16f+0.0625f);
							add_vertex(8-j+1, 8-i+0, 0); // Bottom Left	
							set_use_tex((float)j/16f, (float)i/16f);
							add_vertex(8-j+1, 8-i+1, 0); // Top Left
						}
					}
				}
			}
			
		}
				
		finish_compile();
		
	}
	
	/*
	 * ONLY works with 8-bit RGBA png files.
	 * ONLY works with 16x16.
	 */
	private int gimmedataat(byte[] data, int x, int y){
		if(x < 0 || x >= 16)return -1;
		if(y < 0 || y >= 16)return -1;
		//System.out.printf("data %d at %d, %d is: %d, %d, %d, %d\n", data.length, x, y, data[((x*16)+y)*4], data[((x*16)+y)*4 + 1], data[((x*16)+y)*4 + 2], data[((x*16)+y)*4 + 3] );		
		if(data[((x*16)+y)*4 + 3] >= 0 && data[((x*16)+y)*4 + 3] < 100)return -1; //check alpha first! Arbitrary alpha min. Should really always be 0 or -1 (255) for solid colors.		
		return (data[((x*16)+y)*4] + data[((x*16)+y)*4 + 1] + data[((x*16)+y)*4 + 2])&0xffffff;
	}
	
	public Texture getTexture(){
		if(texture == null){
			texture = TextureMapper.getTexture(texturepath);
		}
		return texture;
	}

	//Player right-clicked on this block with this item
	public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side){
		return false; //return TRUE if your item did something and should be deleted/decremented
	}
	
	//Player left-clicked on this block with this item
	public void leftClickOnBlock(Player p, int dimension, int x, int y, int z, int side){
		
	}
	
	public void onFoodEaten(Entity e){
	}
	
	public void onBlockBroken(Entity ent, int dimension, int x, int y, int z, int wasbid){
		//ent is player. server side!
	}
	
    private void begin_compile(int nverts) {
    	
		stride = 3*4; //xyz coord size (floats!)
		textureoff = stride;
		stride += 2*4; //texture coord size
		coloroff = stride;
		stride += 3*4; //rgb (brightness bytes!)			
		  
    	vao = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(vao);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);		
		
    	vbodata = BufferUtils.createByteBuffer(nverts*stride); //size   	
    }
    
    private void finish_compile(){

    	vbodata.flip();

    	vbo_buffer = GL15.glGenBuffers();
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
    	GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		
    }
    
    private void addVertexInfoToVBO(float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb){
    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);   	
    }
    
    private void add_vertex(float x, float y, float z){   	
		addVertexInfoToVBO(x, y, z, use_tx, use_ty, use_r, use_g, use_b);
    }
    
    private void set_use_color(float r, float g, float b) {
    	use_r = r;
    	use_g = g;
    	use_b = b;
    }
    
    private void set_use_tex(float x, float y) {
    	use_tx = x;
    	use_ty = y;
    }
    
    public void vr_hit_something(Entity e, int bid) {
    	//override and do something if you want! One or the other parameter should be valid.
    	if(bid != 0) {
    		DangerZone.hit_pulse(500);
    		return;
    	}
    	if(e != null) {
    		DangerZone.hit_pulse(1500);
    	}   	
    }
	
    public void vr_hit_EntityBlockItem(Entity e) {  	
    	if(e != null && e instanceof EntityBlockItem) {
    		//System.out.printf("sending %d\n", e.entityID);
			DangerZone.player.leftclick(e.world, 0, 0, 0, 0, e.entityID, 0, 0, 0, 0, 0); //send to server!
			e.deadflag = true; //set dead so we only process it as "hit" once!
    	}
    }
	
	
}
