package dangerzone.entities;

import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;
import dangerzone.rendering.ModelRenderer;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

public class ModelMonarch extends ModelBase
{

  //fields
    ModelRenderer head;
    ModelRenderer body;
    ModelRenderer abdomen;
    ModelRenderer rfleg;
    ModelRenderer lrleg;
    ModelRenderer lfleg;
    ModelRenderer rrleg;
    ModelRenderer lfwing;
    ModelRenderer rfwing;
    ModelRenderer lrwing;
    ModelRenderer rrwing;
    ModelRenderer lant;
    ModelRenderer rant;


  
  public ModelMonarch()
  {

	    
	      head = new ModelRenderer(this, 96, 0);
	      head.addBox(-1.5F, -1.5F, -1.5F, 3, 3, 4);
	      head.setRotationPoint(0F, 1F, -11F);
	      head.setTextureSize(256, 256);
	      head.mirror = true;
	      setRotation(head, 0F, 0F, 0F);
	      body = new ModelRenderer(this, 116, 0);
	      body.addBox(-3F, -3F, -9F, 6, 7, 12);
	      body.setRotationPoint(0F, 2F, 0F);
	      body.setTextureSize(256, 256);
	      body.mirror = true;
	      setRotation(body, 0F, 0F, 0F);
	      abdomen = new ModelRenderer(this, 157, 0);
	      abdomen.addBox(-1F, 0F, 0F, 2, 2, 23);
	      abdomen.setRotationPoint(0F, 0F, 0F);
	      abdomen.setTextureSize(256, 256);
	      abdomen.mirror = true;
	      setRotation(abdomen, 0F, 0F, 0F);
	      rfleg = new ModelRenderer(this, 0, 0);
	      rfleg.addBox(-0.5F, 0F, -0.5F, 1, 10, 1);
	      rfleg.setRotationPoint(-1F, 6F, -5F);
	      rfleg.setTextureSize(256, 256);
	      rfleg.mirror = true;
	      setRotation(rfleg, -0.3490659F, 0F, 0.2617994F);
	      lrleg = new ModelRenderer(this, 9, 14);
	      lrleg.addBox(-0.5F, 0F, -0.5F, 1, 10, 1);
	      lrleg.setRotationPoint(1F, 6F, -3F);
	      lrleg.setTextureSize(256, 256);
	      lrleg.mirror = true;
	      setRotation(lrleg, 0.3490659F, 0F, -0.2617994F);
	      lfleg = new ModelRenderer(this, 9, 0);
	      lfleg.addBox(-0.5F, 0F, -0.5F, 1, 10, 1);
	      lfleg.setRotationPoint(1F, 6F, -5F);
	      lfleg.setTextureSize(256, 256);
	      lfleg.mirror = true;
	      setRotation(lfleg, -0.3490659F, 0F, -0.2617994F);
	      rrleg = new ModelRenderer(this, 0, 14);
	      rrleg.addBox(-0.5F, 0F, -0.5F, 1, 10, 1);
	      rrleg.setRotationPoint(-1F, 6F, -3F);
	      rrleg.setTextureSize(256, 256);
	      rrleg.mirror = true;
	      setRotation(rrleg, 0.3490659F, 0F, 0.2617994F);
	      lfwing = new ModelRenderer(this, 0, 35);
	      lfwing.addBox(0F, 0F, 0F, 40, 1, 30);
	      lfwing.setRotationPoint(1F, 0F, -7F);
	      lfwing.setTextureSize(256, 256);
	      lfwing.mirror = true;
	      setRotation(lfwing, 0F, 0.1919862F, 0F);
	      rfwing = new ModelRenderer(this, 0, 70);
	      rfwing.addBox(-40F, 0F, 0F, 40, 1, 30);
	      rfwing.setRotationPoint(-1F, 0F, -7F);
	      rfwing.setTextureSize(256, 256);
	      rfwing.mirror = true;
	      setRotation(rfwing, 0F, -0.1919862F, 0F);
	      lrwing = new ModelRenderer(this, 0, 105);
	      lrwing.addBox(0F, 0F, 0F, 25, 1, 25);
	      lrwing.setRotationPoint(0F, 1F, 0F);
	      lrwing.setTextureSize(256, 256);
	      lrwing.mirror = true;
	      setRotation(lrwing, 0F, 0F, 0F);
	      rrwing = new ModelRenderer(this, 0, 135);
	      rrwing.addBox(-25F, 0F, 0F, 25, 1, 25);
	      rrwing.setRotationPoint(0F, 1F, 0F);
	      rrwing.setTextureSize(256, 256);
	      rrwing.mirror = true;
	      setRotation(rrwing, 0F, 0F, 0F);
	      lant = new ModelRenderer(this, 50, 0);
	      lant.addBox(-0.5F, -0.5F, -6F, 1, 1, 6);
	      lant.setRotationPoint(-0.5F, 0F, -12F);
	      lant.setTextureSize(256, 256);
	      lant.mirror = true;
	      setRotation(lant, -0.5235988F, 0.5235988F, 0F);
	      rant = new ModelRenderer(this, 69, 0);
	      rant.addBox(-0.5F, -0.5F, -6F, 1, 1, 6);
	      rant.setRotationPoint(0.5F, 0F, -12F);
	      rant.setTextureSize(256, 256);
	      rant.mirror = true;
	      setRotation(rant, -0.5235988F, -0.5235988F, 0F);
  

  }
  
  public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor)
  {
	  float newangle = 0;
	  	  
	  newangle =  (float) (Math.cos(Math.toRadians(f*18.7f)) * (float)Math.PI * 0.30F);
	  //System.out.printf("newangle = %f\n", newangle);
    
    //this.rightwing.rotateAngleZ = (float) (Math.cos(f2 * 1.3F * this.wingspeed) * (float)Math.PI * 0.25F);
    
    this.rfwing.rotateAngleZ = this.rrwing.rotateAngleZ = newangle;
    this.lfwing.rotateAngleZ = this.lrwing.rotateAngleZ = -newangle;

    newangle = (float)Math.cos(Math.toRadians(f*7.6f) ) * (float)Math.PI * 0.04F;
    lant.rotateAngleX = -0.52f + newangle;
    newangle = (float)Math.cos(Math.toRadians(f*7.75f) ) * (float)Math.PI * 0.04F;
    rant.rotateAngleX = -0.52f + newangle;
    
    newangle = (float)Math.cos(Math.toRadians(f*9.1f) ) * (float)Math.PI * 0.04F;
    lant.rotateAngleY = 0.52f + newangle;
    newangle = (float)Math.cos(Math.toRadians(f*11.6f) ) * (float)Math.PI * 0.04F;
    rant.rotateAngleY = -0.52f + newangle;   
    
    head.render(deathfactor);
    body.render(deathfactor);
    abdomen.render(deathfactor);
    rfleg.render(deathfactor);
    lrleg.render(deathfactor);
    lfleg.render(deathfactor);
    rrleg.render(deathfactor);
    lfwing.render(deathfactor);
    rfwing.render(deathfactor);
    lrwing.render(deathfactor);
    rrwing.render(deathfactor);
    lant.render(deathfactor);
    rant.render(deathfactor);

    
  }
  
  public void doScale(Entity ent){
	  super.doScale(ent);
	  MatrixStack.scale(0.5f, 0.5f, 0.5f); 
  }

}