package dangerzone.entities;


import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;

public class ModelMagic extends ModelBase {

	private boolean compiled = false;
	private int list1;
	
	public ModelMagic()
	{
		super();		  
	}	  

	/*
	 * rendering for Item/Block when floating around as an entity.
	 */
	public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor)
	{
		EntityMagic exp = (EntityMagic)entity;
		if(exp.getTexture() == null)return; //nevermind!
		
				
		if(!compiled){
			doCompile();
		}
		
		MatrixStack.sendFinalStack();

	    GL11.glEnable(GL11.GL_BLEND);
	    GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA); 
	    GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "alpha_adjust"), exp.getDensity());
	    DangerZone.wr.setBrightness(0.95f);
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);

		GL30.glBindVertexArray(list1);				
		GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);						
		GL30.glBindVertexArray(0);
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);
		
		
	    DangerZone.wr.setBrightness();
	    GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "alpha_adjust"), 1f);	
	    GL11.glDisable(GL11.GL_BLEND);   
		
	}

	public void doScale(Entity ent){
		EntityMagic pf = (EntityMagic)ent;
		float scl = pf.getScale();
		if(scl > 20)scl = 20;
		MatrixStack.scale( 4f*scl, 4f*scl, 4f*scl);		
	}


	
	private void doCompile(){

		int stride = 3*4; //xyz coord size (floats!)
		int textureoff = stride;
		stride += 2*4; //texture coord size
		int coloroff = stride;
		stride += 3*4; //rgb (brightness bytes!)	


		list1 = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(list1);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);	


		ByteBuffer vbodata = BufferUtils.createByteBuffer(4*stride); // size   	    	
		addVertexInfoToBuffer(vbodata, 4, 4, 0, 1,0, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, -4, 4, 0, 0,0, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, -4, -4, 0, 0,1, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, 4, -4, 0, 1,1, 1f, 1f, 1f);

		vbodata.flip();
		int vbo_buffer = GL15.glGenBuffers();
		GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
		GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
		GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
		GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
		GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
		GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
		GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		


		compiled = true;
	}

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }
}


