package dangerzone.entities;

import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;


public class ModelLightning extends ModelBase {

	int light = 0;
	boolean compiled = false;
	ByteBuffer vbodata = null;
	int vbo_buffer = 0;

	public ModelLightning()
	{

	}

	public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor)
	{
		EntityLightning li = (EntityLightning)entity;
		
		//make it flash
		if(li.world != null && li.world.rand.nextBoolean())return;
		if(li.world == null && DangerZone.rand.nextBoolean())return;
		
		//reset our saved random numbers
		li.resetrand();
		
		int howmany = 1;
		int wid = 10;
		if(li.getnextrand(4) == 2)howmany = 2;
		int howhigh = 200;
		if(entity.getDefense() <= 10){
			howhigh = 100;
			wid--;
		}
		if(entity.getDefense() <= 5){
			howhigh = 50;
			wid--;
		}
		if(entity.getDefense() <= 2){
			howhigh = 25;
			wid--;
		}
		DangerZone.wr.setBrightness(1f);
		
		MatrixStack.sendFinalStack();
		
		for(int i=0;i<howmany;i++){
			doline(li, 0, 0, 0, howhigh, wid);
		}
		
		DangerZone.wr.setBrightness();



	}
	
	//draw and split generally upwards
	private void doline(EntityLightning li, float x, float y, float z, float height, float width){
		if(width <= 1 || height <= 5)return;
		int nx = li.getnextrand((int)(height)) - li.getnextrand((int)(height));
		int nz = li.getnextrand((int)(height)) - li.getnextrand((int)(height));
		
		if(!compiled){
			doCompile();
		}
		
		vbodata.position(0);
		vbodata.limit(vbodata.capacity());
		addVertexInfoToBuffer(vbodata, x + (width/2) + nx, -(y+height), z+nz, 1,1, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, x - (width/2) + nx, -(y+height), z+nz, 0,1, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, x - (width/2), -y, z, 0,0, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, x + (width/2), -y, z, 1,0, 1f, 1f, 1f);
		
		vbodata.position(0);
		vbodata.limit(vbodata.capacity());
			
		
		GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);								
		GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_DYNAMIC_DRAW);
		GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0); //un-attach it
		
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);	

		GL30.glBindVertexArray(light);

		GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);

		GL30.glBindVertexArray(0);

		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		
		
		
		int howmany = 1;
		if(li.getnextrand(4) == 2)howmany = 2;
		for(int i=0;i<howmany;i++){
			doline(li, x+nx, y+height, z+nz, height-li.getnextrand(5), width-(0.5f*(howmany+1)));
		}				
	}

	//meh. 
	public void doScale(Entity ent){
		MatrixStack.scale( 1.125f, 1.125f, 1.125f); 
	}
	

	private void doCompile(){

		int stride = 3*4; //xyz coord size (floats!)
		int textureoff = stride;
		stride += 2*4; //texture coord size
		int coloroff = stride;
		stride += 3*4; //rgb (brightness bytes!)	


		light = GL30.glGenVertexArrays();
		GL30.glBindVertexArray(light);
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);	


		vbodata = BufferUtils.createByteBuffer(4*stride); // size   	    	
		addVertexInfoToBuffer(vbodata, 4, 4, 0, 1,0, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, -4, 4, 0, 0,0, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, -4, -4, 0, 0,1, 1f, 1f, 1f);
		addVertexInfoToBuffer(vbodata, 4, -4, 0, 1,1, 1f, 1f, 1f);

		vbodata.flip();
		vbo_buffer = GL15.glGenBuffers();
		GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
		GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_DYNAMIC_DRAW);
		GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
		GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
		GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
		GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
		GL30.glBindVertexArray(0);
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);		


		compiled = true;
	}

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }


}
