package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import slick.Texture;

import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.world.World;
import dangerzone.blocks.BlockInstability;
import dangerzone.blocks.Blocks;
import dangerzone.threads.ExplosionThread;


public class EntityExplosiveBlock extends EntityLiving {
	
	int exploded_already = 0;

	public EntityExplosiveBlock(World w) {
		super(w);
		uniquename = "DangerZone:EntityExplosiveBlock";
		width = 0.90f;
		height = 0.90f;
		this.moveSpeed = 0;
		this.movefrequency = 5555; //dont go!
		setVarFloat(10, 10 + DangerZone.rand.nextInt(5));
		setHealth(1);
		setMaxHealth(1);
	}
	
	public void doAttackFrom(/*entity that hit me*/Entity e, /*DamageTypes*/int dt, float pain){	
	}
	public void doAttackFromCustom(/*entity that hit me*/Entity e, /*DamageTypes*/int dt, float pain, boolean addknockback){	
	}
		
	public void update(float deltaT){		
		if(world.isServer){
			if(Blocks.getMaxStack(getBID()) == 0){
				deadflag = true; //illegal block ID!
			}else{
				setVarFloat(11, getVarFloat(11)+1);
				if(getVarFloat(11) > getVarFloat(10)){
					exploded_already = 1;	
					trigger(world, dimension, (int)posx, (int)posy, (int)posz);
					//Explosion.boom(this, world, dimension, posx, posy, posz, (int)getAttackDamage(), true);
					if((int)getAttackDamage() <= 99) {
						Explosion.boom(this, world, dimension, posx, posy, posz, (int)(getAttackDamage()), true);
					}else {
						//kick it off into a thread so it doesn't hold things up!!!
						ExplosionThread rt = new ExplosionThread(this, world, dimension, posx, posy, posz, (int)(getAttackDamage()), true);
						Thread it = new Thread(rt);
						it.setPriority(Thread.NORM_PRIORITY); 
						it.start();		
					}
					deadflag = true;
					//System.out.printf("Boom!\n");
					
				}
			}
		}
		super.update(deltaT);
	}
	
	public void trigger(World w, int d, int x, int y, int z){	
		int i, j, k, bid;
		int range = 1;
		if((int)getAttackDamage() > 5)range = 3;
		if((int)getAttackDamage() > 50)range = 5;
				
		for(i=-range;i<=range;i++) {
			for(j=-range;j<=range;j++) {
				for(k=-range;k<=range;k++) {
					bid = w.getblock(d, x+i, y+j, z+k);
					if(Blocks.BlockArray[bid] != null && Blocks.BlockArray[bid] instanceof BlockInstability) {
						BlockInstability b = (BlockInstability) Blocks.BlockArray[bid];
						b.trigger(w, d, x+i, y+j, z+k);
					}
				}
			}
		}
	}

	
	public void onDeath(){
		if(exploded_already == 0){
			exploded_already = 1;	
			trigger(world, dimension, (int)posx, (int)posy, (int)posz);
			//Explosion.boom(this, world, dimension, posx, posy, posz, (int)getAttackDamage(), true);
			//System.out.printf("Boom Death!\n");
			if((int)getAttackDamage() <= 99) {
				Explosion.boom(this, world, dimension, posx, posy, posz, (int)(getAttackDamage()), true);
			}else {
				//kick it off into a thread so it doesn't hold things up!!!
				ExplosionThread rt = new ExplosionThread(this, world, dimension, posx, posy, posz, (int)(getAttackDamage()), true);
				Thread it = new Thread(rt);
				it.setPriority(Thread.NORM_PRIORITY); 
				it.start();		
			}
		}
	}
	
	public float getWidth(){
		if(getVarFloat(11)==0)return 1f;
		return width + (getVarFloat(11)*width*1.5f)/getVarFloat(10);
	}
	
	public float getHeight(){
		if(getVarFloat(11)==0)return 1f;
		return height + (getVarFloat(11)*height*1.5f)/getVarFloat(10);
	}
	
	public float getScale(){
		if(getVarFloat(11)==0)return 1f;
		return 1f + (getVarFloat(11)*1.5f)/getVarFloat(10);
	}
	
	public Texture getTexture(){
		return null; //the block will supply its own texture!
	}
	
	public boolean isDying(){
		return false; //we are already dead, no animation, no delay.
	}
	
	public void doDeathAnimation(){
		deathfactor = 0; //none
		motiony = motionx = motionz = 0;
	}
	

}
