package dangerzone.entities;

import slick.Texture;

import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

import dangerzone.DamageTypes;
import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.KVPair;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;


public class BigPharma extends EntityLiving {
	
	int spawnedminions = 0;
	
	public	BigPharma(World w){
		super(w);
		maxrenderdist = 120; //in blocks
		this.height = 1.90f*2f;
		this.width = 0.85f*2f;
		uniquename = "DangerZone:Big Pharma";
		moveSpeed = 0.45f;
		setMaxHealth(2000.0f);
		setHealth(2000.0f);
		setDefense(2.75f);
		setAttackDamage(60.0f);
		searchDistance = 32f;
		attackRange = 5.5f;
		movefrequency = 55;
		setExperience(10000);
		canSwim = true;
		has_inventory = true;
		temperament = Temperament.HOSTILE;
		enable_hostile = true;
		tower_defense_enable = true;
		enable_buddy = true;

	}
	
	public boolean isBoss() {
		return true;
	}
		
	public String getLivingSound(){
		int which = world.rand.nextInt(8);
		if(which == 1)return "DangerZone:vaxxed_living1";
		if(which == 2)return "DangerZone:vaxxed_living2";
		if(which == 3)return "DangerZone:vaxxed_living3";
		if(which == 4)return "DangerZone:vaxxed_living4";
		if(which == 5)return "DangerZone:vaxxed_living5";
		return null;
	}
	
	public void update(float deltaT){
		if(getAttacking()){
			setArmsUp(true);
		}else{
			setArmsUp(false);
		}
		super.update(deltaT);
	}
	
	public float getLivingSoundVolume(){
		return 1f;
	}
	
	public String getHurtSound(){
		int which = world.rand.nextInt(5);
		if(which == 1)return "DangerZone:vaxxed_hit1";
		if(which == 2)return "DangerZone:vaxxed_hit2";
		if(which == 3)return "DangerZone:vaxxed_hit3";
		if(which == 4)return "DangerZone:vaxxed_hit4";
		if(which == 0)return "DangerZone:vaxxed_hit5";
		return null;
	}
	
	public String getDeathSound(){
		return "DangerZone:vaxxed_death";
	}
	
	public String getAttackSound(){
		int which = world.rand.nextInt(5);
		if(which == 1)return "DangerZone:vaxxed_attack1";
		if(which == 2)return "DangerZone:vaxxed_attack2";
		if(which == 3)return "DangerZone:vaxxed_attack3";
		return null;
	}
	
	 public boolean isBuddy(Entity e){
			if(e instanceof BigPharma)return true;
		 return false;
	 }
	
	
	public void doFindBuddy(){
		if(world.rand.nextInt(findbuddyfrequency) == 1){			
			List<Integer> nearby_list = null;
			int nbuddy = 0;
			double totalx, totalz;
			totalx = totalz = 0;
			//Get a list of entities within range
			nearby_list = DangerZone.server.entityManager.findEntitiesInRangei(findbuddydistance, dimension, posx, posy, posz);
			if(nearby_list != null){
				if(!nearby_list.isEmpty()){
					Entity e = null;
					ListIterator<Integer> li = nearby_list.listIterator();
					while(li.hasNext()){
						e = DangerZone.server.entityManager.entities[li.next()];												
						if(e != null && e != this && isBuddy(e)){

							int mult = 1;
							totalx += e.posx*mult;
							totalz += e.posz*mult;
							nbuddy += mult;

						}		
					}
					if(nbuddy > 0){
						//head towards middle of group
						totalx /= nbuddy;
						totalz /= nbuddy;
						float rundir = (float) Math.atan2(totalx - posx, totalz - posz);
						rundir = (float) Math.toDegrees(rundir);
						findNewTarget(rundir, 45f);
					}
				}								
			}			
		}
	}
	
	public void doAttackFrom(/*entity that hit me*/Entity e, /*DamageTypes*/int dt, float pain){	
		if(dt == DamageTypes.POISON)return; //already poisoned!
		doAttackFromCustom(e, dt, pain, true);
	}
	
	public void doAttack(Entity victim){
		Effects ef = new Effects(Effects.POISON, 0.20f, 500);
		victim.addEffectFromServer(ef);
		ef = new Effects(Effects.CONFUSION, 2f, 500);
		victim.addEffectFromServer(ef);
		ef = new Effects(Effects.WEAKNESS, 2f, 500);
		victim.addEffectFromServer(ef);
		ef = new Effects(Effects.SLOWNESS, 4f, 500);
		victim.addEffectFromServer(ef);
		super.doAttack(victim);
	}	
	
	public void doEntityAction(float deltaT){
		if(world.isServer) {
			if(effect_list == null || effect_list.size() == 0) {
				Effects ef = new Effects(Effects.POISON, 0.01f, 1000);
				addEffect(ef);
				ef = new Effects(Effects.CONFUSION, 1f, 1000);
				addEffect(ef);
				ef = new Effects(Effects.WEAKNESS, 0.1f, 1000);
				addEffect(ef);
				ef = new Effects(Effects.SLOWNESS, 0.1f, 1000);
				addEffect(ef);
			}
			
			if(spawnedminions == 0) {
				double px;
				double py;
				double pz;
				int bid;
				int which = 0;
				EntityLiving sc;
				
				for(int m=0;m<13;m++) {
					px = posx;
					py = posy;
					pz = posz;

					px += (world.rand.nextFloat()-world.rand.nextFloat())*8;
					pz += (world.rand.nextFloat()-world.rand.nextFloat())*8;

					which = world.rand.nextInt(80);

					for(int i=-5; i<=5;i++){
						bid = world.getblock(dimension, (int)px, (int)py+i, (int)pz);
						if(bid == 0){
							bid = world.getblock(dimension, (int)px, (int)py+i-1, (int)pz);
							if(bid != 0){
								sc = null;
								if(which <= 40)sc = (EntityLiving)world.createEntityByName("DangerZone:Vaxxed", dimension, px, py+i, pz);
								else if(which <= 60)sc = (EntityLiving)world.createEntityByName("DangerZone:Libtard", dimension, px, py+i, pz);
								else if(which <= 70)sc = (EntityLiving)world.createEntityByName("DangerZone:Teacher", dimension, px, py+i, pz);
								else if(which <= 75)sc = (EntityLiving)world.createEntityByName("DangerZone:Professor", dimension, px, py+i, pz);
								else if(which <= 77)sc = (EntityLiving)world.createEntityByName("DangerZone:Dean", dimension, px, py+i, pz);
								
								if(sc != null){
									sc.init();
									world.spawnEntityInWorld(sc);
								}
							}
						}
					}
				}


				spawnedminions = 1;
			}
		}
		super.doEntityAction(deltaT);
	}
	
	public void doDeathDrops(){	
		Utils.doDropRand(world, 0, Items.trophybigpharma.itemID, 1f, dimension, posx, posy, posz);
		for(int i=0;i<10;i++) {
			Utils.doDropRand(world, 0, Items.frog_speed3.itemID, 2f, dimension, posx, posy, posz);
			Utils.doDropRand(world, 0, Items.frog_strength3.itemID, 2f, dimension, posx, posy, posz);
			Utils.doDropRand(world, 0, Items.frog_regen3.itemID, 2f, dimension, posx, posy, posz);
			Utils.doDropRand(world, 0, Items.frog_morph3.itemID, 2f, dimension, posx, posy, posz);
			Utils.doDropRand(world, 0, Items.scrollheal.itemID, 2f, dimension, posx, posy, posz);

		}
				
		Utils.doDropRand(world, 0, Items.scrollaccuracyV.itemID, 1f, dimension, posx, posy, posz);
		Utils.doDropRand(world, 0, Items.scrolldamageV.itemID, 1f, dimension, posx, posy, posz);
		Utils.doDropRand(world, 0, Items.scrolldurabilityV.itemID, 1f, dimension, posx, posy, posz);
		Utils.doDropRand(world, 0, Items.scrollreachV.itemID, 1f, dimension, posx, posy, posz);
		Utils.doDropRand(world, 0, Items.scrollspamV.itemID, 1f, dimension, posx, posy, posz);
	
		super.doDeathDrops();
	}

	//Override, because we attack hostiles that are NOT moose!
	public boolean isSuitableTarget(Entity e){
		if(isIgnorable(e))return false;
		if(e instanceof Vaxxed)return false;
		if(e instanceof Libtard)return false;
		if(e instanceof Teacher)return false;
		if(e instanceof Professor)return false;
		if(e instanceof Dean)return false;
		if(e instanceof Doctor)return false;
		if(e instanceof BigPharma)return false;
		if(e.temperament == Temperament.HOSTILE && CanProbablySeeEntity(e) )return true;
		if(e instanceof Player && CanProbablySeeEntity(e) )return true;
		return false;
	}
	
	//Model calls back out to see what texture to use.
	public Texture getTexture(){
		if(texture == null){
			//ENTITIES MUST USE TEXTUREMAPPER.GETTEXTURE()!!!!
			texture = TextureMapper.getTexture("res/skins/"+ "BigPharmatexture.png");	//this is not fast, so we keep our own pointer!
		}
		return texture;
	}
	
	public float getScale(){
		if(isBaby()){
			return 1f;
		}
		return 2f;
	}
	
	public void writeSelf(List<KVPair> prop, String tag){
		prop.add(new KVPair(String.format("%s%s", tag, "spawnedminions"), String.format("%d", spawnedminions)));
		super.writeSelf(prop, tag);
	}
	
	public void readSelf(Properties prop, String tag){
		spawnedminions = Utils.getPropertyInt(prop, String.format("%s%s", tag, "spawnedminions"), 0, 100000, 0);
		super.readSelf(prop, tag);
	}
	

}