package dangerzone.blocks;

import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.World;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class StickyBlock extends Block {
	
	private boolean compiled = false; //graphics outputs compiled. Or not.
	private int squareid3D = 0;
	private float blockrenderwidth = 16;

	public StickyBlock(String n, String txt) {
		super(n, txt);
		isSolidForRendering = false;
		isSolid = false;
		isLiquid = false;
		isSquishy = true;
		friction = 0.85f;
		maxstack = 32;
		hasOwnRenderer = true;
	}
	
	public String getStepSound(){
		int i = DangerZone.rand.nextInt(3);
		if(i == 0)return "DangerZone:sand1";
		if(i == 1)return "DangerZone:sand2";
		return "DangerZone:sand3";
	}
	
	public void renderMeToVBO(long chunkvbos[], WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder){

		VBOBuffer v = null;
		StitchedTexture st = null;
		float brw = blockrenderwidth/2;
		
		st = builder.findVBOtextureforblockside(0, bid); //loads us into the stitching if we are not already!
		v = builder.findOrMakeVBOForTexture(chunkvbos, st, isTranslucent);
		
		if(v != null){
			v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
			v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
			v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
			v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
			
			v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
			v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
			v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
			v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
		}

	}
	
	public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus){

		
		if(!compiled){
			int stride = 3*4; //xyz coord size (floats!)
			int textureoff = stride;
			stride += 2*4; //texture coord size
			int coloroff = stride;
			stride += 3*4; //rgb (brightness bytes!)	
			
			squareid3D = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(squareid3D);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);	

	    	ByteBuffer vbodata = BufferUtils.createByteBuffer(8*stride); // size   	    	
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    	
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    		    	
	    	vbodata.flip();
	    	int vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
	    	
			compiled = true;
		}
		
		wr.loadtextureforblockside(0, bid, false); //We only have one side. Tell world renderer to load our texture.

		MatrixStack.sendFinalStack();
				
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);
		
		GL30.glBindVertexArray(squareid3D);
		
		GL11.glDrawArrays(GL11.GL_QUADS, 0, 8);
				
		GL30.glBindVertexArray(0);
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);
		

	}
	
    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }


}
