package dangerzone.blocks;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;


public class LightStick extends Block {
	private boolean compiled = false; //graphics outputs compiled. Or not.
	private int squareid3D = 0;
	private float blockrenderwidth = 16;
		
	public LightStick(String n, String txt){
		super(n, txt);
		isSolidForRendering = false;
		isSolid = false;
		alwaysRender = true;
		hasOwnRenderer = true;
		brightness = 0.75f;
		maxdamage = 1;
		randomtick = true;
		burntime = 30;
	}
	
	public void notifyNeighborChanged(World w, int d, int x, int y, int z){
		int bid = 0;
		int meta = w.getblockmeta(d, x, y, z); //get my metadata!
		
		if(!w.isServer)return;
		if(w.getblock(d, x, y, z) != blockID)return;
		
		//see if i am still attached!
		switch((meta>>8)){
		case 1:
			bid = w.getblock(d, x, y, z-1);
			break;
		case 2:
			bid = w.getblock(d, x, y, z+1);
			break;
		case 3:
			bid = w.getblock(d, x+1, y, z);
			break;
		case 4:
			bid = w.getblock(d, x-1, y, z);
			break;
		case 5:
			bid = w.getblock(d, x, y+1, z);
			break;
		default:
			bid = w.getblock(d, x, y-1, z);
		}
		
		if(!Blocks.isSolid(bid)){
			//Don't know what I'm on, but it's not good to stay!
			if(!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0))return;
			w.setblock(d, x, y, z, 0); //Can't be here!
			//drop	
			EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x+0.5f, (double)y+0.5f, (double)z+0.5f);
			if(e != null){
				e.fill(this, 1); //I am a block!	
				w.spawnEntityInWorld(e);
			}			
		}
	}
	
	public void tickMe(World w, int d, int x, int y, int z){
		Utils.spawnParticlesFromServer(w, "DangerZone:ParticleFire", w.rand.nextInt(3)+3, d, x+0.5f, y+0.5f, z+0.5f);
	}

	
	/*
		This is the OLD-style torch... see BetterTorch if you want the nice new one...
	 */
	public void renderMeToVBO(long chunkvbos[], WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder){
		
		VBOBuffer v = null;
		StitchedTexture st = null;
		int brw = (int) (blockrenderwidth/2);

		st = builder.findVBOtextureforblockside(0, bid);
		v = builder.findOrMakeVBOForTexture(chunkvbos, st, isTranslucent);
		if(v != null){
			switch((meta>>8)){
			case 1: //on front
				v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);

				v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
				break;
			case 2: //on back
				v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);

				v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
				break;
			case 3: //on left
				v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);

				v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
				break;
			case 4: //on right
				v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);

				v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
				break;
			case 5: //upside down
				v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);

				v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
				break;
			default: //rightside up
				v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);

				v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
				v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
				v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
			}
		}

	}
	
	public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus){

		if(!compiled){
			int stride = 3*4; //xyz coord size (floats!)
			int textureoff = stride;
			stride += 2*4; //texture coord size
			int coloroff = stride;
			stride += 3*4; //rgb (brightness bytes!)	
			
			squareid3D = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(squareid3D);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);	

	    	ByteBuffer vbodata = BufferUtils.createByteBuffer(8*stride); // size   	    	
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    	
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2, -blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2, blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2, blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2, -blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    		    	
	    	vbodata.flip();
	    	int vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
	    	
			compiled = true;
		}
		
		MatrixStack.pushMatrix();

		
		switch((meta>>8)){
		case 1:
			MatrixStack.rotate(90f, 1, 0, 0);
			break;
		case 2:
			MatrixStack.rotate(-90f, 1, 0, 0);
			break;
		case 3:
			MatrixStack.rotate(90f, 0, 0, 1);
			break;
		case 4:
			MatrixStack.rotate(-90f, 0, 0, 1);
			break;
		case 5:
			MatrixStack.rotate(180f, 1, 0, 0);
			break;
		default:
				
		}
		
		MatrixStack.sendCurrentStack();

		wr.loadtextureforblockside(0, bid, false); //We only have one side. Tell world renderer to load our texture.
		
		MatrixStack.sendFinalStack();
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);
		
		GL30.glBindVertexArray(squareid3D);
		
		GL11.glDrawArrays(GL11.GL_QUADS, 0, 8);
				
		GL30.glBindVertexArray(0);
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);
				
		MatrixStack.popMatrix();
		

	}
	
	//client-side only
	public boolean doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side){
		//System.out.printf("side = %d\n", side);	
		
		if(!Blocks.isSolid(focusbid))return false;
		if(Blocks.isLeaves(focusbid))return false;
		if(!Blocks.isSolidThisSide(focusbid, w, dimension, x, y, z, side))return false;
		if(!BreakChecks.canChangeBlock(p, dimension, x, y, z, this.blockID, 0))return false; //close enough
		
		switch(side){
		case 0:
			w.setblockandmeta(dimension, x, y+1, z, this.blockID, side<<8);
			onBlockPlaced(w, dimension, x, y+1, z);
			break;
		case 1:
			w.setblockandmeta(dimension, x, y, z+1, this.blockID, side<<8);
			onBlockPlaced(w, dimension, x, y, z+1);
			break;
		case 2:
			w.setblockandmeta(dimension, x, y, z-1, this.blockID, side<<8);
			onBlockPlaced(w, dimension, x, y, z-1);
			break;
		case 3:
			w.setblockandmeta(dimension, x-1, y, z, this.blockID, side<<8);
			onBlockPlaced(w, dimension, x-1, y, z);
			break;
		case 4:
			w.setblockandmeta(dimension, x+1, y, z, this.blockID, side<<8);
			onBlockPlaced(w, dimension, x+1, y, z);
			break;
		case 5:
			w.setblockandmeta(dimension, x, y-1, z, this.blockID, side<<8);
			onBlockPlaced(w, dimension, x, y-1, z);
			break;
		}
		
		w.playSound(Blocks.getPlaceSound(this.blockID), dimension, x, y, z, 0.5f, 1.0f);

		return true;
	}
	
    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }


}
