package dangerzone.blocks;



import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.FastBlockTicker;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.World;

public class BlockDownRail extends BlockRail {

	public BlockDownRail(String n, String txt, String fulltxt) {
		super(n, txt, fulltxt);
	}
	
	public void notifyNeighborChanged(World w, int d, int x, int y, int z){
		if(w.isServer){
			int bid = w.getblock(d, x, y+1, z);
			int bid2 = w.getblock(d, x, y-1, z);
			if(!Blocks.isSolid(bid) || bid2 != 0){
				Blocks.doBreakBlock(blockID, w, d, x, y, z);
				w.setblock(d, x, y, z, 0);
			}
		}
	}
	
	public void tickMe(World w, int d, int x, int y, int z){
		if(w.isServer){
			int bid = w.getblock(d, x, y+1, z);
			int bid2 = w.getblock(d, x, y-1, z);
			if(!Blocks.isSolid(bid) || bid2 != 0){
				Blocks.doBreakBlock(blockID, w, d, x, y, z);
				w.setblock(d, x, y, z, 0);
				return;
			}
			
			int meta = 0;
			if(isRailBlock(w, d, x+1, y, z))meta |= 0x01;
			if(isRailBlock(w, d, x-1, y, z))meta |= 0x02;
			if(isRailBlock(w, d, x, y, z+1))meta |= 0x04;
			if(isRailBlock(w, d, x, y, z-1))meta |= 0x08;
			
			
			if(isRailBlock(w, d, x+1, y-1, z))meta |= 0x01;
			if(isRailBlock(w, d, x-1, y-1, z))meta |= 0x02;
			if(isRailBlock(w, d, x, y-1, z+1))meta |= 0x04;
			if(isRailBlock(w, d, x, y-1, z-1))meta |= 0x08;
						
			w.setblockandmeta(d, x, y, z, blockID, meta);		

			//tick again later!
			FastBlockTicker.addFastTick(d,  x,  y, z, 8+w.rand.nextInt(3)); //ticks, in TENTHS of a second
						
		}
	}
	
	public void renderMeToVBO(long chunkvbos[], WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder){

		VBOBuffer v = null;
		StitchedTexture st = null;

		st = builder.findVBOtextureforblockside(5, bid);
		if(st == null)return;
		v = builder.findOrMakeVBOForTexture(chunkvbos, st, isTranslucent);
		if(v == null)return;
		
		mbf.railcenter.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
		mbf.railpostA.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo+4, zo, 0);
		mbf.railpost.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo+14, zo, 0);
		
		if((meta & 0x01) != 0){
			mbf.railside.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
		}
		if((meta & 0x02) != 0){
			mbf.railside.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
		}
		if((meta & 0x04) != 0){
			mbf.railside.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
		}
		if((meta & 0x08) != 0){
			mbf.railside.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
		}

	}
	
	public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus){

		wr.loadtextureforblockside(5, bid, false); //We only have one side. Tell world renderer to load our texture.
		
		//MatrixStack.sendCurrentStack();
		MatrixStack.pushMatrix();
		
		MatrixStack.translate(0,  -8,  0);
		
		MatrixStack.sendCurrentStack();
		mbf.railcenter.render(1);
		
		MatrixStack.translate(0,  4,  0);
		MatrixStack.sendCurrentStack();
		mbf.railpostA.render(1);
		MatrixStack.translate(0,  10,  0);
		MatrixStack.sendCurrentStack();
		mbf.railpost.render(1);
		MatrixStack.translate(0,  -14,  0);

		if((meta & 0x01) == 0x01){
			MatrixStack.sendCurrentStack();
			mbf.railside.render(1);
		}
		if((meta & 0x02) == 0x02){
			MatrixStack.rotate(180, 0, 1, 0);
			MatrixStack.sendCurrentStack();
			mbf.railside.render(1);
			MatrixStack.rotate(-180, 0, 1, 0);
		}
		if((meta & 0x04) == 0x04){
			MatrixStack.rotate(-90, 0, 1, 0);
			MatrixStack.sendCurrentStack();
			mbf.railside.render(1);
			MatrixStack.rotate(90, 0, 1, 0);
		}
		if((meta & 0x08) == 0x08){
			MatrixStack.rotate(90, 0, 1, 0);
			MatrixStack.sendCurrentStack();
			mbf.railside.render(1);
			MatrixStack.rotate(-90, 0, 1, 0);
		}
		
		MatrixStack.popMatrix();

	}


}
