package dangerzone;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.rendering.Fastmath;
import dangerzone.world.World;

public class VRHitHandler {
	
	public int focus_x, focus_y, focus_z, focus_side;
	public double poi_x, poi_y, poi_z; //point of impact!!! Client side only.
	public int focus_bid, focus_meta;
	public float focus_damage = 0;
	public float focus_maxdamage = 0;
	public float focus_dist = 0;
	public Entity focus_entity = null;
	private boolean new_contact = false;
	private double prev_fx, prev_fy, prev_fz;
	private double prev_dx, prev_dy, prev_dz;
	private int lfx, lfy, lfz;
	
	
	
	public boolean check_for_contact(World w, TargetInfo ti, float swing_speed, float angular_swing_speed, boolean first, int fps){
		double fx,fy,fz;
		double dx, dz, dy;
		//start
		fx =  ti.real_posx;
		fy =  ti.real_posy;
		fz =  ti.real_posz;
		//direction
		dx = ti.dx;
		dy = ti.dy;
		dz = ti.dz;
		
		if(first) {
			focus_x = focus_y = focus_z = focus_side = focus_bid = focus_meta = 0;
			poi_x = poi_y = poi_z = 0;
			focus_dist = 0;
			focus_entity = null;
			
			new_contact = false;
			
			prev_fx = fx;
			prev_fy = fy;
			prev_fz = fz;
			prev_dx = dx;
			prev_dy = dy;
			prev_dz = dz;
			
			//just one check in this direction.
			return check_for_contact_do(w, fx, fy, fz, dx, dy, dz);
		}else {
			
			if(new_contact)return false; //just ONCE per swing
			
			double dfx,dfy,dfz;
			double ddx, ddz, ddy;
			//Use MAX speed or angular and see how many iterations to break this into.
			//We have to compensate for slow frame rates and/or fast swings by filling in the blanks!
			int ispeed = (int) swing_speed; 
			int iaspeed = (int) angular_swing_speed;
			iaspeed = iaspeed/10;
			if(ispeed < iaspeed)ispeed = iaspeed;
			if(ispeed < 1)ispeed = 1;
			if(fps < 60)ispeed *= 2;
			if(fps < 30)ispeed *= 2;
			if(fps < 15)ispeed *= 2;
			
			dfx = (fx-prev_fx)/ispeed;
			dfy = (fy-prev_fy)/ispeed;
			dfz = (fz-prev_fz)/ispeed;
			ddx = (dx-prev_dx)/ispeed;
			ddy = (dy-prev_dy)/ispeed;
			ddz = (dz-prev_dz)/ispeed;
			
			for(int i=0;i<ispeed;i++) {
				if(check_for_contact_do(w, prev_fx+(dfx*(i+1)), prev_fy+(dfy*(i+1)), prev_fz+(dfz*(i+1)), 
						prev_dx+(ddx*(i+1)), prev_dy+(ddy*(i+1)), prev_dz+(ddz*(i+1)))) {
					return true;
				}
			}
			
			//reset for next pass. above have been checked.
			prev_fx = fx;
			prev_fy = fy;
			prev_fz = fz;
			prev_dx = dx;
			prev_dy = dy;
			prev_dz = dz;
		}
		return false;
	}
	
		/*
		 * Find the block we are pointing at, and the side too...
		 */
		public boolean check_for_contact_do(World w, double startx, double starty, double startz, double dx, double dy, double dz){
	
			double sx, sz, sy;
			double delta = 0.25d;
			double delta2;
			double dist, lastdist;
			int x,y,z;
			double fx,fy,fz;
			int lx, ly, lz;
			int bid;
			int eyebid;

			Entity tempe = null;
			List<Entity> nearby_list = null;
			List<Entity> check_list = new ArrayList<Entity>();
			ListIterator<Entity> li;
			int riddenid = 0;
			Entity ridden = DangerZone.player.getRiddenEntity();
			if(ridden != null )riddenid = ridden.entityID;
						
			fx =  startx;
			fy = starty + DangerZone.player.getEyeHeight();
			fz =  startz;
			x = (int) fx;
			y = (int) fy;
			z = (int) fz;
			eyebid = w.getblock(DangerZone.player.dimension, x, y, z); 
			
			float reach = DangerZone.player.getHeight()/8f;
			if(reach < 0.125f)reach = 0.125f;
			float itemwidth = 0.125f;
			InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
			if(ic != null){
				Item itm = ic.getItem();
				if(itm != null) {
					reach += itm.itemreach;
					itemwidth += itm.itemwidth;
				}
				reach += 0.75f * (float)ic.getAttribute(ItemAttribute.REACH);
				itemwidth += 0.25f * (float)ic.getAttribute(ItemAttribute.ACCURACY);
			}
			if(reach < 0.5f)reach = 0.5f;
			
			//System.out.printf("reach = %f\n", reach);
			
			//pre-filter to take out things we cannot possibly or shouldn't hit!
			nearby_list = DangerZone.clientEntityManager.findEntitiesInRange(20.0f+reach, DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz);
			if(nearby_list != null){
				if(!nearby_list.isEmpty()){
					li = nearby_list.listIterator();
					while(li.hasNext()){
						tempe = (Entity)li.next();
						if(tempe instanceof EntityLiving || tempe instanceof EntityBlockItem) {
							dist = Math.sqrt((fx-tempe.posx)*(fx-tempe.posx)+(fy-tempe.posy)*(fy-tempe.posy)+(fz-tempe.posz)*(fz-tempe.posz));
							dist -= 0.125f; //width of sword or whatever
							dist -= (tempe.getWidth()/2); //general hitbox of entity
							if(tempe instanceof EntityBlockItem && dist < 14){
								//System.out.printf("added %d\n", tempe.entityID);
								check_list.add(tempe);
							}else if(tempe != DangerZone.player && !tempe.canthitme && dist < 14){					
								//don't hit mount unless looking almost straight down!
								if(tempe.entityID != riddenid){
									//System.out.printf("added %d\n", tempe.entityID);
									check_list.add(tempe);
								}
							}
						}
					}
				}
			}
			
			if(ridden != null && dy < -0.75f)check_list.add(ridden); //add whatever we are riding on! (if looking down!)

			//focus_x = focus_y = focus_z = focus_side = 0;
			lx = ly = lz = 0;
			//lfx = focus_x; lfy = focus_y; lfz = focus_z;


			//increment along the axis looking for a block
			while(delta < reach){
				fx =  startx + dx*delta;
				fy =  starty + dy*delta + DangerZone.player.getEyeHeight();
				fz =  startz + dz*delta;
				x = (int) fx;
				y = (int) fy;
				z = (int) fz;
				
				if(delta < (reach-0.1d)) {
					if(delta < reach*0.67f) {
						if(Fastmath.nextBoolean())Utils.spawnParticlesScaled(w, "DangerZone:ParticleSmoke", 1, DangerZone.player.dimension, fx, fy, fz, 0, 0.125f, false);
					}else {
						Utils.spawnParticlesScaled(w, "DangerZone:ParticleHurt", 1, DangerZone.player.dimension, fx, fy, fz, 0, 0.125f, false);
					}
				}else {
					Utils.spawnParticlesScaled(w, "DangerZone:ParticleSparkle", 2, DangerZone.player.dimension, fx, fy, fz, 0, 0.125f, false);
				}
							
				//Hit an entity or a block... whichever...
				if(delta < reach && check_list != null){
					if(!check_list.isEmpty()){
						li = check_list.listIterator();
						while(li.hasNext()){
							tempe = (Entity)li.next();
							if(fy > tempe.posy-itemwidth && fy < tempe.posy+tempe.getHeight()+itemwidth){
								dist = Math.sqrt((fx-tempe.posx)*(fx-tempe.posx)+(fz-tempe.posz)*(fz-tempe.posz));
								dist -= itemwidth; //width of sword or whatever
								dist -= (tempe.getWidth()/2); //general hitbox of entity
								//System.out.printf("entity dist %d, d = %f\n", tempe.entityID, dist);
								if(dist < 0){
									
									if(tempe instanceof EntityLiving) {
										//System.out.printf("entity hit %d, dy = %f\n", tempe.entityID, dy);
										focus_x = focus_y = focus_z = focus_bid = focus_meta = 0;
										focus_damage = 0;
										focus_dist = (float) dist;
										focus_entity = tempe;
										poi_x = fx; poi_y = fy; poi_z = fz;
										lfx = lfy = lfz = 0;
										new_contact = true;
										return true;
									}
									
									if(tempe instanceof EntityBlockItem && !tempe.deadflag) {										
										InventoryContainer icc = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
										if(icc != null) {
											Item it = icc.getItem();
											if(it != null) {
												//System.out.printf("hitting %d\n", tempe.entityID);
												it.vr_hit_EntityBlockItem(tempe);
											}
										}
										//continue!
									}
									
								}
							}
						}
					}
				}
				
				//wait until block actually changes
				if(delta < reach && x != lx || y != ly || z != lz){
					lx = x; ly = y; lz = z;
					bid = w.getblock(DangerZone.player.dimension, x, y, z);
					if(eyebid != 0 && Blocks.isLiquid(eyebid) && Blocks.isLiquid(bid))bid = 0; //we are in water. ignore water.
					if(bid != 0){ //Hit a block!!!	
						
						//but wait! If it is NOT a solid block, then we need to check for a hit-able entity inside!
						//hit the entity if possible, else continue with hitting the block...
						if(!Blocks.isSolid(bid) && check_list != null){
							int tbid;
							int tx, ty, tz;
							int tlx = lx;
							int tlz = lz;
							int tly = ly;
							double tdelta = delta;
							while(tdelta < reach){
								fx =  startx + dx*delta;
								fy =  starty + dy*delta + DangerZone.player.getEyeHeight();
								fz =  startz + dz*delta;
								tx = (int) fx;
								ty = (int) fy;
								tz = (int) fz;
								if(tx != tlx || ty != tly || tz != tlz){
									tbid = w.getblock(DangerZone.player.dimension, tx, ty, tz);
									if(Blocks.isSolid(tbid)){
										break; //hit something solid. break out and process original non-solid block.
									}
									tlx = tx; tly = ty; tlz = tz;
								}
								if(!check_list.isEmpty()){
									li = check_list.listIterator();
									while(li.hasNext()){
										tempe = (Entity)li.next();
										if(fy > tempe.posy-itemwidth && fy < tempe.posy+tempe.getHeight()+itemwidth){
											dist = Math.sqrt((fx-tempe.posx)*(fx-tempe.posx)+(fz-tempe.posz)*(fz-tempe.posz));
											dist -= itemwidth; //width of sword or whatever
											dist -= (tempe.getWidth()/2); //general hitbox of entity
											//System.out.printf("entity dist %d, d = %f\n", tempe.entityID, dist);
											if(dist < 0){
												//System.out.printf("entity hit %d, dy = %f\n", tempe.entityID, dy);
												focus_x = focus_y = focus_z = focus_bid = focus_meta = 0;
												focus_damage = 0;
												focus_dist = (float) dist;
												focus_entity = tempe;
												poi_x = fx; poi_y = fy; poi_z = fz;
												lfx = lfy = lfz = 0;
												new_contact = true;
												return true;
											}
										}
									}
								}
								tdelta += 0.1d;
							}
						}
						
						//hit something! Now back it up one step and loop for 0.01;
						delta2 = delta;
						delta = delta - 0.1f;
						
						x = (int) (startx + dx*delta);
						y = (int) (starty + dy*delta + DangerZone.player.getEyeHeight());
						z = (int) (startz + dz*delta);
						
						lx = x; ly = y; lz = z;

						//loop to get really really close to intersection
						while(delta < delta2+0.01f){
							fx =  startx + dx*delta;
							fy =  starty + dy*delta + DangerZone.player.getEyeHeight();
							fz =  startz + dz*delta;
							x = (int) fx;
							y = (int) fy;
							z = (int) fz;
							if(x != lx || y != ly || z != lz){
								lx = x; ly = y; lz = z;
								bid = w.getblock(DangerZone.player.dimension, x, y, z);
								if(eyebid != 0 && Blocks.isLiquid(eyebid) && Blocks.isLiquid(bid))bid = 0; //we are in water. ignore water.
								if(bid != 0){ //Hit a block!!! (again)
									
									//Now we are within 1/100th of the side. 
									//See which side center is closest to this ray-plane intersection point.
									
									dx =  startx + dx*delta;
									dy =  starty + dy*delta + DangerZone.player.getEyeHeight();
									dz =  startz + dz*delta;
									
									dist = 2.0d;
									lastdist = 2.0d;
									focus_side = 0;
									poi_x = fx; poi_y = fy; poi_z = fz;

									//top
									sx = ((double)x + 0.5f);
									sy = ((double)y + 1.0f);
									sz = ((double)z + 0.5f);
									dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
									if(dist < lastdist){
										lastdist = dist;
										focus_side = 0;
									}						

									//back
									sx = ((double)x + 0.5f);
									sy = ((double)y + 0.5f);
									sz = ((double)z + 0.0f);
									dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
									if(dist < lastdist){
										lastdist = dist;
										focus_side = 2;
									}

									//front
									sx = ((double)x + 0.5f);
									sy = ((double)y + 0.5f);
									sz = ((double)z + 1.0f);
									dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
									if(dist < lastdist){
										lastdist = dist;
										focus_side = 1;
									}

									//left
									sx = ((double)x + 0.0f);
									sy = ((double)y + 0.5f);
									sz = ((double)z + 0.5f);
									dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
									if(dist < lastdist){
										lastdist = dist;
										focus_side = 3;
									}

									//right
									sx = ((double)x + 1.0f);
									sy = ((double)y + 0.5f);
									sz = ((double)z + 0.5f);
									dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
									if(dist < lastdist){
										lastdist = dist;
										focus_side = 4;
									}

									//bottom
									sx = ((double)x + 0.5f);
									sy = ((double)y + 0.0f);
									sz = ((double)z + 0.5f);
									dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
									if(dist < lastdist){
										lastdist = dist;
										focus_side = 5;
									}

									//Done! Fast and efficient, with no complex vector math involved! :)
									focus_x = lx;
									focus_y = ly;
									focus_z = lz;
									focus_bid = bid;
									focus_meta = w.getblockmeta(DangerZone.player.dimension, x, y, z);
									focus_dist = (float) delta;
									focus_entity = null;
									if(lfx != focus_x || lfy != focus_y || lfz != focus_z){
										focus_damage = 0;
										focus_maxdamage = Blocks.getMaxDamage(bid);
										if(focus_maxdamage < 1)focus_maxdamage = 1;
										lfx = focus_x;
										lfy = focus_y;
										lfz = focus_z;
									}
									//System.out.printf("Side = %d\n", focus_side);
									new_contact = true;
									return true;
								}
							}
							delta += 0.01f;
						}
					}
				}
				delta += 0.1d;
			}
			focus_x = focus_y = focus_z = focus_bid = focus_meta = 0;
			//focus_damage = 0;
			poi_x = poi_y = poi_z = 0;
			focus_dist = 0;
			focus_entity = null;
			new_contact = false;
			return false;
		}
		

}
