package slick;



import java.util.ArrayList;
import java.util.List;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;


public class Inputs {
	private boolean[] keys = new boolean[GLFW.GLFW_KEY_LAST]; //current states
	private List<KeyEvent> keyevents; //buffered states
	private List<MouseEvent> mouseevents;
	private List<ScrollEvent> scrollevents;
	private boolean[] buttons = new boolean[GLFW.GLFW_MOUSE_BUTTON_LAST];
	private double mousex = -1, mousey = -1;
	private int mousedx = 0, mousedy = 0;
	private int screen_width = 640, screen_height = 480;
	private boolean resized = false;
	private boolean invert = true;
	private volatile boolean first = true;
	
	/*
	 * keyboard callback.
	 */
	private GLFWKeyCallback keyboard;
	private GLFWCursorPosCallback mouseMove;
	private GLFWMouseButtonCallback mouseButtons;
	private GLFWScrollCallback wheel;
	private GLFWFramebufferSizeCallback framesize;
	
	public class KeyEvent {
		public int key;
		public boolean isdown;
		public boolean used = false;
	}
	
	public class MouseEvent {
		public boolean buttonevent = false;
		public boolean used = false;
		public int button = -1;
		public boolean isdown = false;
		public double x = 0, y = 0;
		public int dx = 0, dy = 0;
	}
	
	public class ScrollEvent {
		public int dx = 0, dy = 0;
	}
	
	public Inputs(int w, int h) {
		screen_width = w;
		screen_height = h;
		do_init();
	}

	public Inputs() {
		do_init();
	}
	
	private void do_init() {

		keyevents = new ArrayList<KeyEvent>();
		mouseevents = new ArrayList<MouseEvent>();
		scrollevents = new ArrayList<ScrollEvent>();

		keyboard = new GLFWKeyCallback() {
			public void invoke(long window, int key, int scancode, int action, int mods) {
				//System.out.printf("callback for key 0x%x, 0x%x, 0x%x\n", key, scancode, GLFW.GLFW_KEY_ESCAPE);
				if(key < 0 || key >= keys.length)return;
				
				keys[key] = (action != GLFW.GLFW_RELEASE);
				KeyEvent ke = new KeyEvent();
				ke.key = key;
				ke.isdown = keys[key];
				if(keyevents.size() < 20)keyevents.add(ke);
			}
		};

		mouseMove = new GLFWCursorPosCallback() {
			public void invoke(long window, double xpos, double inypos) {
				double ypos = inypos;
				if(invert)ypos = screen_height - ypos;
				if(first) {
					mousex = (int)xpos;
					mousey = (int)ypos;
					first = false;
				}
				mousedx = (int)(xpos - mousex);
				mousedy = (int)(ypos - mousey);
			
				//System.out.printf("Mouse %d, %d, %d\n",  (int)xpos, mousex, mousedx);
				mousex = (int) xpos;
				mousey = (int) ypos;	
				MouseEvent me = new MouseEvent();
				me.buttonevent = false;
				me.dx = mousedx;
				me.dy = mousedy;
				me.x = mousex;
				me.y = mousey;
				if(mouseevents.size() < 50)mouseevents.add(me);
			}
		};

		mouseButtons = new GLFWMouseButtonCallback() {
			public void invoke(long window, int button, int action, int mods) {
				buttons[button] = (action != GLFW.GLFW_RELEASE);
				MouseEvent me = new MouseEvent();
				me.buttonevent = true;
				me.button = button;
				me.isdown = buttons[button];
				me.dx = 0;
				me.dy = 0;
				first = true; //so it doesn't yank us into a random position!
				me.x = mousex;
				me.y = mousey;
				if(mouseevents.size() < 50)mouseevents.add(me);
			}
		};
		
		wheel = new GLFWScrollCallback() {
			public void invoke(long window, double xpos, double ypos) {
				//System.out.printf("Scroll event %d, %d\n", (int)xpos, (int)ypos);
				ScrollEvent me = new ScrollEvent();
				me.dx = (int)xpos;
				me.dy = (int)ypos;
				if(scrollevents.size() < 50)scrollevents.add(me);
			}
		};
		
		framesize = new GLFWFramebufferSizeCallback() {
            public void invoke(long window, int w, int h) {
                if (w > 0 && h > 0) {
                	if(screen_width != w || screen_height != h)resized = true;
                    screen_width = w;
                    screen_height = h;
                }
            }
        };

	}


	public GLFWKeyCallback getKeyboardCallback() {
		return keyboard;
	}

	public GLFWCursorPosCallback getMouseMoveCallback() {
		return mouseMove;
	}

	public GLFWMouseButtonCallback getMouseButtonsCallback() {
		return mouseButtons;
	}
	
	public GLFWFramebufferSizeCallback getFrameSizeCallback() {
		return framesize;
	}
	
	public GLFWScrollCallback getScrollCallback() {
		return wheel;
	}
	
	public int getScreenWidth() {
		return screen_width;
	}
	
	public int getScreenHeight() {
		return screen_height;
	}
	
	public void setScreenWidthHeight(int w, int h) {
		screen_width = w;
		screen_height = h;
	}
	
	public boolean isKeyDown(int key) {
		if(key < 0)return false;
		if(key >= keys.length)return false;
		return keys[key];
	}
	
	public boolean hasNextKey() {
		if(keyevents.size() > 0)return true;
		return false;
	}
	
	public KeyEvent nextKey() {
		if(keyevents.size() > 0) {
			//do we need to lock these? I hope not...
			KeyEvent ke = keyevents.get(0);
			keyevents.remove(0);
			return ke;
		}else {
			return null;
		}
	}
	
	public ScrollEvent nextScroll() {
		if(scrollevents.size() > 0) {
			//do we need to lock these? I hope not...
			ScrollEvent ke = scrollevents.get(0);
			scrollevents.remove(0);
			return ke;
		}else {
			return null;
		}
	}
	
	public boolean knext() {
		if(keyevents.size() > 0) {
			if(keyevents.get(0).used) {
				keyevents.remove(0);
				if(keyevents.size() > 0) {
					keyevents.get(0).used = true;
				}else {
					return false;
				}
			}
			keyevents.get(0).used = true;
			return true;
		}
		return false;
	}
	
	public void kclear() {
		keyevents.clear();
	}
	
	public int getEventKey() {
		if(keyevents.size() > 0) {
			return keyevents.get(0).key;
		}
		return -1;
	}
	
	public boolean getEventKeyState() {
		if(keyevents.size() > 0) {
			return keyevents.get(0).isdown;
		}
		return false;
	}
	
	public int getCurMousex() {
		return (int)mousex;
	}
	public int getCurMousey() {
		return (int)mousey;
	}
	public int getCurMousedx() {
		return mousedx;
	}
	public int getCurMousedy() {
		return mousedy;
	}

	public int getEventx() {
		if(mouseevents.size() > 0) {
			return (int)mouseevents.get(0).x;
		}
		return -1;
	}

	public int getEventy() {
		if(mouseevents.size() > 0) {
			return (int)mouseevents.get(0).y;
		}
		return -1;
	}
	
	public int getEventdx() {
		if(mouseevents.size() > 0) {
			return mouseevents.get(0).dx;
		}
		return -1;
	}

	public int getEventdy() {
		if(mouseevents.size() > 0) {
			return mouseevents.get(0).dy;
		}
		return -1;
	}

	public boolean isButtonDown(int button) {
		return buttons[button];
	}
	
	public boolean hasNextButton() {
		int inext = mouseevents.size();
		for(int i = 0;i<inext;i++) {
			if(mouseevents.get(i).buttonevent)return true;
		}
		return false;
	}
	
	public int getEventButton(){
		if(mouseevents.size() > 0) {
			if(mouseevents.get(0).buttonevent) {
				return mouseevents.get(0).button;
			}
		}
		return -1;
	}
	
	public boolean getEventButtonState(){
		if(mouseevents.size() > 0) {
			if(mouseevents.get(0).buttonevent) {
				return mouseevents.get(0).isdown;
			}
		}
		return false;
	}
	
	public boolean mnext() {
		if(mouseevents.size() > 0) {
			if(mouseevents.get(0).used) {
				mouseevents.remove(0);
				if(mouseevents.size() > 0) {
					mouseevents.get(0).used = true;
				}else {
					return false;
				}
			}
			mouseevents.get(0).used = true;
			return true;
		}
		return false;
	}
	
	public void mclear() {
		mouseevents.clear();
		first = true; //so it doesn't yank us into a random position!
	}
	
	public MouseEvent nextButton() {
		while(mouseevents.size() > 0) {
			MouseEvent me = mouseevents.get(0);
			mouseevents.remove(0);
			if(me.buttonevent)return me;
		}
		return null;
	}
	
	public void destroy() {
		keyboard.free();
		mouseMove.free();
		mouseButtons.free();
	}
	
	public boolean wasResized() {
		boolean was = resized;
		resized = false;
		return was;
	}
	
	
}